/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class FormattingOptions
extends JSONBase {
    FormattingOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public int getTabSize() {
        return this.jsonData.getInt("tabSize");
    }

    public FormattingOptions setTabSize(int tabSize) {
        this.jsonData.put("tabSize", tabSize);
        return this;
    }

    public boolean isInsertSpaces() {
        return this.jsonData.getBoolean("insertSpaces");
    }

    public FormattingOptions setInsertSpaces(boolean insertSpaces) {
        this.jsonData.put("insertSpaces", insertSpaces);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getTrimTrailingWhitespace() {
        return this.jsonData.has("trimTrailingWhitespace") ? Boolean.valueOf(this.jsonData.getBoolean("trimTrailingWhitespace")) : null;
    }

    public FormattingOptions setTrimTrailingWhitespace(Boolean trimTrailingWhitespace) {
        this.jsonData.putOpt("trimTrailingWhitespace", trimTrailingWhitespace);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getInsertFinalNewline() {
        return this.jsonData.has("insertFinalNewline") ? Boolean.valueOf(this.jsonData.getBoolean("insertFinalNewline")) : null;
    }

    public FormattingOptions setInsertFinalNewline(Boolean insertFinalNewline) {
        this.jsonData.putOpt("insertFinalNewline", insertFinalNewline);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getTrimFinalNewlines() {
        return this.jsonData.has("trimFinalNewlines") ? Boolean.valueOf(this.jsonData.getBoolean("trimFinalNewlines")) : null;
    }

    public FormattingOptions setTrimFinalNewlines(Boolean trimFinalNewlines) {
        this.jsonData.putOpt("trimFinalNewlines", trimFinalNewlines);
        return this;
    }

    public Object get(String key) {
        return this.jsonData.get(key);
    }

    public FormattingOptions set(String key, Object value) {
        this.jsonData.put(key, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormattingOptions other = (FormattingOptions)obj;
        if (this.getTabSize() != other.getTabSize()) {
            return false;
        }
        if (this.isInsertSpaces() != other.isInsertSpaces()) {
            return false;
        }
        if (!Objects.equals(this.getTrimTrailingWhitespace(), other.getTrimTrailingWhitespace())) {
            return false;
        }
        if (!Objects.equals(this.getInsertFinalNewline(), other.getInsertFinalNewline())) {
            return false;
        }
        return Objects.equals(this.getTrimFinalNewlines(), other.getTrimFinalNewlines());
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Integer.hashCode(this.getTabSize());
        hash = 83 * hash + Boolean.hashCode(this.isInsertSpaces());
        if (this.getTrimTrailingWhitespace() != null) {
            hash = 83 * hash + Boolean.hashCode(this.getTrimTrailingWhitespace());
        }
        if (this.getInsertFinalNewline() != null) {
            hash = 83 * hash + Boolean.hashCode(this.getInsertFinalNewline());
        }
        if (this.getTrimFinalNewlines() != null) {
            hash = 83 * hash + Boolean.hashCode(this.getTrimFinalNewlines());
        }
        return hash;
    }

    public static FormattingOptions create(int tabSize, boolean insertSpaces) {
        JSONObject json = new JSONObject();
        json.put("tabSize", tabSize);
        json.put("insertSpaces", insertSpaces);
        return new FormattingOptions(json);
    }
}

