/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.FileChangeType;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class FileEvent
extends JSONBase {
    FileEvent(JSONObject jsonData) {
        super(jsonData);
    }

    public String getUri() {
        return this.jsonData.getString("uri");
    }

    public FileEvent setUri(String uri) {
        this.jsonData.put("uri", uri);
        return this;
    }

    public FileChangeType getType() {
        return FileChangeType.get(this.jsonData.getInt("type"));
    }

    public FileEvent setType(FileChangeType type) {
        this.jsonData.put("type", type.getIntValue());
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileEvent other = (FileEvent)obj;
        if (!Objects.equals(this.getUri(), other.getUri())) {
            return false;
        }
        return this.getType() == other.getType();
    }

    public int hashCode() {
        int hash = 2;
        hash = 97 * hash + Objects.hashCode(this.getUri());
        hash = 97 * hash + Objects.hashCode((Object)this.getType());
        return hash;
    }

    public static FileEvent create(String uri, FileChangeType type) {
        JSONObject json = new JSONObject();
        json.put("uri", uri);
        json.put("type", type.getIntValue());
        return new FileEvent(json);
    }
}

