/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.SymbolKind;

public class DocumentSymbol
extends JSONBase {
    DocumentSymbol(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public DocumentSymbol setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public String getDetail() {
        return this.jsonData.optString("detail", null);
    }

    public DocumentSymbol setDetail(String detail) {
        this.jsonData.putOpt("detail", detail);
        return this;
    }

    public SymbolKind getKind() {
        return SymbolKind.get(this.jsonData.getInt("kind"));
    }

    public DocumentSymbol setKind(SymbolKind kind) {
        this.jsonData.put("kind", kind.getIntValue());
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDeprecated() {
        return this.jsonData.has("deprecated") ? Boolean.valueOf(this.jsonData.getBoolean("deprecated")) : null;
    }

    public DocumentSymbol setDeprecated(Boolean deprecated) {
        this.jsonData.putOpt("deprecated", deprecated);
        return this;
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public DocumentSymbol setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public Range getSelectionRange() {
        return new Range(this.jsonData.getJSONObject("selectionRange"));
    }

    public DocumentSymbol setSelectionRange(Range selectionRange) {
        this.jsonData.put("selectionRange", selectionRange.jsonData);
        return this;
    }

    public List<DocumentSymbol> getChildren() {
        JSONArray json = this.jsonData.optJSONArray("children");
        if (json == null) {
            return null;
        }
        ArrayList<DocumentSymbol> list = new ArrayList<DocumentSymbol>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new DocumentSymbol(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public DocumentSymbol setChildren(List<DocumentSymbol> children) {
        if (children != null) {
            JSONArray json = new JSONArray();
            for (DocumentSymbol documentSymbol : children) {
                json.put(documentSymbol.jsonData);
            }
            this.jsonData.put("children", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentSymbol other = (DocumentSymbol)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDetail(), other.getDetail())) {
            return false;
        }
        if (this.getKind() != other.getKind()) {
            return false;
        }
        if (!Objects.equals(this.getDeprecated(), other.getDeprecated())) {
            return false;
        }
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (!Objects.equals(this.getSelectionRange(), other.getSelectionRange())) {
            return false;
        }
        return Objects.equals(this.getChildren(), other.getChildren());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.getName());
        if (this.getDetail() != null) {
            hash = 29 * hash + Objects.hashCode(this.getDetail());
        }
        hash = 29 * hash + Objects.hashCode((Object)this.getKind());
        if (this.getDeprecated() != null) {
            hash = 29 * hash + Boolean.hashCode(this.getDeprecated());
        }
        hash = 29 * hash + Objects.hashCode(this.getRange());
        hash = 29 * hash + Objects.hashCode(this.getSelectionRange());
        if (this.getChildren() != null) {
            hash = 29 * hash + Objects.hashCode(this.getChildren());
        }
        return hash;
    }

    public static DocumentSymbol create(String name, String detail, SymbolKind kind, Range range, Range selectionRange, List<DocumentSymbol> children) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.putOpt("detail", detail);
        json.put("kind", kind.getIntValue());
        json.put("range", range.jsonData);
        json.put("selectionRange", selectionRange.jsonData);
        if (children != null) {
            JSONArray childrenJsonArr = new JSONArray();
            for (DocumentSymbol documentSymbol : children) {
                childrenJsonArr.put(documentSymbol.jsonData);
            }
            json.put("children", childrenJsonArr);
        }
        return new DocumentSymbol(json);
    }
}

