/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class Coverage
extends JSONBase {
    Coverage(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Range> getCovered() {
        JSONArray json = this.jsonData.getJSONArray("covered");
        ArrayList<Range> list = new ArrayList<Range>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Range(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Coverage setCovered(List<Range> covered) {
        JSONArray json = new JSONArray();
        for (Range range : covered) {
            json.put(range.jsonData);
        }
        this.jsonData.put("covered", json);
        return this;
    }

    public List<Range> getUncovered() {
        JSONArray json = this.jsonData.getJSONArray("uncovered");
        ArrayList<Range> list = new ArrayList<Range>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Range(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Coverage setUnovered(List<Range> uncovered) {
        JSONArray json = new JSONArray();
        for (Range range : uncovered) {
            json.put(range.jsonData);
        }
        this.jsonData.put("uncovered", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coverage other = (Coverage)obj;
        if (!Objects.equals(this.getCovered(), other.getCovered())) {
            return false;
        }
        return Objects.equals(this.getUncovered(), other.getUncovered());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.getCovered());
        hash = 97 * hash + Objects.hashCode(this.getUncovered());
        return hash;
    }

    public static Coverage create(List<Range> covered, List<Range> uncovered) {
        JSONObject json = new JSONObject();
        JSONArray itemsJsonArr = new JSONArray();
        for (Range range : covered) {
            itemsJsonArr.put(range.jsonData);
        }
        json.put("covered", itemsJsonArr);
        itemsJsonArr = new JSONArray();
        for (Range range : uncovered) {
            itemsJsonArr.put(range.jsonData);
        }
        json.put("uncovered", itemsJsonArr);
        return new Coverage(json);
    }
}

