/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.TextEdit;

public class ColorPresentation
extends JSONBase {
    ColorPresentation(JSONObject jsonData) {
        super(jsonData);
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public ColorPresentation setLabel(String label) {
        this.jsonData.put("label", label);
        return this;
    }

    public TextEdit getTextEdit() {
        return this.jsonData.has("textEdit") ? new TextEdit(this.jsonData.optJSONObject("textEdit")) : null;
    }

    public ColorPresentation setTextEdit(TextEdit textEdit) {
        this.jsonData.putOpt("textEdit", textEdit != null ? textEdit.jsonData : null);
        return this;
    }

    public List<TextEdit> getAdditionalTextEdits() {
        JSONArray json = this.jsonData.optJSONArray("additionalTextEdits");
        if (json == null) {
            return null;
        }
        ArrayList<TextEdit> list = new ArrayList<TextEdit>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new TextEdit(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public ColorPresentation setAdditionalTextEdits(List<TextEdit> additionalTextEdits) {
        if (additionalTextEdits != null) {
            JSONArray json = new JSONArray();
            for (TextEdit textEdit : additionalTextEdits) {
                json.put(textEdit.jsonData);
            }
            this.jsonData.put("additionalTextEdits", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorPresentation other = (ColorPresentation)obj;
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getTextEdit(), other.getTextEdit())) {
            return false;
        }
        return Objects.equals(this.getAdditionalTextEdits(), other.getAdditionalTextEdits());
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.getLabel());
        if (this.getTextEdit() != null) {
            hash = 83 * hash + Objects.hashCode(this.getTextEdit());
        }
        if (this.getAdditionalTextEdits() != null) {
            hash = 83 * hash + Objects.hashCode(this.getAdditionalTextEdits());
        }
        return hash;
    }

    public static ColorPresentation create(String label, TextEdit textEdit, List<TextEdit> additionalTextEdits) {
        JSONObject json = new JSONObject();
        json.put("label", label);
        json.putOpt("textEdit", textEdit != null ? textEdit.jsonData : null);
        if (additionalTextEdits != null) {
            JSONArray additionalTextEditsJsonArr = new JSONArray();
            for (TextEdit additionalTextEdit : additionalTextEdits) {
                additionalTextEditsJsonArr.put(additionalTextEdit.jsonData);
            }
            json.put("additionalTextEdits", additionalTextEditsJsonArr);
        }
        return new ColorPresentation(json);
    }
}

