/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.tools.api.lsp.LSPCommand;
import org.graalvm.tools.api.lsp.LSPExtension;
import org.graalvm.tools.api.lsp.LSPServerAccessor;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.exceptions.UnknownLanguageException;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.LanguageTriggerCharacters;
import org.graalvm.tools.lsp.server.VirtualLanguageServerFileProvider;
import org.graalvm.tools.lsp.server.request.CompletionRequestHandler;
import org.graalvm.tools.lsp.server.request.CoverageRequestHandler;
import org.graalvm.tools.lsp.server.request.HighlightRequestHandler;
import org.graalvm.tools.lsp.server.request.HoverRequestHandler;
import org.graalvm.tools.lsp.server.request.SignatureHelpRequestHandler;
import org.graalvm.tools.lsp.server.request.SourceCodeEvaluator;
import org.graalvm.tools.lsp.server.types.CompletionContext;
import org.graalvm.tools.lsp.server.types.CompletionList;
import org.graalvm.tools.lsp.server.types.CompletionOptions;
import org.graalvm.tools.lsp.server.types.Coverage;
import org.graalvm.tools.lsp.server.types.DocumentHighlight;
import org.graalvm.tools.lsp.server.types.ExecuteCommandParams;
import org.graalvm.tools.lsp.server.types.Hover;
import org.graalvm.tools.lsp.server.types.ServerCapabilities;
import org.graalvm.tools.lsp.server.types.SignatureHelp;
import org.graalvm.tools.lsp.server.types.SignatureHelpOptions;
import org.graalvm.tools.lsp.server.types.TextDocumentContentChangeEvent;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class TruffleAdapter
implements VirtualLanguageServerFileProvider {
    private final boolean developerMode;
    private final TruffleLogger logger;
    private final TruffleInstrument.Env envMain;
    private TruffleInstrument.Env envInternal;
    ContextAwareExecutor contextAwareExecutor;
    private SourceCodeEvaluator sourceCodeEvaluator;
    CompletionRequestHandler completionHandler;
    private HoverRequestHandler hoverHandler;
    private SignatureHelpRequestHandler signatureHelpHandler;
    private CoverageRequestHandler coverageHandler;
    private HighlightRequestHandler highlightHandler;
    private List<LSPCommand> extensionCommands;
    private LSPServerAccessor lspServer;
    private TextDocumentSurrogateMap surrogateMap;
    private final LanguageTriggerCharacters completionTriggerCharacters = new LanguageTriggerCharacters();
    private final LanguageTriggerCharacters signatureTriggerCharacters = new LanguageTriggerCharacters();

    public TruffleAdapter(TruffleInstrument.Env mainEnv, boolean developerMode) {
        this.envMain = mainEnv;
        this.developerMode = developerMode;
        this.logger = this.envMain.getLogger("");
    }

    public void register(TruffleInstrument.Env environment, ContextAwareExecutor executor) {
        this.envInternal = environment;
        this.contextAwareExecutor = executor;
        this.initSurrogateMap();
        this.createLSPRequestHandlers();
    }

    public TruffleLogger getLogger() {
        return this.logger;
    }

    private void createLSPRequestHandlers() {
        this.sourceCodeEvaluator = new SourceCodeEvaluator(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor);
        this.completionHandler = new CompletionRequestHandler(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor, this.sourceCodeEvaluator, this.completionTriggerCharacters);
        this.hoverHandler = new HoverRequestHandler(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor, this.completionHandler, this.developerMode);
        this.signatureHelpHandler = new SignatureHelpRequestHandler(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor, this.sourceCodeEvaluator, this.completionHandler, this.signatureTriggerCharacters);
        this.coverageHandler = new CoverageRequestHandler(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor, this.sourceCodeEvaluator);
        this.highlightHandler = new HighlightRequestHandler(this.envMain, this.envInternal, this.surrogateMap, this.contextAwareExecutor);
    }

    private void initSurrogateMap() {
        try {
            this.contextAwareExecutor.executeWithDefaultContext(() -> {
                this.logger.log(Level.CONFIG, "Truffle Runtime: {0}", (Object)Truffle.getRuntime().getName());
                return null;
            }).get();
            this.surrogateMap = new TextDocumentSurrogateMap(this.envInternal);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    TextDocumentSurrogate getOrCreateSurrogate(URI uri, String text, LanguageInfo languageInfo) {
        TextDocumentSurrogate surrogate = this.surrogateMap.getOrCreateSurrogate(uri, languageInfo);
        surrogate.setEditorText(text);
        return surrogate;
    }

    public void didClose(URI uri) {
        this.surrogateMap.remove(uri);
    }

    public Future<CallTarget> parse(String text, String langId, URI uri) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.parseWithEnteredContext(text, langId, uri));
    }

    protected CallTarget parseWithEnteredContext(String text, String langId, URI uri) throws DiagnosticsNotification {
        LanguageInfo languageInfo = this.findLanguageInfo(langId, this.envInternal.getTruffleFile(null, uri));
        TextDocumentSurrogate surrogate = this.getOrCreateSurrogate(uri, text, languageInfo);
        return this.parseWithEnteredContext(surrogate);
    }

    CallTarget parseWithEnteredContext(TextDocumentSurrogate surrogate) throws DiagnosticsNotification {
        return this.sourceCodeEvaluator.parse(surrogate);
    }

    public Future<?> reparse(URI uri) {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.parseWithEnteredContext(surrogate));
    }

    private LanguageInfo findLanguageInfo(String langId, TruffleFile truffleFile) {
        Map languages = this.envInternal.getLanguages();
        LanguageInfo langInfo = (LanguageInfo)languages.get(langId);
        if (langInfo != null) {
            return langInfo;
        }
        String possibleMimeType = langId;
        String actualLangId = Source.findLanguage((String)possibleMimeType);
        if (actualLangId == null) {
            try {
                actualLangId = Source.findLanguage((TruffleFile)truffleFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (actualLangId == null) {
                actualLangId = langId;
            }
        }
        if ((langInfo = (LanguageInfo)languages.get(actualLangId)) == null) {
            throw new UnknownLanguageException("Unknown language: " + actualLangId + ". Known languages are: " + String.valueOf(languages.keySet()));
        }
        return langInfo;
    }

    public Future<TextDocumentSurrogate> processChangesAndParse(List<? extends TextDocumentContentChangeEvent> list, URI uri) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.processChangesAndParseWithContextEntered(list, uri));
    }

    protected TextDocumentSurrogate processChangesAndParseWithContextEntered(List<? extends TextDocumentContentChangeEvent> list, URI uri) throws DiagnosticsNotification {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        if (surrogate == null) {
            throw new IllegalStateException("No internal mapping for uri=" + uri.toString() + " found.");
        }
        if (list.isEmpty()) {
            return surrogate;
        }
        surrogate.getChangeEventsSinceLastSuccessfulParsing().addAll(list);
        surrogate.setLastChange(list.get(list.size() - 1));
        surrogate.setEditorText(SourceUtils.applyTextDocumentChanges(list, surrogate.getSource(), surrogate, this.logger));
        this.sourceCodeEvaluator.parse(surrogate);
        return surrogate;
    }

    String getLanguageId(URI uri) {
        TextDocumentSurrogate doc = this.surrogateMap.get(uri);
        if (doc != null) {
            return doc.getLanguageId();
        }
        Future<String> future = this.contextAwareExecutor.executeWithDefaultContext(() -> {
            try {
                return Source.findLanguage((TruffleFile)this.envInternal.getTruffleFile(null, uri));
            }
            catch (IOException ex) {
                return null;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setServerCapabilities(String languageId, ServerCapabilities capabilities) {
        List<String> triggerCharacters;
        SignatureHelpOptions signatureHelpProvider;
        List<String> triggerCharacters2;
        CompletionOptions completionProvider = capabilities.getCompletionProvider();
        if (completionProvider != null && (triggerCharacters2 = completionProvider.getTriggerCharacters()) != null) {
            this.completionTriggerCharacters.add(languageId, triggerCharacters2);
        }
        if ((signatureHelpProvider = capabilities.getSignatureHelpProvider()) != null && (triggerCharacters = signatureHelpProvider.getTriggerCharacters()) != null) {
            this.signatureTriggerCharacters.add(languageId, triggerCharacters);
        }
    }

    public Future<CompletionList> completion(URI uri, int line, int column, CompletionContext completionContext) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.completionHandler.completionWithEnteredContext(uri, line, column, completionContext));
    }

    public Future<Hover> hover(URI uri, int line, int column) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.hoverHandler.hoverWithEnteredContext(uri, line, column));
    }

    public Future<SignatureHelp> signatureHelp(URI uri, int line, int character) {
        return this.contextAwareExecutor.executeWithNestedContext(() -> this.signatureHelpHandler.signatureHelpWithEnteredContext(uri, line, character), true);
    }

    public Future<Boolean> runCoverageAnalysis(URI uri) {
        Future<Boolean> future = this.contextAwareExecutor.executeWithDefaultContext(() -> {
            this.contextAwareExecutor.resetContextCache();
            Future<Boolean> futureCoverage = this.contextAwareExecutor.executeWithNestedContext(() -> this.coverageHandler.runCoverageAnalysisWithEnteredContext(uri), true);
            try {
                return futureCoverage.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        });
        return future;
    }

    public Future<Coverage> getCoverage(URI uri) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.coverageHandler.getCoverageWithEnteredContext(uri));
    }

    public Future<List<? extends DocumentHighlight>> documentHighlight(URI uri, int line, int character) {
        return this.contextAwareExecutor.executeWithDefaultContext(() -> this.highlightHandler.highlightWithEnteredContext(uri, line, character));
    }

    public boolean hasCoverageData(URI uri) {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        return surrogate != null ? surrogate.hasCoverageData() : false;
    }

    @Override
    public String getSourceText(Path path) {
        if (this.surrogateMap == null) {
            return null;
        }
        TextDocumentSurrogate surrogate = this.surrogateMap.get(path.toUri());
        return surrogate != null ? surrogate.getEditorText() : null;
    }

    public Source getSource(URI uri) {
        if (this.surrogateMap == null) {
            return null;
        }
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        return surrogate != null ? surrogate.getSource() : null;
    }

    @Override
    public boolean isVirtualFile(Path path) {
        return this.surrogateMap.containsSurrogate(path.toUri());
    }

    public Function<URI, TextDocumentSurrogate> surrogateGetter(LanguageInfo languageInfo) {
        return sourceUri -> this.surrogateMap.getOrCreateSurrogate((URI)sourceUri, () -> languageInfo);
    }

    public void initializeLSPServer(LSPServerAccessor server) {
        this.lspServer = server;
    }

    private List<LSPCommand> getExternalCommands() {
        if (this.extensionCommands == null) {
            this.extensionCommands = new ArrayList<LSPCommand>();
            for (InstrumentInfo instrument : this.envMain.getInstruments().values()) {
                LSPExtension extension;
                if ("lsp".equals(instrument.getId()) || (extension = (LSPExtension)this.envMain.lookup(instrument, LSPExtension.class)) == null) continue;
                for (LSPCommand command : extension.getCommands()) {
                    this.extensionCommands.add(command);
                }
            }
        }
        return this.extensionCommands;
    }

    public Collection<String> getExtensionCommandNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (LSPCommand command : this.getExternalCommands()) {
            result.add(command.getName());
        }
        return result;
    }

    public Future<?> createExtensionCommand(ExecuteCommandParams params) {
        String commandName = params.getCommand();
        for (LSPCommand command : this.getExternalCommands()) {
            if (!commandName.equals(command.getName())) continue;
            List<Object> args = params.getArguments();
            return this.contextAwareExecutor.executeWithNestedContext(() -> command.execute(this.lspServer, this.envInternal, args), command.getTimeoutMillis(), () -> command.onTimeout(args));
        }
        return null;
    }
}

