/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageBuilder;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageObjectReplacer;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.runtime.enterprise.a;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public final class a
extends com.oracle.truffle.runtime.enterprise.a {
    public static final OptionKey<String> Px = new OptionKey((Object)"");
    public static final OptionKey<String> Py = new OptionKey((Object)"");
    public static final OptionKey<String> Pz = new OptionKey((Object)"");
    public static final OptionKey<Boolean> PA = new OptionKey((Object)true);
    public static final OptionKey<a.a> PB = new OptionKey((Object)a.a.MN);
    public static final OptionKey<Boolean> PC = new OptionKey((Object)Boolean.TRUE);
    public static final OptionKey<f> PD = new OptionKey((Object)f.PO);
    public static final OptionKey<Boolean> PE = new OptionKey((Object)false);
    private final ThreadLocal<b> PF = new ThreadLocal();

    public OptionDescriptors getEngineOptions() {
        return new com.oracle.svm.enterprise.truffle.b();
    }

    public int getPriority() {
        return 20;
    }

    public Object tryLoadingCachedEngine(OptionValues optionValues, Function<String, TruffleLogger> function) {
        if (!TruffleOptions.AOT) {
            return null;
        }
        Path path = a.a(optionValues);
        if (path == null) {
            this.a(optionValues, function, "No load engine cache configured.", new Object[0]);
            return null;
        }
        if (!((Boolean)c.AuxiliaryEngineCache.getValue()).booleanValue()) {
            throw new IllegalArgumentException("Cache image cannot be loaded. Native image does not support auxilliary engine caching. Enable with -H:+AuxiliaryEngineCache at image build time.");
        }
        assert (this.PF.get() == null);
        b b2 = this.a(optionValues, function, path);
        if (b2 == null) {
            return null;
        }
        this.PF.set(b2);
        return b2.jF();
    }

    private static Path a(OptionValues optionValues) {
        Path path;
        if (optionValues.hasBeenSet(Px)) {
            if (optionValues.hasBeenSet(Py)) {
                throw new IllegalArgumentException("The options engine.CachePath and engine.CacheLoadPath are mutually exclusive.");
            }
            path = Paths.get((String)optionValues.get(Px), new String[0]);
        } else if (optionValues.hasBeenSet(Py)) {
            path = Paths.get((String)optionValues.get(Py), new String[0]);
        } else {
            return null;
        }
        return path;
    }

    private static Path b(OptionValues optionValues) {
        Path path;
        if (optionValues.hasBeenSet(Px)) {
            if (optionValues.hasBeenSet(Pz)) {
                throw new IllegalArgumentException("The options engine.CachePath and engine.CacheStorePath are mutually exclusive.");
            }
            path = Paths.get((String)optionValues.get(Px), new String[0]);
        } else if (optionValues.hasBeenSet(Pz)) {
            path = Paths.get((String)optionValues.get(Pz), new String[0]);
        } else {
            return null;
        }
        return path;
    }

    private b a(OptionValues optionValues, Function<String, TruffleLogger> function, Path path) {
        if (AuxiliaryImageLoader.hasLoaded()) {
            throw new IllegalStateException("Auxiliary image memory is already in use. Only one image can be loaded per process.");
        }
        boolean bl2 = (Boolean)optionValues.get(PE);
        try {
            long l2 = 0L;
            if (bl2) {
                l2 = System.currentTimeMillis();
                this.a(optionValues, function, "Try loading image '%s'...", new Object[]{path});
            }
            if (!Files.exists(path, new LinkOption[0])) {
                this.a(optionValues, function, "Failed to load image. File does not exist.", new Object[]{path});
                return null;
            }
            File file = path.toFile();
            AuxiliaryImage auxiliaryImage = AuxiliaryImageLoader.load(file);
            if (!auxiliaryImage.contains(b.class)) {
                this.a(optionValues, function, "Failed to load image. Image ignored.", new Object[]{path});
                return null;
            }
            b b2 = auxiliaryImage.lookup(b.class);
            if (bl2) {
                l2 = System.currentTimeMillis() - l2;
                this.a(optionValues, function, "Loaded image in %d ms. %,6d bytes %3d sources %3d roots", new Object[]{l2, file.length(), b2.jG().length, b2.jH().length});
            }
            return b2;
        }
        catch (Throwable throwable) {
            if (bl2) {
                this.a(optionValues, function, "Failed to load image from %s. Image ignored.", new Object[]{path});
                throwable.printStackTrace(TTY.out);
            }
            return null;
        }
    }

    public void onEngineCreated(EngineData engineData) {
    }

    public void onEnginePatch(EngineData engineData) {
        if (!TruffleOptions.AOT) {
            return;
        }
        b b2 = this.PF.get();
        if (b2 != null) {
            this.a(engineData, "Engine from image successfully patched with new options.", new Object[]{b2});
            engineData.putEngineLocal(b.class, (Object)b2);
            this.PF.set(null);
            engineData.mergeLoadedSources(b2.jG());
        }
    }

    protected OptionKey<Boolean> lv() {
        return PE;
    }

    public boolean isStoreEnabled(OptionValues optionValues) {
        return TruffleOptions.AOT && a.b(optionValues) != null;
    }

    public boolean onEngineClosing(EngineData engineData) {
        Path path;
        if (!TruffleOptions.AOT) {
            return false;
        }
        a.a a2 = (a.a)engineData.getEngineOptions().get(PB);
        boolean bl2 = (Boolean)engineData.getEngineOptions().get(this.lv());
        if (this.PF.get() != null) {
            this.PF.set(null);
        }
        if ((path = a.b(engineData.getEngineOptions())) == null) {
            this.a(engineData, "No store engine cache configured.", new Object[0]);
            return false;
        }
        if (!((Boolean)c.AuxiliaryEngineCache.getValue()).booleanValue()) {
            throw new IllegalArgumentException("Cache image cannot be stored. Native image does not support auxilliary engine caching. Enable with -H:+AuxiliaryEngineCache at image build time.");
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            throw new IllegalStateException("Configured store image path is not writable: " + String.valueOf(path.toAbsolutePath()));
        }
        path = path.toAbsolutePath();
        long l2 = 0L;
        if (bl2) {
            this.a(engineData, "Preparing engine for store (compile policy %s)...", new Object[]{a2});
            l2 = System.currentTimeMillis();
        }
        OptionValues optionValues = engineData.getEngineOptions();
        b b2 = new b(this.a(engineData, a2, (Boolean)optionValues.get(PC), (Boolean)optionValues.get(PA)));
        if (bl2) {
            l2 = System.currentTimeMillis() - l2;
            this.a(engineData, "Prepared engine in %,d ms.", new Object[]{l2});
        }
        b b3 = (b)engineData.getEngineLocal(b.class);
        engineData.clearEngineLocal(b.class);
        ByteBuffer byteBuffer = this.a(engineData, b3, b2);
        try {
            if (byteBuffer != null) {
                if (bl2) {
                    this.a(engineData, "Writing image to %s...", new Object[]{path});
                    l2 = System.currentTimeMillis();
                }
                int n2 = a.a(byteBuffer, path.toFile());
                if (bl2) {
                    l2 = System.currentTimeMillis() - l2;
                    this.a(engineData, "Finished writing %,5d bytes in %,d ms.", new Object[]{n2, l2});
                }
            } else {
                this.a(engineData, "Skipped image write. ", new Object[]{path});
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed writing image " + String.valueOf(iOException), iOException);
        }
        return false;
    }

    private ByteBuffer a(EngineData engineData, b b2, b b3) throws AssertionError {
        ByteBuffer byteBuffer;
        boolean bl2 = (Boolean)engineData.getEngineOptions().get(PE);
        long l2 = 0L;
        if (bl2) {
            this.a(engineData, "Persisting engine for store ...", new Object[0]);
            l2 = System.currentTimeMillis();
        }
        AuxiliaryImageBuilder auxiliaryImageBuilder = new AuxiliaryImageBuilder();
        auxiliaryImageBuilder.add(b.class, b3);
        e e2 = new e(b3.jG());
        a a2 = new a(b3.jH());
        auxiliaryImageBuilder.registerObjectReplacer(e2);
        auxiliaryImageBuilder.registerObjectReplacer(a2);
        final Object object = engineData.getEngineLock();
        final Object object2 = new Object();
        auxiliaryImageBuilder.registerObjectReplacer(new AuxiliaryImageObjectReplacer(){

            @Override
            public Object replace(Object object3, AuxiliaryImageObjectReplacer.Access access) {
                if (object3 == object) {
                    return object2;
                }
                return object3;
            }
        });
        try {
            byteBuffer = auxiliaryImageBuilder.persist();
        }
        catch (Throwable throwable) {
            if (bl2) {
                this.a(engineData, "Failed to persist engine to buffer.", new Object[0]);
                this.a(engineData, String.valueOf(throwable), new Object[0]);
            }
            throw new IllegalStateException("Failed persisting image " + String.valueOf(throwable), throwable);
        }
        if (bl2) {
            l2 = System.currentTimeMillis() - l2;
            this.a(engineData, "Persisted engine in %d ms.", new Object[]{l2});
        }
        f f2 = (f)((Object)engineData.getEngineOptions().get(PD));
        if (bl2) {
            this.a(engineData, "Detecting changes (update policy %s)...", new Object[]{f2.toString()});
        }
        if (b2 != null) {
            this.a(engineData, "    Previous image contains  %3d sources and %3d function roots.", new Object[]{b2.jG().length, b2.jH().length});
        }
        this.a(engineData, "    New image contains       %3d sources and %3d function roots.", new Object[]{e2.jI().size(), a2.jI().size(), engineData.getCallTargets().size()});
        switch (f2) {
            case PO: {
                this.a(engineData, "    Always persist policy. ", new Object[0]);
                break;
            }
            case PQ: {
                if (b2 == null) {
                    if (!bl2) break;
                    this.a(engineData, "    New image detected -> always persist.", new Object[0]);
                    break;
                }
                Source[] sourceArray = b2.jG();
                if (!a.a(sourceArray, e2.jI())) {
                    byteBuffer = null;
                }
                if (!bl2) break;
                this.a(engineData, "sources", sourceArray, e2.jI(), byteBuffer != null);
                break;
            }
            case PP: {
                CallTarget[] callTargetArray;
                if (b2 == null) {
                    if (!bl2) break;
                    this.a(engineData, "    New image detected -> always persist.", new Object[0]);
                    break;
                }
                CallTarget[] callTargetArray2 = callTargetArray = b2 == null ? null : b2.jH();
                if (!a.a(callTargetArray, a2.jI())) {
                    byteBuffer = null;
                }
                if (!bl2) break;
                this.a(engineData, "function roots", callTargetArray, a2.jI(), byteBuffer != null);
                break;
            }
            case PR: {
                byteBuffer = null;
                this.a(engineData, "    Never persist policy. Keep previous image.", new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return byteBuffer;
    }

    private <T> void a(EngineData engineData, String string2, T[] TArray, Set<T> set, boolean bl2) {
        if (bl2) {
            HashSet<T> hashSet = new HashSet<T>();
            hashSet.addAll(set);
            if (TArray != null) {
                for (Object object2 : TArray) {
                    hashSet.remove(object2);
                }
            }
            this.a(engineData, "    Changed %s detected:", new Object[]{string2});
            hashSet.stream().map(object -> object.toString() + " 0x" + Integer.toHexString(System.identityHashCode(object))).sorted().forEach(string -> this.a(engineData, "      + %s", new Object[]{string}));
            hashSet.clear();
            if (TArray != null) {
                for (Object object2 : TArray) {
                    hashSet.add(object2);
                }
            }
            for (Object e2 : set) {
                hashSet.remove(e2);
            }
            hashSet.stream().map(object -> object.toString() + " 0x" + Integer.toHexString(System.identityHashCode(object))).sorted().forEach(string -> this.a(engineData, "      - %s", new Object[]{string}));
        } else {
            this.a(engineData, "    No changed %s detected.", new Object[]{string2});
        }
    }

    private static <T> boolean a(T[] TArray, Set<T> set) {
        if (TArray == null) {
            return true;
        }
        if (TArray.length != set.size()) {
            return true;
        }
        if (TArray.length == 0) {
            return false;
        }
        return !set.containsAll(Arrays.asList(TArray));
    }

    static int a(ByteBuffer byteBuffer, File file) throws IOException {
        Files.deleteIfExists(file.toPath());
        try (FileChannel fileChannel = new FileOutputStream(file).getChannel();){
            int n2 = fileChannel.write(byteBuffer);
            return n2;
        }
    }

    public void onEngineClosed(EngineData engineData) {
    }

    public static class c {
        public static final HostedOptionKey<Boolean> AuxiliaryEngineCache = new HostedOptionKey((Object)false);
    }

    private static final class b {
        private final Object PJ;
        private final Source[] PK = new Source[0];
        private final CallTarget[] PL = new CallTarget[0];

        b(Object object) {
            this.PJ = object;
        }

        public Object jF() {
            return this.PJ;
        }

        public Source[] jG() {
            return this.PK;
        }

        public CallTarget[] jH() {
            return this.PL;
        }

        public String toString() {
            return "CachedEngine[" + String.valueOf(this.PJ) + "]";
        }
    }

    static final class e
    extends d<Source> {
        e(Source[] sourceArray) {
            super(sourceArray);
        }

        protected Source[] aG(int n2) {
            return new Source[n2];
        }

        @Override
        protected boolean z(Object object) {
            return object instanceof Source;
        }

        @Override
        protected /* synthetic */ Object[] aF(int n2) {
            return this.aG(n2);
        }
    }

    static final class a
    extends d<CallTarget> {
        a(CallTarget[] callTargetArray) {
            super(callTargetArray);
        }

        protected CallTarget[] aE(int n2) {
            return new CallTarget[n2];
        }

        @Override
        protected boolean z(Object object) {
            return object instanceof OptimizedCallTarget;
        }

        @Override
        protected /* synthetic */ Object[] aF(int n2) {
            return this.aE(n2);
        }
    }

    public static final class f
    extends Enum<f> {
        public static final /* enum */ f PO = new f();
        public static final /* enum */ f PP = new f();
        public static final /* enum */ f PQ = new f();
        public static final /* enum */ f PR = new f();
        private static final /* synthetic */ f[] $VALUES;

        public static f[] values() {
            return (f[])$VALUES.clone();
        }

        public static f an(String string) {
            return Enum.valueOf(f.class, string);
        }

        private static /* synthetic */ f[] jJ() {
            return new f[]{PO, PP, PQ, PR};
        }

        static {
            $VALUES = f.jJ();
        }
    }

    static abstract class d<T>
    implements AuxiliaryImageObjectReplacer {
        private final T[] PM;
        private final Set<T> PN = Collections.newSetFromMap(new IdentityHashMap());

        d(T[] TArray) {
            this.PM = TArray;
        }

        protected abstract boolean z(Object var1);

        @Override
        public final Object replace(Object object, AuxiliaryImageObjectReplacer.Access access) {
            if (this.z(object)) {
                this.PN.add(object);
            }
            return object;
        }

        protected abstract T[] aF(int var1);

        @Override
        public final void epilogue(AuxiliaryImageObjectReplacer.EpilogueAccess epilogueAccess) {
            T[] TArray = this.PN.toArray(this.aF(this.PN.size()));
            epilogueAccess.replaceLate(this.PM, TArray);
        }

        public final Set<T> jI() {
            return this.PN;
        }
    }
}

