/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.h;
import com.oracle.svm.enterprise.profiling.f;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.a;
import com.oracle.svm.enterprise.profiling.metadata.elements.c;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.util.json.JSONParser;
import org.graalvm.util.json.JSONParserException;

public abstract class ProfilingLoader<T, M> {
    public abstract e loadProfile(Path var1);

    public ProfilingBaseProfile loadProfile(List<Path> list, long l2, ProfileData.ProfileSource profileSource) {
        VMError.guarantee((profileSource.isProfiled() || profileSource.isAdopted() || profileSource.isUnknown() ? 1 : 0) != 0);
        return list.stream().map(this::loadProfile).map(e2 -> this.newProfile((e)e2, profileSource)).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).reduce(ProfilingBaseProfile::merge).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).orElse(null);
    }

    public abstract ProfilingBaseProfile newProfile(e var1, ProfileData.ProfileSource var2);

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<d> getGlobalTypes();

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<c> getGlobalMethods();

    public abstract Map<Integer, T> loadTypes(Map<Integer, d> var1);

    public abstract Map<Integer, M> loadMethods(Map<Integer, d> var1, Map<Integer, c> var2);

    public final void loadNodes(b b2, h h2, List<com.oracle.svm.enterprise.profiling.collect.d> list, byte by2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b3) {
        for (com.oracle.svm.enterprise.profiling.collect.d d2 : list) {
            List<a<?>> list2 = f.a(d2.it(), this.getCodePositionGenerator(b2, by2), b3);
            long[] lArray = d2.is();
            com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.s(list2);
            com.oracle.svm.enterprise.profiling.metadata.cctree.d d3 = e2.iS();
            if (e2.iT() && d3 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d3;
                c2.a(h2, lArray);
                continue;
            }
            int n2 = h2.az(lArray.length);
            h2.a(n2, lArray);
            b2.a(list2, by2, n2);
        }
    }

    protected abstract BiFunction<M, Integer, a<?>> getCodePositionGenerator(b var1, byte var2);

    protected static e loadProfile0(Path path, Consumer<String> consumer) {
        try {
            FileInputStream fileInputStream = new FileInputStream(path.toFile());
            InputStream inputStream = ProfilingLoader.handleGzipStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            Object object = new JSONParser((Reader)inputStreamReader).parse();
            e e2 = new e(object);
            com.oracle.svm.enterprise.profiling.collect.b b2 = e2.iu();
            if (b2.iq()) {
                consumer.accept(String.format("Profiles from %s are outdated. Profiles version doesn't exist.", path));
            }
            if (b2.ip()) {
                consumer.accept(String.format("Profiles from %s are outdated. File version %s is older that the latest version %s", path, b2.io(), "0.4.0"));
            }
            return e2;
        }
        catch (IOException iOException) {
            consumer.accept("Cannot load profile: " + String.valueOf(path) + ". Verify that the file exists and has appropriate access rights.");
        }
        catch (JSONParserException jSONParserException) {
            consumer.accept("Malformed JSON in " + String.valueOf(path));
        }
        return null;
    }

    private static InputStream handleGzipStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        pushbackInputStream.unread(n3);
        pushbackInputStream.unread(n2);
        int n4 = n3 << 8 | n2;
        if (n4 == 35615) {
            return new GZIPInputStream(pushbackInputStream);
        }
        return pushbackInputStream;
    }
}

