/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profiling.phases;

import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.nodes.a;
import com.oracle.svm.enterprise.profiling.nodes.e;
import com.oracle.svm.enterprise.profiling.nodes.f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.FilteredNodeIterable;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfilingInstrumentationPhase
extends BasePhase<CoreProviders> {
    public static final int LR = 0;
    private final CanonicalizerPhase LS;

    public ProfilingInstrumentationPhase(CanonicalizerPhase canonicalizerPhase) {
        this.LS = canonicalizerPhase;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        ControlSplitNode controlSplitNode;
        Object object3;
        Object object22;
        assert (structuredGraph.trackNodeSourcePosition()) : "Without source positions AOT instrumentation is useless.";
        ProfilingInstrumentationPhase.a(structuredGraph.start());
        EconomicMap<NodeSourcePosition, List<ControlSplitNode>> economicMap = ProfilingInstrumentationPhase.o(structuredGraph);
        for (Object object22 : economicMap.getValues()) {
            object3 = object22.iterator();
            while (object3.hasNext()) {
                controlSplitNode = (ControlSplitNode)object3.next();
                ProfilingInstrumentationPhase.d(controlSplitNode);
            }
        }
        FilteredNodeIterable filteredNodeIterable = structuredGraph.getNodes(MethodCallTargetNode.TYPE).filter(node -> ((MethodCallTargetNode)node).invokeKind().isIndirect());
        for (Object object3 : filteredNodeIterable) {
            assert (object3.getNodeSourcePosition() != null);
            ProfilingInstrumentationPhase.d((MethodCallTargetNode)object3);
        }
        object22 = structuredGraph.getNodes(MonitorEnterNode.TYPE);
        object3 = object22.iterator();
        while (object3.hasNext()) {
            controlSplitNode = (MonitorEnterNode)object3.next();
            assert (controlSplitNode.getNodeSourcePosition() != null);
            ProfilingInstrumentationPhase.a((MonitorEnterNode)controlSplitNode);
        }
        this.LS.apply(structuredGraph, (Object)coreProviders);
    }

    public static EconomicMap<NodeSourcePosition, List<ControlSplitNode>> o(StructuredGraph structuredGraph) {
        return ProfilingInstrumentationPhase.c((NodeIterable<Node>)ProfilingInstrumentationPhase.p(structuredGraph).filter(node -> !ProfilingInstrumentationPhase.b((ControlSplitNode)node)).filter(node -> !ProfilingInstrumentationPhase.p(node)));
    }

    public static NodeIterable<Node> p(StructuredGraph structuredGraph) {
        return structuredGraph.getNodes().filter(node -> node instanceof IfNode || node instanceof SwitchNode);
    }

    public static boolean b(ControlSplitNode controlSplitNode) {
        for (Node node : controlSplitNode.successors().snapshot()) {
            if (!(((AbstractBeginNode)node).next() instanceof BytecodeExceptionNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean p(Node node) {
        for (NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition(); nodeSourcePosition != null; nodeSourcePosition = nodeSourcePosition.getCaller()) {
            if (nodeSourcePosition.getBCI() != -5 && nodeSourcePosition.getBCI() != -6) continue;
            return true;
        }
        return false;
    }

    private static EconomicMap<NodeSourcePosition, List<ControlSplitNode>> c(NodeIterable<Node> nodeIterable) {
        EconomicMap economicMap = EconomicMap.create();
        nodeIterable.forEach(node -> {
            NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
            if (economicMap.containsKey((Object)nodeSourcePosition)) {
                List list = (List)economicMap.get((Object)nodeSourcePosition);
                economicMap.put((Object)nodeSourcePosition, ProfilingInstrumentationPhase.a((ControlSplitNode)node, list));
            } else {
                ArrayList<ControlSplitNode> arrayList = new ArrayList<ControlSplitNode>();
                arrayList.add((ControlSplitNode)node);
                economicMap.put((Object)nodeSourcePosition, arrayList);
            }
        });
        return economicMap;
    }

    private static List<ControlSplitNode> a(ControlSplitNode controlSplitNode, List<ControlSplitNode> list) {
        assert (controlSplitNode.getNodeSourcePosition().equals((Object)list.get(0).getNodeSourcePosition())) : "This method distinguishes between nodes with the same source position.";
        if (!ProfilingInstrumentationPhase.c(controlSplitNode)) {
            return list;
        }
        if (!ProfilingInstrumentationPhase.c(list.get(0))) {
            list.remove(0);
        }
        list.add(controlSplitNode);
        return list;
    }

    public static boolean c(ControlSplitNode controlSplitNode) {
        double d2 = 1.0 / (double)controlSplitNode.successors().count();
        for (Node node : controlSplitNode.successors().snapshot()) {
            if (Double.compare(controlSplitNode.probability((AbstractBeginNode)node), d2) == 0) continue;
            return false;
        }
        return true;
    }

    private static void a(StartNode startNode) {
        StructuredGraph structuredGraph = startNode.graph();
        ResolvedJavaMethod resolvedJavaMethod = structuredGraph.method();
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, resolvedJavaMethod, 0);
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(nodeSourcePosition);){
            structuredGraph.addAfterFixed((FixedWithNextNode)startNode, (FixedNode)structuredGraph.add((Node)new f(resolvedJavaMethod, d.Nd.iB())));
        }
    }

    private static void d(ControlSplitNode controlSplitNode) {
        StructuredGraph structuredGraph = controlSplitNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)controlSplitNode);){
            controlSplitNode.successors().forEach(node -> structuredGraph.addAfterFixed((FixedWithNextNode)node, (FixedNode)structuredGraph.add((Node)new a(node.getNodeSourcePosition().getBCI(), ProfilingInstrumentationPhase.e(controlSplitNode), ProfilingInstrumentationPhase.f(controlSplitNode), d.Ne.iB()))));
        }
    }

    private static int[] e(ControlSplitNode controlSplitNode) {
        if (controlSplitNode instanceof IfNode) {
            return ProfilingInstrumentationPhase.b((IfNode)controlSplitNode);
        }
        assert (controlSplitNode instanceof SwitchNode);
        return ProfilingInstrumentationPhase.a((SwitchNode)controlSplitNode);
    }

    private static int[] b(IfNode ifNode) {
        int[] nArray = new int[ifNode.successors().count()];
        nArray[0] = ifNode.trueSuccessor().getNodeSourcePosition().getBCI();
        nArray[1] = ifNode.falseSuccessor().getNodeSourcePosition().getBCI();
        return nArray;
    }

    private static int[] a(SwitchNode switchNode) {
        List list = switchNode.successors().snapshot();
        int[] nArray = switchNode.getKeySuccessors();
        int[] nArray2 = new int[nArray.length];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!hashSet.contains(nArray[i2])) {
                nArray2[i2] = ((Node)list.get(nArray[i2])).getNodeSourcePosition().getBCI();
                hashSet.add(nArray[i2]);
                continue;
            }
            nArray2[i2] = -5;
        }
        return nArray2;
    }

    private static int[] f(ControlSplitNode controlSplitNode) {
        if (controlSplitNode instanceof IfNode) {
            return ProfilingInstrumentationPhase.if();
        }
        assert (controlSplitNode instanceof SwitchNode);
        return ProfilingInstrumentationPhase.b((SwitchNode)controlSplitNode);
    }

    private static int[] b(SwitchNode switchNode) {
        return switchNode.getKeySuccessors();
    }

    private static int[] if() {
        return new int[]{0, 1};
    }

    private static void d(MethodCallTargetNode methodCallTargetNode) {
        StructuredGraph structuredGraph = methodCallTargetNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)methodCallTargetNode);){
            Object object;
            ResolvedJavaType[] resolvedJavaTypeArray;
            if (methodCallTargetNode.getTypeProfile() == null) {
                resolvedJavaTypeArray = null;
            } else {
                object = methodCallTargetNode.getTypeProfile().getTypes();
                resolvedJavaTypeArray = new ResolvedJavaType[((JavaTypeProfile.ProfiledType[])object).length];
                for (int i2 = 0; i2 < ((JavaTypeProfile.ProfiledType[])object).length; ++i2) {
                    resolvedJavaTypeArray[i2] = object[i2].getType();
                }
            }
            object = new com.oracle.svm.enterprise.profiling.nodes.d(methodCallTargetNode.receiver(), resolvedJavaTypeArray);
            structuredGraph.addBeforeFixed(methodCallTargetNode.invoke().asFixedNode(), (FixedWithNextNode)structuredGraph.add((Node)object));
            object.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)object.predecessor())).duplicateWithVirtualState());
        }
    }

    private static void a(MonitorEnterNode monitorEnterNode) {
        StructuredGraph structuredGraph = monitorEnterNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)monitorEnterNode);){
            e e2 = new e(monitorEnterNode.object());
            structuredGraph.addAfterFixed((FixedWithNextNode)monitorEnterNode, (FixedNode)structuredGraph.add((Node)e2));
            e2.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)e2.predecessor())).duplicateWithVirtualState());
        }
    }
}

