/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.aotinliner.a;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;

public class HotMethodDuplicationPhase
extends BasePhase<LowTierContext> {
    private static final AtomicInteger IN = new AtomicInteger();
    private final Function<HostedMethod, d.b> IO;

    public HotMethodDuplicationPhase(Function<HostedMethod, d.b> function) {
        this.IO = function;
    }

    protected void a(StructuredGraph structuredGraph, LowTierContext lowTierContext) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not run on cold compilation units";
        b b2 = new b(structuredGraph);
        d.b b3 = this.IO.apply((HostedMethod)structuredGraph.method());
        HotMethodDuplicationPhase.b(structuredGraph, invoke -> {
            HostedMethod hostedMethod;
            NodeSourcePosition nodeSourcePosition = FrameState.toSourcePosition((FrameState)invoke.stateDuring());
            d.b b4 = b3.a((BytecodePosition)nodeSourcePosition, (ResolvedJavaMethod)(hostedMethod = (HostedMethod)invoke.getTargetMethod()));
            if (b4 == null || !b4.gX()) {
                return;
            }
            HostedMethod hostedMethod2 = HotMethodDuplicationPhase.a(b2, (BytecodePosition)nodeSourcePosition, hostedMethod, b4);
            assert (invoke.callTarget() != null);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)hostedMethod2);
        });
    }

    private static HostedMethod a(b b2, BytecodePosition bytecodePosition, HostedMethod hostedMethod, d.b b3) {
        HostedMethod hostedMethod2;
        if (((Boolean)c.IY.getValue(b2.IQ.getOptions())).booleanValue() && b3.gY() && (hostedMethod2 = HotMethodDuplicationPhase.a(b3, hostedMethod)) != null) {
            HotMethodDuplicationPhase.a(b2, hostedMethod2, "Reusing method");
            return hostedMethod2;
        }
        hostedMethod2 = b2.a(hostedMethod, bytecodePosition);
        HotMethodDuplicationPhase.a(b2, hostedMethod2, "Duplicated method");
        return hostedMethod2;
    }

    private static void a(b b2, HostedMethod hostedMethod, String string) {
        if (((Boolean)c.IX.getValue(b2.IQ.getOptions())).booleanValue()) {
            ResolvedJavaMethod resolvedJavaMethod = b2.IQ.method();
            b2.IQ.getDebug().log("[HotMethodDuplicationPhase] %s: %s called from %s", (Object)string, (Object)hostedMethod.format("%h.%n"), (Object)resolvedJavaMethod.format("%h.%n"));
        }
    }

    private static HostedMethod a(d.b b2, HostedMethod hostedMethod) {
        for (d.b b3 = b2; b3 != null; b3 = b3.gW()) {
            d.c c2 = (d.c)b3;
            HostedMethod hostedMethod2 = ((a.a)c2.gZ()).fB();
            if (hostedMethod2 == null || !Objects.equals(hostedMethod2.wrapped, hostedMethod.wrapped)) continue;
            return hostedMethod2;
        }
        return null;
    }

    private static void b(StructuredGraph structuredGraph, Consumer<Invoke> consumer) {
        for (Node node : structuredGraph.getNodes()) {
            Invoke invoke;
            if (!(node instanceof Invoke) || !(invoke = (Invoke)node).getInvokeKind().isDirect() || invoke.getTargetMethod() == null) continue;
            consumer.accept(invoke);
        }
    }

    protected /* synthetic */ void run(StructuredGraph structuredGraph, Object object) {
        this.a(structuredGraph, (LowTierContext)object);
    }

    private static final class b {
        private final StructuredGraph IQ;
        private final Map<a, HostedMethod> IR = new HashMap<a, HostedMethod>();
        private HostedMethod IS;
        private HostedMethod IT;
        private Map<Object, Object> IU;

        private b(StructuredGraph structuredGraph) {
            this.IQ = structuredGraph;
        }

        private HostedMethod a(HostedMethod hostedMethod, BytecodePosition bytecodePosition) {
            return this.IR.computeIfAbsent(new a(bytecodePosition, hostedMethod.wrapped), a2 -> this.p(hostedMethod));
        }

        private HostedMethod p(HostedMethod hostedMethod) {
            this.IS = hostedMethod;
            this.IT = hostedMethod.getOrCreateMultiMethod((MultiMethod.MultiMethodKey)new com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase$a());
            this.IU = new IdentityHashMap<Object, Object>();
            this.IT.compilationInfo.setCompileOptions(new OptionValues(hostedMethod.compilationInfo.getCompileOptions().getMap()));
            EncodedGraph encodedGraph = this.a(hostedMethod.compilationInfo.getCompilationGraph().getEncodedGraph());
            this.IT.compilationInfo.encodeGraph(this.a(encodedGraph, (ResolvedJavaMethod)this.IT));
            return this.IT;
        }

        private EncodedGraph a(EncodedGraph encodedGraph) {
            Object[] objectArray = encodedGraph.getObjects();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = this.u(objectArray[i2]);
            }
            return new EncodedGraph(Arrays.copyOf(encodedGraph.getEncoding(), encodedGraph.getEncoding().length), encodedGraph.getStartOffset(), objectArray2, Arrays.copyOf(encodedGraph.getNodeClasses(), encodedGraph.getNodeClasses().length), encodedGraph.getAssumptions(), encodedGraph.getInlinedMethods(), encodedGraph.hasUnsafeAccess(), encodedGraph.trackNodeSourcePosition());
        }

        private StructuredGraph a(EncodedGraph encodedGraph, ResolvedJavaMethod resolvedJavaMethod) {
            DebugContext debugContext = this.IQ.getDebug();
            StructuredGraph structuredGraph = new StructuredGraph.Builder(this.IQ.getOptions(), debugContext).method(resolvedJavaMethod).recordInlinedMethods(false).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).compilationId((CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID).build();
            try (DebugContext.Scope scope = debugContext.scope((Object)"HotMethodDuplicationPhase#decodeGraph", (Object)structuredGraph, (Object)resolvedJavaMethod);){
                new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, structuredGraph).decode(encodedGraph);
            }
            catch (Throwable throwable) {
                throw debugContext.handle(throwable);
            }
            return structuredGraph;
        }

        private Object u(Object object) {
            if (object == null) {
                return null;
            }
            return this.IU.computeIfAbsent(object, this::v);
        }

        private ResolvedJavaMethod k(ResolvedJavaMethod resolvedJavaMethod) {
            if (Objects.equals(resolvedJavaMethod, this.IS)) {
                return this.IT;
            }
            return (ResolvedJavaMethod)this.u(resolvedJavaMethod);
        }

        private Object v(Object object) {
            if (object instanceof Node) {
                throw VMError.shouldNotReachHere((String)"Must not replace a Graal graph nodes, only data objects referenced from a node");
            }
            if (object.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode resolvedJavaMethodBytecode = (ResolvedJavaMethodBytecode)object;
                HostedMethod hostedMethod = (HostedMethod)this.u(resolvedJavaMethodBytecode.getMethod());
                return new ResolvedJavaMethodBytecode(this.k((ResolvedJavaMethod)hostedMethod), resolvedJavaMethodBytecode.getOrigin());
            }
            if (object.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant substrateMethodPointerConstant = (SubstrateMethodPointerConstant)object;
                MethodPointer methodPointer = substrateMethodPointerConstant.pointer();
                ResolvedJavaMethod resolvedJavaMethod = methodPointer.getMethod();
                ResolvedJavaMethod resolvedJavaMethod2 = this.k(resolvedJavaMethod);
                return new SubstrateMethodPointerConstant(new MethodPointer(resolvedJavaMethod2));
            }
            if (object.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nodeSourcePosition = (NodeSourcePosition)object;
                NodeSourcePosition nodeSourcePosition2 = (NodeSourcePosition)this.u(nodeSourcePosition.getCaller());
                ResolvedJavaMethod resolvedJavaMethod = this.k(nodeSourcePosition.getMethod());
                return new NodeSourcePosition(nodeSourcePosition.getSourceLanguage(), nodeSourcePosition2, resolvedJavaMethod, nodeSourcePosition.getBCI(), nodeSourcePosition.getMarker());
            }
            return object;
        }

        private static final class a {
            final BytecodePosition IV;
            final AnalysisMethod IW;

            a(BytecodePosition bytecodePosition, AnalysisMethod analysisMethod) {
                this.IV = bytecodePosition;
                this.IW = analysisMethod;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                a a2 = (a)object;
                return Objects.equals(this.IV, a2.IV) && Objects.equals(this.IW, a2.IW);
            }

            public int hashCode() {
                return Objects.hash(this.IV, this.IW);
            }
        }
    }

    public static class c {
        public static final OptionKey<Boolean> IX = new OptionKey((Object)false);
        public static final OptionKey<Boolean> IY = new OptionKey((Object)true);
    }

    private static final class a
    implements MultiMethod.MultiMethodKey {
        final int IP = IN.getAndIncrement();

        private a() {
        }

        public String toString() {
            return "Hot_Method_Key_" + this.IP;
        }
    }
}

