/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.phases;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.pgo.c;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.profiling.phases.ProfilingInstrumentationPhase;
import com.oracle.svm.enterprise.profiling.kinds.a;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.d;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.phases.SingleRunSubphase;
import org.graalvm.compiler.phases.tiers.HighTierContext;

public class PGOApplyProfilesPhase
extends SingleRunSubphase<HighTierContext> {
    private final PGOProfilesLookup It;
    private final List<d> Iu;
    private final HostedUniverse Iv;
    private final d.b Iw;

    public PGOApplyProfilesPhase(List<d> list, HostedUniverse hostedUniverse, d.b b2, PGOProfilesLookup pGOProfilesLookup) {
        this.It = pGOProfilesLookup;
        this.Iu = list;
        this.Iv = hostedUniverse;
        this.Iw = b2;
    }

    public PGOApplyProfilesPhase(List<d> list, HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        this(list, hostedUniverse, null, pGOProfilesLookup);
    }

    public PGOApplyProfilesPhase(HostedUniverse hostedUniverse, d.b b2, PGOProfilesLookup pGOProfilesLookup) {
        this(Collections.emptyList(), hostedUniverse, b2, pGOProfilesLookup);
    }

    public PGOApplyProfilesPhase(HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        this(Collections.emptyList(), hostedUniverse, null, pGOProfilesLookup);
    }

    protected void a(StructuredGraph structuredGraph, HighTierContext highTierContext) {
        this.f(structuredGraph);
        this.g(structuredGraph);
    }

    private void f(StructuredGraph structuredGraph) {
        Consumer<MethodCallTargetNode> consumer = structuredGraph.globalProfileProvider().hotCaller() ? this::b : this::a;
        PGOApplyProfilesPhase.a(structuredGraph, consumer);
    }

    private void a(MethodCallTargetNode methodCallTargetNode) {
        this.c(methodCallTargetNode);
    }

    private static void a(StructuredGraph structuredGraph, Consumer<MethodCallTargetNode> consumer) {
        List list = structuredGraph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        for (MethodCallTargetNode methodCallTargetNode : list) {
            if (!methodCallTargetNode.invokeKind().isIndirect()) continue;
            consumer.accept(methodCallTargetNode);
        }
    }

    private void b(MethodCallTargetNode methodCallTargetNode) {
        this.a(methodCallTargetNode);
        if (this.Iw == null) {
            return;
        }
        JavaMethodProfile javaMethodProfile = this.Iw.a(this.Iv, (BytecodePosition)methodCallTargetNode.getNodeSourcePosition());
        if (javaMethodProfile != null) {
            ((SubstrateMethodCallTargetNode)methodCallTargetNode).setJavaMethodProfile(javaMethodProfile);
        }
    }

    private void c(MethodCallTargetNode methodCallTargetNode) {
        List<d> list = PGOApplyProfilesPhase.a(methodCallTargetNode.getNodeSourcePosition(), this.Iu);
        Optional<Map<AnalysisType, Long>> optional = this.It.getVirtualInvokeProfile(list);
        if (optional.isPresent()) {
            SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)methodCallTargetNode;
            JavaTypeProfile javaTypeProfile = c.a(substrateMethodCallTargetNode.getTypeProfile(), optional, (Universe)this.Iv);
            JavaMethodProfile javaMethodProfile = c.a(substrateMethodCallTargetNode.getMethodProfile(), javaTypeProfile);
            substrateMethodCallTargetNode.setProfiles(javaTypeProfile, javaMethodProfile);
        }
    }

    private void g(StructuredGraph structuredGraph) {
        EconomicMap<NodeSourcePosition, List<ControlSplitNode>> economicMap = ProfilingInstrumentationPhase.o(structuredGraph);
        for (List list : economicMap.getValues()) {
            for (ControlSplitNode controlSplitNode : list) {
                this.a(controlSplitNode);
            }
        }
    }

    private void a(ControlSplitNode controlSplitNode) {
        List<d> list = PGOApplyProfilesPhase.a(controlSplitNode.getNodeSourcePosition(), this.Iu);
        Optional<PGOProfilesLookup.a<long[]>> optional = this.It.getConditionalProfile(list);
        optional.ifPresent(a2 -> PGOApplyProfilesPhase.a(a2.hj(), (long[])a2.hk(), controlSplitNode));
    }

    private static void a(ProfileData.ProfileSource profileSource, long[] lArray, ControlSplitNode controlSplitNode) {
        List list = controlSplitNode.successors().snapshot();
        List<Node> list2 = list.stream().filter(Node::isAlive).collect(Collectors.toList());
        Optional<Map<Integer, Double>> optional = PGOApplyProfilesPhase.b(lArray);
        if (optional.isEmpty()) {
            return;
        }
        List<Node> list3 = PGOApplyProfilesPhase.a(list2, optional.get());
        list3.forEach(node -> controlSplitNode.setProbability((AbstractBeginNode)node, ProfileData.BranchProbabilityData.create((double)((Double)((Map)optional.get()).get(node.getNodeSourcePosition().getBCI())), (ProfileData.ProfileSource)profileSource)));
    }

    public static Optional<Map<Integer, Double>> b(long[] lArray) {
        int[] nArray = a.e(lArray);
        int[] nArray2 = a.f(lArray);
        Optional<double[]> optional = a.g(lArray);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (hashMap.containsKey(nArray2[i2])) {
                hashMap.put(nArray2[i2], (Double)hashMap.get(nArray2[i2]) + optional.get()[i2]);
                continue;
            }
            hashMap.put(nArray2[i2], optional.get()[i2]);
        }
        HashMap<Integer, Double> hashMap2 = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            if (!a.H(nArray[i3])) continue;
            hashMap2.put(nArray[i3], (Double)hashMap.get(nArray2[i3]));
        }
        return Optional.of(hashMap2);
    }

    public static List<Node> a(List<Node> list, Map<Integer, Double> map) {
        return list.stream().filter(node -> map.containsKey(node.getNodeSourcePosition().getBCI())).collect(Collectors.toList());
    }

    public static List<d> a(NodeSourcePosition nodeSourcePosition, List<d> list) {
        ArrayList arrayList = (ArrayList)PGOApplyProfilesPhase.a(nodeSourcePosition);
        arrayList.addAll(list);
        return arrayList;
    }

    public static List<d> a(NodeSourcePosition nodeSourcePosition2) {
        return StreamSupport.stream(nodeSourcePosition2.spliterator(), false).map(nodeSourcePosition -> new d(((HostedMethod)nodeSourcePosition.getMethod()).getWrapped(), nodeSourcePosition.getBCI())).collect(Collectors.toList());
    }

    protected /* synthetic */ void run(StructuredGraph structuredGraph, Object object) {
        this.a(structuredGraph, (HighTierContext)object);
    }
}

