/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.features;

import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.al;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.c;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.pgo.profiles.b;
import com.oracle.svm.enterprise.profiling.g;
import com.oracle.svm.hosted.FeatureImpl;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.home.HomeFinder;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class PGOFeature
implements InternalFeature {
    private static final long DEFAULT_PROFILES_NORMALIZATION_VALUE = 1000000000000000L;
    private static final long DEFAULT_CACHED_PROFILES_NORMALIZATION_VALUE = 100000000000000L;
    private static final String PGO_OPTIMIZED_QUALIFIER = "PGO optimized";

    public static boolean isPGOEnabled() {
        return a.PGOEnabled.hasBeenSet() || a.AdoptedPGOEnabled.hasBeenSet();
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return PGOFeature.isPGOEnabled();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        AnalysisUniverse analysisUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess).getUniverse();
        List<AnalysisType> list = analysisUniverse.getTypes().stream().filter(c::d).toList();
        Map<String, AnalysisType> map = list.stream().collect(Collectors.toMap(JavaType::toClassName, analysisType -> analysisType));
        Map<String, AnalysisMethod> map2 = analysisUniverse.getMethods().stream().collect(Collectors.toMap(analysisMethod -> Integer.toString(analysisMethod.getId()), analysisMethod -> analysisMethod));
        PGOFeature.loadProfiles(map, map2);
    }

    private static void loadProfiles(Map<String, AnalysisType> map, Map<String, AnalysisMethod> map2) {
        List<Path> list;
        b b2 = null;
        com.oracle.svm.enterprise.hosted.pgo.loaders.a a2 = new com.oracle.svm.enterprise.hosted.pgo.loaders.a(map, map2);
        if (a.PGOEnabled.hasBeenSet()) {
            list = ((LocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).values();
            if (list.isEmpty()) {
                list = Collections.singletonList(Path.of("default.iprof", new String[0]));
            }
            b2 = (b)a2.loadProfile(list, (Long)a.PGOProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.PROFILED);
        }
        list = null;
        if (a.AdoptedPGOEnabled.hasBeenSet()) {
            List list2 = ((LocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).values();
            assert (list2.size() > 0);
            list = (b)a2.loadProfile(list2, (Long)a.PGOAdoptedProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.ADOPTED);
        }
        assert (b2 != null || list != null);
        ImageSingletons.add(PGOProfilesLookup.class, (Object)new com.oracle.svm.enterprise.hosted.pgo.profiles.a(b2, (b)((Object)list)));
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess afterImageWriteAccess) {
        Optional<g> optional = com.oracle.svm.enterprise.hosted.pgo.profiles.a.hi().getStatistics();
        optional.ifPresent(g2 -> {
            int n2;
            if (a.PGOPrintStatistics.hasBeenSet() && ((Boolean)a.PGOPrintStatistics.getValue()).booleanValue()) {
                System.out.println(g2);
            }
            if (a.PGOPointRequiredHitCount.hasBeenSet() && g2.aw(n2 = ((Integer)a.PGOPointRequiredHitCount.getValue()).intValue())) {
                throw UserError.abort((String)"Insufficient hit rate. Too many points weren't found during profile collection.", (Object[])new Object[0]);
            }
        });
    }

    public static class a {
        @APIOption(name={"pgo"}, defaultValue={"default.iprof"})
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> PGOEnabled = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public void update(EconomicMap<OptionKey<?>, Object> economicMap, Object object) {
                super.update(economicMap, object);
                al.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                PGOContextSensitivityEnabled.update(economicMap, (Object)true);
                com.oracle.svm.enterprise.hosted.aotinliner.c.AOTInliner.update(economicMap, (Object)true);
                a.a.MLProfileInference.update(economicMap, (Object)false);
                CompilerConfigurationFactory.setNativeImageLocationQualifier((String)PGOFeature.PGO_OPTIMIZED_QUALIFIER);
            }
        };
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> AdoptedPGOEnabled = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public LocatableMultiOptionValue.Paths a(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (LocatableMultiOptionValue.Paths)unmodifiableEconomicMap.get((Object)this);
                }
                Path path = HomeFinder.getInstance().getHomeFolder().resolve("lib").resolve("svm").resolve("adopted_profiles").resolve("jdk_profile.iprof");
                if (path.toFile().exists()) {
                    return LocatableMultiOptionValue.Paths.buildWithDefaults((Path[])new Path[]{path});
                }
                return LocatableMultiOptionValue.Paths.buildWithCommaDelimiter();
            }

            public LocatableMultiOptionValue.Paths b(OptionValues optionValues) {
                return this.a(optionValues.getMap());
            }

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, LocatableMultiOptionValue.Paths paths, LocatableMultiOptionValue.Paths paths2) {
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (LocatableMultiOptionValue.Paths)object, (LocatableMultiOptionValue.Paths)object2);
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.a(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.b(optionValues);
            }
        };
        static final HostedOptionKey<Integer> PGOPointRequiredHitCount = new HostedOptionKey((Object)0);
        static final HostedOptionKey<Boolean> PGOPrintStatistics = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOContextSensitivityEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    PriorityInliningPhase.b.wA.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        static final HostedOptionKey<Long> PGOProfilesNormalizationValue = new HostedOptionKey((Object)1000000000000000L);
        static final HostedOptionKey<Long> PGOAdoptedProfilesNormalizationValue = new HostedOptionKey((Object)100000000000000L);
        public static final HostedOptionKey<Boolean> PGOEnableProfileNormalization = new HostedOptionKey((Object)Boolean.FALSE);
    }
}

