/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.word.WordBase;

public final class c {
    private c() {
    }

    public static JavaTypeProfile a(JavaTypeProfile javaTypeProfile, Optional<Map<AnalysisType, Long>> optional, Universe universe) {
        Map<HostedType, Long> map = c.b(optional.get(), javaTypeProfile, universe);
        Map<HostedType, Double> map2 = c.c(map);
        TriState triState = javaTypeProfile != null ? javaTypeProfile.getNullSeen() : TriState.TRUE;
        JavaTypeProfile.ProfiledType[] profiledTypeArray = (JavaTypeProfile.ProfiledType[])map.keySet().stream().map(hostedType -> new JavaTypeProfile.ProfiledType((ResolvedJavaType)hostedType, ((Double)map2.get(hostedType)).doubleValue())).sorted().toArray(JavaTypeProfile.ProfiledType[]::new);
        return new JavaTypeProfile(triState, 1.0000000000287557E-6, profiledTypeArray);
    }

    public static JavaMethodProfile a(JavaMethodProfile javaMethodProfile, JavaTypeProfile javaTypeProfile) {
        if (javaMethodProfile == null) {
            return null;
        }
        JavaMethodProfile.ProfiledMethod[] profiledMethodArray = (JavaMethodProfile.ProfiledMethod[])Arrays.stream(javaMethodProfile.getMethods()).map(profiledMethod -> c.a(profiledMethod.getMethod(), javaTypeProfile)).sorted().toArray(JavaMethodProfile.ProfiledMethod[]::new);
        return new JavaMethodProfile(javaMethodProfile.getNotRecordedProbability(), profiledMethodArray);
    }

    public static JavaMethodProfile b(Map<HostedMethod, Long> map) {
        ArrayList<JavaMethodProfile.ProfiledMethod> arrayList = new ArrayList<JavaMethodProfile.ProfiledMethod>();
        long l3 = map.values().stream().mapToLong(l2 -> l2).sum();
        for (Map.Entry<HostedMethod, Long> entry : map.entrySet()) {
            HostedMethod hostedMethod = entry.getKey();
            long l4 = entry.getValue();
            JavaMethodProfile.ProfiledMethod profiledMethod = new JavaMethodProfile.ProfiledMethod((ResolvedJavaMethod)hostedMethod, 1.0 * (double)l4 / (double)l3);
            arrayList.add(profiledMethod);
        }
        Collections.sort(arrayList);
        return new JavaMethodProfile(1.0000000000287557E-6, arrayList.toArray(new JavaMethodProfile.ProfiledMethod[0]));
    }

    private static JavaMethodProfile.ProfiledMethod a(ResolvedJavaMethod resolvedJavaMethod, JavaTypeProfile javaTypeProfile) {
        double d2 = 0.0;
        AnalysisMethod analysisMethod = ((HostedMethod)resolvedJavaMethod).getWrapped();
        for (JavaTypeProfile.ProfiledType profiledType : javaTypeProfile.getTypes()) {
            AnalysisType analysisType = ((HostedType)profiledType.getType()).getWrapped();
            if (!analysisMethod.equals((Object)analysisType.resolveConcreteMethod((ResolvedJavaMethod)analysisMethod, (ResolvedJavaType)analysisMethod.getDeclaringClass()))) continue;
            d2 += profiledType.getProbability();
        }
        return new JavaMethodProfile.ProfiledMethod(resolvedJavaMethod, Math.min(1.0, d2));
    }

    public static Map<HostedType, Double> a(Map<AnalysisType, Long> map, JavaTypeProfile javaTypeProfile, Universe universe) {
        Map<HostedType, Long> map2 = c.b(map, javaTypeProfile, universe);
        return c.c(map2);
    }

    private static Map<HostedType, Long> b(Map<AnalysisType, Long> map, JavaTypeProfile javaTypeProfile, Universe universe) {
        HashMap<HostedType, Long> hashMap = new HashMap<HostedType, Long>();
        if (javaTypeProfile != null) {
            Arrays.stream(javaTypeProfile.getTypes()).forEach(profiledType -> hashMap.put((HostedType)profiledType.getType(), 0L));
        }
        map.forEach((analysisType, l2) -> hashMap.put((HostedType)universe.lookup((JavaType)analysisType), (Long)l2));
        return hashMap;
    }

    private static Map<HostedType, Double> c(Map<HostedType, Long> map) {
        long l3 = map.values().stream().mapToLong(l2 -> l2).sum();
        assert (l3 > 0L) : "Points that never get invoked should not reach this point.";
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> 1.0 * (double)((Long)entry.getValue()).longValue() / (double)l3));
    }

    public static boolean d(AnalysisType analysisType) {
        return analysisType.isReachable() || WordBase.class.isAssignableFrom(analysisType.getJavaClass());
    }
}

