/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.objectinlining;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.objectinlining.i;
import com.oracle.svm.enterprise.hosted.objectinlining.j;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.Phase;

public class ObjectInliningPhase
extends Phase {
    private static final byte Hr = 0;
    private static final byte Hs = 1;
    private final HostedUniverse Ht;

    public ObjectInliningPhase(HostedUniverse hostedUniverse) {
        this.Ht = hostedUniverse;
    }

    protected void run(StructuredGraph structuredGraph) {
        DebugContext debugContext = structuredGraph.getDebug();
        try (DebugContext.Scope scope = debugContext.scope((Object)"ObjectInlining (compiler phase)");){
            for (AccessFieldNode accessFieldNode : structuredGraph.getNodes().filter(AccessFieldNode.class)) {
                HostedField hostedField = (HostedField)accessFieldNode.field();
                boolean bl2 = com.oracle.svm.enterprise.hosted.objectinlining.b.gK().k((ResolvedJavaField)hostedField);
                boolean bl3 = com.oracle.svm.enterprise.hosted.objectinlining.b.gK().j((ResolvedJavaField)hostedField);
                if (bl3 && i.gO().m(hostedField.wrapped)) {
                    this.c(structuredGraph, accessFieldNode);
                    debugContext.log(3, "intercepting value graph access: %s", (Object)accessFieldNode);
                    continue;
                }
                if (!bl2 || !i.gO().m(hostedField.wrapped)) continue;
                this.b(structuredGraph, accessFieldNode);
                debugContext.log(3, "intercepting value field access: %s", (Object)accessFieldNode);
            }
        }
    }

    private static AnalysisField p(List<AnalysisField> list) {
        AnalysisField analysisField = null;
        for (AnalysisField analysisField2 : list) {
            if (!analysisField2.getType().isArray()) continue;
            analysisField = analysisField2;
            break;
        }
        assert (analysisField != null);
        return analysisField;
    }

    public static void e(StructuredGraph structuredGraph) {
        for (CommitAllocationNode commitAllocationNode : structuredGraph.getNodes().filter(CommitAllocationNode.class)) {
            ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>(commitAllocationNode.getValues());
            int n2 = 0;
            for (VirtualObjectNode virtualObjectNode : commitAllocationNode.getVirtualObjects()) {
                AnalysisType analysisType = (AnalysisType)virtualObjectNode.type();
                if (!analysisType.isArray() && i.gO().c(analysisType)) {
                    VirtualInstanceNode virtualInstanceNode = (VirtualInstanceNode)virtualObjectNode;
                    for (int i2 = 0; i2 < virtualInstanceNode.getFields().length; ++i2) {
                        arrayList.remove(n2);
                    }
                    ObjectInliningPhase.a((Node)virtualInstanceNode, virtualInstanceNode.getFields(), analysisType.getInstanceFields(true));
                    for (ResolvedJavaField resolvedJavaField : virtualInstanceNode.getFields()) {
                        arrayList.add(n2, (ValueNode)structuredGraph.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)resolvedJavaField.getJavaKind())));
                        ++n2;
                    }
                    continue;
                }
                n2 += virtualObjectNode.entryCount();
            }
            if (commitAllocationNode.getValues().size() == arrayList.size()) continue;
            commitAllocationNode.getValues().clear();
            commitAllocationNode.getValues().addAll(arrayList);
        }
    }

    private void a(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        if (accessFieldNode instanceof StoreFieldNode) {
            new f(structuredGraph, accessFieldNode).ck();
        } else {
            new c(structuredGraph, accessFieldNode).ck();
        }
    }

    private void b(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        HostedField hostedField = (HostedField)accessFieldNode.field();
        if (ObjectInliningPhase.c(hostedField)) {
            if (accessFieldNode instanceof StoreFieldNode) {
                new g(structuredGraph, accessFieldNode).ck();
            } else {
                new d(structuredGraph, accessFieldNode).ck();
            }
        } else if (ObjectInliningPhase.j(hostedField.wrapped)) {
            this.a(structuredGraph, accessFieldNode);
        } else {
            throw VMError.shouldNotReachHere((String)("Can't handle access to : " + String.valueOf(hostedField)));
        }
    }

    private void c(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        if (accessFieldNode instanceof StoreFieldNode) {
            new h(structuredGraph, accessFieldNode).ck();
        } else {
            new e(structuredGraph, accessFieldNode).ck();
        }
    }

    private static void a(Node node, Object object, Object object2) {
        Fields fields = node.getNodeClass().getData();
        for (int i2 = 0; i2 < fields.getCount(); ++i2) {
            if (object != fields.get((Object)node, i2)) continue;
            fields.putObjectChecked((Object)node, i2, object2);
        }
    }

    public HostedField h(AnalysisField analysisField) {
        return this.a(i.gO().o(analysisField), analysisField);
    }

    private HostedField a(List<AnalysisField> list, AnalysisField analysisField) {
        HostedField hostedField = null;
        if (ObjectInliningPhase.i(analysisField)) {
            for (AnalysisField analysisField2 : list) {
                j j2 = (j)analysisField2.wrapped;
                if (!j2.gH().equals(analysisField)) continue;
                hostedField = this.Ht.lookup((JavaField)analysisField2);
                break;
            }
        } else if (ObjectInliningPhase.j(analysisField)) {
            hostedField = this.Ht.lookup((JavaField)ObjectInliningPhase.p(i.gO().k(analysisField)));
        } else {
            throw VMError.shouldNotReachHere((String)("Could not find state for : " + String.valueOf(analysisField)));
        }
        assert (hostedField != null);
        return hostedField;
    }

    private static boolean c(HostedField hostedField) {
        return ObjectInliningPhase.i(hostedField.wrapped);
    }

    private static boolean i(AnalysisField analysisField) {
        return !ObjectInliningPhase.j(analysisField);
    }

    private static boolean j(AnalysisField analysisField) {
        return analysisField.getType().getJavaClass().equals(String.class);
    }

    private static StoreFieldNode a(StructuredGraph structuredGraph, ValueNode valueNode, ResolvedJavaField resolvedJavaField, ValueNode valueNode2, FrameState frameState) {
        StoreFieldNode storeFieldNode = (StoreFieldNode)structuredGraph.addOrUniqueWithInputs((Node)new StoreFieldNode(valueNode, resolvedJavaField, valueNode2, frameState));
        return storeFieldNode;
    }

    class f
    extends g {
        protected LoadFieldNode HO;

        f(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        protected void a(EndNode endNode) {
            ValueNode valueNode = (ValueNode)this.Hu.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
            StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.Hu, this.Hz, (ResolvedJavaField)this.Hx, valueNode, this.HA);
            this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        @Override
        protected void b(EndNode endNode) {
        }
    }

    class c
    extends d {
        c(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        public LogicNode gN() {
            this.HK = (LoadFieldNode)this.Hu.add((Node)LoadFieldNode.create(null, (ValueNode)this.Hz, (ResolvedJavaField)this.Hx));
            return (LogicNode)this.Hu.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)this.HK));
        }
    }

    class g
    extends a {
        protected ValueNode uY;

        g(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
            this.uY = ((StoreFieldNode)accessFieldNode).value();
        }

        @Override
        public LogicNode gN() {
            return (LogicNode)this.Hu.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)this.uY));
        }

        private StoreFieldNode a(ConstantNode constantNode) {
            return ObjectInliningPhase.a(this.Hu, this.Hz, (ResolvedJavaField)this.Hx, (ValueNode)constantNode, this.HA);
        }

        protected void a(EndNode endNode) {
            StoreFieldNode storeFieldNode = this.a((ConstantNode)this.Hu.addOrUniqueWithInputs((Node)ConstantNode.forByte((byte)0, (StructuredGraph)this.Hu)));
            this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        protected void b(EndNode endNode) {
            StoreFieldNode storeFieldNode = this.a(ConstantNode.forByte((byte)1, (StructuredGraph)this.Hu));
            this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        @Override
        public void a(BeginNode beginNode, EndNode endNode) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            this.a(endNode);
            for (AnalysisField analysisField : this.Hy) {
                HostedField hostedField = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField);
                if (analysisField.getType().isPrimitive()) continue;
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.Hu, this.Hz, (ResolvedJavaField)hostedField, (ValueNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object), this.HA);
                arrayList.add(storeFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
        }

        @Override
        public void b(BeginNode beginNode, EndNode endNode) {
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<StoreFieldNode> arrayList2 = new ArrayList<StoreFieldNode>();
            for (AnalysisField analysisField : this.Hy) {
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped;
                HostedField hostedField = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField);
                HostedField hostedField2 = ObjectInliningPhase.this.Ht.lookup((JavaField)a2.gE());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.Hu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.uY, (ResolvedJavaField)hostedField2));
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.Hu, this.Hz, (ResolvedJavaField)hostedField, (ValueNode)loadFieldNode, this.HA);
                arrayList.add(loadFieldNode);
                arrayList2.add(storeFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            this.b(endNode);
        }

        @Override
        public void a(IfNode ifNode, MergeNode mergeNode) {
            FixedNode fixedNode = this.Hv.next();
            this.Hv.setNext(null);
            mergeNode.setNext(fixedNode);
            this.Hv.replaceAndDelete((Node)ifNode);
        }
    }

    class d
    extends a {
        protected LoadFieldNode HK;
        protected ValueNode[] HL;

        d(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
            this.HL = new ValueNode[2];
        }

        @Override
        public LogicNode gN() {
            this.HK = (LoadFieldNode)this.Hu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.Hz, (ResolvedJavaField)this.Hx));
            return CompareNode.createCompareNode((StructuredGraph)this.Hu, (CanonicalCondition)CanonicalCondition.EQ, (ValueNode)this.HK, (ValueNode)ConstantNode.forByte((byte)0, (StructuredGraph)this.Hu), null, (NodeView)NodeView.DEFAULT);
        }

        @Override
        public void a(BeginNode beginNode, EndNode endNode) {
            this.HL[0] = (ValueNode)this.Hu.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        }

        @Override
        public void b(BeginNode beginNode, EndNode endNode) {
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<StoreFieldNode> arrayList2 = new ArrayList<StoreFieldNode>();
            NewInstanceNode newInstanceNode = (NewInstanceNode)this.Hu.addOrUniqueWithInputs((Node)new NewInstanceNode((ResolvedJavaType)this.Hw.getType(), true, null));
            this.HL[1] = newInstanceNode;
            this.Hu.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)newInstanceNode);
            for (AnalysisField analysisField : this.Hy) {
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped;
                HostedField hostedField = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField);
                HostedField hostedField2 = ObjectInliningPhase.this.Ht.lookup((JavaField)a2.gE());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.Hu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.Hz, (ResolvedJavaField)hostedField));
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.Hu, (ValueNode)newInstanceNode, (ResolvedJavaField)hostedField2, (ValueNode)loadFieldNode, this.HA);
                arrayList.add(loadFieldNode);
                arrayList2.add(storeFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.Hu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
        }

        @Override
        public void a(IfNode ifNode, MergeNode mergeNode) {
            ValuePhiNode valuePhiNode = (ValuePhiNode)this.Hu.addWithoutUnique((Node)new ValuePhiNode(StampFactory.forKind((JavaKind)JavaKind.Object), (AbstractMergeNode)mergeNode, this.HL));
            FixedNode fixedNode = this.Hv.next();
            this.Hv.replaceAtUsages((Node)valuePhiNode);
            this.Hv.setNext(null);
            mergeNode.setNext(fixedNode);
            this.Hv.replaceAndDelete((Node)ifNode);
            this.Hu.addBeforeFixed((FixedNode)ifNode, (FixedWithNextNode)this.HK);
        }
    }

    class h
    extends b {
        h(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        private StoreFieldNode a(ValueNode valueNode, HostedField hostedField) {
            ValueNode valueNode2 = (ValueNode)this.HD.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)hostedField.getJavaKind()));
            return ObjectInliningPhase.a(this.HD, valueNode, (ResolvedJavaField)hostedField, valueNode2, this.HG);
        }

        private StoreFieldNode b(ValueNode valueNode, HostedField hostedField) {
            ConstantNode constantNode = ConstantNode.forByte((byte)1, (StructuredGraph)this.HD);
            return ObjectInliningPhase.a(this.HD, valueNode, (ResolvedJavaField)hostedField, (ValueNode)constantNode, this.HG);
        }

        @Override
        protected LogicNode f(ValueNode valueNode) {
            return (LogicNode)this.HD.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)valueNode));
        }

        @Override
        protected ValueNode a(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            if (ObjectInliningPhase.c(hostedField2)) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)this.a(valueNode, hostedField));
            }
            for (AnalysisField analysisField : i.gO().k(hostedField2.wrapped)) {
                if (analysisField.wrapped instanceof j) continue;
                HostedField hostedField3 = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField);
                if (analysisField.getType().isPrimitive()) continue;
                if (!i.gO().m(analysisField)) {
                    arrayList.add(ObjectInliningPhase.a(this.HD, valueNode, (ResolvedJavaField)hostedField3, valueNode2, this.HG));
                    continue;
                }
                this.a(valueNode, hostedField3, valueNode2, (FixedWithNextNode)endNode.predecessor(), false);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            return null;
        }

        @Override
        protected ValueNode b(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            for (AnalysisField analysisField : i.gO().k(hostedField2.wrapped)) {
                if (analysisField.wrapped instanceof j) continue;
                HostedField hostedField3 = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField);
                HostedField hostedField4 = ObjectInliningPhase.this.Ht.lookup((JavaField)((com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped).gE());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.HD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode2, (ResolvedJavaField)hostedField4));
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
                if (!i.gO().m(analysisField)) {
                    arrayList.add(ObjectInliningPhase.a(this.HD, valueNode, (ResolvedJavaField)hostedField3, (ValueNode)loadFieldNode, this.HG));
                    continue;
                }
                this.a(valueNode, hostedField3, (ValueNode)loadFieldNode, (FixedWithNextNode)endNode.predecessor(), false);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            if (ObjectInliningPhase.c(hostedField2)) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)this.b(valueNode, hostedField));
            }
            return null;
        }

        @Override
        protected ValueNode a(ValueNode valueNode, HostedField hostedField, ValueNode valueNode2, FixedWithNextNode fixedWithNextNode, boolean bl2) {
            HostedField hostedField2 = ObjectInliningPhase.this.a(this.HF, hostedField.wrapped);
            LogicNode logicNode = this.f(valueNode2);
            BeginNode beginNode = (BeginNode)this.HD.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.HD.add((Node)new EndNode());
            this.HD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            this.a(beginNode, endNode, valueNode, hostedField2, hostedField, (ValueNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
            BeginNode beginNode2 = (BeginNode)this.HD.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.HD.add((Node)new EndNode());
            this.HD.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            this.b(beginNode2, endNode2, valueNode, hostedField2, hostedField, valueNode2);
            IfNode ifNode = (IfNode)this.HD.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.HH);
            MergeNode mergeNode = (MergeNode)this.HD.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            if (bl2) {
                FixedNode fixedNode = fixedWithNextNode.next();
                this.HE.setNext(null);
                mergeNode.setNext(fixedNode);
                this.HE.replaceAndDelete((Node)ifNode);
            } else {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.setNext((FixedNode)ifNode);
                mergeNode.setNext(fixedNode);
            }
            mergeNode.setStateAfter(this.HG);
            return null;
        }

        @Override
        public void ck() {
            this.a(this.HE.object(), (HostedField)this.HE.field(), ((StoreFieldNode)this.HE).value(), (FixedWithNextNode)this.HE, true);
        }
    }

    class e
    extends b {
        e(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        protected LogicNode f(ValueNode valueNode) {
            return CompareNode.createCompareNode((StructuredGraph)this.HD, (CanonicalCondition)CanonicalCondition.EQ, (ValueNode)valueNode, (ValueNode)ConstantNode.defaultForKind((JavaKind)valueNode.getStackKind()), null, (NodeView)NodeView.DEFAULT);
        }

        @Override
        protected ValueNode a(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            return (ValueNode)this.HD.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        }

        @Override
        protected ValueNode b(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            AnalysisField analysisField = hostedField2.wrapped;
            NewInstanceNode newInstanceNode = (NewInstanceNode)this.HD.addOrUniqueWithInputs((Node)new NewInstanceNode((ResolvedJavaType)hostedField2.getType(), true, null));
            this.HD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)newInstanceNode);
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<LoadFieldNode> arrayList2 = new ArrayList<LoadFieldNode>();
            for (AnalysisField analysisField2 : i.gO().k(analysisField)) {
                ValueNode valueNode3;
                LoadFieldNode loadFieldNode;
                if (analysisField2.wrapped instanceof j) continue;
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField2.wrapped;
                HostedField hostedField3 = ObjectInliningPhase.this.Ht.lookup((JavaField)analysisField2);
                HostedField hostedField4 = ObjectInliningPhase.this.Ht.lookup((JavaField)a2.gE());
                if (!i.gO().m(analysisField2)) {
                    loadFieldNode = (LoadFieldNode)this.HD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode, (ResolvedJavaField)hostedField3));
                    arrayList.add(loadFieldNode);
                    valueNode3 = loadFieldNode;
                } else {
                    valueNode3 = this.a(valueNode, hostedField3, valueNode2, (FixedWithNextNode)newInstanceNode, false);
                }
                loadFieldNode = ObjectInliningPhase.a(this.HD, (ValueNode)newInstanceNode, (ResolvedJavaField)hostedField4, valueNode3, this.HG);
                arrayList2.add(loadFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.HD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            return newInstanceNode;
        }

        @Override
        protected ValueNode a(ValueNode valueNode, HostedField hostedField, ValueNode valueNode2, FixedWithNextNode fixedWithNextNode, boolean bl2) {
            HostedField hostedField2 = ObjectInliningPhase.this.a(this.HF, hostedField.wrapped);
            ValueNode[] valueNodeArray = new ValueNode[2];
            LoadFieldNode loadFieldNode = (LoadFieldNode)this.HD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode, (ResolvedJavaField)hostedField2));
            LogicNode logicNode = this.f((ValueNode)loadFieldNode);
            BeginNode beginNode = (BeginNode)this.HD.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.HD.add((Node)new EndNode());
            this.HD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            valueNodeArray[0] = this.a(beginNode, endNode, valueNode, hostedField2, hostedField, null);
            BeginNode beginNode2 = (BeginNode)this.HD.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.HD.add((Node)new EndNode());
            this.HD.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            valueNodeArray[1] = this.b(beginNode2, endNode2, valueNode, hostedField2, hostedField, null);
            IfNode ifNode = (IfNode)this.HD.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.HH);
            MergeNode mergeNode = (MergeNode)this.HD.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            ValuePhiNode valuePhiNode = (ValuePhiNode)this.HD.addWithoutUnique((Node)new ValuePhiNode(StampFactory.forKind((JavaKind)JavaKind.Object), (AbstractMergeNode)mergeNode, valueNodeArray));
            if (bl2) {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.replaceAtUsages((Node)valuePhiNode);
                fixedWithNextNode.setNext(null);
                mergeNode.setNext(fixedNode);
                fixedWithNextNode.replaceAndDelete((Node)ifNode);
                this.HD.addBeforeFixed((FixedNode)ifNode, (FixedWithNextNode)loadFieldNode);
            } else {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.setNext((FixedNode)loadFieldNode);
                this.HD.addAfterFixed((FixedWithNextNode)loadFieldNode, (FixedNode)ifNode);
                mergeNode.setNext(fixedNode);
            }
            mergeNode.setStateAfter(this.HG);
            return valuePhiNode;
        }

        @Override
        public void ck() {
            this.a(this.HE.object(), (HostedField)this.HE.field(), null, (FixedWithNextNode)this.HE, true);
        }
    }

    abstract class b {
        protected final StructuredGraph HD;
        protected final AccessFieldNode HE;
        protected final List<AnalysisField> HF;
        protected final FrameState HG;
        protected final NodeSourcePosition HH;

        b(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            this.HD = structuredGraph;
            this.HE = accessFieldNode;
            HostedField hostedField = (HostedField)accessFieldNode.field();
            this.HF = i.gO().o(hostedField.wrapped);
            this.HG = GraphUtil.findLastFrameState((FixedNode)accessFieldNode).duplicateWithVirtualState();
            this.HH = accessFieldNode.getNodeSourcePosition();
        }

        public abstract void ck();

        protected abstract ValueNode a(ValueNode var1, HostedField var2, ValueNode var3, FixedWithNextNode var4, boolean var5);

        protected abstract LogicNode f(ValueNode var1);

        protected abstract ValueNode a(BeginNode var1, EndNode var2, ValueNode var3, HostedField var4, HostedField var5, ValueNode var6);

        protected abstract ValueNode b(BeginNode var1, EndNode var2, ValueNode var3, HostedField var4, HostedField var5, ValueNode var6);
    }

    abstract class a {
        protected final StructuredGraph Hu;
        protected final AccessFieldNode Hv;
        protected final HostedField Hw;
        protected final HostedField Hx;
        protected final List<AnalysisField> Hy;
        protected final ValueNode Hz;
        protected final FrameState HA;
        protected final NodeSourcePosition HB;

        a(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            this.Hu = structuredGraph;
            this.Hv = accessFieldNode;
            this.Hw = (HostedField)accessFieldNode.field();
            this.Hz = accessFieldNode.object();
            this.Hy = i.gO().n(this.Hw.wrapped);
            this.Hx = ObjectInliningPhase.this.h(this.Hw.wrapped);
            this.HA = GraphUtil.findLastFrameState((FixedNode)accessFieldNode).duplicateWithVirtualState();
            this.HB = accessFieldNode.getNodeSourcePosition();
        }

        public void ck() {
            LogicNode logicNode = this.gN();
            BeginNode beginNode = (BeginNode)this.Hu.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.Hu.add((Node)new EndNode());
            this.Hu.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            this.a(beginNode, endNode);
            BeginNode beginNode2 = (BeginNode)this.Hu.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.Hu.add((Node)new EndNode());
            this.Hu.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            this.b(beginNode2, endNode2);
            IfNode ifNode = (IfNode)this.Hu.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.HB);
            MergeNode mergeNode = (MergeNode)this.Hu.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            this.a(ifNode, mergeNode);
            mergeNode.setStateAfter(this.HA);
        }

        public abstract LogicNode gN();

        public abstract void a(BeginNode var1, EndNode var2);

        public abstract void b(BeginNode var1, EndNode var2);

        public abstract void a(IfNode var1, MergeNode var2);
    }
}

