/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.phases;

import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.graal.compiler.enterprise.ml.features.provider.b;
import com.oracle.svm.enterprise.hosted.ml.features.ControlSplitFeatures;
import com.oracle.svm.enterprise.hosted.ml.features.PathFeatures;
import com.oracle.svm.enterprise.hosted.ml.phases.InferControlSplitProfilesPhase;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.FilteredNodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class GuardControlSplitProfileInferencePhase
extends BasePhase<CoreProviders> {
    private final com.oracle.graal.compiler.enterprise.ml.features.provider.c<Node, c> Gy;
    private final double Gz;
    private final double GA;
    private final double GB;

    public GuardControlSplitProfileInferencePhase(com.oracle.graal.compiler.enterprise.ml.features.provider.c<Node, c> c2, double d2, double d3, double d4) {
        this.Gy = c2;
        this.Gz = d2;
        this.GA = d3;
        this.GB = d4;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        FilteredNodeIterable<Node> filteredNodeIterable = InferControlSplitProfilesPhase.d(structuredGraph);
        b b2 = this.Gy.g(Long.toString(structuredGraph.graphId()));
        for (Node node : filteredNodeIterable) {
            IfNode ifNode;
            Optional optional;
            if (!(node instanceof IfNode) || !(optional = b2.a((Object)(ifNode = (IfNode)node))).isPresent()) continue;
            assert (!ifNode.getProfileData().getProfileSource().isUnknown()) : "To guard the inferred profiles generated by machine learning, it is necessary first to infer them.";
            this.a(ifNode);
            this.a(ifNode, (ControlSplitFeatures)((Object)optional.get()));
        }
    }

    private void a(IfNode ifNode) {
        AbstractBeginNode abstractBeginNode = ifNode.getSuccessor(true);
        AbstractBeginNode abstractBeginNode2 = ifNode.getSuccessor(false);
        ProfileData.ProfileSource profileSource = ifNode.getProfileData().getProfileSource();
        if (abstractBeginNode2 instanceof LoopExitNode && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() < this.Gz) {
            ifNode.setProbability(abstractBeginNode, ProfileData.BranchProbabilityData.create((double)this.Gz, (ProfileData.ProfileSource)ProfileData.ProfileSource.INFERRED));
        }
        if (abstractBeginNode instanceof LoopExitNode && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() > 1.0 - this.Gz) {
            ifNode.setProbability(abstractBeginNode, ProfileData.BranchProbabilityData.create((double)(1.0 - this.Gz), (ProfileData.ProfileSource)ProfileData.ProfileSource.INFERRED));
        }
    }

    private void a(IfNode ifNode, ControlSplitFeatures controlSplitFeatures) {
        AbstractBeginNode abstractBeginNode = ifNode.getSuccessor(true);
        PathFeatures pathFeatures = controlSplitFeatures.getBranch(abstractBeginNode);
        AbstractBeginNode abstractBeginNode2 = ifNode.getSuccessor(false);
        PathFeatures pathFeatures2 = controlSplitFeatures.getBranch(abstractBeginNode2);
        ProfileData.ProfileSource profileSource = ifNode.getProfileData().getProfileSource();
        if (GuardControlSplitProfileInferencePhase.a(pathFeatures) && (double)pathFeatures2.getEstimatedAssemblySize() >= this.GB && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() > this.GA) {
            ifNode.setProbability(abstractBeginNode, ProfileData.BranchProbabilityData.create((double)this.GA, (ProfileData.ProfileSource)ProfileData.ProfileSource.INFERRED));
        }
        if (GuardControlSplitProfileInferencePhase.a(pathFeatures2) && (double)pathFeatures.getEstimatedAssemblySize() >= this.GB && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() < 1.0 - this.GA) {
            ifNode.setProbability(abstractBeginNode, ProfileData.BranchProbabilityData.create((double)(1.0 - this.GA), (ProfileData.ProfileSource)ProfileData.ProfileSource.INFERRED));
        }
    }

    private static boolean a(PathFeatures pathFeatures) {
        EconomicMap<Class<? extends Node>, Integer> economicMap = pathFeatures.getBranchHistogram();
        for (Class clazz : economicMap.getKeys()) {
            if (!ControlSinkNode.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

