/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.diagnostics;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.j;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class a
implements j.a {
    @Override
    public void a(BuildArtifacts buildArtifacts) {
        Path path = NativeImageGenerator.generatedFiles((OptionValues)HostedOptionValues.singleton());
        String string = String.format("%s-build-report.html", SubstrateOptions.Name.getValue());
        try {
            b.b(path, string);
        }
        catch (Exception exception) {
            throw VMError.shouldNotReachHere((String)"Failed to generate build report", (Throwable)exception);
        }
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, path.resolve(string));
    }

    public static final class b {
        public static final String zJ = "/diagnostics/index.html";
        public static final String zK = "/diagnostics/list-js.txt";
        public static final Pattern zL = Pattern.compile("<!-- *@(.+) *-->");

        private static String c(Path path) {
            return "/".concat(StreamSupport.stream(path.spliterator(), false).map(Path::toString).collect(Collectors.joining("/")));
        }

        public static byte[] N(String string) {
            try {
                InputStream inputStream = a.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                return inputStream.readAllBytes();
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        public static void a(String string, Consumer<String> consumer) {
            try {
                InputStream inputStream = a.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        consumer.accept(string2);
                    }
                }
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        private static void a(a a2, BiConsumer<String, a> biConsumer) {
            b.a(zJ, (String string) -> {
                Matcher matcher = zL.matcher(string.trim());
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    biConsumer.accept(string2, a2);
                } else {
                    a2.zH.add((String)string);
                }
            });
        }

        private static void b(Path path, String string) throws IOException {
            a a3 = new a(path, string);
            b.a(a3, (String string2, a a2) -> {
                Object[] objectArray = string2.split(" ");
                switch (objectArray[0]) {
                    case "INCLUDE_JS_FILES": {
                        String string3;
                        b.a(zK, (String string) -> {
                            Path path = Path.of(string, new String[0]);
                            String string2 = b.c(path);
                            a2.M("<script>");
                            b.a(string2, a2::M);
                            a2.M("</script>");
                        });
                        try {
                            string3 = com.oracle.svm.enterprise.diagnostics.data.a.instance().ao();
                        }
                        catch (IOException iOException) {
                            throw VMError.shouldNotReachHere((String)"Failed to dump build report data", (Throwable)iOException);
                        }
                        a2.M("<script>");
                        a2.M(string3);
                        a2.M("</script>");
                        break;
                    }
                    case "INCLUDE_CSS": {
                        assert (objectArray.length == 2) : "INCLUDE_CSS requires exactly one argument, found = " + Arrays.toString(objectArray);
                        String string4 = objectArray[1].trim();
                        String string5 = b.c(Path.of(zJ, new String[0]).resolveSibling(string4));
                        a2.M("<style>");
                        b.a(string5, a2::M);
                        a2.M("</style>");
                    }
                }
            });
            a3.dY();
        }
    }

    private static class a {
        private final Path zE;
        private final String zF;
        static final boolean zG = true;
        private final List<String> zH = new ArrayList<String>();
        private final Map<String, byte[]> zI = new HashMap<String, byte[]>();

        a(Path path, String string) {
            this.zE = path;
            this.zF = string;
        }

        void M(String string) {
            this.zH.add(string);
        }

        void a(String string, byte[] byArray) {
            assert (!string.startsWith("/")) : "Resource path should be relative to target directory, found = " + string;
            this.zI.put(string, byArray);
        }

        void dY() throws IOException {
            Files.createDirectories(this.zE, new FileAttribute[0]);
            Path path = this.zE.resolve(this.zF);
            try (PrintWriter printWriter = new PrintWriter(path.toFile());){
                for (String string2 : this.zH) {
                    printWriter.println(string2);
                }
            }
            assert (this.zI.isEmpty()) : "EMBED_RESOURCE = true, resources.size = " + this.zI.size();
            this.zI.forEach((string, byArray) -> {
                Path path = this.zE.resolve((String)string);
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(path, byArray, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    throw VMError.shouldNotReachHere((String)"Failed write build report", (Throwable)iOException);
                }
            });
        }
    }
}

