/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.dwarf.data.g;
import com.oracle.dwarf.e;
import com.oracle.dwarf.entries.m;
import com.oracle.dwarf.entries.s;
import com.oracle.dwarf.entries.t;
import com.oracle.dwarf.graal.a;
import com.oracle.dwarf.graal.c;
import com.oracle.dwarf.sections.i;
import com.oracle.dwarf.sections.l;
import com.oracle.objectfile.BasicNobitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.LibJITDebug;
import com.oracle.svm.enterprise.core.al;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class SubstrateDebugInfoInstaller
implements InstalledCodeObserver {
    private static final String pc = System.getProperty("java.vm.version");
    private final d pd;

    private SubstrateDebugInfoInstaller(DebugContext debugContext, SharedMethod sharedMethod, CompilationResult compilationResult, MetaAccessProvider metaAccessProvider, RuntimeConfiguration runtimeConfiguration, Pointer pointer, int n2) {
        try (DebugContext.Scope scope = debugContext.scope((Object)"RuntimeDebugInfoGeneratorBuild");){
            this.pd = new d(debugContext, metaAccessProvider, runtimeConfiguration, sharedMethod, compilationResult, pointer.rawValue(), n2);
        }
        catch (Throwable throwable) {
            throw debugContext.handle(throwable);
        }
    }

    public InstalledCodeObserver.InstalledCodeObserverHandle install() {
        NonmovableArray<Byte> nonmovableArray;
        Object object;
        DebugContext debugContext = this.pd.pk;
        try {
            object = debugContext.scope((Object)"RuntimeDebugInfoGeneratorWrite");
            try {
                nonmovableArray = this.pd.bI();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Throwable throwable) {
            throw debugContext.handle(throwable);
        }
        object = a.a(nonmovableArray);
        try (DebugContext.Scope scope = debugContext.scope((Object)"SubstrateDebugInfoInstallerHandle");){
            if (debugContext.isLogEnabled()) {
                debugContext.log("iii %s for %s", (Object)a.b((Handle)object), (Object)this.pd.bJ());
            }
        }
        return object;
    }

    private static final class d
    implements com.oracle.dwarf.graal.b {
        private static final AtomicReference<com.oracle.dwarf.graal.d> pj = new AtomicReference();
        private final DebugContext pk;
        private final SharedMethod pl;
        private final CompilationResult pm;
        private final MetaAccessProvider pn;
        private final RuntimeConfiguration po;
        private final long pp;
        private final int pq;
        private final ObjectFile pr;
        private final List<ObjectFile.Element> ps;
        private final int pt;
        private final c.c pu;

        d(DebugContext debugContext, MetaAccessProvider metaAccessProvider, RuntimeConfiguration runtimeConfiguration, SharedMethod sharedMethod, CompilationResult compilationResult, long l2, int n2) {
            this.pk = debugContext;
            this.pn = metaAccessProvider;
            this.po = runtimeConfiguration;
            this.pl = sharedMethod;
            this.pm = compilationResult;
            this.pp = l2;
            this.pq = n2;
            assert (compilationResult == null || n2 == compilationResult.getTargetCodeSize());
            int n3 = NumUtil.safeToInt((long)((VirtualMemoryProvider)ImageSingletons.lookup(VirtualMemoryProvider.class)).getGranularity().rawValue());
            this.pr = ObjectFile.createRuntimeDebugInfo((int)n3);
            this.pr.newNobitsSection(SectionName.TEXT.getFormatDependentName(this.pr.getFormat()), (ObjectFile.NobitsSectionImpl)new BasicNobitsSectionImpl((long)n2));
            e e2 = new e();
            Path path = al.bM();
            this.pu = new c.c(debugContext, this.pr, e2, this, path, d.a(debugContext));
            new a(this.pr, e2, this.pu, this, l2).ag();
            new c.a(debugContext, this.pr, e2, this, l2).ag();
            this.pu.ag();
            this.ps = new ArrayList<ObjectFile.Element>();
            this.pt = this.pr.bake(this.ps);
            try (DebugContext.Scope scope = debugContext.scope((Object)"RuntimeDebugInfoGeneratorDumpObjectFile");){
                if (debugContext.isLogEnabled(4)) {
                    this.bK();
                }
            }
        }

        private static com.oracle.dwarf.graal.d a(DebugContext debugContext) {
            List<Path> list;
            com.oracle.dwarf.graal.d d2 = pj.get();
            if (d2 == null && !pj.compareAndSet(null, d2 = new com.oracle.dwarf.graal.d(debugContext, list = com.oracle.svm.enterprise.core.a.bs(), false))) {
                d2 = pj.get();
            }
            return d2;
        }

        private NonmovableArray<Byte> bI() {
            NonmovableArray nonmovableArray = NonmovableArrays.createByteArray((int)this.pt);
            this.pr.writeBuffer(this.ps, NonmovableArrays.asByteBuffer((NonmovableArray)nonmovableArray));
            return nonmovableArray;
        }

        @Override
        public void a(BiConsumer<ResolvedJavaMethod, CompilationResult> biConsumer) {
            if (this.pl != null && this.pm != null) {
                biConsumer.accept((ResolvedJavaMethod)this.pl, this.pm);
            }
        }

        @Override
        public a.a ad() {
            return (a.a)ImageSingletons.lookup(a.a.class);
        }

        @Override
        public int a(ResolvedJavaMethod resolvedJavaMethod) {
            VMError.guarantee((boolean)resolvedJavaMethod.equals((Object)this.pl));
            return 0;
        }

        @Override
        public int c(ResolvedJavaMethod resolvedJavaMethod) {
            return this.pu.c(resolvedJavaMethod);
        }

        @Override
        public ResolvedJavaMethod b(ResolvedJavaMethod resolvedJavaMethod) {
            return resolvedJavaMethod;
        }

        @Override
        public JavaKind[] a(CallingConvention callingConvention) {
            return ((SubstrateCallingConvention)callingConvention).getArgumentStorageKinds();
        }

        @Override
        public CallingConvention a(ResolvedJavaMethod resolvedJavaMethod, JavaType javaType, JavaType[] javaTypeArray) {
            SubstrateBackend substrateBackend = this.po.lookupBackend((ResolvedJavaMethod)this.pl);
            RegisterConfig registerConfig = substrateBackend.getProviders().getCodeCache().getRegisterConfig();
            SubstrateCallingConventionType substrateCallingConventionType = this.pl.getCallingConventionKind().toType(false);
            return registerConfig.getCallingConvention((CallingConvention.Type)substrateCallingConventionType, javaType, javaTypeArray, (ValueKindFactory)substrateBackend);
        }

        @Override
        public ResolvedJavaType a(Class<?> clazz) {
            return this.pn.lookupJavaType(clazz);
        }

        @Override
        public String d(ResolvedJavaMethod resolvedJavaMethod) {
            return null;
        }

        @Override
        public CompressEncoding ae() {
            return ReferenceAccess.singleton().getCompressEncoding();
        }

        private String bJ() {
            Object object;
            Object object2 = object = this.pm != null ? this.pm.getName() : null;
            if (object == null && this.pl != null) {
                object = this.pl.format("%H.%n(%p)");
            }
            if (object == null || ((String)object).isEmpty()) {
                object = "UnnamedCU";
            }
            object = (String)object + " at 0x" + Long.toHexString(this.pp);
            return object;
        }

        private void bK() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.bJ()).append(".debug");
            try (FileChannel fileChannel = FileChannel.open(Paths.get(stringBuilder.toString(), new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.pt);
                this.pr.writeBuffer(this.ps, (ByteBuffer)mappedByteBuffer);
            }
            catch (IOException iOException) {
                this.pk.log("Failed to dump %s", (Object)stringBuilder);
            }
        }

        @Override
        public boolean a(Call call) {
            return false;
        }

        @Override
        public com.oracle.dwarf.a af() {
            return com.oracle.dwarf.graal.b.a(this.po.getBackendForNormalMethod().getTarget().arch);
        }

        private final class a
        extends c.b {
            private final Map<SharedType, s> pv;

            a(ObjectFile objectFile, l l2, i i2, d d3, long l3) {
                super(d.this.pk, objectFile, l2, i2, d3);
                this.pv = new HashMap<SharedType, s>();
                com.oracle.dwarf.entries.c c2 = this.I().aU();
                VMError.guarantee((pc != null ? 1 : 0) != 0, (String)"Value used as DW_AT_producer attribute cannot be determined");
                c2.i("SVM_JIT Oracle GraalVM " + pc + " arch=" + ((SubstrateTargetDescription)ImageSingletons.lookup(SubstrateTargetDescription.class)).arch.getName());
                c2.a(g.gr);
                c2.k(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
                c2.j(d.this.bJ());
                c2.a(0);
                c2.a(l3, l3 + (long)d.this.pq);
            }

            @Override
            protected void aj() {
                super.aj();
                HashSet<s> hashSet = new HashSet<s>();
                for (s s2 : this.pv.values()) {
                    this.a(hashSet, s2);
                }
                for (s s2 : hashSet) {
                    this.I().aU().a(s2);
                }
            }

            private void a(Set<s> set, s s2) {
                set.add(s2);
                s s3 = s2.X();
                if (s3 != null) {
                    this.a(set, s3);
                }
            }

            @Override
            protected s a(JavaType javaType, boolean bl2) {
                return this.pv.computeIfAbsent((SharedType)javaType, sharedType -> this.a((SharedType)sharedType));
            }

            private s a(SharedType sharedType) {
                if (sharedType.getStorageKind() == JavaKind.Void) {
                    return null;
                }
                if (sharedType.isPrimitive()) {
                    return this.b(sharedType);
                }
                return this.c(sharedType);
            }

            private s b(SharedType sharedType) {
                com.oracle.dwarf.entries.b b2 = new com.oracle.dwarf.entries.b(this).h(sharedType.toJavaName());
                JavaKind javaKind = sharedType.getStorageKind();
                b2.b(this.b(javaKind)).a(a.a(javaKind));
                return b2;
            }

            private s c(SharedType sharedType) {
                return new m(this).c(this.b(JavaKind.Object)).e(new t(this, null).t(sharedType.toJavaName()));
            }

            private byte b(JavaKind javaKind) {
                return (byte)((SubstrateTargetDescription)ImageSingletons.lookup(SubstrateTargetDescription.class)).arch.getPlatformKind(javaKind).getSizeInBytes();
            }
        }
    }

    static final class a
    implements InstalledCodeObserver.InstalledCodeObserverHandleAccessor {
        a() {
        }

        static Handle a(NonmovableArray<Byte> nonmovableArray) {
            Handle handle = (Handle)UnmanagedMemory.malloc((int)SizeOf.get(Handle.class));
            handle.setAccessor((InstalledCodeObserver.InstalledCodeObserverHandleAccessor)ImageSingletons.lookup(a.class));
            handle.setState(0);
            handle.setRawHandle((LibJITDebug.jit_code_entry)WordFactory.nullPointer());
            handle.setDebugInfoData(nonmovableArray);
            return handle;
        }

        public void activate(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            Handle handle = (Handle)installedCodeObserverHandle;
            VMOperation.guaranteeInProgress((String)"SubstrateDebugInfoInstaller.Accessor.activate must run in a VMOperation");
            VMError.guarantee((handle.getState() == 0 ? 1 : 0) != 0);
            CCharPointer cCharPointer = (CCharPointer)NonmovableArrays.addressOf(handle.getDebugInfoData(), (int)0);
            int n2 = NonmovableArrays.lengthOf(handle.getDebugInfoData());
            handle.setRawHandle(LibJITDebug.register_jitcode(cCharPointer, n2));
            handle.setState(1);
        }

        public void release(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            Handle handle = (Handle)installedCodeObserverHandle;
            VMOperation.guaranteeInProgress((String)"SubstrateDebugInfoInstaller.Accessor.release must run in a VMOperation");
            VMError.guarantee((handle.getState() == 1 ? 1 : 0) != 0);
            LibJITDebug.unregister_jitcode(handle.getRawHandle());
            handle.setState(2);
            a.a(handle);
        }

        public void detachFromCurrentIsolate(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            NonmovableArrays.untrackUnmanagedArray(((Handle)installedCodeObserverHandle).getDebugInfoData());
        }

        public void attachToCurrentIsolate(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            NonmovableArrays.trackUnmanagedArray(((Handle)installedCodeObserverHandle).getDebugInfoData());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void releaseOnTearDown(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            Handle handle = (Handle)installedCodeObserverHandle;
            if (handle.getState() == 1) {
                LibJITDebug.unregister_jitcode(handle.getRawHandle());
                handle.setState(2);
            }
            a.a(handle);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void a(Handle handle) {
            NonmovableArrays.releaseUnmanagedArray(handle.getDebugInfoData());
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)handle);
        }

        static String b(Handle handle) {
            StringBuilder stringBuilder = new StringBuilder("DebugInfoHandle(handle = 0x");
            stringBuilder.append(Long.toHexString(handle.getRawHandle().rawValue()));
            stringBuilder.append(", address = 0x");
            stringBuilder.append(Long.toHexString(NonmovableArrays.addressOf(handle.getDebugInfoData(), (int)0).rawValue()));
            stringBuilder.append(", size = ");
            stringBuilder.append(NonmovableArrays.lengthOf(handle.getDebugInfoData()));
            stringBuilder.append(", handleState = ");
            stringBuilder.append(handle.getState());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    @RawStructure
    private static interface Handle
    extends InstalledCodeObserver.InstalledCodeObserverHandle {
        public static final int pg = 0;
        public static final int ph = 1;
        public static final int pi = 2;

        @RawField
        public LibJITDebug.jit_code_entry getRawHandle();

        @RawField
        public void setRawHandle(LibJITDebug.jit_code_entry var1);

        @RawField
        public NonmovableArray<Byte> getDebugInfoData();

        @RawField
        public void setDebugInfoData(NonmovableArray<Byte> var1);

        @RawField
        public int getState();

        @RawField
        public void setState(int var1);
    }

    static final class b
    implements InstalledCodeObserver.Factory {
        private final MetaAccessProvider pe;
        private final RuntimeConfiguration pf;

        b(MetaAccessProvider metaAccessProvider, RuntimeConfiguration runtimeConfiguration) {
            this.pe = metaAccessProvider;
            this.pf = runtimeConfiguration;
        }

        public InstalledCodeObserver create(DebugContext debugContext, SharedMethod sharedMethod, CompilationResult compilationResult, Pointer pointer, int n2) {
            if (((Boolean)c.GenerateRuntimeDebugInfo.getValue()).booleanValue()) {
                return new SubstrateDebugInfoInstaller(debugContext, sharedMethod, compilationResult, this.pe, this.pf, pointer, n2);
            }
            return null;
        }
    }

    public static class c {
        public static final RuntimeOptionKey<Boolean> GenerateRuntimeDebugInfo = new RuntimeOptionKey((Object)false, new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates});
    }
}

