/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtUtil;
import ai.onnxruntime.SequenceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OnnxSequence
implements OnnxValue {
    final long nativeHandle;
    private final long allocatorHandle;
    private final SequenceInfo info;

    OnnxSequence(long l2, long l3, SequenceInfo sequenceInfo) {
        this.nativeHandle = l2;
        this.allocatorHandle = l3;
        this.info = sequenceInfo;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_SEQUENCE;
    }

    @Override
    public List<Object> getValue() throws OrtException {
        if (this.info.sequenceOfMaps) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.info.length);
            for (int i2 = 0; i2 < this.info.length; ++i2) {
                Object[] objectArray = this.getMapKeys(i2);
                Object[] objectArray2 = this.getMapValues(i2);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>(OrtUtil.capacityFromSize(objectArray.length));
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    hashMap.put(objectArray[i3], objectArray2[i3]);
                }
                arrayList.add(hashMap);
            }
            return arrayList;
        }
        switch (this.info.sequenceType) {
            case FLOAT: {
                float[] fArray = this.getFloats(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                ArrayList<Object> arrayList = new ArrayList<Object>(fArray.length);
                for (float f2 : fArray) {
                    arrayList.add(Float.valueOf(f2));
                }
                return arrayList;
            }
            case DOUBLE: {
                return Arrays.stream(this.getDoubles(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().collect(Collectors.toList());
            }
            case INT64: {
                return Arrays.stream(this.getLongs(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().collect(Collectors.toList());
            }
            case STRING: {
                String[] stringArray = this.getStrings(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
                arrayList.addAll(Arrays.asList(stringArray));
                return arrayList;
            }
        }
        throw new OrtException("Unsupported type in a sequence, found " + (Object)((Object)this.info.sequenceType));
    }

    @Override
    public SequenceInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "OnnxSequence(info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    private Object[] getMapKeys(int n2) throws OrtException {
        if (this.info.mapInfo.keyType == OnnxJavaType.STRING) {
            return this.getStringKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2);
        }
        return Arrays.stream(this.getLongKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2)).boxed().toArray();
    }

    private Object[] getMapValues(int n2) throws OrtException {
        switch (this.info.mapInfo.valueType) {
            case STRING: {
                return this.getStringValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2);
            }
            case INT64: {
                return Arrays.stream(this.getLongValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2)).boxed().toArray();
            }
            case FLOAT: {
                float[] fArray = this.getFloatValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2);
                Object[] objectArray = new Float[fArray.length];
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    objectArray[i2] = Float.valueOf(fArray[i2]);
                }
                return objectArray;
            }
            case DOUBLE: {
                return Arrays.stream(this.getDoubleValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, n2)).boxed().toArray();
            }
        }
        throw new RuntimeException("Invalid or unknown valueType: " + (Object)((Object)this.info.mapInfo.valueType));
    }

    private native String[] getStringKeys(long var1, long var3, long var5, int var7) throws OrtException;

    private native long[] getLongKeys(long var1, long var3, long var5, int var7) throws OrtException;

    private native String[] getStringValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native long[] getLongValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native float[] getFloatValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native double[] getDoubleValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native String[] getStrings(long var1, long var3, long var5) throws OrtException;

    private native long[] getLongs(long var1, long var3, long var5) throws OrtException;

    private native float[] getFloats(long var1, long var3, long var5) throws OrtException;

    private native double[] getDoubles(long var1, long var3, long var5) throws OrtException;

    private native void close(long var1, long var3);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }
}

