/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.api.lsp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.graalvm.tools.api.lsp.LSPLibrary;

@GeneratedBy(value=LSPLibrary.class)
final class LSPLibraryGen
extends LibraryFactory<LSPLibrary> {
    private static final Class<LSPLibrary> LIBRARY_CLASS = LSPLibraryGen.lazyLibraryClass();
    private static final Message GET_DOCUMENTATION = new MessageImpl("getDocumentation", 0, false, Object.class, Object.class);
    private static final Message GET_SIGNATURE = new MessageImpl("getSignature", 1, false, Object.class, Object.class);
    private static final LSPLibraryGen INSTANCE = new LSPLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LSPLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(GET_DOCUMENTATION, GET_SIGNATURE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return LSPLibrary.class;
    }

    protected LSPLibrary createAssertions(LSPLibrary delegate) {
        return new LSPLibrary.Asserts(delegate);
    }

    protected LSPLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LSPLibrary createDelegate(LSPLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LSPLibrary lib = (LSPLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.getDocumentation(receiver);
            }
            case 1: {
                return lib.getSignature(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LSPLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LSPLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LSPLibrary> lazyLibraryClass() {
        try {
            return Class.forName("org.graalvm.tools.api.lsp.LSPLibrary", false, LSPLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class Proxy
    extends LSPLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object getDocumentation(Object receiver_) throws UnsupportedMessageException {
            try {
                return this.lib.send(receiver_, GET_DOCUMENTATION, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getSignature(Object receiver_) throws UnsupportedMessageException {
            try {
                return this.lib.send(receiver_, GET_SIGNATURE, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class Delegate
    extends LSPLibrary {
        @Node.Child
        private LSPLibrary delegateLibrary;

        Delegate(LSPLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object getDocumentation(Object receiver_) throws UnsupportedMessageException {
            if (LSPLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LSPLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LSPLibrary)LSPLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getDocumentation(delegate);
            }
            return this.delegateLibrary.getDocumentation(receiver_);
        }

        @Override
        public Object getSignature(Object receiver_) throws UnsupportedMessageException {
            if (LSPLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LSPLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LSPLibrary)LSPLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getSignature(delegate);
            }
            return this.delegateLibrary.getSignature(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(LSPLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static abstract class CachedDispatch
    extends LSPLibrary {
        @Node.Child
        LSPLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LSPLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object getDocumentation(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    LSPLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getDocumentation(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getSignature(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    LSPLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getSignature(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                LSPLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LSPLibrary)this.insert((Node)((LSPLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LSPLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LSPLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LSPLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LSPLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getDocumentation(Object receiver_) throws UnsupportedMessageException {
            return ((LSPLibrary)INSTANCE.getUncached(receiver_)).getDocumentation(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getSignature(Object receiver_) throws UnsupportedMessageException {
            return ((LSPLibrary)INSTANCE.getUncached(receiver_)).getSignature(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class Default
    extends LibraryExport<LSPLibrary> {
        private Default() {
            super(LSPLibrary.class, Object.class, false, false, 0);
        }

        protected LSPLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LSPLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LSPLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends LSPLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getDocumentation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getDocumentation(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getSignature(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getSignature(receiver);
            }
        }

        @GeneratedBy(value=LSPLibrary.class)
        private static final class Cached
        extends LSPLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public Object getDocumentation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getDocumentation(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getSignature(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getSignature(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LSPLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LSPLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LSPLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getDocumentation(Object receiver_) throws UnsupportedMessageException {
            assert (this.getRootNode() != null) : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LSPLibrary)INSTANCE.getUncached(receiver_)).getDocumentation(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getSignature(Object receiver_) throws UnsupportedMessageException {
            assert (this.getRootNode() != null) : "Invalid library usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LSPLibrary)INSTANCE.getUncached(receiver_)).getSignature(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

