/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.infrastructure.Universe;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class WrappedSignature
implements Signature {
    private final Universe universe;
    private final Signature wrapped;
    private final ResolvedJavaType defaultAccessingClass;

    public WrappedSignature(Universe universe, Signature wrapped, ResolvedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int getParameterCount(boolean receiver) {
        return this.wrapped.getParameterCount(receiver);
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        ResolvedJavaType parameterType;
        try {
            parameterType = this.resolve(this.wrapped.getParameterType(index, this.defaultAccessingClass));
        }
        catch (LinkageError e) {
            return this.universe.objectType();
        }
        return this.universe.lookup((JavaType)parameterType);
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        ResolvedJavaType returnType;
        try {
            returnType = this.resolve(this.wrapped.getReturnType(this.defaultAccessingClass));
        }
        catch (LinkageError e) {
            return this.universe.objectType();
        }
        return this.universe.lookup((JavaType)returnType);
    }

    private ResolvedJavaType resolve(JavaType type) {
        if (type instanceof ResolvedJavaType) {
            return (ResolvedJavaType)type;
        }
        return type.resolve(this.defaultAccessingClass);
    }
}

