/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.word.WordBase;

public abstract class ImageHeapScanner {
    private static final JavaConstant[] emptyConstantArray = new JavaConstant[0];
    protected final BigBang bb;
    protected final ImageHeap imageHeap;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisUniverse universe;
    protected final HostVM hostVM;
    protected final SnippetReflectionProvider snippetReflection;
    protected final ConstantReflectionProvider constantReflection;
    protected final ConstantReflectionProvider hostedConstantReflection;
    protected final SnippetReflectionProvider hostedSnippetReflection;
    protected ObjectScanningObserver scanningObserver;
    private static final ImageHeapConstant NULL_IMAGE_HEAP_OBJECT = new ImageHeapInstance(null, JavaConstant.NULL_POINTER, 0);

    public ImageHeapScanner(BigBang bb, ImageHeap heap, AnalysisMetaAccess aMetaAccess, SnippetReflectionProvider aSnippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver) {
        this.bb = bb;
        this.imageHeap = heap;
        this.metaAccess = aMetaAccess;
        this.universe = aMetaAccess.getUniverse();
        this.hostVM = aMetaAccess.getUniverse().hostVM();
        this.snippetReflection = aSnippetReflection;
        this.constantReflection = aConstantReflection;
        this.scanningObserver = aScanningObserver;
        this.hostedConstantReflection = GraalAccess.getOriginalProviders().getConstantReflection();
        this.hostedSnippetReflection = GraalAccess.getOriginalProviders().getSnippetReflection();
    }

    public void scanEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        if (this.isNonNullObjectConstant(root)) {
            AnalysisType type = this.metaAccess.lookupJavaType(root);
            ObjectScanner.EmbeddedRootScan reason = new ObjectScanner.EmbeddedRootScan(position, root);
            type.registerAsReachable(reason);
            this.getOrCreateConstantReachableTask(root, reason, null);
        }
    }

    public void onFieldRead(AnalysisField field) {
        assert (field.isRead());
        if (this.isValueAvailable(field)) {
            AnalysisType declaringClass = field.getDeclaringClass();
            if (field.isStatic()) {
                this.snapshotFieldValue(field, declaringClass.getOrComputeData().getFieldValue(field));
            } else {
                this.postTask(() -> this.onInstanceFieldRead(field, declaringClass));
            }
        }
    }

    private void onInstanceFieldRead(AnalysisField field, AnalysisType type) {
        for (AnalysisType subtype : type.getSubTypes()) {
            for (ImageHeapConstant imageHeapConstant : this.imageHeap.getObjects(subtype)) {
                this.snapshotFieldValue(field, ((ImageHeapInstance)imageHeapConstant).getFieldValue(field));
            }
            if (subtype.equals(type)) continue;
            this.onInstanceFieldRead(field, subtype);
        }
    }

    public TypeData computeTypeData(AnalysisType type) {
        GraalError.guarantee((boolean)type.isReachable(), (String)"TypeData is only available for reachable types");
        ResolvedJavaField[] staticFields = type.getStaticFields();
        TypeData data = new TypeData(staticFields.length);
        for (ResolvedJavaField javaField : staticFields) {
            AnalysisField field = (AnalysisField)javaField;
            ValueSupplier<JavaConstant> rawFieldValue = this.readHostedFieldValue(field, null);
            data.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                JavaConstant value = this.onFieldValueReachable(field, rawFieldValue, new ObjectScanner.FieldScan(field));
                data.setFieldValue(field, value);
                return value;
            }));
        }
        return data;
    }

    void markTypeInstantiated(AnalysisType type, ObjectScanner.ScanReason reason) {
        if (this.universe.sealed() && !type.isReachable()) {
            throw AnalysisError.shouldNotReachHere("Universe is sealed. New type reachable: " + type.toJavaName());
        }
        this.universe.getBigbang().registerTypeAsInHeap(type, reason);
    }

    JavaConstant markConstantReachable(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        if (this.isNonNullObjectConstant(constant)) {
            return this.getOrCreateConstantReachableTask(constant, reason, onAnalysisModified);
        }
        return constant;
    }

    public ImageHeapConstant toImageHeapObject(JavaConstant constant) {
        return this.toImageHeapObject(constant, ObjectScanner.OtherReason.RESCAN, null);
    }

    protected ImageHeapConstant toImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        assert (constant != null && this.isNonNullObjectConstant(constant));
        return this.getOrCreateConstantReachableTask(constant, reason, onAnalysisModified);
    }

    protected ImageHeapConstant getOrCreateConstantReachableTask(JavaConstant javaConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        ObjectScanner.ScanReason nonNullReason = Objects.requireNonNull(reason);
        Object existingTask = this.imageHeap.getTask(javaConstant);
        if (existingTask == null) {
            if (this.universe.sealed()) {
                throw AnalysisError.shouldNotReachHere("Universe is sealed. New constant reachable: " + javaConstant.toValueString());
            }
            if (javaConstant instanceof ImageHeapConstant) {
                ImageHeapConstant imageHeapConstant = (ImageHeapConstant)javaConstant;
                this.imageHeap.setValue(javaConstant, imageHeapConstant);
                this.imageHeap.add((AnalysisType)imageHeapConstant.getType(this.metaAccess), imageHeapConstant);
                this.scanImageHeapObject(imageHeapConstant, nonNullReason, onAnalysisModified);
                existingTask = javaConstant;
            } else {
                AnalysisFuture<ImageHeapConstant> newTask = new AnalysisFuture<ImageHeapConstant>(() -> {
                    ImageHeapConstant imageHeapConstant = this.createImageHeapObject(javaConstant, nonNullReason, onAnalysisModified);
                    this.imageHeap.setValue(javaConstant, imageHeapConstant);
                    return imageHeapConstant;
                });
                existingTask = this.imageHeap.setTask(javaConstant, newTask);
                if (existingTask == null) {
                    this.postTask(newTask);
                    return newTask.ensureDone();
                }
            }
        }
        return existingTask instanceof ImageHeapConstant ? (ImageHeapConstant)existingTask : (ImageHeapConstant)((AnalysisFuture)existingTask).ensureDone();
    }

    protected void scanImageHeapObject(ImageHeapConstant object, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        assert (object.getJavaKind() == JavaKind.Object && !object.isNull());
        AnalysisType type = (AnalysisType)object.getType(this.metaAccess);
        if (type.isArray()) {
            if (!type.getComponentType().isPrimitive()) {
                ImageHeapArray array = (ImageHeapArray)object;
                ObjectScanner.ArrayScan arrayReason = new ObjectScanner.ArrayScan(type, object, reason);
                for (int idx = 0; idx < array.getLength(); ++idx) {
                    JavaConstant elementValue = array.getElement(idx);
                    this.onArrayElementReachable(array, type, elementValue, idx, arrayReason, onAnalysisModified);
                }
            }
            this.markTypeInstantiated(type, reason);
        } else {
            ImageHeapInstance instance = (ImageHeapInstance)object;
            this.markTypeInstantiated(type, reason);
            for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
                AnalysisField field = (AnalysisField)javaField;
                if (field.isRead() && this.isValueAvailable(field)) {
                    JavaConstant fieldValue = instance.readFieldValue(field);
                    ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, object, reason);
                    this.onFieldValueReachable(field, instance, fieldValue, (ObjectScanner.ScanReason)fieldReason, onAnalysisModified);
                    continue;
                }
                JavaConstant originalFieldValue = (JavaConstant)instance.getFieldValue(field);
                instance.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                    ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, object, reason);
                    this.onFieldValueReachable(field, instance, originalFieldValue, (ObjectScanner.ScanReason)fieldReason, onAnalysisModified);
                    instance.setFieldValue(field, originalFieldValue);
                    return originalFieldValue;
                }));
            }
        }
    }

    protected ImageHeapConstant createImageHeapObject(JavaConstant constant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        ImageHeapConstant newImageHeapConstant;
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull());
        Optional<JavaConstant> replaced = this.maybeReplace(constant, reason);
        if (replaced.isPresent()) {
            if (replaced.get().isNull()) {
                return NULL_IMAGE_HEAP_OBJECT;
            }
            return this.toImageHeapObject(replaced.get(), reason, onAnalysisModified);
        }
        AnalysisType type = this.metaAccess.lookupJavaType(constant);
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive()) {
                newImageHeapConstant = new ImageHeapArray((ResolvedJavaType)type, constant, emptyConstantArray);
            } else {
                int length = this.constantReflection.readArrayLength(constant);
                newImageHeapConstant = new ImageHeapArray((ResolvedJavaType)type, constant, length);
                ObjectScanner.ArrayScan arrayReason = new ObjectScanner.ArrayScan(type, constant, reason);
                ImageHeapConstant array = newImageHeapConstant;
                for (int idx = 0; idx < length; ++idx) {
                    JavaConstant rawElementValue = this.constantReflection.readArrayElement(constant, idx);
                    JavaConstant arrayElement = this.onArrayElementReachable((ImageHeapArray)array, type, rawElementValue, idx, arrayReason, onAnalysisModified);
                    ((ImageHeapArray)array).setElement(idx, arrayElement);
                }
            }
            this.markTypeInstantiated(type, reason);
        } else {
            this.markTypeInstantiated(type, reason);
            ResolvedJavaField[] instanceFields = type.getInstanceFields(true);
            newImageHeapConstant = new ImageHeapInstance(type, constant, instanceFields.length);
            for (ResolvedJavaField javaField : instanceFields) {
                ValueSupplier<JavaConstant> rawFieldValue;
                AnalysisField field = (AnalysisField)javaField;
                try {
                    rawFieldValue = this.readHostedFieldValue(field, this.universe.toHosted(constant));
                }
                catch (InternalError | LinkageError | TypeNotPresentException e) {
                    continue;
                }
                ImageHeapInstance finalObject = (ImageHeapInstance)newImageHeapConstant;
                finalObject.setFieldTask(field, new AnalysisFuture<JavaConstant>(() -> {
                    ObjectScanner.FieldScan fieldReason = new ObjectScanner.FieldScan(field, constant, reason);
                    JavaConstant value = this.onFieldValueReachable(field, finalObject, rawFieldValue, (ObjectScanner.ScanReason)fieldReason, onAnalysisModified);
                    finalObject.setFieldValue(field, value);
                    return value;
                }));
            }
            AnalysisType typeFromClassConstant = (AnalysisType)this.constantReflection.asJavaType((Constant)constant);
            if (typeFromClassConstant != null) {
                typeFromClassConstant.registerAsReachable(reason);
            }
        }
        this.postTask(() -> this.onObjectReachable(newImageHeapConstant, reason));
        return newImageHeapConstant;
    }

    private Optional<JavaConstant> maybeReplace(JavaConstant constant, ObjectScanner.ScanReason reason) {
        Object unwrapped = this.unwrapObject(constant);
        if (unwrapped == null) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Could not unwrap constant", reason));
        }
        if (unwrapped instanceof ImageHeapConstant) {
            throw GraalError.shouldNotReachHere((String)this.formatReason("Double wrapping of constant. Most likely, the reachability analysis code itself is seen as reachable.", reason));
        }
        if (constant.getJavaKind() == JavaKind.Object) {
            try {
                Object replaced = this.universe.replaceObject(unwrapped);
                if (replaced != unwrapped) {
                    JavaConstant replacedConstant = this.universe.getSnippetReflection().forObject(replaced);
                    return Optional.of(replacedConstant);
                }
            }
            catch (UnsupportedFeatureException e) {
                ObjectScanner.unsupportedFeatureDuringConstantScan(this.universe.getBigbang(), constant, e, reason);
                return Optional.of(JavaConstant.NULL_POINTER);
            }
        }
        return Optional.empty();
    }

    protected Object unwrapObject(JavaConstant constant) {
        return this.snippetReflection.asObject(Object.class, constant);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason) {
        return this.onFieldValueReachable(field, null, rawValue, reason, null);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, null, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        return this.onFieldValueReachable(field, receiver, ValueSupplier.eagerValue(fieldValue), reason, onAnalysisModified);
    }

    JavaConstant onFieldValueReachable(AnalysisField field, ImageHeapInstance receiver, ValueSupplier<JavaConstant> rawValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        JavaConstant transformedValue;
        AnalysisError.guarantee(field.isReachable(), "Field value is only reachable when field is reachable: %s", field);
        AnalysisError.guarantee(rawValue.isAvailable(), "Value not yet available for %s", field);
        try {
            transformedValue = this.transformFieldValue(field, receiver, rawValue.get());
        }
        catch (UnsupportedFeatureException e) {
            ObjectScanner.unsupportedFeatureDuringFieldScan(this.universe.getBigbang(), field, receiver, e, reason);
            transformedValue = JavaConstant.NULL_POINTER;
        }
        JavaConstant fieldValue = this.markConstantReachable(transformedValue, reason, onAnalysisModified);
        if (this.scanningObserver != null && (analysisModified = this.notifyAnalysis(field, receiver, fieldValue, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
        return fieldValue;
    }

    private boolean notifyAnalysis(AnalysisField field, JavaConstant receiver, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean analysisModified = false;
        if (fieldValue.getJavaKind() == JavaKind.Object && this.hostVM.isRelocatedPointer(this.metaAccess, fieldValue)) {
            analysisModified = this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
        } else if (fieldValue.isNull()) {
            analysisModified = this.scanningObserver.forNullFieldValue(receiver, field, reason);
        } else if (fieldValue.getJavaKind() == JavaKind.Object) {
            analysisModified = this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
        }
        return analysisModified;
    }

    protected JavaConstant transformFieldValue(AnalysisField field, JavaConstant receiverConstant, JavaConstant originalValueConstant) {
        return originalValueConstant;
    }

    protected JavaConstant onArrayElementReachable(ImageHeapArray array, AnalysisType arrayType, JavaConstant rawElementValue, int elementIndex, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        boolean analysisModified;
        JavaConstant elementValue = this.markConstantReachable(rawElementValue, reason, onAnalysisModified);
        if (this.scanningObserver != null && arrayType.getComponentType().getJavaKind() == JavaKind.Object && (analysisModified = this.notifyAnalysis(array, arrayType, elementValue, elementIndex, reason)) && onAnalysisModified != null) {
            onAnalysisModified.accept(reason);
        }
        return elementValue;
    }

    private boolean isNonNullObjectConstant(JavaConstant constant) {
        return constant.getJavaKind() == JavaKind.Object && constant.isNonNull() && !this.isWordType(constant);
    }

    private boolean isWordType(JavaConstant rawElementValue) {
        return this.metaAccess.isInstanceOf(rawElementValue, WordBase.class);
    }

    private boolean notifyAnalysis(JavaConstant array, AnalysisType arrayType, JavaConstant elementValue, int elementIndex, ObjectScanner.ScanReason reason) {
        boolean analysisModified;
        if (elementValue.isNull()) {
            analysisModified = this.scanningObserver.forNullArrayElement(array, arrayType, elementIndex, reason);
        } else {
            if (this.isWordType(elementValue)) {
                return false;
            }
            AnalysisType elementType = this.metaAccess.lookupJavaType(elementValue);
            analysisModified = this.scanningObserver.forNonNullArrayElement(array, arrayType, elementValue, elementType, elementIndex, reason);
        }
        return analysisModified;
    }

    protected void onObjectReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason) {
        AnalysisType objectType = this.metaAccess.lookupJavaType(imageHeapConstant);
        this.imageHeap.add(objectType, imageHeapConstant);
        this.markTypeInstantiated(objectType, reason);
        if (imageHeapConstant instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)imageHeapConstant;
            for (ResolvedJavaField javaField : objectType.getInstanceFields(true)) {
                AnalysisField field = (AnalysisField)javaField;
                if (!field.isRead() || !this.isValueAvailable(field)) continue;
                this.snapshotFieldValue(field, imageHeapInstance.getFieldValue(field));
            }
        }
    }

    public boolean isValueAvailable(AnalysisField field) {
        return true;
    }

    private void snapshotFieldValue(AnalysisField field, Object fieldTask) {
        if (fieldTask instanceof AnalysisFuture) {
            AnalysisError.guarantee(field.isReachable(), "Field value snapshot computed for field not reachable: %s", field);
            this.postTask((AnalysisFuture)fieldTask);
        }
    }

    protected String formatReason(String message, ObjectScanner.ScanReason reason) {
        return message + " " + String.valueOf(reason);
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant value = this.universe.lookup(this.hostedConstantReflection.readFieldValue(field.wrapped, receiver));
        return ValueSupplier.eagerValue(value);
    }

    protected boolean skipScanning() {
        return false;
    }

    private void maybeRunInExecutor(CompletionExecutor.DebugContextRunnable task) {
        if (this.bb.executorIsStarted()) {
            this.bb.postTask(task);
        } else {
            task.run(null);
        }
    }

    public void rescanRoot(Field reflectionField) {
        if (this.skipScanning()) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                JavaConstant fieldValue = this.readHostedFieldValue(field, null).get();
                TypeData typeData = field.getDeclaringClass().getOrComputeData();
                AnalysisFuture<JavaConstant> fieldTask = this.patchStaticField(typeData, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                if (field.isRead() || field.isFolded()) {
                    this.rescanCollectionElements(fieldTask.ensureDone());
                }
            }
        });
    }

    public void rescanField(Object receiver, Field reflectionField) {
        if (this.skipScanning()) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)reflectionField.getDeclaringClass());
            if (type.isReachable()) {
                JavaConstant fieldValue;
                AnalysisField field = this.metaAccess.lookupJavaField(reflectionField);
                assert (!field.isStatic());
                JavaConstant receiverConstant = this.asConstant(receiver);
                Optional<JavaConstant> replaced = this.maybeReplace(receiverConstant, ObjectScanner.OtherReason.RESCAN);
                if (replaced.isPresent()) {
                    if (replaced.get().isNull()) {
                        return;
                    }
                    receiverConstant = replaced.get();
                }
                if ((fieldValue = this.readHostedFieldValue(field, this.universe.toHosted(receiverConstant)).get()) != null) {
                    ImageHeapInstance receiverObject = (ImageHeapInstance)this.toImageHeapObject(receiverConstant);
                    AnalysisFuture<JavaConstant> fieldTask = this.patchInstanceField(receiverObject, field, fieldValue, ObjectScanner.OtherReason.RESCAN, null);
                    if (field.isRead() || field.isFolded()) {
                        this.rescanCollectionElements(fieldTask.ensureDone());
                    }
                }
            }
        });
    }

    protected AnalysisFuture<JavaConstant> patchStaticField(TypeData typeData, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, fieldValue, reason, onAnalysisModified);
            typeData.setFieldValue(field, value);
            return value;
        });
        typeData.setFieldTask(field, task);
        return task;
    }

    protected AnalysisFuture<JavaConstant> patchInstanceField(ImageHeapInstance receiverObject, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        AnalysisFuture<JavaConstant> task = new AnalysisFuture<JavaConstant>(() -> {
            JavaConstant value = this.onFieldValueReachable(field, receiverObject, fieldValue, reason, onAnalysisModified);
            receiverObject.setFieldValue(field, value);
            return value;
        });
        receiverObject.setFieldTask(field, task);
        return task;
    }

    public void rescanObject(Object object) {
        this.rescanObject(object, ObjectScanner.OtherReason.RESCAN);
    }

    public void rescanObject(Object object, ObjectScanner.ScanReason reason) {
        if (this.skipScanning()) {
            return;
        }
        if (object == null) {
            return;
        }
        this.maybeRunInExecutor(unused -> {
            this.doScan(this.asConstant(object), reason);
            this.rescanCollectionElements(object);
        });
    }

    private void rescanCollectionElements(JavaConstant constant) {
        if (this.isNonNullObjectConstant(constant)) {
            this.rescanCollectionElements(this.asObject(((ImageHeapConstant)constant).getHostedObject()));
        }
    }

    private void rescanCollectionElements(Object object) {
        if (object instanceof Object[]) {
            Object[] array;
            for (Object element : array = (Object[])object) {
                this.doScan(this.asConstant(element));
            }
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(e -> this.doScan(this.asConstant(e)));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.forEach((k, v) -> {
                this.doScan(this.asConstant(k));
                this.doScan(this.asConstant(v));
            });
        } else if (object instanceof EconomicMap) {
            this.rescanEconomicMap((EconomicMap)object);
        }
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> object) {
        MapCursor cursor = object.getEntries();
        while (cursor.advance()) {
            this.doScan(this.asConstant(cursor.getKey()));
            this.doScan(this.asConstant(cursor.getValue()));
        }
    }

    void doScan(JavaConstant constant) {
        this.doScan(constant, ObjectScanner.OtherReason.RESCAN);
    }

    void doScan(JavaConstant constant, ObjectScanner.ScanReason reason) {
        this.markConstantReachable(constant, reason, null);
    }

    protected Object asObject(JavaConstant constant) {
        return this.snippetReflection.asObject(Object.class, constant);
    }

    public JavaConstant asConstant(Object object) {
        return this.snippetReflection.forObject(object);
    }

    public void cleanupAfterAnalysis() {
        this.scanningObserver = null;
    }

    public ObjectScanningObserver getScanningObserver() {
        return this.scanningObserver;
    }

    protected abstract Class<?> getClass(String var1);

    protected AnalysisType lookupJavaType(String className) {
        return this.metaAccess.lookupJavaType((Class)this.getClass(className));
    }

    protected AnalysisField lookupJavaField(String className, String fieldName) {
        return this.metaAccess.lookupJavaField(ReflectionUtil.lookupField(this.getClass(className), (String)fieldName));
    }

    public void postTask(AnalysisFuture<?> future) {
        if (future.isDone()) {
            return;
        }
        this.universe.getBigbang().postTask((DebugContext debug) -> future.ensureDone());
    }

    public void postTask(Runnable task) {
        this.universe.getBigbang().postTask((DebugContext debug) -> task.run());
    }
}

