/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.CreateCastData;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.NodeFieldData;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class NodeData
extends Template
implements Comparable<NodeData> {
    private final String nodeId;
    private final List<NodeData> enclosingNodes = new ArrayList<NodeData>();
    private NodeData declaringNode;
    private final TypeSystemData typeSystem;
    private final List<NodeChildData> children;
    private final List<NodeExecutionData> childExecutions;
    private final List<NodeFieldData> fields;
    private ParameterSpec instanceParameterSpec;
    private final List<SpecializationData> specializations = new ArrayList<SpecializationData>();
    private final List<CreateCastData> casts = new ArrayList<CreateCastData>();
    private final List<ExecutableTypeData> executableTypes = new ArrayList<ExecutableTypeData>();
    private final NodeExecutionData thisExecution;
    private final boolean generateFactory;
    private TypeMirror frameType;
    private boolean generateIntrospection;
    private boolean generateStatistics;
    private boolean generateAOT;
    private boolean generateInline;
    private boolean generateUncached;
    private boolean generateCached = true;
    private boolean defaultInlineCached;
    private boolean generateTraceOnEnter;
    private boolean generateTraceOnReturn;
    private boolean generateTraceOnException;
    private boolean reportPolymorphism;
    private boolean isUncachable;
    private boolean isNodeBound;
    private boolean generatePackagePrivate;
    private double activationProbability = 1.0;
    private Set<String> allowedCheckedExceptions;
    private Map<CacheExpression, String> sharedCaches = Collections.emptyMap();
    private ExecutableTypeData polymorphicExecutable;
    private final NodeData parsingParent;
    private List<SpecializationData> reachableSpecializations;
    private final Set<TypeMirror> libraryTypes = new LinkedHashSet<TypeMirror>();

    public NodeData(ProcessorContext context, NodeData inliningParent, TypeElement type, TypeSystemData typeSystem, boolean generateFactory, boolean generateUncached, boolean generatePackagePrivate) {
        super(context, type, null);
        this.parsingParent = inliningParent;
        this.nodeId = ElementUtils.getSimpleName(type);
        this.typeSystem = typeSystem;
        this.fields = new ArrayList<NodeFieldData>();
        this.children = new ArrayList<NodeChildData>();
        this.childExecutions = new ArrayList<NodeExecutionData>();
        this.thisExecution = new NodeExecutionData(new NodeChildData(null, null, "this", this.getNodeType(), this.getNodeType(), null, NodeChildData.Cardinality.ONE, null, null, null), -1, -1);
        this.thisExecution.getChild().setNode(this);
        this.generateFactory = generateFactory;
        this.generateUncached = generateUncached;
        this.generatePackagePrivate = generatePackagePrivate;
    }

    public double getActivationProbability() {
        return this.activationProbability;
    }

    public void setActivationProbability(double activationProbability) {
        this.activationProbability = activationProbability;
    }

    public List<SpecializationData> getReachableSpecializations() {
        if (this.reachableSpecializations == null) {
            ArrayList<SpecializationData> reachable = new ArrayList<SpecializationData>();
            for (SpecializationData specialization : this.getSpecializations()) {
                if (!specialization.isReachable() || !specialization.isSpecialized() && (!specialization.isFallback() || specialization.getMethod() == null)) continue;
                reachable.add(specialization);
            }
            return reachable;
        }
        return this.reachableSpecializations;
    }

    public void setReachableSpecializations(List<SpecializationData> reachableSpecializations) {
        this.reachableSpecializations = reachableSpecializations;
    }

    public NodeData getParsingParent() {
        return this.parsingParent;
    }

    public boolean shouldInlineByDefault() {
        return this.isGenerateInline() || this.isDefaultInlineCached();
    }

    public boolean isDefaultInlineCached() {
        return this.defaultInlineCached;
    }

    public void setDefaultInlineCached(boolean defaultInlineCached) {
        this.defaultInlineCached = defaultInlineCached;
    }

    public void setGenerateCached(boolean generateCached) {
        this.generateCached = generateCached;
    }

    public boolean isGenerateCached() {
        return this.generateCached;
    }

    public void setGenerateStatistics(boolean generateStatistics) {
        this.generateStatistics = generateStatistics;
    }

    public boolean isGenerateStatistics() {
        return this.generateStatistics;
    }

    public Map<CacheExpression, String> getSharedCaches() {
        return this.sharedCaches;
    }

    public void setSharedCaches(Map<CacheExpression, String> sharedCaches) {
        this.sharedCaches = sharedCaches;
    }

    public NodeData(ProcessorContext context, NodeData inliningParent, TypeElement type) {
        this(context, inliningParent, type, null, false, false, false);
    }

    public void setNodeBound(boolean isNodeBound) {
        this.isNodeBound = isNodeBound;
    }

    public boolean isNodeBound() {
        return this.isNodeBound;
    }

    public void setUncachable(boolean uncached) {
        this.isUncachable = uncached;
    }

    public void setGenerateUncached(boolean generateUncached) {
        this.generateUncached = generateUncached;
    }

    public boolean isGenerateUncached() {
        return this.generateUncached;
    }

    public void setGeneratePackagePrivate(boolean generatePackagePrivate) {
        this.generatePackagePrivate = generatePackagePrivate;
    }

    public boolean isGeneratePackagePrivate() {
        return this.generatePackagePrivate;
    }

    public boolean isUncachable() {
        return this.isUncachable;
    }

    public boolean isGenerateFactory() {
        return this.generateFactory;
    }

    public NodeExecutionData getThisExecution() {
        return this.thisExecution;
    }

    public boolean isGenerateIntrospection() {
        return this.generateIntrospection;
    }

    public void setGenerateIntrospection(boolean reflectable) {
        this.generateIntrospection = reflectable;
    }

    public boolean isGenerateAOT() {
        return this.generateAOT;
    }

    public void setGenerateAOT(boolean generateAOT) {
        this.generateAOT = generateAOT;
    }

    public boolean isGenerateTraceOnEnter() {
        return this.generateTraceOnEnter;
    }

    public boolean isGenerateTraceOnReturn() {
        return this.generateTraceOnReturn;
    }

    public boolean isGenerateTraceOnException() {
        return this.generateTraceOnException;
    }

    public void setGenerateExecuteTracing(boolean generateTraceOnEnter, boolean generateTraceOnReturn, boolean generateTraceOnException) {
        this.generateTraceOnEnter = generateTraceOnEnter;
        this.generateTraceOnReturn = generateTraceOnReturn;
        this.generateTraceOnException = generateTraceOnException;
    }

    public boolean isGenerateInline() {
        return this.generateInline;
    }

    public void setGenerateInline(boolean generateInline) {
        this.generateInline = generateInline;
    }

    public boolean isFallbackReachable() {
        SpecializationData generic = this.getFallbackSpecialization();
        if (generic != null) {
            return generic.isReachable();
        }
        return false;
    }

    public void setFrameType(TypeMirror frameType) {
        this.frameType = frameType;
    }

    public TypeMirror getFrameType() {
        return this.frameType;
    }

    public void addEnclosedNode(NodeData node) {
        this.enclosingNodes.add(node);
        node.declaringNode = this;
    }

    public List<NodeExecutionData> getChildExecutions() {
        return this.childExecutions;
    }

    public int getExecutionCount() {
        return this.getChildExecutions().size();
    }

    public int getSignatureSize() {
        return this.getChildExecutions().size();
    }

    public boolean isFrameUsedByAnyGuard() {
        for (SpecializationData specialization : this.specializations) {
            if (!specialization.isReachable() || !specialization.isFrameUsedByGuard()) continue;
            return true;
        }
        return false;
    }

    public List<CreateCastData> getCasts() {
        return this.casts;
    }

    public List<NodeFieldData> getFields() {
        return this.fields;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        ArrayList<MessageContainer> containerChildren = new ArrayList<MessageContainer>();
        if (this.enclosingNodes != null) {
            containerChildren.addAll(this.enclosingNodes);
        }
        if (this.typeSystem != null) {
            containerChildren.add(this.typeSystem);
        }
        if (this.specializations != null) {
            for (MessageContainer messageContainer : this.specializations) {
                if (messageContainer.getMessageElement() == null) continue;
                containerChildren.add(messageContainer);
            }
        }
        if (this.executableTypes != null) {
            containerChildren.addAll(this.getExecutableTypes());
        }
        if (this.children != null) {
            containerChildren.addAll(this.children);
        }
        if (this.fields != null) {
            containerChildren.addAll(this.fields);
        }
        if (this.casts != null) {
            containerChildren.addAll(this.casts);
        }
        return containerChildren;
    }

    public ParameterSpec getInstanceParameterSpec() {
        return this.instanceParameterSpec;
    }

    public void setInstanceParameterSpec(ParameterSpec instanceParameter) {
        this.instanceParameterSpec = instanceParameter;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TypeMirror getNodeType() {
        return this.getTemplateType().asType();
    }

    public Modifier getVisibility() {
        return this.generatePackagePrivate ? null : ElementUtils.getVisibility(this.getTemplateType().getModifiers());
    }

    public boolean needsFactory() {
        if (this.specializations == null) {
            return false;
        }
        if (this.getTemplateType().getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        boolean noSpecialization = true;
        for (SpecializationData specialization : this.specializations) {
            noSpecialization = noSpecialization && !specialization.isSpecialized();
        }
        return !noSpecialization;
    }

    public boolean supportsFrame() {
        if (this.executableTypes != null) {
            for (ExecutableTypeData execType : this.getExecutableTypes(-1)) {
                if (execType.getFrameParameter() != null) continue;
                return false;
            }
        }
        return true;
    }

    public List<NodeData> getNodesWithFactories() {
        ArrayList<NodeData> nodeChildren = new ArrayList<NodeData>();
        for (NodeData child : this.getEnclosingNodes()) {
            if (child.needsFactory() && child.isGenerateFactory()) {
                nodeChildren.add(child);
            }
            nodeChildren.addAll(child.getNodesWithFactories());
        }
        return nodeChildren;
    }

    public NodeData getDeclaringNode() {
        return this.declaringNode;
    }

    public List<NodeData> getEnclosingNodes() {
        return this.enclosingNodes;
    }

    public List<ExecutableElement> getAllTemplateMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (SpecializationData specialization : this.getSpecializations()) {
            methods.add(specialization.getMethod());
        }
        for (ExecutableTypeData execType : this.getExecutableTypes()) {
            if (execType.getMethod() == null) continue;
            methods.add(execType.getMethod());
        }
        if (this.getCasts() != null) {
            for (CreateCastData castData : this.getCasts()) {
                methods.add(castData.getMethod());
            }
        }
        return methods;
    }

    public ExecutableTypeData findAnyGenericExecutableType(ProcessorContext context, int evaluatedCount) {
        List<ExecutableTypeData> foundTypes = this.findGenericExecutableTypes(evaluatedCount);
        for (ExecutableTypeData type : foundTypes) {
            if (!context.isType(type.getReturnType(), Object.class)) continue;
            return type;
        }
        for (ExecutableTypeData type : foundTypes) {
            if (context.isType(type.getReturnType(), Void.TYPE)) continue;
            return type;
        }
        Iterator<ExecutableTypeData> iterator = foundTypes.iterator();
        if (iterator.hasNext()) {
            ExecutableTypeData type;
            type = iterator.next();
            return type;
        }
        return null;
    }

    public List<ExecutableTypeData> getExecutableTypes(int evaluatedCount) {
        if (evaluatedCount == -1) {
            return this.executableTypes;
        }
        ArrayList<ExecutableTypeData> filteredTypes = new ArrayList<ExecutableTypeData>();
        for (ExecutableTypeData type : this.executableTypes) {
            if (type.getEvaluatedCount() != evaluatedCount) continue;
            filteredTypes.add(type);
        }
        return filteredTypes;
    }

    public List<ExecutableTypeData> findGenericExecutableTypes(int evaluatedCount) {
        ArrayList<ExecutableTypeData> foundTypes = new ArrayList<ExecutableTypeData>();
        for (ExecutableTypeData type : this.getExecutableTypes(evaluatedCount)) {
            if (type.hasUnexpectedValue()) continue;
            foundTypes.add(type);
        }
        return foundTypes;
    }

    public ExecutableTypeData findExecutableType(TypeMirror primitiveType, int evaluatedCount) {
        for (ExecutableTypeData type : this.getExecutableTypes(evaluatedCount)) {
            if (!ElementUtils.typeEquals(type.getReturnType(), primitiveType)) continue;
            return type;
        }
        return null;
    }

    public boolean needsRewrites(ProcessorContext context) {
        int count = 0;
        for (SpecializationData specialization : this.getSpecializations()) {
            if (specialization.getMethod() == null) continue;
            if (count == 1) {
                return true;
            }
            if (specialization.needsRewrite(context)) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public SpecializationData getFallbackSpecialization() {
        for (SpecializationData specialization : this.specializations) {
            if (!specialization.isFallback()) continue;
            return specialization;
        }
        return null;
    }

    public TypeSystemData getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public String dump() {
        return this.dump(0);
    }

    private String dump(int level) {
        Object indent = "";
        for (int i = 0; i < level; ++i) {
            indent = (String)indent + "    ";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s%s {", indent, this.toString()));
        NodeData.dumpProperty(builder, (String)indent, "templateClass", ElementUtils.getQualifiedName(this.getTemplateType()));
        NodeData.dumpProperty(builder, (String)indent, "typeSystem", this.getTypeSystem());
        NodeData.dumpProperty(builder, (String)indent, "fields", this.getChildren());
        NodeData.dumpProperty(builder, (String)indent, "executableTypes", this.getExecutableTypes());
        NodeData.dumpProperty(builder, (String)indent, "specializations", this.getSpecializations());
        NodeData.dumpProperty(builder, (String)indent, "casts", this.getCasts());
        NodeData.dumpProperty(builder, (String)indent, "messages", this.collectMessages());
        if (this.getEnclosingNodes().size() > 0) {
            builder.append(String.format("%n%s  children = [", indent));
            for (NodeData node : this.getEnclosingNodes()) {
                builder.append("%n");
                builder.append(node.dump(level + 1));
            }
            builder.append(String.format("%n%s  ]", indent));
        }
        builder.append(String.format("%s}", indent));
        return builder.toString();
    }

    private static void dumpProperty(StringBuilder b, String indent, String propertyName, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                b.append(String.format("%n%s  %s = %s", indent, propertyName, NodeData.dumpList(indent, (List)value)));
            }
        } else if (value != null) {
            b.append(String.format("%n%s  %s = %s", indent, propertyName, value));
        }
    }

    private static String dumpList(String indent, List<?> array) {
        if (array == null) {
            return "null";
        }
        if (array.isEmpty()) {
            return "[]";
        }
        if (array.size() == 1) {
            return "[" + array.get(0).toString() + "]";
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (Object object : array) {
            b.append("%n        ");
            b.append(indent);
            b.append(object);
            b.append(", ");
        }
        b.append("%n    ").append(indent).append("]");
        return b.toString();
    }

    public NodeChildData findChild(String name) {
        for (NodeChildData field : this.getChildren()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List<NodeChildData> getChildren() {
        return this.children;
    }

    public Collection<SpecializationData> computeUncachedSpecializations(List<SpecializationData> s) {
        LinkedHashSet<SpecializationData> uncached = new LinkedHashSet<SpecializationData>(s);
        for (SpecializationData specialization : s) {
            uncached.removeAll(specialization.getReplaces());
        }
        return uncached;
    }

    public List<SpecializationData> getSpecializations() {
        return this.specializations;
    }

    public ExecutableTypeData getGenericExecutableType(ExecutableTypeData typeHint) {
        ExecutableTypeData polymorphicDelegate = null;
        if (typeHint != null) {
            polymorphicDelegate = typeHint;
            while (polymorphicDelegate.getDelegatedTo() != null && polymorphicDelegate.getEvaluatedCount() != this.getSignatureSize()) {
                polymorphicDelegate = polymorphicDelegate.getDelegatedTo();
            }
        }
        if (polymorphicDelegate == null) {
            for (ExecutableTypeData type : this.getExecutableTypes()) {
                if (type.getDelegatedTo() != null || type.getEvaluatedCount() != this.getSignatureSize()) continue;
                polymorphicDelegate = type;
                break;
            }
        }
        return polymorphicDelegate;
    }

    public List<ExecutableTypeData> getExecutableTypes() {
        return this.getExecutableTypes(-1);
    }

    public int getMinimalEvaluatedParameters() {
        int minimalEvaluatedParameters = Integer.MAX_VALUE;
        for (ExecutableTypeData type : this.getExecutableTypes()) {
            minimalEvaluatedParameters = Math.min(minimalEvaluatedParameters, type.getEvaluatedCount());
        }
        return minimalEvaluatedParameters;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getNodeId() + "]";
    }

    public CreateCastData findCast(String name) {
        if (this.getCasts() != null) {
            for (CreateCastData cast : this.getCasts()) {
                if (!cast.getChildNames().contains(name)) continue;
                return cast;
            }
        }
        return null;
    }

    @Override
    public int compareTo(NodeData o) {
        return this.getNodeId().compareTo(o.getNodeId());
    }

    public TypeMirror getGenericType(NodeExecutionData execution) {
        return ElementUtils.getCommonSuperType(this.getContext(), this.getGenericTypes(execution));
    }

    public List<TypeMirror> getGenericTypes(NodeExecutionData execution) {
        int executionIndex;
        ArrayList<TypeMirror> foundTypes = new ArrayList<TypeMirror>();
        if (execution.getChild() != null) {
            for (ExecutableTypeData executable : execution.getChild().getNodeData().getExecutableTypes()) {
                if (executable.hasUnexpectedValue()) continue;
                foundTypes.add(executable.getReturnType());
            }
        }
        if ((executionIndex = execution.getIndex()) >= 0) {
            for (ExecutableTypeData typeData : this.getExecutableTypes()) {
                List<TypeMirror> signatureParameters = typeData.getSignatureParameters();
                if (executionIndex >= signatureParameters.size()) continue;
                TypeMirror genericType = signatureParameters.get(executionIndex);
                foundTypes.add(genericType);
            }
        }
        return Arrays.asList(ElementUtils.getCommonSuperType(ProcessorContext.getInstance(), foundTypes));
    }

    public void setReportPolymorphism(boolean report) {
        this.reportPolymorphism = report;
    }

    public boolean isReportPolymorphism() {
        return this.reportPolymorphism;
    }

    public void setAllowedCheckedExceptions(Set<String> checkedExceptions) {
        this.allowedCheckedExceptions = checkedExceptions;
    }

    public Set<String> getAllowedCheckedExceptions() {
        return this.allowedCheckedExceptions;
    }

    public Set<TypeMirror> getLibraryTypes() {
        return this.libraryTypes;
    }

    public void setPolymorphicExecutable(ExecutableTypeData polymorphicType) {
        this.polymorphicExecutable = polymorphicType;
    }

    public ExecutableTypeData getPolymorphicExecutable() {
        return this.polymorphicExecutable;
    }
}

