/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class CodeTypeParameterElement
extends CodeElement<Element>
implements TypeParameterElement {
    private final Name name;
    private final List<TypeMirror> bounds = new ArrayList<TypeMirror>();

    public CodeTypeParameterElement(Name name, TypeMirror ... bounds) {
        super(ElementUtils.modifiers(new Modifier[0]));
        this.name = name;
        this.bounds.addAll(Arrays.asList(bounds));
    }

    @Override
    public TypeMirror asType() {
        return new Mirror(null, null);
    }

    public TypeMirror createMirror(TypeMirror upperBound, TypeMirror lowerBound) {
        return new Mirror(upperBound, lowerBound);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.TYPE_PARAMETER;
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitTypeParameter(this, p);
    }

    @Override
    public Element getGenericElement() {
        return this.getEnclosingElement();
    }

    public List<TypeMirror> getBounds() {
        return this.bounds;
    }

    private class Mirror
    extends CodeTypeMirror
    implements TypeVariable {
        private final TypeMirror upperBound;
        private final TypeMirror lowerBound;

        Mirror(TypeMirror upperBound, TypeMirror lowerBound) {
            super(TypeKind.TYPEVAR);
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
        }

        @Override
        public Element asElement() {
            return CodeTypeParameterElement.this;
        }

        @Override
        public TypeMirror getUpperBound() {
            return this.upperBound;
        }

        @Override
        public TypeMirror getLowerBound() {
            return this.lowerBound;
        }
    }
}

