/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.Timer;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public final class AnnotationProcessor<M extends Template> {
    private final AbstractParser<M> parser;
    private final CodeTypeElementFactory<M> factory;
    private final Set<String> processedElements = new HashSet<String>();
    private final Map<String, Map<String, Element>> serviceRegistrations = new LinkedHashMap<String, Map<String, Element>>();

    AnnotationProcessor(AbstractParser<M> parser, CodeTypeElementFactory<M> factory) {
        this.parser = parser;
        this.factory = factory;
    }

    public AbstractParser<M> getParser() {
        return this.parser;
    }

    public Map<String, Map<String, Element>> getServiceRegistrations() {
        return this.serviceRegistrations;
    }

    public void registerService(String serviceBinaryName, String implBinaryName, Element sourceElement) {
        if (sourceElement instanceof GeneratedElement) {
            throw new IllegalArgumentException("Service source element must not be generated.");
        }
        Map<String, Element> services = this.serviceRegistrations.get(serviceBinaryName);
        if (services == null) {
            services = new LinkedHashMap<String, Element>();
            this.serviceRegistrations.put(serviceBinaryName, services);
        }
        services.put(implBinaryName, sourceElement);
    }

    public void process(Element element) {
        String qualifiedName = ElementUtils.getQualifiedName((TypeElement)element);
        if (this.processedElements.contains(qualifiedName)) {
            return;
        }
        this.processedElements.add(qualifiedName);
        this.processImpl(element);
    }

    private void processImpl(Element element) {
        TypeElement type;
        ProcessorContext context = ProcessorContext.getInstance();
        Template model = context.parseIfAbsent(type = (TypeElement)element, this.parser.getClass(), e -> {
            try (Timer timer = Timer.create("Parse", e);){
                Template template = (Template)this.parser.parse((Element)e);
                return template;
            }
        });
        if (model != null) {
            List<CodeTypeElement> units;
            Timer timer;
            try {
                timer = Timer.create("Generate", element);
                try {
                    units = this.factory.create(ProcessorContext.getInstance(), this, model);
                }
                finally {
                    if (timer != null) {
                        timer.close();
                    }
                }
            }
            catch (Throwable e2) {
                RuntimeException ex = new RuntimeException(String.format("Failed to write code for %s.", ElementUtils.getQualifiedName(type)));
                e2.addSuppressed(ex);
                throw e2;
            }
            if (units == null || units.isEmpty()) {
                return;
            }
            timer = Timer.create("Fixup", element);
            try {
                for (CodeTypeElement unit : units) {
                    unit.setGeneratorAnnotationMirror(model.getTemplateTypeAnnotation());
                    unit.setGeneratorElement(model.getTemplateType());
                    DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
                    unit.accept(new GenerateOverrideVisitor(overrideType), null);
                    unit.accept(new FixWarningsVisitor(overrideType), null);
                }
            }
            finally {
                if (timer != null) {
                    timer.close();
                }
            }
            timer = Timer.create("CodeWriter", element);
            try {
                for (CodeTypeElement unit : units) {
                    unit.accept(new CodeWriter(context.getEnvironment(), element), null);
                }
            }
            finally {
                if (timer != null) {
                    timer.close();
                }
            }
        }
    }
}

