/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.nio.ByteOrder;

abstract class NativeBuffer
implements TruffleObject {
    NativeBuffer() {
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=SerializableLibrary.class, useForAOT=false), @ExportLibrary(value=InteropLibrary.class)})
    static final class Array
    extends NativeBuffer {
        final byte[] content;

        Array(byte[] content) {
            this.content = content;
        }

        @ExportMessage
        boolean isSerializable() {
            return true;
        }

        @ExportMessage(limit="1")
        void serialize(Object buffer, @CachedLibrary(value="buffer") InteropLibrary interop) {
            try {
                for (int i = 0; i < this.content.length; ++i) {
                    interop.writeBufferByte(buffer, (long)i, this.content[i]);
                }
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @ExportMessage
        boolean hasBufferElements() {
            return true;
        }

        @ExportMessage
        int getBufferSize() {
            return this.content.length;
        }

        @ExportMessage
        byte readBufferByte(long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            if (Long.compareUnsigned(offset, this.content.length) >= 0) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)offset, (long)this.content.length);
            }
            return this.content[(int)offset];
        }

        private int check(ByteArraySupport support, long offset, int len, BranchProfile exception) throws InvalidBufferOffsetException {
            int ret = (int)offset;
            if ((long)ret != offset || !support.inBounds(this.content, ret, len)) {
                exception.enter();
                throw InvalidBufferOffsetException.create((long)offset, (long)this.content.length);
            }
            return ret;
        }

        private static ByteArraySupport byteArraySupport(ByteOrder order) {
            if (order == ByteOrder.BIG_ENDIAN) {
                return ByteArraySupport.bigEndian();
            }
            return ByteArraySupport.littleEndian();
        }

        @ExportMessage
        short readBufferShort(ByteOrder order, long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            ByteArraySupport support = Array.byteArraySupport(order);
            return support.getShort(this.content, this.check(support, offset, 2, exception));
        }

        @ExportMessage
        int readBufferInt(ByteOrder order, long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            ByteArraySupport support = Array.byteArraySupport(order);
            return support.getInt(this.content, this.check(support, offset, 4, exception));
        }

        @ExportMessage
        long readBufferLong(ByteOrder order, long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            ByteArraySupport support = Array.byteArraySupport(order);
            return support.getLong(this.content, this.check(support, offset, 8, exception));
        }

        @ExportMessage
        float readBufferFloat(ByteOrder order, long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            ByteArraySupport support = Array.byteArraySupport(order);
            return support.getFloat(this.content, this.check(support, offset, 4, exception));
        }

        @ExportMessage
        double readBufferDouble(ByteOrder order, long offset, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidBufferOffsetException {
            ByteArraySupport support = Array.byteArraySupport(order);
            return support.getDouble(this.content, this.check(support, offset, 8, exception));
        }
    }
}

