/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.agentscript.impl.AbstractContextObject;

@ExportLibrary(value=InteropLibrary.class)
final class LocationObject
extends AbstractContextObject {
    private final Node node;

    LocationObject(Node node) {
        this.node = node;
    }

    @ExportMessage
    static boolean hasMembers(LocationObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(LocationObject obj, boolean includeInternal) {
        return MEMBERS;
    }

    @Override
    @ExportMessage
    Object readMember(String member) throws UnknownIdentifierException {
        return super.readMember(member);
    }

    @ExportMessage
    static boolean isMemberReadable(LocationObject obj, String member) {
        return MEMBERS.contains(member);
    }

    @Override
    Node getInstrumentedNode() {
        return this.node;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    SourceSection getInstrumentedSourceSection() {
        for (Node n = this.node; n != null; n = n.getParent()) {
            SourceSection section = n instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)n).getDelegateNode().getSourceSection() : n.getSourceSection();
            if (section == null) continue;
            return section;
        }
        return null;
    }
}

