/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.AgentScriptInstrumentOptionDescriptors;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightPerSource;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

@TruffleInstrument.Registration(id="agentscript", name="Agent Script", version="1.2", services={Function.class})
public final class AgentScriptInstrument
extends InsightInstrument {
    @Option(stability=OptionStability.EXPERIMENTAL, name="", help="Deprecated. Use --insight!", category=OptionCategory.USER)
    static final OptionKey<String> DEPRECATED = new OptionKey((Object)"");
    private AgentObject agent;

    @Override
    protected OptionDescriptors getOptionDescriptors() {
        return new AgentScriptInstrumentOptionDescriptors();
    }

    @Override
    OptionKey<String> option() {
        return DEPRECATED;
    }

    @Override
    synchronized void collectGlobalSymbolsImpl(InsightPerSource src, List<String> argNames, List<Object> args) {
        if (this.agent == null) {
            this.agent = new AgentObject("Warning: 'agent' is deprecated. Use 'insight'.\n", this, src);
        }
        argNames.add("agent");
        args.add(this.agent);
    }

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        super.onCreate(env);
        try {
            env.err().write("Warning: Option --agentscript is deprecated. Use --insight option.\n".getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

