/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.metainf;

import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.driver.metainf.MetaInfFileType;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NativeImageMetaInfWalker {
    public static final String nativeImageMetaInf = "META-INF/native-image";
    public static final String nativeImagePropertiesFilename = "native-image.properties";

    public static void walkMetaInfForCPEntry(Path classpathEntry, NativeImageMetaInfResourceProcessor metaInfProcessor) throws MetaInfWalkException {
        block11: {
            try {
                FileSystem probeJarFS;
                if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                    Path nativeImageMetaInfBase = classpathEntry.resolve(Paths.get(nativeImageMetaInf, new String[0]));
                    NativeImageMetaInfWalker.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                    break block11;
                }
                if (!ClasspathUtils.isJar((Path)classpathEntry)) break block11;
                URI jarFileURI = URI.create("jar:" + String.valueOf(classpathEntry.toUri()));
                try {
                    probeJarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
                }
                catch (UnsupportedOperationException e) {
                    probeJarFS = null;
                    metaInfProcessor.showWarning(String.valueOf(classpathEntry) + " does not describe valid jar-file");
                }
                if (probeJarFS == null) break block11;
                try (FileSystem jarFS = probeJarFS;){
                    Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                    NativeImageMetaInfWalker.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                }
            }
            catch (IOException | FileSystemNotFoundException e) {
                throw new MetaInfWalkException("Invalid classpath entry " + String.valueOf(classpathEntry), e);
            }
        }
    }

    private static void processNativeImageMetaInf(Path classpathEntry, Path nativeImageMetaInfBase, NativeImageMetaInfResourceProcessor metaInfProcessor) throws MetaInfWalkException {
        if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
            for (MetaInfFileType fileType : MetaInfFileType.values()) {
                List nativeImageMetaInfFiles;
                try (Stream<Path> pathStream = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]);){
                    nativeImageMetaInfFiles = pathStream.filter(p -> p.endsWith(fileType.fileName)).collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new MetaInfWalkException("Processing " + String.valueOf(nativeImageMetaInfBase.toUri()) + " failed.", e);
                }
                for (Path nativeImageMetaInfFile : nativeImageMetaInfFiles) {
                    boolean excluded = metaInfProcessor.isExcluded(nativeImageMetaInfFile, classpathEntry);
                    if (excluded) continue;
                    Path resourceRoot = nativeImageMetaInfBase.getParent().getParent();
                    metaInfProcessor.showVerboseMessage("Apply " + String.valueOf(nativeImageMetaInfFile.toUri()));
                    try {
                        metaInfProcessor.processMetaInfResource(classpathEntry, resourceRoot, nativeImageMetaInfFile, fileType);
                    }
                    catch (Throwable err) {
                        throw new MetaInfWalkException("Processing " + String.valueOf(nativeImageMetaInfFile.toUri()) + " failed", err);
                    }
                }
            }
        }
    }

    public static class MetaInfWalkException
    extends Exception {
        private static final long serialVersionUID = 7185681203564964445L;
        public final Throwable cause;

        public MetaInfWalkException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }
    }
}

