/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.URLConnectionFactory;

public class ProxyConnectionFactory
implements URLConnectionFactory {
    private static final int DEFAULT_CONNECT_DELAY = Integer.getInteger("org.graalvm.component.installer.connectDelaySec", 10);
    private static final int DEFAULT_DIRECT_CONNECT_DELAY = Integer.getInteger("org.graalvm.component.installer.directConnectDelaySec", 20);
    private static final String PROXY_SCHEME_PREFIX = "http://";
    private final Feedback feedback;
    private final URL urlBase;
    private Connector winningConnector;
    private final ExecutorService connectors = Executors.newCachedThreadPool();
    String envHttpProxy = System.getProperty("http_proxy", System.getenv("http_proxy"));
    String envHttpsProxy = System.getProperty("https_proxy", System.getenv("https_proxy"));
    private int connectDelay = DEFAULT_CONNECT_DELAY;
    private int directConnectDelay = DEFAULT_DIRECT_CONNECT_DELAY;
    private static final Pattern SCHEME_REGEXP = Pattern.compile("^\\p{Alpha}[\\p{Alnum}+-.]*:", 2);

    public ProxyConnectionFactory(Feedback feedback, URL urlBase) {
        this.feedback = feedback.withBundle(ProxyConnectionFactory.class);
        this.urlBase = urlBase;
    }

    public void setConnectDelay(int delay, int directDelay) {
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        this.connectDelay = delay;
        if (directDelay >= 0) {
            this.directConnectDelay = directDelay;
        } else {
            float factor = Math.min(1.0f, (float)DEFAULT_DIRECT_CONNECT_DELAY / (float)DEFAULT_CONNECT_DELAY);
            this.directConnectDelay = Math.round((float)delay * factor);
        }
    }

    public void setConnectDelayFactor(float factor) {
        this.connectDelay = Math.round((float)DEFAULT_CONNECT_DELAY * factor);
        this.directConnectDelay = Math.round((float)DEFAULT_DIRECT_CONNECT_DELAY * factor);
    }

    public ProxyConnectionFactory setProxy(boolean secure, String proxyURI) {
        if (secure) {
            this.envHttpsProxy = proxyURI;
        } else {
            this.envHttpProxy = proxyURI;
        }
        return this;
    }

    public URLConnection openConnection(URI relative, URLConnectionFactory.Configure configCallback) throws IOException {
        if (relative != null) {
            try {
                return this.openConnectionWithProxies(this.urlBase.toURI().resolve(relative).toURL(), configCallback);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return this.openConnectionWithProxies(this.urlBase, configCallback);
    }

    public static InetSocketAddress proxyAddress(String proxySpec) throws URISyntaxException {
        URI uri;
        Object trimmed;
        block11: {
            if (proxySpec == null) {
                return null;
            }
            trimmed = proxySpec.trim();
            if ("".equals(trimmed)) {
                return null;
            }
            try {
                uri = new URI((String)trimmed);
            }
            catch (URISyntaxException ex) {
                if (SCHEME_REGEXP.matcher((CharSequence)trimmed).find()) {
                    throw ex;
                }
                try {
                    trimmed = PROXY_SCHEME_PREFIX + (String)trimmed;
                    uri = new URI((String)trimmed);
                }
                catch (URISyntaxException ex2) {
                    throw ex;
                }
                if (uri.getHost() != null && uri.getPort() >= 1) break block11;
                throw ex;
            }
        }
        if (uri.getScheme() == null || uri.getHost() == null) {
            URI checkURI = null;
            try {
                checkURI = new URI(PROXY_SCHEME_PREFIX + (String)trimmed);
                if (checkURI.getHost() != null && checkURI.getPort() >= 1) {
                    uri = checkURI;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
        return address;
    }

    List<Connector> makeConnectors(String httpProxy, String httpsProxy) {
        InetSocketAddress httpProxyAddress = null;
        InetSocketAddress httpsProxyAddress = null;
        URISyntaxException httpError = null;
        URISyntaxException httpsError = null;
        if (httpProxy != null) {
            try {
                httpProxyAddress = ProxyConnectionFactory.proxyAddress(httpProxy);
            }
            catch (URISyntaxException ex) {
                httpError = ex;
            }
        }
        if (httpsProxy != null && !Objects.equals(httpProxy, httpsProxy)) {
            try {
                httpsProxyAddress = ProxyConnectionFactory.proxyAddress(httpsProxy);
            }
            catch (URISyntaxException ex) {
                httpsError = ex;
            }
        }
        ArrayList<Connector> tryConnectors = new ArrayList<Connector>();
        if (httpProxyAddress != null) {
            tryConnectors.add(new Connector(httpProxyAddress));
        }
        if (httpsProxyAddress != null) {
            tryConnectors.add(new Connector(httpsProxyAddress));
        }
        if (httpError != null) {
            this.feedback.error("WARN_HttpProxyGarbage", httpError, httpProxy);
        }
        if (httpsError != null) {
            this.feedback.error("WARN_HttpsProxyGarbage", httpError, httpProxy);
        }
        if (tryConnectors.isEmpty()) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        tryConnectors.add(new Connector(null));
        return tryConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection openConnectionWithProxies(URL url, URLConnectionFactory.Configure configCallback) throws IOException {
        Connector winner;
        String httpsProxy;
        String httpProxy;
        CountDownLatch connected = new CountDownLatch(1);
        ConnectionContext ctx = new ConnectionContext(url, configCallback, connected);
        ProxyConnectionFactory proxyConnectionFactory = this;
        synchronized (proxyConnectionFactory) {
            httpProxy = this.envHttpProxy;
            httpsProxy = this.envHttpsProxy;
            winner = this.winningConnector;
        }
        boolean haveProxy = false;
        if (winner != null && winner.accepts(url)) {
            winner.bind(ctx);
            ctx.submit(winner);
        } else {
            List<Connector> newConnectors = this.makeConnectors(httpProxy, httpsProxy);
            haveProxy = newConnectors.size() > 1;
            newConnectors.forEach(c -> ctx.submit(c.bind(ctx)));
        }
        ctx.start();
        int shouldDelay = haveProxy ? this.connectDelay : this.directConnectDelay;
        URLConnection res = null;
        try {
            if (shouldDelay > 0) {
                if (!connected.await(shouldDelay, TimeUnit.SECONDS)) {
                    throw ctx.getConnectException();
                }
                res = ctx.getConnection();
            } else {
                connected.await();
                res = ctx.getConnection();
            }
        }
        catch (InterruptedException ex) {
            throw new ConnectException(this.feedback.l10n("EXC_InterruptedConnectingTo", url));
        }
        return res;
    }

    @Override
    public URLConnection createConnection(URL u, URLConnectionFactory.Configure configCallback) throws IOException {
        try {
            return this.openConnection(u.toURI(), configCallback);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    final class Connector
    implements Runnable {
        private final InetSocketAddress proxyAddress;
        private URL url;
        private ConnectionContext context;

        Connector(InetSocketAddress address) {
            this.proxyAddress = address;
        }

        InetSocketAddress getProxyAddress() {
            return this.proxyAddress;
        }

        boolean isDirect() {
            return this.proxyAddress == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean accepts(URL u) {
            Connector connector = this;
            synchronized (connector) {
                return Objects.equals(u.getAuthority(), this.url.getAuthority());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connector bind(ConnectionContext ctx) {
            Connector connector = this;
            synchronized (connector) {
                this.context = ctx;
                this.url = ctx.url;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionContext ctx;
            Connector connector = this;
            synchronized (connector) {
                ctx = this.context;
                this.context = null;
            }
            this.runWithContext(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runWithContext(ConnectionContext ctx) {
            Proxy proxy = this.isDirect() ? null : new Proxy(Proxy.Type.HTTP, this.proxyAddress);
            URLConnectionFactory.Configure configCallback = ctx.configCallback;
            boolean won = false;
            URLConnection test = null;
            try {
                HttpURLConnection htest;
                int rcode;
                URLConnection uRLConnection = test = proxy == null ? this.url.openConnection() : this.url.openConnection(proxy);
                if (configCallback != null) {
                    configCallback.accept(test);
                }
                test.connect();
                if (test instanceof HttpURLConnection && (rcode = (htest = (HttpURLConnection)test).getResponseCode()) >= 400) {
                    try {
                        htest.getInputStream().close();
                    }
                    catch (IOException ex) {
                        throw new HttpConnectionException(ex.getMessage(), ex, this.isDirect(), htest);
                    }
                    if (!this.isDirect()) {
                        throw new IOException(ProxyConnectionFactory.this.feedback.l10n("EXC_ProxyFailed", rcode));
                    }
                }
                won = ctx.setOutcome(this, test);
            }
            catch (IOException ex) {
                ctx.setOutcome(this.isDirect(), ex);
            }
            finally {
                if (!won && test instanceof HttpURLConnection) {
                    ((HttpURLConnection)test).disconnect();
                }
            }
        }
    }

    private class ConnectionContext {
        private final URLConnectionFactory.Configure configCallback;
        private final CountDownLatch countDown;
        private final URL url;
        private final List<Connector> tryConnectors = new ArrayList<Connector>();
        private Connector winner;
        private URLConnection openedConnection;
        private IOException exProxy;
        private IOException exDirect;
        private int outcomes;

        ConnectionContext(URL url, URLConnectionFactory.Configure configCallback, CountDownLatch latch) {
            this.configCallback = configCallback;
            this.countDown = latch;
            this.url = url;
        }

        synchronized URLConnection getConnection() throws IOException {
            if (this.openedConnection == null) {
                if (this.exDirect != null) {
                    throw this.exDirect;
                }
                if (this.exProxy != null) {
                    throw this.exProxy;
                }
                throw new ConnectException(ProxyConnectionFactory.this.feedback.l10n("EXC_CannotConnectTo", this.url));
            }
            return this.openedConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setOutcome(Connector w, URLConnection opened) {
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                if (this.winner != null) {
                    return false;
                }
                this.winner = w;
                this.openedConnection = opened;
            }
            if (this.countDown != null) {
                this.countDown.countDown();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setOutcome(boolean direct, IOException e) {
            ConnectionContext connectionContext = this;
            synchronized (connectionContext) {
                if (direct) {
                    this.exDirect = e;
                } else {
                    this.exProxy = e;
                }
                if (++this.outcomes == this.tryConnectors.size()) {
                    this.countDown.countDown();
                }
            }
        }

        synchronized IOException getConnectException() {
            if (this.exDirect != null) {
                return this.exDirect;
            }
            if (this.exProxy != null) {
                return this.exProxy;
            }
            return new ConnectException(ProxyConnectionFactory.this.feedback.l10n("EXC_TimeoutConnectTo", this.url));
        }

        synchronized void submit(Connector c) {
            this.tryConnectors.add(c);
        }

        void start() {
            for (Connector c : this.tryConnectors) {
                ProxyConnectionFactory.this.connectors.submit(c);
            }
        }
    }

    public static class HttpConnectionException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final boolean isDirect;
        private final int retCode;
        private final URL connectionUrl;
        private final String response;

        public HttpConnectionException(String message, IOException cause, boolean isDirect, HttpURLConnection connection) throws IOException {
            super(message, cause);
            this.response = HttpConnectionException.parseErrorResponse(connection);
            this.retCode = connection.getResponseCode();
            this.connectionUrl = connection.getURL();
            this.isDirect = isDirect;
        }

        private static String parseErrorResponse(HttpURLConnection connection) {
            String string;
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            try {
                string = br.lines().reduce((s1, s2) -> s1 + "\n" + s2).orElse("");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException t) {
                    return t.getLocalizedMessage();
                }
            }
            br.close();
            return string;
        }

        public int getRetCode() {
            return this.retCode;
        }

        public String getResponse() {
            return this.response;
        }

        public URL getConnectionUrl() {
            return this.connectionUrl;
        }

        public boolean isProxy() {
            return this.isDirect;
        }
    }
}

