/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.model.CatalogContents;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.GraalEdition;
import org.graalvm.component.installer.remote.RemoteCatalogDownloader;

public final class GraalEditionList
implements CommandInput.CatalogFactory {
    static final String CAP_CATALOG_URL_SUFFIX = "_url";
    private final CommandInput input;
    private final ComponentRegistry targetGraal;
    private final Feedback feedback;
    private final List<GraalEdition> editions = new ArrayList<GraalEdition>();
    private final Map<String, GraalEdition> editionMap = new HashMap<String, GraalEdition>();
    private final Map<ComponentRegistry, GraalEditionList> foreignGraals = new HashMap<ComponentRegistry, GraalEditionList>();
    private String overrideCatalogSpec;
    private String defaultCatalogSpec;
    private GraalEdition defaultEdition;
    private boolean remoteSourcesAllowed = true;
    private List<SoftwareChannelSource> localSources = new ArrayList<SoftwareChannelSource>();
    private static final Comparator<String> CHANNEL_KEY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int i1 = Integer.MAX_VALUE;
            int i2 = Integer.MAX_VALUE;
            String k1 = o1.substring("component_catalog_".length() - 1);
            String k2 = o2.substring("component_catalog_".length() - 1);
            if (k1.equals("")) {
                i1 = 0;
            } else {
                if (k1.startsWith("_")) {
                    k1 = k1.substring(1);
                }
                try {
                    i1 = Integer.parseInt(k1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (k2.equals("")) {
                i2 = 0;
            } else {
                if (k2.startsWith("_")) {
                    k2 = k2.substring(1);
                }
                try {
                    i2 = Integer.parseInt(k2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (i1 != i2) {
                return i1 - i2;
            }
            return k1.compareToIgnoreCase(k2);
        }
    };
    private static final String EDITION_MATCH_REGEXP = "(?:([^_]+)_)?component_catalog(_?.*)_url";
    private ComponentCatalog catalog;

    public GraalEditionList(Feedback feedback, CommandInput input, ComponentRegistry reg) {
        this.input = input;
        this.targetGraal = reg;
        this.feedback = feedback.withBundle(GraalEditionList.class);
    }

    public String getOverrideCatalogSpec() {
        return this.overrideCatalogSpec;
    }

    public void setOverrideCatalogSpec(String overrideCatalogSpec) {
        this.overrideCatalogSpec = overrideCatalogSpec;
    }

    public String getDefaultCatalogSpec() {
        return this.defaultCatalogSpec;
    }

    public void setDefaultCatalogSpec(String defaultCatalogSpec) {
        this.defaultCatalogSpec = defaultCatalogSpec;
    }

    public GraalEdition getDefaultEdition() {
        this.init();
        return this.defaultEdition;
    }

    public void setDefaultEdition(GraalEdition ed) {
        this.defaultEdition = ed;
    }

    public List<GraalEdition> editions() {
        this.init();
        return this.editions;
    }

    public GraalEdition getEdition(String id) {
        if (id == null || "".equals(id)) {
            return this.getDefaultEdition();
        }
        this.init();
        GraalEdition e = this.editionMap.get(id.toLowerCase(Locale.ENGLISH));
        if (e == null) {
            throw this.feedback.failure("ERR_NoSuchEdition", null, id);
        }
        return e;
    }

    List<SoftwareChannelSource> parseChannelSources(String edId, String overrideSpec) {
        ArrayList<SoftwareChannelSource> sources = new ArrayList<SoftwareChannelSource>();
        if (!this.remoteSourcesAllowed || overrideSpec == null) {
            return sources;
        }
        int priority = 1;
        String[] parts = overrideSpec.split("\\|");
        String id = edId;
        if (id == null) {
            id = this.targetGraal.getGraalCapabilities().get("edition");
        }
        for (String s : parts) {
            SoftwareChannelSource chs = new SoftwareChannelSource(s);
            chs.setPriority(priority);
            chs.setParameter("edition", id);
            sources.add(chs);
            ++priority;
        }
        return sources;
    }

    void parseSimpleSpecification(String defId, String spec) {
        String[] eds;
        if (spec == null) {
            return;
        }
        for (String part : eds = spec.split("\\{")) {
            String edId;
            String edName;
            if ("".equals(part)) continue;
            String src = part;
            int endBracket = part.indexOf(125);
            if (endBracket != -1) {
                int eqSign = part.indexOf(61);
                if (eqSign == -1 || eqSign >= endBracket) {
                    edId = edName = part.substring(0, endBracket);
                } else {
                    edId = part.substring(0, eqSign);
                    edName = part.substring(eqSign + 1, endBracket);
                }
                src = part.substring(endBracket + 1).trim();
                if (src.endsWith("|")) {
                    src = src.substring(0, src.length() - 1);
                }
            } else {
                edId = defId != null ? defId : "ce";
                edName = this.getEditionLabel(edId);
                if (edName == null) {
                    edName = this.getEditionLabel(null);
                }
            }
            GraalEdition ge = new GraalEdition(edId, edName);
            boolean def = false;
            ge.setSoftwareSources(this.parseChannelSources(edId, src));
            if (this.defaultEdition == null && endBracket == -1) {
                def = true;
            } else if (edId.equals(defId)) {
                def = true;
            }
            this.registerEdition(ge, def);
        }
    }

    boolean isExplicitOverride() {
        return this.overrideCatalogSpec != null;
    }

    void init() {
        List<SoftwareChannelSource> sources;
        String label;
        if (this.defaultEdition != null) {
            return;
        }
        String defEditionId = this.targetGraal.getGraalCapabilities().get("edition");
        if (this.isExplicitOverride()) {
            this.initSimple(defEditionId, this.overrideCatalogSpec);
            return;
        }
        List<SoftwareChannelSource> srcs = this.readChannelSources(defEditionId);
        if (srcs.isEmpty()) {
            srcs = this.readChannelSources(null);
        }
        if (srcs.isEmpty()) {
            this.initSimple(defEditionId, this.defaultCatalogSpec);
            return;
        }
        List<String> edList = this.listEditionsFromRelease();
        if (edList.contains(defEditionId)) {
            edList.remove(defEditionId);
            label = this.getEditionLabel(defEditionId);
            sources = this.readChannelSources(defEditionId);
        } else {
            if (!edList.remove("")) {
                throw new IllegalStateException("Malformed release file.");
            }
            label = this.getEditionLabel(null);
            sources = this.readChannelSources(null);
        }
        GraalEdition ge = new GraalEdition(defEditionId, label);
        ge.setSoftwareSources(sources);
        this.registerEdition(ge, true);
        for (String id : edList) {
            label = this.getEditionLabel(id);
            sources = this.readChannelSources(id);
            ge = new GraalEdition(id, label);
            ge.setSoftwareSources(sources);
            this.registerEdition(ge, false);
        }
    }

    private void registerEdition(GraalEdition ge, boolean defaultEd) {
        if (!this.editions.contains(ge)) {
            this.editions.add(ge);
        }
        if (defaultEd) {
            this.editionMap.put("", ge);
            this.defaultEdition = ge;
        }
        this.editionMap.put(ge.getId().toLowerCase(Locale.ENGLISH), ge);
    }

    private List<String> listEditionsFromRelease() {
        HashMap<String, String> editionOrder = new HashMap<String, String>();
        GraalEditionList.addEditions(editionOrder, this.targetGraal.getGraalCapabilities(), Pattern.compile(EDITION_MATCH_REGEXP));
        GraalEditionList.addEditions(editionOrder, GraalEditionList.lowercaseMap(this.input.parameters(false)), Pattern.compile("GRAALVM_CATALOG_".toLowerCase(Locale.ENGLISH) + EDITION_MATCH_REGEXP));
        ArrayList<String> editionIds = new ArrayList<String>(editionOrder.keySet());
        Collections.sort(editionIds, (a, b) -> CHANNEL_KEY_COMPARATOR.compare((String)editionOrder.get(a), (String)editionOrder.get(b)));
        return editionIds;
    }

    private static void addEditions(Map<String, String> eds, Map<String, String> params, Pattern match) {
        for (String k : params.keySet()) {
            Matcher m = match.matcher(k);
            if (!m.matches()) continue;
            String id = m.group(1);
            if (null == id) {
                id = "";
            }
            eds.putIfAbsent(id, k);
        }
    }

    private void ensureDefaultDefined(String defEditionId) {
        GraalEdition ge;
        if (this.editions.isEmpty()) {
            String label = this.getEditionLabel(defEditionId);
            ge = new GraalEdition(defEditionId == null ? "" : defEditionId, label);
        } else {
            ge = this.defaultEdition == null ? this.editions.get(0) : this.defaultEdition;
        }
        this.registerEdition(ge, true);
    }

    private void initSimple(String defEditionId, String spec) {
        this.parseSimpleSpecification(defEditionId, spec);
        if (this.editions.isEmpty()) {
            GraalEdition ge;
            String label = this.getEditionLabel(defEditionId);
            this.defaultEdition = ge = new GraalEdition(defEditionId, label);
            this.editions.add(ge);
        }
        this.foreignGraals.put(this.targetGraal, this);
        this.ensureDefaultDefined(defEditionId);
    }

    String getEditionLabel(String id) {
        Object readPrefix = id == null ? "" : id + "_";
        String key = (String)readPrefix + "component_catalog_editionLabel";
        String label = this.input.getParameter("GRAALVM_" + key.toUpperCase(Locale.ENGLISH), false);
        if (label == null) {
            label = this.targetGraal.getGraalCapabilities().get(key);
        }
        if (label == null) {
            label = this.targetGraal.getGraalCapabilities().get("edition");
            if (label == null) {
                if ("".equals(id) || id == null) {
                    return "CE";
                }
                return id.toUpperCase(Locale.ENGLISH);
            }
            return label.toUpperCase(Locale.ENGLISH);
        }
        return label;
    }

    public boolean isRemoteSourcesAllowed() {
        return this.remoteSourcesAllowed;
    }

    public void setRemoteSourcesAllowed(boolean remoteSourcesAllowed) {
        this.remoteSourcesAllowed = remoteSourcesAllowed;
    }

    private static Map<String, String> lowercaseMap(Map<String, String> map) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : map.keySet()) {
            res.put(s.toLowerCase(Locale.ENGLISH), map.get(s));
        }
        return res;
    }

    List<SoftwareChannelSource> readChannelSources(String editionPrefix) {
        Object readPrefix = editionPrefix == null ? "" : editionPrefix + "_";
        Map<String, String> lcEnv = GraalEditionList.lowercaseMap(this.input.parameters(false));
        List<SoftwareChannelSource> res = this.readChannelSources(editionPrefix, "GRAALVM_".toLowerCase(Locale.ENGLISH) + (String)readPrefix, lcEnv);
        if (res != null && !res.isEmpty()) {
            return res;
        }
        if (this.remoteSourcesAllowed) {
            return this.readChannelSources(editionPrefix, (String)readPrefix, this.input.getLocalRegistry().getGraalCapabilities());
        }
        ArrayList<SoftwareChannelSource> l = new ArrayList<SoftwareChannelSource>();
        return l;
    }

    List<SoftwareChannelSource> readChannelSources(String id, String pref, Map<String, String> graalCaps) {
        ArrayList<SoftwareChannelSource> sources = new ArrayList<SoftwareChannelSource>();
        if (!this.remoteSourcesAllowed) {
            return sources;
        }
        String prefix = pref + "component_catalog_";
        List orderedKeys = graalCaps.keySet().stream().filter(k -> {
            String lk = k.toLowerCase(Locale.ENGLISH);
            return lk.startsWith(prefix) && lk.endsWith(CAP_CATALOG_URL_SUFFIX);
        }).map(k -> k.substring(0, k.length() - CAP_CATALOG_URL_SUFFIX.length())).collect(Collectors.toList());
        Collections.sort(orderedKeys, CHANNEL_KEY_COMPARATOR);
        int priority = 0;
        for (String key : orderedKeys) {
            String url = graalCaps.get(key + CAP_CATALOG_URL_SUFFIX);
            String lab = graalCaps.get(key + "_label");
            if (url == null) continue;
            SoftwareChannelSource s = new SoftwareChannelSource(url, lab);
            s.setPriority(priority);
            block8: for (String a : graalCaps.keySet()) {
                String k2;
                if (!a.startsWith(key) || a.length() <= key.length() + 1) continue;
                switch (k2 = a.substring(key.length() + 1).toLowerCase(Locale.ENGLISH)) {
                    case "label": 
                    case "url": {
                        continue block8;
                    }
                }
                s.setParameter(k2, graalCaps.get(a));
            }
            if (s.getParameter("edition") == null) {
                s.setParameter("edition", id != null ? id : this.targetGraal.getGraalCapabilities().get("edition"));
            }
            sources.add(s);
            ++priority;
        }
        return sources;
    }

    RemoteCatalogDownloader createEditionDownloader(GraalEdition edition) {
        GraalEdition ed = edition;
        if (ed == null) {
            ed = this.defaultEdition;
        }
        RemoteCatalogDownloader dn = new RemoteCatalogDownloader(this.input, this.feedback, this.overrideCatalogSpec);
        Stream.concat(ed.getSoftwareSources().stream(), this.localSources.stream()).forEach(dn::addLocalChannelSource);
        dn.setRemoteSourcesAllowed(false);
        return dn;
    }

    public void addLocalChannelSource(SoftwareChannelSource src) {
        src.setParameter("reportErrors", Boolean.FALSE.toString());
        this.localSources.add(src);
    }

    GraalEditionList listGraalEditions(CommandInput in, ComponentRegistry otherGraal) {
        return this.foreignGraals.computeIfAbsent(otherGraal, og -> {
            GraalEditionList gl = new GraalEditionList(this.feedback, in, (ComponentRegistry)og);
            gl.setRemoteSourcesAllowed(this.remoteSourcesAllowed);
            String defCatalog = og.getGraalCapabilities().get("component_catalog");
            gl.setDefaultCatalogSpec(defCatalog);
            return gl;
        });
    }

    @Override
    public ComponentCatalog createComponentCatalog(CommandInput in) {
        ComponentRegistry targetGraalVM = in.getLocalRegistry();
        if (targetGraalVM != this.targetGraal) {
            GraalEditionList gl = this.listGraalEditions(in, targetGraalVM);
            return gl.createComponentCatalog(in);
        }
        if (this.catalog != null) {
            return this.catalog;
        }
        String edId = in.optValue("$", "");
        GraalEdition ge = this.getEdition(edId);
        RemoteCatalogDownloader downloader = this.createEditionDownloader(ge);
        CatalogContents col = new CatalogContents(this.feedback, downloader.getStorage(), targetGraalVM);
        this.catalog = col;
        return this.catalog;
    }

    @Override
    public List<GraalEdition> listEditions(ComponentRegistry targetGraalVM) {
        return this.editions();
    }

    final class GE
    extends GraalEdition {
        GE(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public SoftwareChannel getCatalogProvider() {
            SoftwareChannel ch = super.getCatalogProvider();
            if (ch == null) {
                ch = GraalEditionList.this.createEditionDownloader(this);
                this.setCatalogProvider(ch);
            }
            return ch;
        }
    }
}

