/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.component.installer.DependencyException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.StabilityLevel;

public class HeaderParser {
    private static final String DIRECTIVE_FILTER = "filter";
    private final String headerName;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, String> directives = new HashMap<String, String>();
    private final Map<String, String> filterValue = new HashMap<String, String>();
    private final Map<String, Object> capabilities = new HashMap<String, Object>();
    private final Set<String> dependencies = new HashSet<String>();
    private final Feedback feedback;
    private String header;
    private int pos;
    private String directiveOrParameterName;
    private int contentStart;
    private String versionFilter;

    public HeaderParser(String headerName, String header, Feedback feedback) {
        this.headerName = headerName;
        this.feedback = feedback.withBundle(HeaderParser.class);
        this.header = header != null ? header.trim() : "";
    }

    private MetadataException metaEx(String key, Object ... args) {
        return new MetadataException(this.headerName, this.feedback.l10n(key, args));
    }

    public HeaderParser mustExist() throws MetadataException {
        if (this.header == null || this.header.isEmpty()) {
            throw this.metaEx("ERROR_HeaderMissing", this.headerName);
        }
        return this;
    }

    private static boolean isAlphaNum(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isToken(char c) {
        return HeaderParser.isAlphaNum(c) || c == '_' || c == '-';
    }

    private static boolean isExtended(char c) {
        return HeaderParser.isToken(c) || c == '.';
    }

    public boolean getBoolean(Boolean defValue) {
        String s;
        if (this.pos >= this.header.length()) {
            if (defValue == null) {
                throw this.metaEx("ERROR_HeaderMissing", this.headerName);
            }
            return defValue;
        }
        switch (s = this.header.substring(this.pos).trim().toLowerCase(Locale.ENGLISH)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw this.metaEx("ERROR_HeaderInvalid", this.headerName, s);
    }

    public String getContents(String defValue) {
        if (this.pos >= this.header.length()) {
            return defValue;
        }
        return this.header.substring(this.pos).trim();
    }

    private void addFilterAttribute(String attrName, String value) {
        if (this.filterValue.put(attrName, value) != null) {
            throw this.metaErr("ERROR_DuplicateFilterAttribute", new Object[0]);
        }
    }

    private boolean isEmpty() {
        return this.pos >= this.header.length();
    }

    public String parseSymbolicName() throws MetadataException {
        return this.parseNameOrNamespace(HeaderParser::isToken, "ERROR_MissingSymbolicName", "ERROR_InvalidSymbolicName", '.');
    }

    private char next() {
        return this.pos < this.header.length() ? this.header.charAt(this.pos++) : (char)'\u0000';
    }

    private void advance() {
        ++this.pos;
    }

    private char ch() {
        return this.isEmpty() ? (char)'\u0000' : this.header.charAt(this.pos);
    }

    private String returnCut() {
        String s = this.cut();
        this.skipWhitespaces();
        return s;
    }

    private void skipWhitespaces() {
        while (!this.isEmpty()) {
            if (!Character.isWhitespace(this.ch())) {
                this.contentStart = this.pos;
                return;
            }
            this.advance();
        }
        this.contentStart = -1;
    }

    private void skipWithSemicolon() {
        this.skipWhitespaces();
        if (this.ch() == ';') {
            this.advance();
        }
        this.contentStart = -1;
    }

    private String cut() {
        return this.cut(0);
    }

    private String cut(int delim) {
        int e = this.pos - delim;
        return this.contentStart == -1 || this.contentStart >= e ? "" : this.header.substring(this.contentStart, e);
    }

    private void markContent() {
        this.contentStart = this.pos;
    }

    private String readExtendedParameter() throws MetadataException {
        char c;
        this.skipWhitespaces();
        while (!this.isEmpty() && !Character.isWhitespace(c = this.next())) {
            if (c == ';') {
                --this.pos;
                break;
            }
            if (HeaderParser.isExtended(c)) continue;
            throw this.metaEx("ERROR_InvalidParameterSyntax", this.directiveOrParameterName);
        }
        String s = this.cut();
        this.skipWithSemicolon();
        return s;
    }

    private String readQuotedParameter() throws MetadataException {
        this.markContent();
        while (!this.isEmpty()) {
            char c = this.next();
            switch (c) {
                case '\"': {
                    String s = this.cut(1);
                    this.skipWithSemicolon();
                    return s;
                }
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.metaEx("ERROR_InvalidQuotedString", new Object[0]);
                }
                case '\\': {
                    this.next();
                }
            }
        }
        throw this.metaEx("ERROR_InvalidQuotedString", new Object[0]);
    }

    private String parseArgument() throws MetadataException {
        this.skipWhitespaces();
        char c = this.ch();
        if (c == ';') {
            throw this.metaEx("ERROR_MissingArgument", this.directiveOrParameterName);
        }
        if (c == '\"') {
            this.advance();
            return this.readQuotedParameter();
        }
        return this.readExtendedParameter();
    }

    private String parseNameOrNamespace(Predicate<Character> charAcceptor, String missingKeyName, String invalidKeyName, char compDelimiter) throws MetadataException {
        if (this.header == null || this.isEmpty()) {
            throw this.metaEx(missingKeyName, new Object[0]);
        }
        this.skipWhitespaces();
        boolean componentEmpty = true;
        while (!this.isEmpty()) {
            char c = this.ch();
            if (c == ';' || c == ',') {
                String s = this.cut();
                return s;
            }
            this.advance();
            if (c == compDelimiter) {
                if (componentEmpty) {
                    throw this.metaEx(invalidKeyName, new Object[0]);
                }
                componentEmpty = true;
                continue;
            }
            if (Character.isWhitespace(c)) break;
            if (!charAcceptor.test(Character.valueOf(c))) {
                throw this.metaEx(invalidKeyName, new Object[0]);
            }
            componentEmpty = false;
        }
        return this.returnCut();
    }

    private String parseNamespace() throws MetadataException {
        return this.parseNameOrNamespace(HeaderParser::isExtended, "ERROR_MissingCapabilityName", "ERROR_InvalidCapabilityName", '\u0000');
    }

    public String version() throws MetadataException {
        int versionStart = -1;
        int partCount = 0;
        boolean partContents = false;
        if (this.isEmpty()) {
            throw this.metaErr("ERROR_InvalidVersion", new Object[0]);
        }
        boolean dash = false;
        while (!this.isEmpty()) {
            char c = this.ch();
            if (Character.isWhitespace(c)) {
                if (versionStart != -1) break;
                this.advance();
                continue;
            }
            if (c == ';') break;
            this.advance();
            if (c == '.') {
                ++partCount;
                if (!partContents) {
                    throw this.metaErr("ERROR_InvalidVersion", new Object[0]);
                }
                partContents = false;
                dash = false;
                continue;
            }
            if (partCount > 0 && partContents && c == '-') {
                dash = true;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (versionStart == -1) {
                    versionStart = this.pos - 1;
                }
            } else {
                if (partCount < 1) {
                    throw this.metaErr("ERROR_InvalidVersion", new Object[0]);
                }
                boolean err = false;
                err = partCount >= 3 || dash ? !HeaderParser.isToken(c) : true;
                if (err) {
                    throw this.metaErr("ERROR_InvalidVersion", new Object[0]);
                }
            }
            partContents = true;
        }
        String v = this.cut();
        this.skipWhitespaces();
        if (!this.isEmpty() || !partContents) {
            throw this.metaErr("ERROR_InvalidVersion", new Object[0]);
        }
        return v;
    }

    private String readExtendedName() {
        this.skipWhitespaces();
        while (!this.isEmpty()) {
            char c = this.ch();
            if (HeaderParser.isExtended(c)) {
                this.advance();
                continue;
            }
            if (Character.isWhitespace(c) || c == ':' || c == '=' || c == ';') break;
            throw this.metaEx("ERROR_InvalidParameterName", new Object[0]);
        }
        return this.returnCut();
    }

    private void parseParameters() {
        while (!this.isEmpty()) {
            boolean dcolon;
            String paramOrDirectiveName = this.readExtendedName();
            if (paramOrDirectiveName.isEmpty()) {
                throw this.metaEx("ERROR_InvalidParameterName", new Object[0]);
            }
            this.directiveOrParameterName = paramOrDirectiveName;
            char c = this.ch();
            boolean bl = dcolon = c == ':';
            if (dcolon) {
                this.advance();
            }
            if ((c = this.next()) != '=') {
                throw this.metaEx("ERROR_InvalidParameterSyntax", paramOrDirectiveName);
            }
            (dcolon ? this.directives : this.parameters).put(paramOrDirectiveName, this.parseArgument());
        }
    }

    private void replaceInputText(String text) {
        this.header = text;
        this.pos = 0;
    }

    private MetadataException metaErr(String key, Object ... args) throws MetadataException {
        throw this.metaEx(key, args);
    }

    private MetadataException filterError() throws MetadataException {
        throw this.metaErr("ERROR_InvalidFilterSpecification", new Object[0]);
    }

    private void parseFilterConjunction() {
        this.skipWhitespaces();
        char c = this.next();
        while (c == '(') {
            this.parseFilterContent();
            c = this.next();
        }
        if (c != ')') {
            throw this.filterError();
        }
    }

    private void parseFilterClause() {
        this.skipWhitespaces();
        int lastPos = -1;
        block8: while (!this.isEmpty()) {
            char c = this.ch();
            if (Character.isWhitespace(c)) {
                if (lastPos != -1) continue;
                lastPos = this.pos;
                continue;
            }
            switch (c) {
                case '(': 
                case ')': 
                case '<': 
                case '=': 
                case '>': 
                case '~': {
                    break block8;
                }
                default: {
                    lastPos = -1;
                    this.advance();
                    continue block8;
                }
            }
        }
        String attributeName = this.returnCut();
        char c = this.next();
        if (c != '=') {
            throw this.metaErr("ERROR_UnsupportedFilterOperation", new Object[0]);
        }
        c = this.ch();
        if (c == '*') {
            throw this.metaErr("ERROR_UnsupportedFilterOperation", new Object[0]);
        }
        this.markContent();
        while (!this.isEmpty()) {
            c = this.next();
            if (c == ')') {
                this.addFilterAttribute(attributeName, this.cut(1));
                this.skipWhitespaces();
                return;
            }
            switch (c) {
                case '\\': {
                    c = this.next();
                    if (c != '\u0000') break;
                    throw this.filterError();
                }
                case '*': {
                    throw this.metaErr("ERROR_UnsupportedFilterOperation", new Object[0]);
                }
                case '(': 
                case '<': 
                case '=': 
                case '>': 
                case '~': {
                    throw this.filterError();
                }
            }
        }
        throw this.filterError();
    }

    private void parseFilterContent() {
        this.skipWhitespaces();
        char o = this.ch();
        if (o == '&') {
            this.advance();
            this.parseFilterConjunction();
        } else if (HeaderParser.isExtended(o)) {
            this.parseFilterClause();
        } else {
            throw this.metaErr("ERROR_InvalidFilterSpecification", new Object[0]);
        }
    }

    private void parseFilterSpecification() {
        this.skipWhitespaces();
        if (this.isEmpty()) {
            throw this.filterError();
        }
        char c = this.next();
        if (c == '(') {
            this.parseFilterContent();
            this.skipWhitespaces();
            if (!this.isEmpty()) {
                throw this.metaErr("ERROR_InvalidFilterSpecification", new Object[0]);
            }
        } else {
            throw this.filterError();
        }
    }

    public Map<String, String> parseRequiredCapabilities() {
        String namespace = this.parseNamespace();
        char c = this.next();
        if (c != ';' && c != '\u0000') {
            throw this.metaErr("ERROR_InvalidFilterSpecification", new Object[0]);
        }
        if (!"org.graalvm".equals(namespace)) {
            throw new MetadataException("Bundle-RequireCapability", this.feedback.l10n("ERROR_UnknownCapability", new Object[0]));
        }
        this.parseParameters();
        if (!this.parameters.isEmpty()) {
            throw this.metaErr("ERROR_UnsupportedParameters", new Object[0]);
        }
        this.versionFilter = this.directives.remove(DIRECTIVE_FILTER);
        if (!this.directives.isEmpty()) {
            throw this.metaErr("ERROR_UnsupportedDirectives", new Object[0]);
        }
        if (this.versionFilter == null) {
            throw this.metaErr("ERROR_MissingVersionFilter", new Object[0]);
        }
        this.replaceInputText(this.versionFilter);
        this.parseFilterSpecification();
        return this.filterValue;
    }

    public Map<String, Object> parseProvidedCapabilities() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        String namespace = this.parseNamespace();
        char c = this.next();
        if (c != ';' && c != '\u0000') {
            throw this.metaErr("ERROR_InvalidCapabilitySyntax", new Object[0]);
        }
        if (!"org.graalvm".equals(namespace)) {
            throw new DependencyException(namespace, null, null, this.feedback.l10n("ERROR_UnknownCapability", new Object[0]));
        }
        while (!this.isEmpty()) {
            this.parseCapability();
        }
        return this.capabilities;
    }

    public StabilityLevel parseStability() {
        if (this.isEmpty()) {
            return StabilityLevel.Undefined;
        }
        return StabilityLevel.valueOfMixedCase(this.getContents(""));
    }

    public Set<String> parseDependencies() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        while (!this.isEmpty()) {
            String sn = this.parseSymbolicName();
            this.dependencies.add(sn);
            this.skipWhitespaces();
            if (this.isEmpty()) break;
            char c = this.next();
            switch (c) {
                case ',': {
                    break;
                }
                case ';': {
                    throw this.metaEx("ERROR_DependencyParametersNotSupported", new Object[0]);
                }
            }
        }
        return this.dependencies;
    }

    private void parseCapability() {
        Object o;
        String capName = this.readExtendedName();
        if (capName.isEmpty()) {
            throw this.metaEx("ERROR_InvalidCapabilityName", new Object[0]);
        }
        this.directiveOrParameterName = capName;
        char c = this.next();
        boolean dcolon = c == ':';
        boolean makeVersion = false;
        if (dcolon) {
            block22: {
                if (this.ch() == '=') {
                    throw this.metaEx("ERROR_InvalidCapabilitySyntax", capName);
                }
                this.skipWhitespaces();
                do {
                    if (this.isEmpty()) {
                        throw this.metaEx("ERROR_InvalidCapabilitySyntax", capName);
                    }
                    c = this.next();
                    if (!Character.isWhitespace(c) && c != '=' && c != ';') continue;
                    if (this.isEmpty()) {
                        throw this.metaEx("ERROR_InvalidCapabilitySyntax", capName);
                    }
                    break block22;
                } while (HeaderParser.isAlphaNum(c));
                throw this.metaEx("ERROR_InvalidCapabilitySyntax", capName);
            }
            String type = this.cut(1);
            switch (type.toLowerCase(Locale.ENGLISH)) {
                case "version": {
                    makeVersion = true;
                    break;
                }
                case "string": {
                    break;
                }
                default: {
                    throw this.metaEx("ERROR_UnsupportedCapabilityType", capName, type);
                }
            }
            this.skipWhitespaces();
        }
        if (c != '=') {
            throw this.metaEx("ERROR_InvalidCapabilitySyntax", capName);
        }
        String s = this.parseArgument();
        if (makeVersion) {
            try {
                o = Version.fromString(s);
            }
            catch (IllegalArgumentException ex) {
                throw this.metaEx("ERROR_InvalidCapabilityVersion", capName, s);
            }
        } else {
            o = s;
        }
        this.capabilities.put(capName, o);
    }
}

