/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.persist.DirectoryCatalogProvider;

public class DirectoryChannelFactory
implements SoftwareChannel.Factory {
    @Override
    public SoftwareChannel createChannel(SoftwareChannelSource source, CommandInput input, Feedback output) {
        String u = source.getLocationURL();
        if (!u.startsWith("file:")) {
            return null;
        }
        Feedback out2 = output.withBundle(DirectoryChannelFactory.class);
        try {
            Path p = new File(new URI(u)).toPath();
            if (!Files.isDirectory(p, new LinkOption[0])) {
                return null;
            }
            DirectoryCatalogProvider dp = new DirectoryCatalogProvider(p, out2);
            dp.setVerifyJars(input.optValue("s") == null);
            if (Boolean.FALSE.toString().equals(source.getParameter("reportErrors"))) {
                dp.setReportErrors(false);
            }
            return dp;
        }
        catch (URISyntaxException ex) {
            out2.error("ERR_DirectoryURLInvalid", ex, u, ex.getMessage());
            return null;
        }
    }

    @Override
    public void init(CommandInput input, Feedback output) {
    }
}

