/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.util.Locale;
import org.graalvm.component.installer.Feedback;

public enum StabilityLevel {
    Undefined("undefined"),
    Supported("supported"),
    EarlyAdopter("earlyadopter"),
    Experimental("experimental"),
    Experimental_Earlyadopter("experimental-earlyadopter");

    private final String val;

    private StabilityLevel(String aVal) {
        this.val = aVal;
    }

    public String displayName(Feedback fb) {
        return fb.withBundle(StabilityLevel.class).l10n("ComponentStabilityLevel_" + this.name().toLowerCase(), new Object[0]);
    }

    public String toString() {
        if (this == Undefined) {
            return "";
        }
        return this.val;
    }

    public static StabilityLevel valueOfMixedCase(String mcs) {
        if (mcs.isEmpty()) {
            return Undefined;
        }
        String s = mcs.replaceAll("[^\\p{Alnum}]", "_").toLowerCase(Locale.ENGLISH);
        for (StabilityLevel l : StabilityLevel.values()) {
            if (!l.name().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(s)) continue;
            return l;
        }
        return Undefined;
    }

    public static StabilityLevel fromName(String name) {
        for (StabilityLevel level : StabilityLevel.values()) {
            if (!level.val.equals(name)) continue;
            return level;
        }
        return Undefined;
    }
}

