/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.gds.rest.GDSChannel;

public class GDSChannelFactory
implements SoftwareChannel.Factory {
    private static final String PROTOCOL_GDS_REST_PREFIX = "rest:";
    private static final String PROTOCOL_HTTTPS_PREFIX = "https:";
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private Feedback feedback;

    @Override
    public SoftwareChannel createChannel(SoftwareChannelSource source, CommandInput input, Feedback output) {
        URL u;
        this.feedback = output;
        String urlString = source.getLocationURL();
        if (!urlString.startsWith(PROTOCOL_GDS_REST_PREFIX)) {
            return null;
        }
        String rest = urlString.substring(PROTOCOL_GDS_REST_PREFIX.length());
        try {
            u = rest.startsWith("http") || rest.startsWith("file:") || rest.startsWith("test:") ? SystemUtils.toURL(rest) : SystemUtils.toURL(PROTOCOL_HTTTPS_PREFIX + rest);
        }
        catch (MalformedURLException ex) {
            throw output.failure("YUM_InvalidLocation", ex, urlString, ex.getLocalizedMessage());
        }
        GDSChannel ch = new GDSChannel(input, output, input.getLocalRegistry());
        ch.setIndexURL(u);
        ch.setEdition(source.getParameter("edition"));
        return ch;
    }

    @Override
    public Map<String, String> globalOptions() {
        return OPTIONS;
    }

    @Override
    public String globalOptionsHelp() {
        return this.feedback.l10n("GDS_REST_ExtraOptionsHelp", new Object[0]);
    }

    @Override
    public void init(CommandInput input, Feedback output) {
        this.feedback = output.withBundle(this.getClass());
    }

    static {
        OPTIONS.put(";", "s");
        OPTIONS.put("config", ";");
        OPTIONS.put("}", "");
        OPTIONS.put("show-ee-token", "}");
        OPTIONS.put("{", "s");
        OPTIONS.put("revoke-token", "{");
        OPTIONS.put("1", "s");
        OPTIONS.put("revoke-all-tokens", "1");
        OPTIONS.put("~", "");
        OPTIONS.put("revoke-current-token", "~");
    }
}

