/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds.rest;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONException;
import com.oracle.truffle.tools.utils.json.JSONObject;
import com.oracle.truffle.tools.utils.json.JSONTokener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.gds.GraalChannelBase;
import org.graalvm.component.installer.gds.MailStorage;
import org.graalvm.component.installer.gds.rest.ArtifactParser;
import org.graalvm.component.installer.gds.rest.GDSCatalogStorage;
import org.graalvm.component.installer.gds.rest.GDSRESTConnector;
import org.graalvm.component.installer.gds.rest.GDSTokenStorage;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.persist.MetadataLoaderAdapter;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.ProxyConnectionFactory;

public class GDSChannel
extends GraalChannelBase {
    private static final Logger LOG = Logger.getLogger(GDSChannel.class.getName());
    private static final String HEADER_DOWNLOAD_CONFIG = "x-download-token";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String JSON_ITEMS = "items";
    private static final String JSON_EXC_CODE = "code";
    private static final String EXC_URL_END = "/content";
    private static final String EXC_CODE_UNVERIFIED_CONFIG = "UnverifiedToken";
    private static final String EXC_CODE_INVALID_CONFIG = "InvalidToken";
    private static final String EXC_CODE_UNACCEPTED = "InvalidLicenseAcceptance";
    private GDSTokenStorage tokenStorage;
    private GDSRESTConnector gdsConnector;

    public GDSChannel(CommandInput aInput, Feedback aFeedback, ComponentRegistry aRegistry) {
        super(aInput, aFeedback.withBundle(GDSChannel.class), aRegistry);
    }

    void setTokenStorage(GDSTokenStorage s) {
        this.tokenStorage = s;
    }

    private String getToken() {
        if (this.tokenStorage == null) {
            this.tokenStorage = new GDSTokenStorage(this.fb, this.input);
        }
        return this.tokenStorage.getToken();
    }

    protected boolean needToken(ComponentInfo info) {
        return !info.isImplicitlyAccepted();
    }

    @Override
    public FileDownloader configureDownloader(ComponentInfo info, FileDownloader dn) {
        if (this.needToken(info)) {
            String token = this.getToken();
            if (!SystemUtils.nonBlankString(token)) {
                token = this.getToken(info.getLicensePath());
            }
            dn.addRequestHeader(HEADER_DOWNLOAD_CONFIG, token);
        }
        this.getConnector().fillBasics(dn);
        dn.setDownloadExceptionInterceptor(this::interceptDownloadException);
        return dn;
    }

    public IOException interceptDownloadException(IOException downloadException, FileDownloader fileDownloader) {
        String code;
        if (!(downloadException instanceof ProxyConnectionFactory.HttpConnectionException)) {
            return downloadException;
        }
        ProxyConnectionFactory.HttpConnectionException hex = (ProxyConnectionFactory.HttpConnectionException)downloadException;
        if (hex.getRetCode() < 400) {
            return (IOException)hex.getCause();
        }
        String downloadURL = hex.getConnectionUrl().toString();
        if (!downloadURL.endsWith(EXC_URL_END)) {
            return (IOException)hex.getCause();
        }
        String licensePath = this.findLicensePath(downloadURL);
        if (!SystemUtils.nonBlankString(licensePath)) {
            return (IOException)hex.getCause();
        }
        try {
            code = new JSONObject(hex.getResponse()).getString(JSON_EXC_CODE);
        }
        catch (JSONException ex) {
            return (IOException)hex.getCause();
        }
        String token = this.getToken();
        switch (code) {
            case "InvalidToken": {
                this.fb.output("ERR_WrongToken", token);
                if (this.tokenStorage.getConfSource().equals((Object)GDSTokenStorage.Source.FIL)) {
                    this.setToken("");
                }
                token = this.getToken(licensePath);
                break;
            }
            case "UnverifiedToken": {
                this.fb.output("ERR_InvalidToken", token);
                this.fb.acceptLine(false);
                break;
            }
            case "InvalidLicenseAcceptance": {
                if (fileDownloader.getAttemptNr() == 1) {
                    this.getConnector().sendVerificationEmail(null, licensePath, token);
                }
                this.fb.output("PROMPT_VerifyEmailAddressEntry", this.fb.l10n("MSG_YourEmail", new Object[0]));
                this.fb.acceptLine(false);
                break;
            }
            default: {
                return (IOException)hex.getCause();
            }
        }
        fileDownloader.addRequestHeader(HEADER_DOWNLOAD_CONFIG, token);
        return null;
    }

    private String findLicensePath(String artifactURL) {
        try {
            for (String id : this.storage.listComponentIDs()) {
                for (ComponentInfo info : this.storage.loadComponentMetadata(id)) {
                    if (!info.getRemoteURL().toString().equals(artifactURL)) continue;
                    return info.getLicensePath();
                }
            }
        }
        catch (IOException ex) {
            throw this.fb.withBundle(ComponentInstaller.class).failure("REGISTRY_ReadingComponentList", ex, ex.getLocalizedMessage());
        }
        return null;
    }

    private String getToken(String licensePath) {
        this.fb.output("MSG_InputTokenEntry", new Object[0]);
        this.fb.outputPart("PROMPT_InputTokenEntry", new Object[0]);
        String token = this.fb.acceptLine(false);
        if (!SystemUtils.nonBlankString(token)) {
            String email = MailStorage.checkEmailAddress(this.receiveEmailAddress(), this.fb);
            token = this.getConnector().sendVerificationEmail(email, licensePath, null);
            this.saveToken(token);
            this.fb.output("PROMPT_VerifyEmailAddressEntry", email);
            this.fb.acceptLine(false);
        } else {
            this.saveToken(token);
        }
        return token;
    }

    private void saveToken(String token) {
        this.fb.output("MSG_ObtainedToken", token);
        this.setToken(token);
    }

    private void setToken(String token) {
        try {
            this.tokenStorage.setToken(token);
            this.tokenStorage.save();
        }
        catch (IOException ex) {
            this.fb.error("WARN_CannotSaveToken", ex, this.tokenStorage.getPropertiesPath());
        }
    }

    @Override
    public MetadataLoader interceptMetadataLoader(ComponentInfo info, MetadataLoader delegate) {
        return new MetadataLoaderAdapter(delegate){

            @Override
            public String getLicenseType() {
                return null;
            }

            @Override
            public String getLicenseID() {
                return null;
            }
        };
    }

    String receiveEmailAddress() {
        String mail = this.input.optValue("^");
        if (mail == null) {
            this.fb.output("MSG_EmailAddressEntry", new Object[0]);
            this.fb.outputPart("PROMPT_EmailAddressEntry", new Object[0]);
            mail = this.fb.acceptLine(false);
        }
        if (mail == null) {
            throw this.fb.failure("ERR_EmailAddressMissing", null, new Object[0]);
        }
        return mail;
    }

    @Override
    protected ComponentStorage loadStorage() throws IOException {
        FileDownloader fd = this.getConnector().obtainArtifacts(this.localRegistry.getJavaVersion());
        Path storagePath = fd.getLocalFile().toPath();
        List<ComponentInfo> artifacts = this.loadArtifacts(storagePath, fd.getResponseHeader().get(HEADER_CONTENT_ENCODING));
        if (artifacts.isEmpty()) {
            return this.throwEmptyStorage();
        }
        return new GDSCatalogStorage(this.localRegistry, this.fb, storagePath.toUri().toURL(), artifacts);
    }

    List<ComponentInfo> loadArtifacts(Path releasesIndexPath, List<String> contentEncoding) throws IOException {
        if (this.edition == null) {
            this.edition = this.localRegistry.getGraalCapabilities().get("edition");
        }
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        try (InputStreamReader urlReader = new InputStreamReader(contentEncoding != null && contentEncoding.contains("gzip") ? new GZIPInputStream(Files.newInputStream(releasesIndexPath, new OpenOption[0])) : Files.newInputStream(releasesIndexPath, new OpenOption[0]));){
            JSONTokener tokener = new JSONTokener((Reader)urlReader);
            JSONObject obj = new JSONObject(tokener);
            JSONArray releases = obj.getJSONArray(JSON_ITEMS);
            if (releases == null) {
                throw new IncompatibleException(this.fb.l10n("OLDS_InvalidReleasesFile", new Object[0]));
            }
            Version v = this.localRegistry.getGraalVersion();
            for (Object k : releases) {
                ArtifactParser e;
                JSONObject jo = (JSONObject)k;
                try {
                    e = new ArtifactParser(jo);
                }
                catch (JSONException | IllegalArgumentException ex) {
                    this.fb.error("OLDS_ErrorReadingRelease", ex, k, ex.getLocalizedMessage());
                    continue;
                }
                if (!this.localRegistry.getGraalCapabilities().get("os_name").equals(e.getOs())) {
                    LOG.log(Level.FINER, "Incorrect OS: {0}", k);
                    continue;
                }
                if (!this.localRegistry.getGraalCapabilities().get("os_arch").equals(e.getArch())) {
                    LOG.log(Level.FINER, "Incorrect Arch: {0}", k);
                    continue;
                }
                if (!this.localRegistry.getJavaVersion().equals(e.getJava())) {
                    LOG.log(Level.FINER, "Incorrect Java: {0}", k);
                    continue;
                }
                if (this.edition != null && !this.edition.equals(e.getEdition())) {
                    LOG.log(Level.FINER, "Incorrect edition: {0}", k);
                    continue;
                }
                if (!this.acceptsVersion(v, Version.fromString(e.getVersion()))) {
                    LOG.log(Level.FINER, "Old version: {0} != {1}", new Object[]{v, Version.fromString(e.getVersion()), e.getVersion()});
                    continue;
                }
                if (e.getLabel() == null) {
                    LOG.log(Level.FINER, "Isn't installable component: {0}", new Object[]{e});
                    continue;
                }
                result.add(e.asComponentInfo(this.getConnector(), this.fb));
            }
        }
        return result;
    }

    GDSRESTConnector getConnector() {
        if (this.gdsConnector == null) {
            this.gdsConnector = new GDSRESTConnector(this.getIndexURL().toString(), this.fb, this.input.getLocalRegistry().getGraalCapabilities().get("gds_product_id"), this.input.getLocalRegistry().getGraalVersion());
        }
        return this.gdsConnector;
    }
}

