/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.gds.rest;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.gds.rest.GDSRESTConnector;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.StabilityLevel;
import org.graalvm.component.installer.persist.HeaderParser;

class ArtifactParser {
    private static final String JSON_META = "metadata";
    private static final String JSON_META_KEY = "key";
    private static final String JSON_META_VAL = "value";
    private static final String JSON_ID = "id";
    private static final String JSON_NAME = "displayName";
    private static final String JSON_LICENSE = "licenseId";
    private static final String JSON_LICENSE_LABEL = "licenseName";
    private static final String JSON_LICENSE_IMPLICITLY_ACCEPTED = "isLicenseImplicitlyAccepted";
    private static final String JSON_HASH = "checksum";
    private static final String META_VERSION = "version";
    private static final String META_EDITION = "edition";
    private static final String META_JAVA = "java";
    private static final String META_ARCH = "arch";
    private static final String META_OS = "os";
    private static final String META_STABILITY_LEVEL = "stabilityLevel";
    private static final String META_STABILITY = "stability";
    private static final String META_SYMBOLIC_NAME = "symbolicName";
    private static final String META_DEPENDENCY = "requireBundle";
    private static final String META_REQUIRED = "requiredCapabilities";
    private static final String META_PROVIDED = "providedCapabilities";
    private static final String META_WORK_DIR = "workingDirectories";
    private final JSONObject json;

    ArtifactParser(JSONObject json) {
        if (json == null) {
            throw new IllegalArgumentException("Parsed Artifact JSON cannot be null.");
        }
        this.json = json;
        this.checkContent();
    }

    private void checkContent() {
        this.getId();
        this.getChecksum();
        this.getMetadata();
        this.abreviatedDisplayName();
        this.getLicenseId();
        this.getLicenseName();
    }

    public String getVersion() {
        return this.getMetadata(META_VERSION);
    }

    public String getJava() {
        String java = this.getMetadata(META_JAVA, () -> Integer.toString(SystemUtils.getJavaMajorVersion()));
        if (java.startsWith("jdk")) {
            java = java.substring(3);
        }
        return java;
    }

    public String getArch() {
        return this.getMetadata(META_ARCH, () -> SystemUtils.ARCH.get().getName());
    }

    public String getOs() {
        return this.getMetadata(META_OS, () -> SystemUtils.OS.get().getName());
    }

    public String getEdition() {
        return this.getMetadata(META_EDITION);
    }

    private JSONArray getMetadata() {
        return this.json.getJSONArray(JSON_META);
    }

    private String getId() {
        return this.json.getString(JSON_ID);
    }

    public String getLabel() {
        return this.getMetadata(META_SYMBOLIC_NAME);
    }

    private String getDisplayName() {
        return this.json.getString(JSON_NAME);
    }

    private String getLicenseId() {
        return this.json.getString(JSON_LICENSE);
    }

    private String getChecksum() {
        return this.json.getString(JSON_HASH);
    }

    private String getLicenseName() {
        return this.json.getString(JSON_LICENSE_LABEL);
    }

    private boolean getIsImplicitlyAccepted() {
        boolean out = false;
        if (this.json.has(JSON_LICENSE_IMPLICITLY_ACCEPTED)) {
            out = this.json.getBoolean(JSON_LICENSE_IMPLICITLY_ACCEPTED);
        }
        return out;
    }

    private String getStability() {
        return this.getMetadata(META_STABILITY_LEVEL, () -> this.getMetadata(META_STABILITY));
    }

    private String getRequiredDependency() {
        return this.getMetadata(META_DEPENDENCY);
    }

    private String getRequiredCapabilities() {
        return this.getMetadata(META_REQUIRED);
    }

    private String getProvidedCapabilities() {
        return this.getMetadata(META_PROVIDED);
    }

    private String getWorkingDir() {
        return this.getMetadata(META_WORK_DIR);
    }

    public ComponentInfo asComponentInfo(GDSRESTConnector connector, Feedback fb) {
        return this.fillInComponent(new ComponentInfo(this.getLabel(), this.abreviatedDisplayName(), this.getVersion(), this.getChecksum()), connector, fb);
    }

    private ComponentInfo fillInComponent(ComponentInfo info, GDSRESTConnector connector, Feedback fb) {
        info.addRequiredValues(this.translateRequiredValues(fb));
        info.addProvidedValues(this.translateProvidedValues(fb));
        info.setDependencies(this.translateDependency(fb));
        info.setStability(this.translateStability());
        info.addWorkingDirectories(this.translateWorkingDirs());
        info.setLicenseType(this.getLicenseName());
        info.setLicensePath(connector.makeLicenseURL(this.getLicenseId()));
        info.setOrigin(connector.makeArtifactsURL(this.getJava()));
        info.setRemoteURL(connector.makeArtifactDownloadURL(this.getId()));
        info.setShaDigest(SystemUtils.toHashBytes(this.getChecksum()));
        info.setImplicitlyAccepted(this.getIsImplicitlyAccepted());
        return info;
    }

    private Map<String, String> translateRequiredValues(Feedback fb) {
        String req = this.getRequiredCapabilities();
        if (req == null) {
            return Collections.emptyMap();
        }
        return new HeaderParser("GDS Required capabilities.", req, fb).parseRequiredCapabilities();
    }

    private String abreviatedDisplayName() {
        String dispName = this.getDisplayName();
        String osName = this.getOs();
        if (SystemUtils.OS.fromName(osName) == SystemUtils.OS.MAC) {
            osName = dispName.contains("mac") ? "mac" : "darwin";
        }
        return dispName.substring(0, dispName.indexOf(osName)).trim();
    }

    private Map<String, Object> translateProvidedValues(Feedback fb) {
        String prov = this.getProvidedCapabilities();
        if (prov == null || prov.isBlank()) {
            return Collections.emptyMap();
        }
        return new HeaderParser("GDS Provided capabilities.", prov, fb).parseProvidedCapabilities();
    }

    private Collection<String> translateWorkingDirs() {
        String dir = this.getWorkingDir();
        if (dir == null || dir.isBlank()) {
            return Collections.emptyList();
        }
        return Collections.singleton(dir);
    }

    private StabilityLevel translateStability() {
        return StabilityLevel.fromName(this.getStability());
    }

    private Set<String> translateDependency(Feedback fb) {
        String dep = this.getRequiredDependency();
        if (dep == null || dep.isBlank()) {
            return Collections.emptySet();
        }
        return new HeaderParser("GDS Dependencies.", dep, fb).parseDependencies();
    }

    private String getMetadata(String key) {
        return this.getMetadata(key, () -> null);
    }

    private String getMetadata(String key, Supplier<String> defValue) {
        for (Object o : this.getMetadata()) {
            JSONObject mo = (JSONObject)o;
            if (!key.equals(mo.getString(JSON_META_KEY))) continue;
            return mo.getString(JSON_META_VAL);
        }
        return defValue.get();
    }

    public String toString() {
        return this.json.toString();
    }
}

