/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.ComponentInstaller;
import org.graalvm.component.installer.ComponentIterable;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.UnknownVersionException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.GraalVMInstaller;
import org.graalvm.component.installer.commands.InstallCommand;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.DistributionType;
import org.graalvm.component.installer.persist.DirectoryStorage;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.remote.CatalogIterable;

public class UpgradeProcess
implements AutoCloseable {
    private final CommandInput input;
    private final Feedback feedback;
    private final ComponentCollection catalog;
    private final Set<String> existingComponents = new HashSet<String>();
    private final Set<ComponentParam> addComponents = new HashSet<ComponentParam>();
    private final Set<ComponentInfo> migrated = new HashSet<ComponentInfo>();
    private final Set<String> explicitIds = new HashSet<String>();
    private ComponentInfo targetInfo;
    private Path newInstallPath;
    private Path newGraalHomePath;
    private MetadataLoader metaLoader;
    private boolean allowMissing;
    private ComponentRegistry newGraalRegistry;
    private Version minVersion = Version.NO_VERSION;
    private String editionUpgrade;
    private Set<String> acceptedLicenseIDs = new HashSet<String>();
    private ComponentParam graalCoreParam;
    private GraalVMInstaller coreInstaller;

    public UpgradeProcess(CommandInput input, Feedback feedback, ComponentCollection catalog) {
        this.input = input;
        this.feedback = feedback.withBundle(UpgradeProcess.class);
        this.catalog = catalog;
        this.resetExistingComponents();
    }

    final void resetExistingComponents() {
        this.existingComponents.clear();
        this.existingComponents.addAll(this.input.getLocalRegistry().getComponentIDs().stream().filter(id -> {
            ComponentInfo info = this.input.getLocalRegistry().findComponent((String)id);
            return info != null && this.input.getLocalRegistry().findDependentComponents(info, false).isEmpty();
        }).collect(Collectors.toList()));
        this.existingComponents.remove("org.graalvm");
    }

    public String getEditionUpgrade() {
        return this.editionUpgrade;
    }

    public void setEditionUpgrade(String editionUpgrade) {
        this.editionUpgrade = editionUpgrade;
    }

    public void addComponent(ComponentParam info) throws IOException {
        this.addComponents.add(info);
        this.explicitIds.add(info.createMetaLoader().getComponentInfo().getId().toLowerCase(Locale.ENGLISH));
    }

    public Set<ComponentParam> addedComponents() {
        return this.addComponents;
    }

    public boolean isAllowMissing() {
        return this.allowMissing;
    }

    public void setAllowMissing(boolean allowMissing) {
        this.allowMissing = allowMissing;
    }

    Path getNewInstallPath() {
        return this.newInstallPath;
    }

    public List<ComponentParam> allComponents() throws IOException {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<ComponentParam> allComps = new ArrayList<ComponentParam>(this.addedComponents());
        for (ComponentParam p : allComps) {
            ids.add(p.createMetaLoader().getComponentInfo().getId());
        }
        for (ComponentInfo mig : this.migrated) {
            if (ids.contains(mig.getId())) continue;
            allComps.add(this.input.existingFiles().createParam(mig.getId(), mig));
        }
        return allComps;
    }

    public ComponentRegistry getNewGraalRegistry() {
        return this.newGraalRegistry;
    }

    Path findGraalVMParentPath() {
        Path parent;
        Path skipped;
        Path vmRoot = this.input.getGraalHomePath().normalize();
        if (vmRoot.getNameCount() == 0) {
            return null;
        }
        Path skipPath = SystemUtils.getGraalVMJDKRoot(this.input.getLocalRegistry());
        for (skipped = vmRoot; skipPath != null && skipped != null && skipPath.getNameCount() > 0 && Objects.equals(skipPath.getFileName(), skipped.getFileName()); skipPath = skipPath.getParent(), skipped = skipped.getParent()) {
        }
        if (skipPath == null || skipPath.getNameCount() == 0) {
            vmRoot = skipped;
        }
        if ((parent = vmRoot.getParent()) != null && !Files.isWritable(parent)) {
            throw this.feedback.failure("UPGRADE_DirectoryNotWritable", null, parent);
        }
        return parent;
    }

    Path createInstallName(ComponentInfo graal) {
        String ed;
        String targetDir = this.input.optValue("d");
        Path base = targetDir != null ? SystemUtils.fromUserString(targetDir) : this.findGraalVMParentPath();
        String jv = graal.getProvidedValue("java_version", String.class);
        if (jv == null) {
            jv = graal.getRequiredGraalValues().get("java_version");
        }
        if (jv == null) {
            jv = this.input.getLocalRegistry().getGraalCapabilities().get("java_version");
        }
        if ((ed = graal.getProvidedValue("edition", String.class)) == null) {
            ed = this.editionUpgrade != null ? this.editionUpgrade : this.input.getLocalRegistry().getGraalCapabilities().get("edition");
        }
        String dirName = this.feedback.l10n(ed == null ? "UPGRADE_GraalVMDirName@" : "UPGRADE_GraalVMDirNameEdition@", graal.getVersion().displayString(), ed, jv);
        return base.resolve(SystemUtils.fileName(dirName));
    }

    boolean prepareInstall(ComponentInfo info) throws IOException {
        Version min = this.input.getLocalRegistry().getGraalVersion();
        if (info == null) {
            this.feedback.message("UPGRADE_NoUpdateFound", min.displayString());
            return false;
        }
        int cmp = min.compareTo(info.getVersion());
        if (cmp > 0 || this.editionUpgrade == null && cmp == 0) {
            this.feedback.message("UPGRADE_NoUpdateLatestVersion", min.displayString());
            this.migrated.clear();
            return false;
        }
        Path reported = this.createInstallName(info);
        this.feedback.output("UPGRADE_PreparingInstall", info.getVersion().displayString(), reported);
        this.failIfDirectotyExistsNotEmpty(reported);
        ComponentParam coreParam = this.createGraalComponentParam(info);
        InstallCommand cmd = new InstallCommand();
        cmd.init(this.input, this.feedback);
        MetadataLoader ldr = coreParam.createMetaLoader();
        cmd.addLicenseToAccept(ldr);
        cmd.acceptLicenses();
        this.acceptedLicenseIDs = cmd.getProcessedLicenses();
        ComponentParam param = this.input.existingFiles().createParam("core", info);
        this.metaLoader = param.createFileLoader();
        ComponentInfo completeInfo = this.metaLoader.completeMetadata();
        this.newGraalHomePath = this.newInstallPath = this.createInstallName(completeInfo);
        this.failIfDirectotyExistsNotEmpty(this.newInstallPath);
        if (!reported.equals(this.newInstallPath)) {
            this.feedback.error("UPGRADE_WarningEditionDifferent", null, info.getVersion().displayString(), this.newInstallPath);
        }
        this.existingComponents.addAll(this.input.getLocalRegistry().getComponentIDs());
        this.existingComponents.remove("org.graalvm");
        return true;
    }

    void failIfDirectotyExistsNotEmpty(Path target) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(target, new LinkOption[0])) {
            throw this.feedback.failure("UPGRADE_TargetExistsNotDirectory", null, target);
        }
        Path ghome = target.resolve(SystemUtils.getGraalVMJDKRoot(this.input.getLocalRegistry()));
        Path relFile = ghome.resolve("release");
        if (Files.isReadable(relFile)) {
            Version targetVersion = null;
            try {
                ComponentRegistry reg = this.createRegistryFor(ghome);
                targetVersion = reg.getGraalVersion();
            }
            catch (FailedOperationException failedOperationException) {
                // empty catch block
            }
            if (targetVersion != null) {
                throw this.feedback.failure("UPGRADE_TargetExistsContainsGraalVM", null, target, targetVersion.displayString());
            }
        }
        if (Files.list(target).findFirst().isPresent()) {
            throw this.feedback.failure("UPGRADE_TargetExistsNotEmpty", null, target);
        }
    }

    GraalVMInstaller createGraalVMInstaller(ComponentInfo info) throws IOException {
        ComponentInfo completeInfo;
        ComponentParam p = this.createGraalComponentParam(info);
        MetadataLoader ldr = p.createFileLoader();
        ldr.loadPaths();
        if (p.isComplete()) {
            Archive a = ldr.getArchive();
            a.verifyIntegrity(this.input);
        }
        this.targetInfo = completeInfo = ldr.getComponentInfo();
        this.metaLoader = ldr;
        GraalVMInstaller gvmInstaller = new GraalVMInstaller(this.feedback, this.input.getFileOperations(), this.input.getLocalRegistry(), completeInfo, this.catalog, this.metaLoader.getArchive());
        boolean disableSymlink = this.input.hasOption("S") || this.input.hasOption("d");
        gvmInstaller.setDisableSymlinks(disableSymlink);
        gvmInstaller.setAllowFilesInComponentDir(true);
        gvmInstaller.setCurrentInstallPath(this.input.getGraalHomePath());
        gvmInstaller.setInstallPath(this.newInstallPath);
        gvmInstaller.setPermissions(ldr.loadPermissions());
        gvmInstaller.setSymlinks(ldr.loadSymlinks());
        this.newGraalHomePath = gvmInstaller.getInstalledPath();
        return gvmInstaller;
    }

    ComponentParam createGraalComponentParam(ComponentInfo info) {
        if (this.graalCoreParam == null) {
            this.graalCoreParam = this.input.existingFiles().createParam(info.getId(), info);
        }
        return this.graalCoreParam;
    }

    public boolean installGraalCore(ComponentInfo info) throws IOException {
        if (!this.prepareInstall(info)) {
            return false;
        }
        GraalVMInstaller gvmInstaller = this.createGraalVMInstaller(info);
        this.feedback.output("UPGRADE_InstallingCore", info.getVersion().displayString(), this.newInstallPath.toString());
        gvmInstaller.install();
        this.coreInstaller = gvmInstaller;
        Path installed = gvmInstaller.getInstalledPath();
        this.newGraalRegistry = this.createRegistryFor(installed);
        this.migrateLicenses();
        return true;
    }

    private ComponentRegistry createRegistryFor(Path home) {
        DirectoryStorage dst = new DirectoryStorage(this.feedback.withBundle(ComponentInstaller.class), home.resolve(SystemUtils.fromCommonRelative("lib/installer/components")), home);
        dst.setJavaVersion(this.input.getLocalRegistry().getJavaVersion());
        return new ComponentRegistry(this.feedback, dst);
    }

    Collection<ComponentInfo> satisfiedAddedComponents(ComponentInfo candidate) throws IOException {
        ArrayList<ComponentInfo> broken = new ArrayList<ComponentInfo>();
        Version gv = candidate.getVersion();
        Version.Match satisfies = gv.match(Version.Match.Type.COMPATIBLE);
        for (ComponentParam param : this.addComponents) {
            ComponentInfo in = param.createMetaLoader().getComponentInfo();
            String vs = in.getRequiredGraalValues().get("graalvm_version");
            Version cv = Version.fromString(vs);
            if (satisfies.test(cv)) continue;
            broken.add(in);
            if (this.minVersion.compareTo(cv) >= 0) continue;
            this.minVersion = cv;
        }
        return broken;
    }

    Set<ComponentInfo> findInstallables(ComponentInfo graal) {
        Version gv = graal.getVersion();
        Version.Match satisfies = gv.match(Version.Match.Type.COMPATIBLE);
        HashSet<ComponentInfo> ret = new HashSet<ComponentInfo>();
        for (String id : this.existingComponents) {
            Collection<ComponentInfo> cis;
            if (this.explicitIds.contains(id) || (cis = this.catalog.loadComponents(id, satisfies, false)) == null || cis.isEmpty()) continue;
            ArrayList<ComponentInfo> versions = new ArrayList<ComponentInfo>(cis);
            ret.add((ComponentInfo)versions.get(versions.size() - 1));
        }
        return ret;
    }

    public ComponentInfo getTargetInfo() {
        return this.targetInfo;
    }

    private String lowerCaseId(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public ComponentInfo findGraalVersion(Version.Match minimum) throws IOException {
        Collection<ComponentInfo> graals;
        Version.Match filter = minimum.getType() == Version.Match.Type.MOSTRECENT ? minimum.getVersion().match(Version.Match.Type.INSTALLABLE) : minimum;
        try {
            graals = this.catalog.loadComponents("org.graalvm", filter, false);
            if (graals == null || graals.isEmpty()) {
                return null;
            }
        }
        catch (UnknownVersionException ex) {
            if (ex.getCandidate() == null) {
                throw this.feedback.failure("UPGRADE_NoSpecificVersion", ex, filter.getVersion().displayString());
            }
            throw this.feedback.failure("UPGRADE_NoSpecificVersion2", ex, filter.getVersion().displayString(), ex.getCandidate().displayString());
        }
        ArrayList<ComponentInfo> versions = new ArrayList<ComponentInfo>(graals);
        Collections.sort(versions, ComponentInfo.versionComparator().reversed());
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            ComponentInfo candidate = (ComponentInfo)it.next();
            Collection<ComponentInfo> broken = this.satisfiedAddedComponents(candidate);
            if (broken.isEmpty()) continue;
            it.remove();
        }
        if (versions.isEmpty()) {
            throw this.feedback.failure("UPGRADE_NoVersionSatisfiesComponents", null, this.minVersion.toString());
        }
        Set<ComponentInfo> installables = null;
        Set<ComponentInfo> first = null;
        ComponentInfo result = null;
        Set toMigrate = this.existingComponents.stream().filter(id -> {
            ComponentInfo ci = this.input.getLocalRegistry().loadSingleComponent((String)id, false);
            return ci.getDistributionType() != DistributionType.BUNDLED;
        }).map(this::lowerCaseId).collect(Collectors.toSet());
        toMigrate.removeAll(this.explicitIds);
        HashMap missingParts = new HashMap();
        for (ComponentInfo candidate : versions) {
            Set<ComponentInfo> instCandidates = this.findInstallables(candidate);
            if (first == null) {
                first = instCandidates;
            }
            Set canMigrate = instCandidates.stream().map(ComponentInfo::getId).map(this::lowerCaseId).collect(Collectors.toSet());
            if (this.allowMissing || canMigrate.containsAll(toMigrate)) {
                installables = instCandidates;
                result = candidate;
                break;
            }
            HashSet miss = new HashSet(toMigrate);
            miss.removeAll(canMigrate);
            missingParts.put(candidate, miss.stream().map(id -> this.input.getLocalRegistry().findComponent((String)id)).collect(Collectors.toSet()));
        }
        if (installables == null) {
            if (!this.allowMissing) {
                ArrayList reportVersions = new ArrayList(missingParts.keySet());
                for (ComponentInfo core : reportVersions) {
                    ArrayList list = new ArrayList((Collection)missingParts.get(core));
                    Collections.sort(list, (a, b) -> a.getId().compareToIgnoreCase(b.getId()));
                    String msg = null;
                    for (ComponentInfo ci : list) {
                        String shortId = this.input.getLocalRegistry().shortenComponentId(ci);
                        String s = this.feedback.l10n("UPGRADE_MissingComponentItem", shortId, ci.getName());
                        if (msg == null) {
                            msg = s;
                            continue;
                        }
                        msg = this.feedback.l10n("UPGRADE_MissingComponentListPart", msg, s);
                    }
                    this.feedback.error("UPGRADE_MissingComponents", null, core.getName(), core.getVersion().displayString(), msg);
                }
                if (this.editionUpgrade != null) {
                    throw this.feedback.failure("UPGRADE_ComponentsMissingFromEdition", null, this.editionUpgrade);
                }
                throw this.feedback.failure("UPGRADE_ComponentsCannotMigrate", null, new Object[0]);
            }
            if (versions.isEmpty()) {
                throw this.feedback.failure("UPGRADE_NoVersionSatisfiesComponents", null, new Object[0]);
            }
            result = (ComponentInfo)versions.get(0);
            installables = first;
        }
        this.migrated.clear();
        if (result != null && (!this.input.getLocalRegistry().getGraalVersion().equals(result.getVersion()) || this.input.hasOption("$"))) {
            this.migrated.addAll(installables);
            this.targetInfo = result;
        }
        return result;
    }

    public boolean didUpgrade() {
        return this.newGraalRegistry != null;
    }

    public void migrateLicenses() {
        if (!SystemUtils.isLicenseTrackingEnabled()) {
            return;
        }
        this.feedback.output("UPGRADE_MigratingLicenses", this.input.getLocalRegistry().getGraalVersion().displayString(), this.targetInfo.getVersion().displayString());
        for (Map.Entry<String, Collection<String>> e : this.input.getLocalRegistry().getAcceptedLicenses().entrySet()) {
            String licId = e.getKey();
            for (String compId : e.getValue()) {
                try {
                    String t = this.input.getLocalRegistry().licenseText(licId);
                    ComponentInfo info = this.input.getLocalRegistry().findComponent(compId);
                    Date d = this.input.getLocalRegistry().isLicenseAccepted(info, licId);
                    this.newGraalRegistry.acceptLicense(info, licId, t, d);
                }
                catch (FailedOperationException ex) {
                    this.feedback.error("UPGRADE_CannotMigrateLicense", ex, compId, licId);
                }
            }
        }
        Path gdsSettings = SystemUtils.resolveRelative(this.input.getGraalHomePath(), "lib/installer/components/gds");
        if (Files.isDirectory(gdsSettings, new LinkOption[0])) {
            Path targetGdsSettings = SystemUtils.resolveRelative(this.newInstallPath.resolve(SystemUtils.getGraalVMJDKRoot(this.newGraalRegistry)), "lib/installer/components/gds");
            try {
                SystemUtils.copySubtree(gdsSettings, targetGdsSettings);
            }
            catch (IOException ex) {
                this.feedback.error("UPGRADE_CannotMigrateGDS", ex, ex.getLocalizedMessage());
            }
        }
    }

    protected InstallCommand configureInstallCommand(InstallCommand instCommand) throws IOException {
        ArrayList<ComponentParam> params = new ArrayList<ComponentParam>();
        params.addAll(this.allComponents());
        if (params.isEmpty()) {
            return null;
        }
        instCommand.init(new InputDelegate(params), this.feedback);
        instCommand.setAllowUpgrades(true);
        instCommand.setForce(true);
        instCommand.markLicensesProcessed(this.acceptedLicenseIDs);
        return instCommand;
    }

    public void installAddedComponents() throws IOException {
        InstallCommand ic = this.configureInstallCommand(new InstallCommand());
        if (ic != null) {
            ic.execute();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.coreInstaller != null) {
            this.coreInstaller.createSymlink();
        }
        for (ComponentParam p : this.allComponents()) {
            p.close();
        }
        if (this.metaLoader != null) {
            this.metaLoader.close();
        }
    }

    class InputDelegate
    implements CommandInput {
        private final List<ComponentParam> params;
        private int index;
        private ComponentCatalog remoteRegistry;

        InputDelegate(List<ComponentParam> params) {
            this.params = params;
        }

        @Override
        public FileOperations getFileOperations() {
            return UpgradeProcess.this.input.getFileOperations();
        }

        @Override
        public CommandInput.CatalogFactory getCatalogFactory() {
            return UpgradeProcess.this.input.getCatalogFactory();
        }

        @Override
        public ComponentIterable existingFiles() throws FailedOperationException {
            return new ComponentIterable(){

                @Override
                public void setVerifyJars(boolean verify) {
                    UpgradeProcess.this.input.existingFiles().setVerifyJars(verify);
                }

                @Override
                public ComponentParam createParam(String cmdString, ComponentInfo info) {
                    return new CatalogIterable.CatalogItemParam(InputDelegate.this.getRegistry().getDownloadInterceptor(), info, info.getName(), cmdString, UpgradeProcess.this.feedback, UpgradeProcess.this.input.optValue("n") == null);
                }

                @Override
                public Iterator<ComponentParam> iterator() {
                    return new Iterator<ComponentParam>(){
                        boolean init;

                        @Override
                        public boolean hasNext() {
                            if (!this.init) {
                                this.init = true;
                                InputDelegate.this.index = 0;
                            }
                            return InputDelegate.this.index < InputDelegate.this.params.size();
                        }

                        @Override
                        public ComponentParam next() {
                            if (InputDelegate.this.index >= InputDelegate.this.params.size()) {
                                throw new NoSuchElementException();
                            }
                            return InputDelegate.this.params.get(InputDelegate.this.index++);
                        }
                    };
                }

                @Override
                public ComponentIterable matchVersion(Version.Match m) {
                    return this;
                }

                @Override
                public ComponentIterable allowIncompatible() {
                    return this;
                }
            };
        }

        @Override
        public String requiredParameter() throws FailedOperationException {
            if (this.index >= this.params.size()) {
                throw UpgradeProcess.this.feedback.failure("UPGRADE_MissingParameter", null, new Object[0]);
            }
            return this.nextParameter();
        }

        @Override
        public String nextParameter() {
            if (!this.hasParameter()) {
                return null;
            }
            return this.params.get(this.index++).getSpecification();
        }

        @Override
        public String peekParameter() {
            if (!this.hasParameter()) {
                return null;
            }
            return this.params.get(this.index).getSpecification();
        }

        @Override
        public boolean hasParameter() {
            return this.params.size() > this.index;
        }

        @Override
        public Path getGraalHomePath() {
            return UpgradeProcess.this.didUpgrade() ? UpgradeProcess.this.newGraalHomePath : UpgradeProcess.this.input.getGraalHomePath();
        }

        @Override
        public ComponentCatalog getRegistry() {
            if (this.remoteRegistry == null) {
                this.remoteRegistry = UpgradeProcess.this.input.getCatalogFactory().createComponentCatalog(this);
            }
            return this.remoteRegistry;
        }

        @Override
        public ComponentRegistry getLocalRegistry() {
            if (UpgradeProcess.this.newGraalRegistry != null) {
                return UpgradeProcess.this.newGraalRegistry;
            }
            return UpgradeProcess.this.input.getLocalRegistry();
        }

        @Override
        public String optValue(String option) {
            return UpgradeProcess.this.input.optValue(option);
        }

        @Override
        public String getParameter(String key, boolean cmdLine) {
            return UpgradeProcess.this.input.getParameter(key, cmdLine);
        }

        @Override
        public Map<String, String> parameters(boolean cmdLine) {
            return UpgradeProcess.this.input.parameters(cmdLine);
        }
    }
}

