/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.commands.PreRemoveProcess;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;

public class Uninstaller {
    private final Feedback feedback;
    private final ComponentInfo componentInfo;
    private final ComponentRegistry registry;
    private final FileOperations fileOps;
    private PreRemoveProcess preRemove;
    private Set<String> preservePaths = Collections.emptySet();
    private boolean dryRun;
    private boolean ignoreFailedDeletions;
    private Path installPath;
    private final Set<String> directoriesToDelete = new HashSet<String>();

    public Uninstaller(Feedback feedback, FileOperations fops, ComponentInfo componentInfo, ComponentRegistry registry) {
        this.feedback = feedback;
        this.componentInfo = componentInfo;
        this.registry = registry;
        this.fileOps = fops;
    }

    public void uninstall() throws IOException {
        this.uninstallContent();
        if (!this.isDryRun()) {
            this.registry.removeComponent(this.componentInfo);
        }
    }

    void uninstallContent() throws IOException {
        this.preRemove = new PreRemoveProcess(this.installPath, this.fileOps, this.feedback).setDryRun(this.isDryRun()).setIgnoreFailedDeletions(this.isIgnoreFailedDeletions());
        block2: for (String p : this.componentInfo.getPaths()) {
            if (this.preservePaths.contains(p)) {
                this.feedback.verboseOutput("INSTALL_SkippingSharedFile", p);
                continue;
            }
            Path toDelete = this.installPath.resolve(SystemUtils.fromCommonRelative(p));
            if (Files.isDirectory(toDelete, new LinkOption[0])) {
                for (String s : this.preservePaths) {
                    Path x = SystemUtils.fromCommonRelative(s);
                    if (!x.startsWith(p)) continue;
                    continue block2;
                }
                this.directoriesToDelete.add(p);
                continue;
            }
            this.feedback.verboseOutput("UNINSTALL_DeletingFile", p);
            if (this.dryRun) continue;
            this.preRemove.deleteOneFile(toDelete);
        }
        ArrayList<String> dirNames = new ArrayList<String>(this.directoriesToDelete);
        this.preRemove.processComponent(this.componentInfo);
        Collections.sort(dirNames);
        Collections.reverse(dirNames);
        for (String s : dirNames) {
            Path p = this.installPath.resolve(SystemUtils.fromCommonRelative(s));
            this.feedback.verboseOutput("UNINSTALL_DeletingDirectory", p);
            if (this.dryRun) continue;
            try {
                this.fileOps.deleteFile(p);
            }
            catch (IOException ex) {
                if (this.ignoreFailedDeletions) {
                    this.feedback.error("INSTALL_FailedToDeleteDirectory", ex, p, ex.getLocalizedMessage());
                    continue;
                }
                throw ex;
            }
        }
    }

    public boolean isIgnoreFailedDeletions() {
        return this.ignoreFailedDeletions;
    }

    public void setIgnoreFailedDeletions(boolean ignoreFailedDeletions) {
        this.ignoreFailedDeletions = ignoreFailedDeletions;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Path getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(Path installPath) {
        this.installPath = installPath;
    }

    public Set<String> getPreservePaths() {
        return this.preservePaths;
    }

    public void setPreservePaths(Set<String> preservePaths) {
        this.preservePaths = preservePaths;
    }

    public ComponentInfo getComponentInfo() {
        return this.componentInfo;
    }
}

