/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;

public class PreRemoveProcess {
    private final Path installPath;
    private final Feedback feedback;
    private final List<ComponentInfo> infos = new ArrayList<ComponentInfo>();
    private final FileOperations fileOps;
    private boolean dryRun;
    private boolean ignoreFailedDeletions;
    private Set<String> knownPaths;

    public PreRemoveProcess(Path instPath, FileOperations fops, Feedback fb) {
        this.feedback = fb.withBundle(PreRemoveProcess.class);
        this.installPath = instPath;
        this.fileOps = fops;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public PreRemoveProcess setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean isIgnoreFailedDeletions() {
        return this.ignoreFailedDeletions;
    }

    public PreRemoveProcess setIgnoreFailedDeletions(boolean ignoreFailedDeletions) {
        this.ignoreFailedDeletions = ignoreFailedDeletions;
        return this;
    }

    public void addComponentInfo(ComponentInfo info) {
        this.infos.add(info);
    }

    public void run() throws IOException {
        for (ComponentInfo ci : this.infos) {
            this.processComponent(ci);
        }
    }

    void deleteOneFile(Path p) throws IOException {
        try {
            this.fileOps.deleteFile(p);
        }
        catch (IOException ex) {
            if (this.ignoreFailedDeletions) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    this.feedback.error("INSTALL_FailedToDeleteDirectory", ex, p, ex.getLocalizedMessage());
                } else {
                    this.feedback.error("INSTALL_FailedToDeleteFile", ex, p, ex.getLocalizedMessage());
                }
                return;
            }
            throw ex;
        }
    }

    void deleteContentsRecursively(Path rootPath) throws IOException {
        if (this.dryRun) {
            return;
        }
        try (Stream<Path> paths = Files.walk(rootPath, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    if (!p.equals(rootPath) && this.shouldDeletePath((Path)p)) {
                        this.deleteOneFile((Path)p);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private boolean shouldDeletePath(Path toDelete) {
        Path rel;
        try {
            rel = this.installPath.relativize(toDelete);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        Object relString = SystemUtils.toCommonPath(rel);
        if (Files.isDirectory(toDelete, new LinkOption[0])) {
            relString = (String)relString + "/";
        }
        return this.knownPaths == null || !this.knownPaths.contains(relString);
    }

    void processComponent(ComponentInfo ci) throws IOException {
        for (String s : ci.getWorkingDirectories()) {
            Path p = this.installPath.resolve(SystemUtils.fromCommonRelative(s));
            this.feedback.verboseOutput("UNINSTALL_DeletingDirectoryRecursively", p);
            this.knownPaths = new HashSet<String>(ci.getPaths());
            this.deleteContentsRecursively(p);
        }
    }
}

