/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;

final class PostInstProcess {
    private final CommandInput input;
    private final Feedback feedback;
    private final List<ComponentInfo> infos = new ArrayList<ComponentInfo>();
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\$\\{([\\p{Alnum}_-]+)\\}");

    PostInstProcess(CommandInput cInput, Feedback fb) {
        this.input = cInput;
        this.feedback = fb;
    }

    public void addComponentInfo(ComponentInfo info) {
        this.infos.add(info);
    }

    String replaceTokens(ComponentInfo info, String message) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        Path graalPath = this.input.getGraalHomePath().normalize();
        Path archPath = SystemUtils.getRuntimeLibDir(graalPath, true);
        tokens.put("graalvm_home", graalPath.toString());
        tokens.put("graalvm_languages_dir", SystemUtils.getRuntimeBaseDir(graalPath).resolve("languages").toString());
        tokens.put("graalvm_rtlib_arch_dir", archPath.toString());
        tokens.put("graalvm_rtlib_dir", SystemUtils.getRuntimeLibDir(graalPath, false).toString());
        tokens.putAll(info.getRequiredGraalValues());
        tokens.putAll(this.input.getLocalRegistry().getGraalCapabilities());
        Matcher m = TOKEN_PATTERN.matcher(message);
        StringBuilder result = null;
        int start = 0;
        int last = 0;
        while (m.find(start)) {
            String token = m.group(1);
            String val = (String)tokens.get(token);
            if (val != null) {
                if (result == null) {
                    result = new StringBuilder(archPath.toString().length() * 2);
                }
                result.append(message.substring(last, m.start()));
                result.append(val);
                last = m.end();
            }
            start = m.end();
        }
        if (result == null) {
            return message;
        }
        result.append(message.substring(last));
        return result.toString();
    }

    void run() {
        for (ComponentInfo ci : this.infos) {
            this.printPostinst(ci);
        }
    }

    void printPostinst(ComponentInfo i) {
        String msg = i.getPostinstMessage();
        if (msg != null) {
            String replaced = this.replaceTokens(i, msg);
            this.feedback.verbatimOut(replaced, false);
            this.feedback.verbatimOut("", false);
        }
    }
}

