/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.commands.ListInstalledCommand;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.Verifier;

public class AvailableCommand
extends ListInstalledCommand {
    private Version.Match vmatch;
    private boolean showUpdates;
    private boolean showCore;
    private boolean defaultFilter = true;

    @Override
    public Map<String, String> supportedOptions() {
        HashMap<String, String> opts = new HashMap<String, String>(super.supportedOptions());
        opts.put("a", "");
        opts.put("all-versions", "a");
        opts.put("V", "s");
        opts.put("use-version", "V");
        opts.put("c", "X");
        opts.put("C", "s");
        opts.put("custom-catalog", "C");
        opts.put("$", "s");
        opts.put("edition", "$");
        opts.put("%", "");
        opts.put("show-core", "%");
        opts.put("&", "");
        opts.put("show-updates", "&");
        return opts;
    }

    @Override
    protected ComponentCollection initRegistry() {
        super.initRegistry();
        if (this.showUpdates) {
            this.input.getRegistry().setAllowDistUpdate(true);
        }
        return this.input.getRegistry();
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        String v = commandInput.optValue("V");
        if (v != null) {
            this.vmatch = Version.versionFilter(v);
        }
        this.showUpdates = commandInput.hasOption("&") || commandInput.hasOption("a");
        this.showCore = commandInput.hasOption("%") | this.showUpdates | commandInput.hasOption("$");
        super.init(commandInput, feedBack);
    }

    @Override
    public int execute() throws IOException {
        if (this.input.optValue("h") != null) {
            this.feedback.output("AVAILABLE_Help", new Object[0]);
            return 0;
        }
        return super.execute();
    }

    @Override
    protected List<ComponentInfo> filterDisplayedVersions(String id, Collection<ComponentInfo> infos) {
        if (this.input.optValue("a") != null) {
            return super.filterDisplayedVersions(id, infos);
        }
        HashSet<Version> seen = new HashSet<Version>();
        ArrayList<ComponentInfo> filtered = new ArrayList<ComponentInfo>();
        Verifier vrf = new Verifier(this.feedback, this.input.getLocalRegistry(), this.input.getRegistry());
        vrf.setCollectErrors(true);
        vrf.setSilent(true);
        vrf.ignoreExisting(true);
        if (this.showUpdates) {
            vrf.setVersionMatch(this.getRegistry().getGraalVersion().match(Version.Match.Type.INSTALLABLE));
        } else {
            vrf.setVersionMatch(this.getRegistry().getGraalVersion().match(Version.Match.Type.SATISFIES_COMPATIBLE));
        }
        if (this.defaultFilter) {
            ArrayList<ComponentInfo> sorted = new ArrayList<ComponentInfo>(infos);
            Collections.sort(sorted, ComponentInfo.versionComparator().reversed());
            for (ComponentInfo ci : sorted) {
                if (vrf.validateRequirements(ci).hasErrors() || "org.graalvm".equals(ci.getId()) && (!this.showCore || !vrf.getVersionMatch().test(ci.getVersion()))) continue;
                filtered.add(ci);
                break;
            }
        } else {
            for (ComponentInfo ci : infos) {
                if (!seen.add(ci.getVersion().installVersion())) continue;
                filtered.add(ci);
            }
        }
        return super.filterDisplayedVersions(id, filtered);
    }

    @Override
    protected String acceptExpression(String expr) {
        if (this.vmatch != null) {
            return super.acceptExpression(expr);
        }
        Version.Match vm = Version.versionFilter(expr);
        if (vm == null) {
            this.vmatch = this.getRegistry().getGraalVersion().match(Version.Match.Type.INSTALLABLE);
            this.defaultFilter = true;
            return expr;
        }
        this.defaultFilter = false;
        this.vmatch = vm;
        return null;
    }

    @Override
    protected Version.Match getVersionFilter() {
        return this.vmatch == null ? super.getVersionFilter() : this.vmatch;
    }
}

