/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.ce;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.model.RemoteInfoProcessor;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.RemotePropertiesStorage;

public class WebCatalog
implements SoftwareChannel {
    private final String urlString;
    private final SoftwareChannelSource source;
    private URL catalogURL;
    private Feedback feedback;
    private ComponentRegistry local;
    private ComponentStorage storage;
    private RuntimeException savedException;
    private RemoteInfoProcessor remoteProcessor = RemoteInfoProcessor.NONE;
    private Version.Match matchVersion;
    private boolean enableV1Versions;

    public WebCatalog(String u, SoftwareChannelSource source) {
        this.urlString = u;
        this.source = source;
    }

    public RemoteInfoProcessor getRemoteProcessor() {
        return this.remoteProcessor;
    }

    public void setRemoteProcessor(RemoteInfoProcessor remoteProcessor) {
        this.remoteProcessor = remoteProcessor;
    }

    public Version.Match getMatchVersion() {
        return this.matchVersion;
    }

    public boolean isEnableV1Versions() {
        return this.enableV1Versions;
    }

    public void setEnableV1Versions(boolean enableV1Versions) {
        this.enableV1Versions = enableV1Versions;
    }

    public void setMatchVersion(Version.Match aMatchVersion) {
        this.matchVersion = aMatchVersion;
    }

    protected static boolean acceptURLScheme(String scheme, String urlSpec) {
        switch (scheme) {
            case "http": 
            case "https": 
            case "ftp": 
            case "ftps": {
                return true;
            }
            case "file": {
                try {
                    Path p = new File(new URI(urlSpec)).toPath();
                    return Files.isRegularFile(p, new LinkOption[0]) && Files.isReadable(p);
                }
                catch (URISyntaxException ex) {
                    break;
                }
            }
        }
        return false;
    }

    public void init(CommandInput in, Feedback out) {
        this.init(in.getLocalRegistry(), out);
    }

    public void init(ComponentRegistry aLocal, Feedback out) {
        this.feedback = out.withBundle(WebCatalog.class);
        this.local = aLocal;
    }

    @Override
    public ComponentStorage getStorage() {
        Version normalizedVersion;
        String graalVersionString;
        FileDownloader dn;
        if (this.storage != null) {
            return this.storage;
        }
        Map<String, String> graalCaps = this.local.getGraalCapabilities();
        StringBuilder sb = new StringBuilder();
        sb.append(SystemUtils.patternOsName(graalCaps.get("os_name"), graalCaps.get("os_variant")).toLowerCase());
        sb.append("_");
        sb.append(SystemUtils.patternOsArch(graalCaps.get("os_arch").toLowerCase()));
        try {
            this.catalogURL = SystemUtils.toURL(this.urlString);
        }
        catch (MalformedURLException ex) {
            throw this.feedback.failure("REMOTE_InvalidURL", ex, this.catalogURL, ex.getLocalizedMessage());
        }
        Properties props = new Properties();
        RemotePropertiesStorage newStorage = this.createPropertiesStorage(this.feedback, this.local, props, sb.toString(), this.catalogURL);
        if (this.remoteProcessor != null) {
            newStorage.setRemoteProcessor(this.remoteProcessor);
        }
        Properties loadProps = new Properties();
        try {
            if (this.savedException != null) {
                throw this.savedException;
            }
            this.catalogURL = SystemUtils.toURL(this.urlString);
            String l = this.source.getLabel();
            dn = new FileDownloader(this.feedback.l10n(l == null || l.isEmpty() ? "REMOTE_CatalogLabel2" : "REMOTE_CatalogLabel", l), this.catalogURL, this.feedback);
            dn.download();
        }
        catch (ConnectException | NoRouteToHostException ex) {
            this.savedException = this.feedback.failure("REMOTE_ErrorDownloadCatalogProxy", ex, this.catalogURL, ex.getLocalizedMessage());
            throw this.savedException;
        }
        catch (FileNotFoundException ex) {
            this.feedback.error("REMOTE_WarningErrorDownloadCatalogNotFoundSkip", ex, this.catalogURL);
            this.storage = newStorage;
            return this.storage;
        }
        catch (IOException ex) {
            this.savedException = this.feedback.failure("REMOTE_ErrorDownloadCatalog", ex, this.catalogURL, ex.getLocalizedMessage());
            throw this.savedException;
        }
        this.storage = newStorage;
        StringBuilder oldGraalPref = new StringBuilder("^org.graalvm");
        oldGraalPref.append('.');
        if (this.matchVersion != null) {
            graalVersionString = this.matchVersion.getVersion().displayString();
            normalizedVersion = this.matchVersion.getVersion().installVersion();
        } else {
            graalVersionString = graalCaps.get("graalvm_version").toLowerCase();
            normalizedVersion = this.local.getGraalVersion().installVersion();
        }
        StringBuilder graalPref = new StringBuilder(oldGraalPref);
        oldGraalPref.append(Pattern.quote(graalVersionString));
        oldGraalPref.append('_').append((CharSequence)sb);
        graalPref.append((CharSequence)sb).append('/');
        graalPref.append("(?<ver>[^/]+)$");
        try (FileInputStream fis = new FileInputStream(dn.getLocalFile());){
            loadProps.load(fis);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw this.feedback.failure("REMOTE_CorruptedCatalogFile", ex, this.catalogURL);
        }
        Pattern oldPrefixPattern = Pattern.compile(oldGraalPref.toString(), 2);
        Pattern newPrefixPattern = Pattern.compile(graalPref.toString(), 2);
        Stream propNames = loadProps.stringPropertyNames().stream();
        boolean foundPrefix = propNames.anyMatch(p -> {
            if (oldPrefixPattern.matcher((CharSequence)p).matches()) {
                return true;
            }
            Matcher m = newPrefixPattern.matcher((CharSequence)p);
            if (!m.find() || m.start() > 0) {
                return false;
            }
            try {
                Version v = Version.fromString(m.group("ver"));
                return normalizedVersion.match(Version.Match.Type.INSTALLABLE).test(v);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        });
        if (!foundPrefix) {
            boolean graalPrefixFound = false;
            boolean componentFound = false;
            for (String s : loadProps.stringPropertyNames()) {
                if (s.startsWith("org.graalvm")) {
                    graalPrefixFound = true;
                }
                if (!s.startsWith("Component.")) continue;
                componentFound = true;
            }
            if (!componentFound) {
                this.feedback.verboseOutput("REMOTE_CatalogDoesNotContainComponents", this.catalogURL);
                return newStorage;
            }
            if (!graalPrefixFound) {
                throw this.feedback.failure("REMOTE_CorruptedCatalogFile", null, this.catalogURL);
            }
            throw new IncompatibleException(this.feedback.l10n("REMOTE_UnsupportedGraalVersion", graalCaps.get("graalvm_version"), graalCaps.get("os_name"), graalCaps.get("os_arch")), null);
        }
        props.putAll((Map<?, ?>)loadProps);
        return newStorage;
    }

    protected RemotePropertiesStorage createPropertiesStorage(Feedback aFeedback, ComponentRegistry aLocal, Properties props, String selector, URL baseURL) {
        return new RemotePropertiesStorage(aFeedback, aLocal, props, selector, null, baseURL);
    }

    @Override
    public FileDownloader configureDownloader(ComponentInfo cInfo, FileDownloader dn) {
        return dn;
    }

    public static class WebCatalogFactory
    implements SoftwareChannel.Factory {
        private CommandInput input;

        @Override
        public SoftwareChannel createChannel(SoftwareChannelSource src, CommandInput in, Feedback fb) {
            String urlSpec = src.getLocationURL();
            int schColon = urlSpec.indexOf(58);
            if (schColon == -1) {
                return null;
            }
            String scheme = urlSpec.toLowerCase().substring(0, schColon);
            if (WebCatalog.acceptURLScheme(scheme, urlSpec)) {
                WebCatalog c = new WebCatalog(urlSpec, src);
                c.init(in, fb);
                return c;
            }
            return null;
        }

        @Override
        public void init(CommandInput in, Feedback out) {
            assert (this.input == null);
            this.input = in;
        }
    }
}

