/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.graalvm.component.installer.AbstractIterable;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentArchiveReader;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.persist.MetadataLoader;

public class FileIterable
extends AbstractIterable {
    public FileIterable(CommandInput input, Feedback fb) {
        super(input, fb);
    }

    private File getFile(String pathSpec) {
        File f = new File(pathSpec);
        if (f.exists()) {
            return f;
        }
        throw this.feedback.failure("ERROR_MissingFile", null, pathSpec);
    }

    @Override
    public Iterator<ComponentParam> iterator() {
        return new Iterator<ComponentParam>(){

            @Override
            public boolean hasNext() {
                return FileIterable.this.input.hasParameter();
            }

            @Override
            public ComponentParam next() {
                return new FileComponent(FileIterable.this.getFile(FileIterable.this.input.requiredParameter()), FileIterable.this.isVerifyJars(), null, FileIterable.this.feedback);
            }
        };
    }

    public static class FileComponent
    implements ComponentParam {
        private final File localFile;
        private MetadataLoader loader;
        private final boolean verifyJars;
        private final Feedback feedback;
        private final String serial;

        public FileComponent(File localFile, boolean verifyJars, String serial, Feedback feedback) {
            this.localFile = localFile;
            this.verifyJars = verifyJars;
            this.serial = serial;
            this.feedback = feedback.withBundle(FileComponent.class);
        }

        @Override
        public MetadataLoader createMetaLoader() throws IOException {
            String ser;
            if (this.loader != null) {
                return this.loader;
            }
            byte[] fileStart = null;
            if (this.localFile.isFile()) {
                try (FileChannel ch = FileChannel.open(this.localFile.toPath(), StandardOpenOption.READ);){
                    ByteBuffer bb = ByteBuffer.allocate(8);
                    ch.read(bb);
                    fileStart = bb.array();
                }
                ser = this.serial != null ? this.serial : SystemUtils.fingerPrint(SystemUtils.computeFileDigest(this.localFile.toPath(), null), false);
            } else {
                fileStart = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                ser = "";
            }
            for (ComponentArchiveReader provider : ServiceLoader.load(ComponentArchiveReader.class)) {
                MetadataLoader ldr = provider.createLoader(this.localFile.toPath(), fileStart, ser, this.feedback, this.verifyJars);
                if (ldr == null) continue;
                this.loader = ldr;
                return ldr;
            }
            throw this.feedback.failure("ERROR_UnknownFileFormat", null, this.localFile.toString());
        }

        @Override
        public void close() throws IOException {
            if (this.loader != null) {
                this.loader.close();
            }
        }

        @Override
        public MetadataLoader createFileLoader() throws IOException {
            return this.createMetaLoader();
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public String getSpecification() {
            return this.localFile.toString();
        }

        @Override
        public String getDisplayName() {
            return this.localFile.toString();
        }

        @Override
        public String getFullPath() {
            return this.localFile.getAbsolutePath();
        }

        @Override
        public String getShortName() {
            return this.localFile.getName();
        }
    }
}

