/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.ComponentIterable;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.remote.CatalogIterable;
import org.graalvm.component.installer.remote.FileDownloader;

abstract class AbstractIterable
implements ComponentIterable {
    protected final CommandInput input;
    protected final Feedback feedback;
    private boolean verifyJars;
    private CommandInput.CatalogFactory remoteFactory;
    private ComponentCatalog remoteCatalog;

    protected AbstractIterable(CommandInput input, Feedback feedback) {
        this.input = input;
        this.feedback = feedback;
    }

    public boolean isVerifyJars() {
        return this.verifyJars;
    }

    @Override
    public void setVerifyJars(boolean verifyJars) {
        this.verifyJars = verifyJars;
    }

    public void setCatalogFactory(CommandInput.CatalogFactory cFactory) {
        this.remoteFactory = cFactory;
    }

    private ComponentCatalog getRemoteContents() {
        if (this.remoteCatalog != null) {
            return this.remoteCatalog;
        }
        this.remoteCatalog = this.remoteFactory != null ? this.remoteFactory.createComponentCatalog(this.input) : new NullCatalog();
        return this.remoteCatalog;
    }

    @Override
    public ComponentIterable matchVersion(Version.Match m) {
        return this;
    }

    @Override
    public ComponentIterable allowIncompatible() {
        return this;
    }

    @Override
    public ComponentParam createParam(String cmdString, ComponentInfo info) {
        CatalogIterable.CatalogItemParam param = new CatalogIterable.CatalogItemParam(this.getRemoteContents().getDownloadInterceptor(), info, info.getName(), cmdString, this.feedback, this.input.optValue("n") == null);
        param.setVerifyJars(this.verifyJars);
        return param;
    }

    private static class NullCatalog
    implements ComponentCatalog,
    ComponentCatalog.DownloadInterceptor {
        private NullCatalog() {
        }

        @Override
        public boolean isAllowDistUpdate() {
            return false;
        }

        @Override
        public ComponentInfo findComponentMatch(String id, Version.Match vmatch, boolean localOnly, boolean exact) {
            return null;
        }

        @Override
        public Set<String> findDependencies(ComponentInfo start, boolean closure, Boolean installed, Set<ComponentInfo> result) {
            return new HashSet<String>(start.getDependencies());
        }

        @Override
        public FileDownloader processDownloader(ComponentInfo info, FileDownloader dn) {
            return dn;
        }

        @Override
        public ComponentCatalog.DownloadInterceptor getDownloadInterceptor() {
            return this;
        }

        @Override
        public void setAllowDistUpdate(boolean distUpgrade) {
        }

        @Override
        public ComponentInfo findComponentMatch(String id, Version.Match vm, boolean exact) {
            return null;
        }

        @Override
        public String shortenComponentId(ComponentInfo info) {
            return info.getId();
        }

        @Override
        public Collection<String> getComponentIDs() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ComponentInfo> loadComponents(String id, Version.Match selector, boolean filelist) {
            return Collections.emptySet();
        }

        @Override
        public boolean isRemoteEnabled() {
            return false;
        }
    }
}

