/*
 * Copyright (c) 2021, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.svm.core.jdk;

import static com.oracle.svm.core.Containers.Options.UseContainerSupport;

import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.heap.PhysicalMemory.PhysicalMemorySupport;

@Platforms(Platform.LINUX.class)
@TargetClass(className = "jdk.internal.platform.CgroupMetrics", onlyWith = CgroupMetricsJDK.class)
public final class Target_jdk_internal_platform_CgroupMetrics {
    @Substitute
    public static boolean isUseContainerSupport() {
        return UseContainerSupport.getValue();
    }

    @Substitute
    @TargetElement(onlyWith = HasGetTotalMemorySize0.class)
    public static long getTotalMemorySize0() {
        // We ought not to use PhysicalMemory.size() here since that might return the
        // container memory which we explicitly want to avoid for this method. It serves
        // as an upper bound of the container memory.
        return ImageSingletons.lookup(PhysicalMemorySupport.class).size().rawValue();
    }
}
