// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetPreciseCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CalcStringAttributesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodePointLengthNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetPreciseCodeRangeNodeGen;
import com.oracle.truffle.api.strings.TruffleString.CompactionLevel;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendArrayIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendByteNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCharUTF16Node;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCodePointIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCodePointNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendIntNumberNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendLongNumberNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendStringNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendSubstringByteIndexNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.ToStringNode;
import com.oracle.truffle.api.strings.TruffleStringFactory.ToIndexableNodeGen;
import java.lang.invoke.MethodHandles;

@GeneratedBy(TruffleStringBuilder.class)
@SuppressWarnings("javadoc")
public final class TruffleStringBuilderFactory {

    @CompilationFinal(dimensions = 1) private static final CompactionLevel[] COMPACTION_LEVEL_VALUES = DSLSupport.lookupEnumConstants(CompactionLevel.class);

    private static CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeCompactionLevel(CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendByteNode#append}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre>
     */
    @GeneratedBy(AppendByteNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendByteNodeGen extends AppendByteNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendByteNode#append}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(0, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendByteNode#append}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(2, 1)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-1: InlinedCache
         *        Specialization: {@link AppendByteNode#append}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   2: InlinedCache
         *        Specialization: {@link AppendByteNode#append}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;

        private AppendByteNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
            append(arg0Value, arg1Value, INLINED_BUFFER_GROW_PROFILE_, INLINED_ERROR_PROFILE_);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static AppendByteNode create() {
            return new AppendByteNodeGen();
        }

        @NeverDefault
        public static AppendByteNode getUncached() {
            return AppendByteNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendByteNode.class)
        @DenyReplace
        private static final class Uncached extends AppendByteNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
                append(arg0Value, arg1Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendCharUTF16Node#doCached}
     *     Activation probability: 0.65000
     *     With/without class size: 22/8 bytes
     *   Specialization {@link AppendCharUTF16Node#doUncached}
     *     Activation probability: 0.35000
     *     With/without class size: 9/0 bytes
     * </pre>
     */
    @GeneratedBy(AppendCharUTF16Node.class)
    @SuppressWarnings("javadoc")
    static final class AppendCharUTF16NodeGen extends AppendCharUTF16Node {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendCharUTF16Node#doCached}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_BUFFER_GROW = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(2, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendCharUTF16Node#doCached}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(4, 1)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link AppendCharUTF16Node#doCached}
         *   1: SpecializationActive {@link AppendCharUTF16Node#doUncached}
         *   2-3: InlinedCache
         *        Specialization: {@link AppendCharUTF16Node#doCached}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   4: InlinedCache
         *        Specialization: {@link AppendCharUTF16Node#doCached}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        @UnsafeAccessedField @Child private CachedData cached_cache;

        private AppendCharUTF16NodeGen() {
        }

        @ExplodeLoop
        @Override
        public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doCached(TruffleStringBuilder, char, Node, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doUncached(TruffleStringBuilder, char, InlinedConditionProfile, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doCached(TruffleStringBuilder, char, Node, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if ((decodeCompactionLevel(((s0_.cached_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)] */) - 2).getStride() == arg0Value.stride) && (decodeCompactionLevel(((s0_.cached_state_0_ & 0b111000) >>> 3 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)] */) - 2).getStride() == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                            Node node__ = (this);
                            AppendCharUTF16Node.doCached(arg0Value, arg1Value, node__, decodeCompactionLevel(((s0_.cached_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)] */) - 2), decodeCompactionLevel(((s0_.cached_state_0_ & 0b111000) >>> 3 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doUncached(TruffleStringBuilder, char, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    doUncached(arg0Value, arg1Value, INLINED_BUFFER_GROW, INLINED_ERROR);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, char arg1Value) {
            int state_0 = this.state_0_;
            {
                Node node__ = null;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doUncached(TruffleStringBuilder, char, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    while (true) {
                        int count0_ = 0;
                        CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                        CachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((decodeCompactionLevel(((s0_.cached_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)] */) - 2).getStride() == arg0Value.stride) && (decodeCompactionLevel(((s0_.cached_state_0_ & 0b111000) >>> 3 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)] */) - 2).getStride() == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                                node__ = (this);
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                CompactionLevel cachedCurCompaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                                if ((cachedCurCompaction__.getStride() == arg0Value.stride)) {
                                    CompactionLevel cachedNewCompaction__ = (CompactionLevel.fromStride(TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)));
                                    if ((cachedNewCompaction__.getStride() == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)) && count0_ < (9)) {
                                        s0_ = this.insert(new CachedData(s0_original));
                                        node__ = (this);
                                        s0_.cached_state_0_ = (s0_.cached_state_0_ | ((encodeCompactionLevel(cachedCurCompaction__) + 2) << 0) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)] */);
                                        s0_.cached_state_0_ = (s0_.cached_state_0_ | ((encodeCompactionLevel(cachedNewCompaction__) + 2) << 3) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)] */);
                                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doCached(TruffleStringBuilder, char, Node, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            AppendCharUTF16Node.doCached(arg0Value, arg1Value, node__, decodeCompactionLevel(((s0_.cached_state_0_ & 0b111) >>> 0 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)] */) - 2), decodeCompactionLevel(((s0_.cached_state_0_ & 0b111000) >>> 3 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                        break;
                    }
                }
            }
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doCached(TruffleStringBuilder, char, Node, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
            state_0 = state_0 | 0b10 /* add SpecializationActive[TruffleStringBuilder.AppendCharUTF16Node.doUncached(TruffleStringBuilder, char, InlinedConditionProfile, InlinedBranchProfile)] */;
            this.state_0_ = state_0;
            doUncached(arg0Value, arg1Value, INLINED_BUFFER_GROW, INLINED_ERROR);
            return;
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static AppendCharUTF16Node create() {
            return new AppendCharUTF16NodeGen();
        }

        @NeverDefault
        public static AppendCharUTF16Node getUncached() {
            return AppendCharUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(AppendCharUTF16Node.class)
        @DenyReplace
        private static final class CachedData extends Node {

            @Child CachedData next_;
            /**
             * State Info: <pre>
             *   0-2: EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedCurCompaction, ...)]
             *   3-5: EncodedEnum[cache=TruffleStringBuilder.AppendCharUTF16Node.doCached(..., CompactionLevel cachedNewCompaction, ...)]
             * </pre>
             */
            @CompilationFinal private int cached_state_0_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AppendCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends AppendCharUTF16Node {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
                doUncached(arg0Value, arg1Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendCodePointNode#append}
     *     Activation probability: 1.00000
     *     With/without class size: 32/10 bytes
     * </pre>
     */
    @GeneratedBy(AppendCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendCodePointNodeGen extends AppendCodePointNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendCodePointNode#append}
         *   Parameter: {@link AppendCodePointIntlNode} appendCodePointIntlNode
         *   Inline method: {@link AppendCodePointIntlNodeGen#inline}</pre>
         */
        private static final AppendCodePointIntlNode INLINED_APPEND_CODE_POINT_INTL_NODE_ = AppendCodePointIntlNodeGen.inline(InlineTarget.create(AppendCodePointIntlNode.class, STATE_0_UPDATER.subUpdater(0, 12), ReferenceField.create(MethodHandles.lookup(), "appendCodePointIntlNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "appendCodePointIntlNode__field2_", Node.class)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-11: InlinedCache
         *        Specialization: {@link AppendCodePointNode#append}
         *        Parameter: {@link AppendCodePointIntlNode} appendCodePointIntlNode
         *        Inline method: {@link AppendCodePointIntlNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendCodePointNode#append}
         *   Parameter: {@link AppendCodePointIntlNode} appendCodePointIntlNode
         *   Inline method: {@link AppendCodePointIntlNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node appendCodePointIntlNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendCodePointNode#append}
         *   Parameter: {@link AppendCodePointIntlNode} appendCodePointIntlNode
         *   Inline method: {@link AppendCodePointIntlNodeGen#inline}
         *   Inline field: {@link Node} field2</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node appendCodePointIntlNode__field2_;

        private AppendCodePointNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_APPEND_CODE_POINT_INTL_NODE_);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static AppendCodePointNode create() {
            return new AppendCodePointNodeGen();
        }

        @NeverDefault
        public static AppendCodePointNode getUncached() {
            return AppendCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends AppendCodePointNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
                append(arg0Value, arg1Value, arg2Value, arg3Value, (AppendCodePointIntlNodeGen.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendCodePointIntlNode#bytes}
     *     Activation probability: 0.23929
     *     With/without class size: 7/0 bytes
     *   Specialization {@link AppendCodePointIntlNode#utf8}
     *     Activation probability: 0.20714
     *     With/without class size: 7/0 bytes
     *   Specialization {@link AppendCodePointIntlNode#utf16Cached}
     *     Activation probability: 0.17500
     *     With/without class size: 8/8 bytes
     *   Specialization {@link AppendCodePointIntlNode#utf16Uncached}
     *     Activation probability: 0.14286
     *     With/without class size: 6/0 bytes
     *   Specialization {@link AppendCodePointIntlNode#utf32Cached}
     *     Activation probability: 0.11071
     *     With/without class size: 7/8 bytes
     *   Specialization {@link AppendCodePointIntlNode#utf32Uncached}
     *     Activation probability: 0.07857
     *     With/without class size: 5/0 bytes
     *   Specialization {@link AppendCodePointIntlNode#unsupported}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(AppendCodePointIntlNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendCodePointIntlNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static AppendCodePointIntlNode getUncached() {
            return AppendCodePointIntlNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#utf16Cached_cache}
         * <li>{@link Inlined#utf32Cached_cache}
         * </ul>
         */
        @NeverDefault
        public static AppendCodePointIntlNode inline(@RequiredField(bits = 12, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new AppendCodePointIntlNodeGen.Inlined(target);
        }

        @GeneratedBy(AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Inlined extends AppendCodePointIntlNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AppendCodePointIntlNode#bytes}
             *   1: SpecializationActive {@link AppendCodePointIntlNode#utf8}
             *   2: SpecializationActive {@link AppendCodePointIntlNode#utf16Cached}
             *   3: SpecializationActive {@link AppendCodePointIntlNode#utf16Uncached}
             *   4: SpecializationActive {@link AppendCodePointIntlNode#utf32Cached}
             *   5: SpecializationActive {@link AppendCodePointIntlNode#utf32Uncached}
             *   6: SpecializationActive {@link AppendCodePointIntlNode#unsupported}
             *   7-8: InlinedCache
             *        Specialization: {@link AppendCodePointIntlNode#bytes}
             *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   9: InlinedCache
             *        Specialization: {@link AppendCodePointIntlNode#bytes}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link AppendCodePointIntlNode#utf16Cached}
             *        Parameter: {@link InlinedConditionProfile} bmpProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            private final ReferenceField<Utf16CachedData> utf16Cached_cache;
            private final ReferenceField<Utf32CachedData> utf32Cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#bytes}
             *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile bufferGrow;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#bytes}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile error;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#utf16Cached}
             *   Parameter: {@link InlinedConditionProfile} bmpProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile bmp;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(AppendCodePointIntlNode.class);
                this.state_0_ = target.getState(0, 12);
                this.utf16Cached_cache = target.getReference(1, Utf16CachedData.class);
                this.utf32Cached_cache = target.getReference(2, Utf32CachedData.class);
                this.bufferGrow = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(7, 2)));
                this.error = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(9, 1)));
                this.bmp = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
            }

            @ExplodeLoop
            @Override
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, boolean arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.bytes(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf8(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int, InlinedConditionProfile)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.unsupported(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.bytes(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isAsciiBytesOrLatin1(arg3Value))) {
                            AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                            return;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf8(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isUTF8(arg3Value))) {
                            AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                            return;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int, InlinedConditionProfile)] */ && (TStringGuards.isUTF16(arg3Value))) {
                        Utf16CachedData s2_ = this.utf16Cached_cache.get(arg0Value);
                        while (s2_ != null) {
                            if ((s2_.cachedCurStride_ == arg1Value.stride) && (s2_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg1Value, arg2Value))) {
                                AppendCodePointIntlNode.utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s2_.cachedCurStride_, s2_.cachedNewStride_, this.bmp);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg3Value))) {
                            AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, this.bmp);
                            return;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int)] */ && (TStringGuards.isUTF32(arg3Value))) {
                        Utf32CachedData s4_ = this.utf32Cached_cache.get(arg0Value);
                        while (s4_ != null) {
                            if ((s4_.cachedCurStride_ == arg1Value.stride) && (s4_.cachedNewStride_ == TruffleStringBuilder.utf32Stride(arg1Value, arg2Value))) {
                                AppendCodePointIntlNode.utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s4_.cachedCurStride_, s4_.cachedNewStride_);
                                return;
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isUTF32(arg3Value))) {
                            AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                            return;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.unsupported(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                            AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                return;
            }

            private void executeAndSpecialize(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, boolean arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isAsciiBytesOrLatin1(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.bytes(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf8(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] */ && (TStringGuards.isUTF16(arg3Value))) {
                    while (true) {
                        int count2_ = 0;
                        Utf16CachedData s2_ = this.utf16Cached_cache.getVolatile(arg0Value);
                        Utf16CachedData s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.cachedCurStride_ == arg1Value.stride) && (s2_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg1Value, arg2Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                int cachedNewStride__ = (TruffleStringBuilder.utf16Stride(arg1Value, arg2Value));
                                // assert (s2_.cachedCurStride_ == arg1Value.stride);
                                if ((cachedNewStride__ == TruffleStringBuilder.utf16Stride(arg1Value, arg2Value)) && count2_ < (9)) {
                                    s2_ = arg0Value.insert(new Utf16CachedData(s2_original));
                                    s2_.cachedCurStride_ = (arg1Value.stride);
                                    s2_.cachedNewStride_ = cachedNewStride__;
                                    if (!this.utf16Cached_cache.compareAndSet(arg0Value, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int, InlinedConditionProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                }
                            }
                        }
                        if (s2_ != null) {
                            AppendCodePointIntlNode.utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s2_.cachedCurStride_, s2_.cachedNewStride_, this.bmp);
                            return;
                        }
                        break;
                    }
                }
                if ((TStringGuards.isUTF16(arg3Value))) {
                    this.utf16Cached_cache.set(arg0Value, null);
                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int, InlinedConditionProfile)] */;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf16Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, this.bmp);
                    return;
                }
                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */ && (TStringGuards.isUTF32(arg3Value))) {
                    while (true) {
                        int count4_ = 0;
                        Utf32CachedData s4_ = this.utf32Cached_cache.getVolatile(arg0Value);
                        Utf32CachedData s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.cachedCurStride_ == arg1Value.stride) && (s4_.cachedNewStride_ == TruffleStringBuilder.utf32Stride(arg1Value, arg2Value))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                int cachedNewStride__1 = (TruffleStringBuilder.utf32Stride(arg1Value, arg2Value));
                                // assert (s4_.cachedCurStride_ == arg1Value.stride);
                                if ((cachedNewStride__1 == TruffleStringBuilder.utf32Stride(arg1Value, arg2Value)) && count4_ < (9)) {
                                    s4_ = arg0Value.insert(new Utf32CachedData(s4_original));
                                    s4_.cachedCurStride_ = (arg1Value.stride);
                                    s4_.cachedNewStride_ = cachedNewStride__1;
                                    if (!this.utf32Cached_cache.compareAndSet(arg0Value, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                }
                            }
                        }
                        if (s4_ != null) {
                            AppendCodePointIntlNode.utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error, s4_.cachedCurStride_, s4_.cachedNewStride_);
                            return;
                        }
                        break;
                    }
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    this.utf32Cached_cache.set(arg0Value, null);
                    state_0 = state_0 & 0xffffffef /* remove SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Cached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile, int, int)] */;
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.utf32Uncached(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[TruffleStringBuilder.AppendCodePointIntlNode.unsupported(Node, TruffleStringBuilder, int, Encoding, int, boolean, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.bufferGrow, this.error);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Utf16CachedData extends Node {

            @Child Utf16CachedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#utf16Cached}
             *   Parameter: int cachedCurStride</pre>
             */
            @CompilationFinal int cachedCurStride_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#utf16Cached}
             *   Parameter: int cachedNewStride</pre>
             */
            @CompilationFinal int cachedNewStride_;

            Utf16CachedData(Utf16CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Utf32CachedData extends Node {

            @Child Utf32CachedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#utf32Cached}
             *   Parameter: int cachedCurStride</pre>
             */
            @CompilationFinal int cachedCurStride_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendCodePointIntlNode#utf32Cached}
             *   Parameter: int cachedNewStride</pre>
             */
            @CompilationFinal int cachedNewStride_;

            Utf32CachedData(Utf32CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Uncached extends AppendCodePointIntlNode {

            @TruffleBoundary
            @Override
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, int arg2Value, Encoding arg3Value, int arg4Value, boolean arg5Value) {
                if ((TStringGuards.isAsciiBytesOrLatin1(arg3Value))) {
                    AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((TStringGuards.isUTF8(arg3Value))) {
                    AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((TStringGuards.isUTF16(arg3Value))) {
                    AppendCodePointIntlNode.utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                    return;
                }
                if ((TStringGuards.isUTF32(arg3Value))) {
                    AppendCodePointIntlNode.utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((TStringGuards.isUnsupportedEncoding(arg3Value))) {
                    AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendIntNumberNode#doAppend}
     *     Activation probability: 0.48333
     *     With/without class size: 13/4 bytes
     *   Specialization {@link AppendIntNumberNode#doAppend}
     *     Activation probability: 0.33333
     *     With/without class size: 10/4 bytes
     *   Specialization {@link AppendIntNumberNode#doAppend}
     *     Activation probability: 0.18333
     *     With/without class size: 7/4 bytes
     * </pre>
     */
    @GeneratedBy(AppendIntNumberNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendIntNumberNodeGen extends AppendIntNumberNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendIntNumberNode#doAppend}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_BUFFER_GROW = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(12, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendIntNumberNode#doAppend}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(14, 1)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link AppendIntNumberNode#doAppend}
         *   1-3: EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   4: SpecializationActive {@link AppendIntNumberNode#doAppend}
         *   5-7: EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   8: SpecializationActive {@link AppendIntNumberNode#doAppend}
         *   9-11: EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   12-13: InlinedCache
         *        Specialization: {@link AppendIntNumberNode#doAppend}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   14: InlinedCache
         *        Specialization: {@link AppendIntNumberNode#doAppend}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;

        private AppendIntNumberNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100010001) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append0_duplicateFound_ = true;
                        }
                    }
                    if (!Append0_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append0_duplicateFound_ = true;
                        }
                    }
                    if (Append0_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                        return;
                    }
                    break;
                }
            }
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append1_duplicateFound_ = false;
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append1_duplicateFound_ = true;
                        }
                    }
                    if (!Append1_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append1_duplicateFound_ = true;
                        }
                    }
                    if (Append1_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                        return;
                    }
                    break;
                }
            }
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append2_duplicateFound_ = false;
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append2_duplicateFound_ = true;
                        }
                    }
                    if (!Append2_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[TruffleStringBuilder.AppendIntNumberNode.doAppend(TruffleStringBuilder, int, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append2_duplicateFound_ = true;
                        }
                    }
                    if (Append2_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendIntNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_BUFFER_GROW, INLINED_ERROR);
                        return;
                    }
                    break;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100010001) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b100010001) & ((state_0 & 0b100010001) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static AppendIntNumberNode create() {
            return new AppendIntNumberNodeGen();
        }

        @NeverDefault
        public static AppendIntNumberNode getUncached() {
            return AppendIntNumberNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendIntNumberNode.class)
        @DenyReplace
        private static final class Uncached extends AppendIntNumberNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
                // assert ((CompactionLevel.fromStride(arg0Value.stride)) == ((CompactionLevel.fromStride(arg0Value.stride))));
                doAppend(arg0Value, arg1Value, (CompactionLevel.fromStride(arg0Value.stride)), ((CompactionLevel.fromStride(arg0Value.stride))), (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendLongNumberNode#doAppend}
     *     Activation probability: 0.48333
     *     With/without class size: 15/5 bytes
     *   Specialization {@link AppendLongNumberNode#doAppend}
     *     Activation probability: 0.33333
     *     With/without class size: 12/5 bytes
     *   Specialization {@link AppendLongNumberNode#doAppend}
     *     Activation probability: 0.18333
     *     With/without class size: 8/5 bytes
     * </pre>
     */
    @GeneratedBy(AppendLongNumberNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendLongNumberNodeGen extends AppendLongNumberNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_APPEND0_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(12, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_APPEND0_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(14, 1)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_APPEND1_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(15, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_APPEND1_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(17, 1)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_APPEND2_BUFFER_GROW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(18, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendLongNumberNode#doAppend}
         *   Parameter: {@link InlinedBranchProfile} errorProfile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_APPEND2_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(20, 1)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link AppendLongNumberNode#doAppend}
         *   1-3: EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   4: SpecializationActive {@link AppendLongNumberNode#doAppend}
         *   5-7: EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   8: SpecializationActive {@link AppendLongNumberNode#doAppend}
         *   9-11: EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)]
         *   12-13: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   14: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         *   15-16: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   17: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         *   18-19: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   20: InlinedCache
         *        Specialization: {@link AppendLongNumberNode#doAppend}
         *        Parameter: {@link InlinedBranchProfile} errorProfile
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;

        private AppendLongNumberNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100010001) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND0_BUFFER_GROW_PROFILE_, INLINED_APPEND0_ERROR_PROFILE_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND1_BUFFER_GROW_PROFILE_, INLINED_APPEND1_ERROR_PROFILE_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        CompactionLevel compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND2_BUFFER_GROW_PROFILE_, INLINED_APPEND2_ERROR_PROFILE_);
                            return;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append0_duplicateFound_ = true;
                        }
                    }
                    if (!Append0_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append0_duplicateFound_ = true;
                        }
                    }
                    if (Append0_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND0_BUFFER_GROW_PROFILE_, INLINED_APPEND0_ERROR_PROFILE_);
                        return;
                    }
                    break;
                }
            }
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append1_duplicateFound_ = false;
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append1_duplicateFound_ = true;
                        }
                    }
                    if (!Append1_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append1_duplicateFound_ = true;
                        }
                    }
                    if (Append1_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND1_BUFFER_GROW_PROFILE_, INLINED_APPEND1_ERROR_PROFILE_);
                        return;
                    }
                    break;
                }
            }
            {
                CompactionLevel compaction__ = null;
                while (true) {
                    boolean Append2_duplicateFound_ = false;
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                        compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                        if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                            Append2_duplicateFound_ = true;
                        }
                    }
                    if (!Append2_duplicateFound_) {
                        // assert ((CompactionLevel.fromStride(arg0Value.stride)) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                        if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */) {
                            compaction__ = (CompactionLevel.fromStride(arg0Value.stride));
                            state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[TruffleStringBuilder.AppendLongNumberNode.doAppend(TruffleStringBuilder, long, CompactionLevel, CompactionLevel, InlinedConditionProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            Append2_duplicateFound_ = true;
                        }
                    }
                    if (Append2_duplicateFound_) {
                        doAppend(arg0Value, arg1Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TruffleStringBuilder.AppendLongNumberNode.doAppend(..., CompactionLevel cachedCompaction, ...)] */) - 2), INLINED_APPEND2_BUFFER_GROW_PROFILE_, INLINED_APPEND2_ERROR_PROFILE_);
                        return;
                    }
                    break;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0b100010001) == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if (((state_0 & 0b100010001) & ((state_0 & 0b100010001) - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static AppendLongNumberNode create() {
            return new AppendLongNumberNodeGen();
        }

        @NeverDefault
        public static AppendLongNumberNode getUncached() {
            return AppendLongNumberNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendLongNumberNode.class)
        @DenyReplace
        private static final class Uncached extends AppendLongNumberNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
                // assert ((CompactionLevel.fromStride(arg0Value.stride)) == ((CompactionLevel.fromStride(arg0Value.stride))));
                doAppend(arg0Value, arg1Value, (CompactionLevel.fromStride(arg0Value.stride)), ((CompactionLevel.fromStride(arg0Value.stride))), (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendStringNode#append}
     *     Activation probability: 1.00000
     *     With/without class size: 32/12 bytes
     * </pre>
     */
    @GeneratedBy(AppendStringNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendStringNodeGen extends AppendStringNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendStringNode#append}
         *   Parameter: {@link ToIndexableNode} toIndexableNode
         *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
         */
        private static final ToIndexableNode INLINED_TO_INDEXABLE_NODE_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, STATE_0_UPDATER.subUpdater(0, 7)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendStringNode#append}
         *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
         *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre>
         */
        private static final GetCodePointLengthNode INLINED_GET_CODE_POINT_LENGTH_NODE_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, STATE_0_UPDATER.subUpdater(7, 25)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendStringNode#append}
         *   Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
         *   Inline method: {@link GetPreciseCodeRangeNodeGen#inline}</pre>
         */
        private static final GetPreciseCodeRangeNode INLINED_GET_PRECISE_CODE_RANGE_NODE_ = GetPreciseCodeRangeNodeGen.inline(InlineTarget.create(GetPreciseCodeRangeNode.class, STATE_1_UPDATER.subUpdater(0, 25)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendStringNode#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}</pre>
         */
        private static final AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineTarget.create(AppendArrayIntlNode.class, STATE_1_UPDATER.subUpdater(25, 5), ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-6: InlinedCache
         *        Specialization: {@link AppendStringNode#append}
         *        Parameter: {@link ToIndexableNode} toIndexableNode
         *        Inline method: {@link ToIndexableNodeGen#inline}
         *   7-31: InlinedCache
         *        Specialization: {@link AppendStringNode#append}
         *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
         *        Inline method: {@link GetCodePointLengthNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * State Info: <pre>
         *   0-24: InlinedCache
         *        Specialization: {@link AppendStringNode#append}
         *        Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
         *        Inline method: {@link GetPreciseCodeRangeNodeGen#inline}
         *   25-29: InlinedCache
         *        Specialization: {@link AppendStringNode#append}
         *        Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *        Inline method: {@link AppendArrayIntlNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendStringNode#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node appendArrayIntlNode__field1_;

        private AppendStringNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
            append(arg0Value, arg1Value, INLINED_TO_INDEXABLE_NODE_, INLINED_GET_CODE_POINT_LENGTH_NODE_, INLINED_GET_PRECISE_CODE_RANGE_NODE_, INLINED_APPEND_ARRAY_INTL_NODE_);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static AppendStringNode create() {
            return new AppendStringNodeGen();
        }

        @NeverDefault
        public static AppendStringNode getUncached() {
            return AppendStringNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendStringNode.class)
        @DenyReplace
        private static final class Uncached extends AppendStringNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
                append(arg0Value, arg1Value, (ToIndexableNodeGen.getUncached()), (GetCodePointLengthNode.getUncached()), (GetPreciseCodeRangeNodeGen.getUncached()), (AppendArrayIntlNodeGen.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendSubstringByteIndexNode#append}
     *     Activation probability: 1.00000
     *     With/without class size: 36/14 bytes
     * </pre>
     */
    @GeneratedBy(AppendSubstringByteIndexNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendSubstringByteIndexNodeGen extends AppendSubstringByteIndexNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
        private static final StateField STATE_2_UPDATER = StateField.create(MethodHandles.lookup(), "state_2_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link ToIndexableNode} toIndexableNode
         *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
         */
        private static final ToIndexableNode INLINED_TO_INDEXABLE_NODE_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, STATE_0_UPDATER.subUpdater(0, 7)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
         *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre>
         */
        private static final GetCodePointLengthNode INLINED_GET_CODE_POINT_LENGTH_NODE_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, STATE_0_UPDATER.subUpdater(7, 25)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
         *   Inline method: {@link GetPreciseCodeRangeNodeGen#inline}</pre>
         */
        private static final GetPreciseCodeRangeNode INLINED_GET_PRECISE_CODE_RANGE_NODE_ = GetPreciseCodeRangeNodeGen.inline(InlineTarget.create(GetPreciseCodeRangeNode.class, STATE_1_UPDATER.subUpdater(0, 25)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}</pre>
         */
        private static final AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineTarget.create(AppendArrayIntlNode.class, STATE_1_UPDATER.subUpdater(25, 5), ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link CalcStringAttributesNode} calcAttributesNode
         *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
         */
        private static final CalcStringAttributesNode INLINED_CALC_ATTRIBUTES_NODE_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, STATE_2_UPDATER.subUpdater(0, 16)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link InlinedConditionProfile} calcAttrsProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_CALC_ATTRS_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_1_UPDATER.subUpdater(30, 2)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-6: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link ToIndexableNode} toIndexableNode
         *        Inline method: {@link ToIndexableNodeGen#inline}
         *   7-31: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
         *        Inline method: {@link GetCodePointLengthNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * State Info: <pre>
         *   0-24: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
         *        Inline method: {@link GetPreciseCodeRangeNodeGen#inline}
         *   25-29: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *        Inline method: {@link AppendArrayIntlNodeGen#inline}
         *   30-31: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link InlinedConditionProfile} calcAttrsProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_1_;
        /**
         * State Info: <pre>
         *   0-15: InlinedCache
         *        Specialization: {@link AppendSubstringByteIndexNode#append}
         *        Parameter: {@link CalcStringAttributesNode} calcAttributesNode
         *        Inline method: {@link CalcStringAttributesNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_2_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendSubstringByteIndexNode#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node appendArrayIntlNode__field1_;

        private AppendSubstringByteIndexNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
            append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_TO_INDEXABLE_NODE_, INLINED_GET_CODE_POINT_LENGTH_NODE_, INLINED_GET_PRECISE_CODE_RANGE_NODE_, INLINED_APPEND_ARRAY_INTL_NODE_, INLINED_CALC_ATTRIBUTES_NODE_, INLINED_CALC_ATTRS_PROFILE_);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static AppendSubstringByteIndexNode create() {
            return new AppendSubstringByteIndexNodeGen();
        }

        @NeverDefault
        public static AppendSubstringByteIndexNode getUncached() {
            return AppendSubstringByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendSubstringByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends AppendSubstringByteIndexNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
                append(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNodeGen.getUncached()), (GetCodePointLengthNode.getUncached()), (GetPreciseCodeRangeNodeGen.getUncached()), (AppendArrayIntlNodeGen.getUncached()), (CalcStringAttributesNodeGen.getUncached()), (InlinedConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendJavaStringUTF16Node#append}
     *     Activation probability: 1.00000
     *     With/without class size: 28/5 bytes
     * </pre>
     */
    @GeneratedBy(AppendJavaStringUTF16Node.class)
    @SuppressWarnings("javadoc")
    static final class AppendJavaStringUTF16NodeGen extends AppendJavaStringUTF16Node {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendJavaStringUTF16Node#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}</pre>
         */
        private static final AppendArrayIntlNode INLINED_APPEND_ARRAY_INTL_NODE_ = AppendArrayIntlNodeGen.inline(InlineTarget.create(AppendArrayIntlNode.class, STATE_0_UPDATER.subUpdater(0, 5), ReferenceField.create(MethodHandles.lookup(), "appendArrayIntlNode__field1_", Node.class)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendJavaStringUTF16Node#append}
         *   Parameter: {@link InlinedConditionProfile} stride0Profile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_STRIDE0_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(5, 2)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-4: InlinedCache
         *        Specialization: {@link AppendJavaStringUTF16Node#append}
         *        Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *        Inline method: {@link AppendArrayIntlNodeGen#inline}
         *   5-6: InlinedCache
         *        Specialization: {@link AppendJavaStringUTF16Node#append}
         *        Parameter: {@link InlinedConditionProfile} stride0Profile
         *        Inline method: {@link InlinedConditionProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AppendJavaStringUTF16Node#append}
         *   Parameter: {@link AppendArrayIntlNode} appendArrayIntlNode
         *   Inline method: {@link AppendArrayIntlNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node appendArrayIntlNode__field1_;

        private AppendJavaStringUTF16NodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
            append(arg0Value, arg1Value, arg2Value, arg3Value, INLINED_APPEND_ARRAY_INTL_NODE_, INLINED_STRIDE0_PROFILE_);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static AppendJavaStringUTF16Node create() {
            return new AppendJavaStringUTF16NodeGen();
        }

        @NeverDefault
        public static AppendJavaStringUTF16Node getUncached() {
            return AppendJavaStringUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(AppendJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends AppendJavaStringUTF16Node {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
                append(arg0Value, arg1Value, arg2Value, arg3Value, (AppendArrayIntlNodeGen.getUncached()), (InlinedConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ToStringNode#createString}
     *     Activation probability: 1.00000
     *     With/without class size: 24/3 bytes
     * </pre>
     */
    @GeneratedBy(ToStringNode.class)
    @SuppressWarnings("javadoc")
    static final class ToStringNodeGen extends ToStringNode {

        private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToStringNode#createString}
         *   Parameter: {@link InlinedConditionProfile} calcAttributesProfile
         *   Inline method: {@link InlinedConditionProfile#inline}</pre>
         */
        private static final InlinedConditionProfile INLINED_CALC_ATTRIBUTES_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(0, 2)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToStringNode#createString}
         *   Parameter: {@link CalcStringAttributesNode} calcAttributesNode
         *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
         */
        private static final CalcStringAttributesNode INLINED_CALC_ATTRIBUTES_NODE_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, STATE_0_UPDATER.subUpdater(2, 16)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0-1: InlinedCache
         *        Specialization: {@link ToStringNode#createString}
         *        Parameter: {@link InlinedConditionProfile} calcAttributesProfile
         *        Inline method: {@link InlinedConditionProfile#inline}
         *   2-17: InlinedCache
         *        Specialization: {@link ToStringNode#createString}
         *        Parameter: {@link CalcStringAttributesNode} calcAttributesNode
         *        Inline method: {@link CalcStringAttributesNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;

        private ToStringNodeGen() {
        }

        @Override
        public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
            return createString(arg0Value, arg1Value, INLINED_CALC_ATTRIBUTES_PROFILE_, INLINED_CALC_ATTRIBUTES_NODE_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static ToStringNode create() {
            return new ToStringNodeGen();
        }

        @NeverDefault
        public static ToStringNode getUncached() {
            return ToStringNodeGen.UNCACHED;
        }

        @GeneratedBy(ToStringNode.class)
        @DenyReplace
        private static final class Uncached extends ToStringNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
                return createString(arg0Value, arg1Value, (InlinedConditionProfile.getUncached()), (CalcStringAttributesNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link AppendArrayIntlNode#doCached}
     *     Activation probability: 0.65000
     *     With/without class size: 24/12 bytes
     *   Specialization {@link AppendArrayIntlNode#doUncached}
     *     Activation probability: 0.35000
     *     With/without class size: 9/0 bytes
     * </pre>
     */
    @GeneratedBy(AppendArrayIntlNode.class)
    @SuppressWarnings("javadoc")
    static final class AppendArrayIntlNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static AppendArrayIntlNode getUncached() {
            return AppendArrayIntlNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#cached_cache}
         * </ul>
         */
        @NeverDefault
        public static AppendArrayIntlNode inline(@RequiredField(bits = 5, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new AppendArrayIntlNodeGen.Inlined(target);
        }

        @GeneratedBy(AppendArrayIntlNode.class)
        @DenyReplace
        private static final class Inlined extends AppendArrayIntlNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AppendArrayIntlNode#doCached}
             *   1: SpecializationActive {@link AppendArrayIntlNode#doUncached}
             *   2-3: InlinedCache
             *        Specialization: {@link AppendArrayIntlNode#doCached}
             *        Parameter: {@link InlinedConditionProfile} bufferGrowProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4: InlinedCache
             *        Specialization: {@link AppendArrayIntlNode#doCached}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            private final ReferenceField<CachedData> cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendArrayIntlNode#doCached}
             *   Parameter: {@link InlinedConditionProfile} bufferGrowProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile bufferGrow;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendArrayIntlNode#doCached}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile error;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(AppendArrayIntlNode.class);
                this.state_0_ = target.getState(0, 5);
                this.cached_cache = target.getReference(1, CachedData.class);
                this.bufferGrow = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.error = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(4, 1)));
            }

            @ExplodeLoop
            @Override
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doCached(Node, TruffleStringBuilder, Object, int, int, int, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doUncached(Node, TruffleStringBuilder, Object, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doCached(Node, TruffleStringBuilder, Object, int, int, int, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        CachedData s0_ = this.cached_cache.get(arg0Value);
                        while (s0_ != null) {
                            if ((arg1Value.stride == s0_.cachedStrideSB_) && (arg5Value == s0_.cachedStrideA_) && (arg6Value == s0_.cachedStrideNew_)) {
                                AppendArrayIntlNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, this.bufferGrow, this.error);
                                return;
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doUncached(Node, TruffleStringBuilder, Object, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.bufferGrow, this.error);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                return;
            }

            private void executeAndSpecialize(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doUncached(Node, TruffleStringBuilder, Object, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */) {
                    while (true) {
                        int count0_ = 0;
                        CachedData s0_ = this.cached_cache.getVolatile(arg0Value);
                        CachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg1Value.stride == s0_.cachedStrideSB_) && (arg5Value == s0_.cachedStrideA_) && (arg6Value == s0_.cachedStrideNew_)) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (arg1Value.stride == s0_.cachedStrideSB_);
                            // assert (arg5Value == s0_.cachedStrideA_);
                            // assert (arg6Value == s0_.cachedStrideNew_);
                            if (count0_ < (9)) {
                                s0_ = arg0Value.insert(new CachedData(s0_original));
                                s0_.cachedStrideSB_ = (arg1Value.stride);
                                s0_.cachedStrideA_ = (arg5Value);
                                s0_.cachedStrideNew_ = (arg6Value);
                                if (!this.cached_cache.compareAndSet(arg0Value, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doCached(Node, TruffleStringBuilder, Object, int, int, int, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */;
                                this.state_0_.set(arg0Value, state_0);
                            }
                        }
                        if (s0_ != null) {
                            AppendArrayIntlNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, this.bufferGrow, this.error);
                            return;
                        }
                        break;
                    }
                }
                this.cached_cache.set(arg0Value, null);
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doCached(Node, TruffleStringBuilder, Object, int, int, int, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[TruffleStringBuilder.AppendArrayIntlNode.doUncached(Node, TruffleStringBuilder, Object, int, int, int, int, InlinedConditionProfile, InlinedBranchProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.bufferGrow, this.error);
                return;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(AppendArrayIntlNode.class)
        @DenyReplace
        private static final class CachedData extends Node {

            @Child CachedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendArrayIntlNode#doCached}
             *   Parameter: int cachedStrideSB</pre>
             */
            @CompilationFinal int cachedStrideSB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendArrayIntlNode#doCached}
             *   Parameter: int cachedStrideA</pre>
             */
            @CompilationFinal int cachedStrideA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AppendArrayIntlNode#doCached}
             *   Parameter: int cachedStrideNew</pre>
             */
            @CompilationFinal int cachedStrideNew_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AppendArrayIntlNode.class)
        @DenyReplace
        private static final class Uncached extends AppendArrayIntlNode {

            @TruffleBoundary
            @Override
            void execute(Node arg0Value, TruffleStringBuilder arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                AppendArrayIntlNode.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
