// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString.NativePointer;
import com.oracle.truffle.api.strings.IndexOfCodePointSet.IndexOfNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ByteLengthOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesInnerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointIndexToRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatEagerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatMaterializeBytesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CreateJavaStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeForIndexCalculationNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetPreciseCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointSetNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.InternalIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseDoubleNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseIntNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseLongNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RawIndexToCodePointIndexNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ReadByteNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RegionEqualsNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.StrideFromCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.SubstringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeIntlNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TruffleString.CompactionLevel;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ErrorHandling;
import com.oracle.truffle.api.strings.TruffleString.NumberFormatException;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleStringFactory.ToIndexableNodeGen;
import com.oracle.truffle.api.strings.TruffleStringIterator.InternalNextNode;
import com.oracle.truffle.api.strings.TruffleStringIterator.InternalPreviousNode;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory.InternalNextNodeGen;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory.InternalPreviousNodeGen;
import java.lang.invoke.MethodHandles;

@GeneratedBy(TStringInternalNodes.class)
@SuppressWarnings("javadoc")
final class TStringInternalNodesFactory {

    @CompilationFinal(dimensions = 1) private static final CompactionLevel[] COMPACTION_LEVEL_VALUES = DSLSupport.lookupEnumConstants(CompactionLevel.class);

    private static CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeCompactionLevel(CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link GetCodeRangeForIndexCalculationNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
    @SuppressWarnings("javadoc")
    static final class GetCodeRangeForIndexCalculationNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetCodeRangeForIndexCalculationNode getUncached() {
            return GetCodeRangeForIndexCalculationNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static GetCodeRangeForIndexCalculationNode inline(@RequiredField(bits = 25, value = StateField.class) InlineTarget target) {
            return new GetCodeRangeForIndexCalculationNodeGen.Inlined(target);
        }

        @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Inlined extends GetCodeRangeForIndexCalculationNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-8: InlinedCache
             *        Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *        Parameter: {@link ToIndexableNode} toIndexableNode
             *        Inline method: {@link ToIndexableNodeGen#inline}
             *   9-24: InlinedCache
             *        Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *        Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile impreciseProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *   Parameter: {@link ToIndexableNode} toIndexableNode
             *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
             */
            private final ToIndexableNode toIndexableNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *   Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
             */
            private final CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetCodeRangeForIndexCalculationNode.class);
                this.state_0_ = target.getState(0, 25);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodeRangeForIndexCalculationNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (ToIndexableNodeGen.getUncached()), (CalcStringAttributesNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetPreciseCodeRangeNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(GetPreciseCodeRangeNode.class)
    @SuppressWarnings("javadoc")
    static final class GetPreciseCodeRangeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetPreciseCodeRangeNode getUncached() {
            return GetPreciseCodeRangeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static GetPreciseCodeRangeNode inline(@RequiredField(bits = 25, value = StateField.class) InlineTarget target) {
            return new GetPreciseCodeRangeNodeGen.Inlined(target);
        }

        @GeneratedBy(GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined extends GetPreciseCodeRangeNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-8: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeNode#get}
             *        Parameter: {@link ToIndexableNode} toIndexableNode
             *        Inline method: {@link ToIndexableNodeGen#inline}
             *   9-24: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeNode#get}
             *        Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile impreciseProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeNode#get}
             *   Parameter: {@link ToIndexableNode} toIndexableNode
             *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
             */
            private final ToIndexableNode toIndexableNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeNode#get}
             *   Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
             */
            private final CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetPreciseCodeRangeNode.class);
                this.state_0_ = target.getState(0, 25);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends GetPreciseCodeRangeNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (ToIndexableNodeGen.getUncached()), (CalcStringAttributesNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetCodePointLengthNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(GetCodePointLengthNode.class)
    @SuppressWarnings("javadoc")
    static final class GetCodePointLengthNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetCodePointLengthNode getUncached() {
            return GetCodePointLengthNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static GetCodePointLengthNode inline(@RequiredField(bits = 25, value = StateField.class) InlineTarget target) {
            return new GetCodePointLengthNodeGen.Inlined(target);
        }

        @GeneratedBy(GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Inlined extends GetCodePointLengthNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetCodePointLengthNode#get}
             *        Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-8: InlinedCache
             *        Specialization: {@link GetCodePointLengthNode#get}
             *        Parameter: {@link ToIndexableNode} toIndexableNode
             *        Inline method: {@link ToIndexableNodeGen#inline}
             *   9-24: InlinedCache
             *        Specialization: {@link GetCodePointLengthNode#get}
             *        Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthNode#get}
             *   Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile cacheMissProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthNode#get}
             *   Parameter: {@link ToIndexableNode} toIndexableNode
             *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
             */
            private final ToIndexableNode toIndexableNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthNode#get}
             *   Parameter: {@link CalcStringAttributesNode} calcStringAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
             */
            private final CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetCodePointLengthNode.class);
                this.state_0_ = target.getState(0, 25);
                this.cacheMissProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, this.cacheMissProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodePointLengthNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (ToIndexableNodeGen.getUncached()), (CalcStringAttributesNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
     *     Activation probability: 1.00000
     *     With/without class size: 24/3 bytes
     * </pre>
     */
    @GeneratedBy(FromBufferWithStringCompactionNode.class)
    @SuppressWarnings("javadoc")
    static final class FromBufferWithStringCompactionNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromBufferWithStringCompactionNode getUncached() {
            return FromBufferWithStringCompactionNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static FromBufferWithStringCompactionNode inline(@RequiredField(bits = 20, value = StateField.class) InlineTarget target) {
            return new FromBufferWithStringCompactionNodeGen.Inlined(target);
        }

        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Inlined extends FromBufferWithStringCompactionNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} asciiLatinBytesProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf8Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} exoticValidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} exoticFixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} asciiLatinBytesProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile asciiLatinBytesProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf8Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8BrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16CompactProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Compact0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Compact1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} exoticValidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile exoticValidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} exoticFixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile exoticFixedWidthProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromBufferWithStringCompactionNode.class);
                this.state_0_ = target.getState(0, 20);
                this.asciiLatinBytesProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.exoticValidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.exoticFixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.asciiLatinBytesProfile_, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_, this.exoticValidProfile_, this.exoticFixedWidthProfile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                return FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
     *     Activation probability: 1.00000
     *     With/without class size: 28/8 bytes
     * </pre>
     */
    @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
    @SuppressWarnings("javadoc")
    static final class FromBufferWithStringCompactionKnownAttributesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return FromBufferWithStringCompactionKnownAttributesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static FromBufferWithStringCompactionKnownAttributesNode inline(@RequiredField(bits = 31, value = StateField.class)@RequiredField(bits = 29, value = StateField.class) InlineTarget target) {
            return new FromBufferWithStringCompactionKnownAttributesNodeGen.Inlined(target);
        }

        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Inlined extends FromBufferWithStringCompactionKnownAttributesNode {

            /**
             * State Info: <pre>
             *   0-24: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             *   25-26: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   27-28: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   29-30: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-24: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
             *        Inline method: {@link GetPreciseCodeRangeNodeGen#inline}
             *   25-26: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   27-28: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre>
             */
            private final GetCodePointLengthNode getCodePointLengthNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
             *   Inline method: {@link GetPreciseCodeRangeNodeGen#inline}</pre>
             */
            private final GetPreciseCodeRangeNode getPreciseCodeRangeNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16CompactProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Compact0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Compact1Profile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromBufferWithStringCompactionKnownAttributesNode.class);
                this.state_0_ = target.getState(0, 31);
                this.state_1_ = target.getState(1, 29);
                this.getCodePointLengthNode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_0_.subUpdater(0, 25)));
                this.getPreciseCodeRangeNode_ = GetPreciseCodeRangeNodeGen.inline(InlineTarget.create(GetPreciseCodeRangeNode.class, state_1_.subUpdater(0, 25)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(29, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(25, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(27, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(25, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(27, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, Encoding arg3Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_0_, this.state_1_, this.state_1_, this.state_0_, this.state_0_);
                return FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, this.getCodePointLengthNode_, this.getPreciseCodeRangeNode_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionKnownAttributesNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, Encoding arg3Value) {
                return FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, (GetCodePointLengthNode.getUncached()), (GetPreciseCodeRangeNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromNativePointerNode#fromNativePointerInternal}
     *     Activation probability: 1.00000
     *     With/without class size: 24/2 bytes
     * </pre>
     */
    @GeneratedBy(FromNativePointerNode.class)
    @SuppressWarnings("javadoc")
    static final class FromNativePointerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromNativePointerNode getUncached() {
            return FromNativePointerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static FromNativePointerNode inline(@RequiredField(bits = 14, value = StateField.class) InlineTarget target) {
            return new FromNativePointerNodeGen.Inlined(target);
        }

        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Inlined extends FromNativePointerNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} asciiLatinBytesProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf8Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} exoticValidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} exoticFixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} asciiLatinBytesProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile asciiLatinBytesProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf8Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8BrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} exoticValidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile exoticValidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} exoticFixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile exoticFixedWidthProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromNativePointerNode.class);
                this.state_0_ = target.getState(0, 14);
                this.asciiLatinBytesProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.exoticValidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.exoticFixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, NativePointer arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.asciiLatinBytesProfile_, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf32Profile_, this.exoticValidProfile_, this.exoticFixedWidthProfile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends FromNativePointerNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, NativePointer arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value) {
                return FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ByteLengthOfCodePointNode#doFixed}
     *     Activation probability: 0.19111
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#doFixedValidReturnNegative}
     *     Activation probability: 0.17111
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#doASCIIBrokenReturnNegative}
     *     Activation probability: 0.15111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#doUTF32BrokenReturnNegative}
     *     Activation probability: 0.13111
     *     With/without class size: 6/3 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf8Valid}
     *     Activation probability: 0.11111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf8Broken}
     *     Activation probability: 0.09111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf16Valid}
     *     Activation probability: 0.07111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf16Broken}
     *     Activation probability: 0.05111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#unsupported}
     *     Activation probability: 0.03111
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(ByteLengthOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class ByteLengthOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ByteLengthOfCodePointNode getUncached() {
            return ByteLengthOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static ByteLengthOfCodePointNode inline(@RequiredField(bits = 27, value = StateField.class) InlineTarget target) {
            return new ByteLengthOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends ByteLengthOfCodePointNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ByteLengthOfCodePointNode#doFixed}
             *   1: SpecializationActive {@link ByteLengthOfCodePointNode#doFixedValidReturnNegative}
             *   2: SpecializationActive {@link ByteLengthOfCodePointNode#doASCIIBrokenReturnNegative}
             *   3: SpecializationActive {@link ByteLengthOfCodePointNode#doUTF32BrokenReturnNegative}
             *   4: SpecializationActive {@link ByteLengthOfCodePointNode#utf8Valid}
             *   5: SpecializationActive {@link ByteLengthOfCodePointNode#utf8Broken}
             *   6: SpecializationActive {@link ByteLengthOfCodePointNode#utf16Valid}
             *   7: SpecializationActive {@link ByteLengthOfCodePointNode#utf16Broken}
             *   8: SpecializationActive {@link ByteLengthOfCodePointNode#unsupported}
             *   9-26: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#doUTF32BrokenReturnNegative}
             *        Parameter: {@link CodePointAtRawNode} codePointAtRawNode
             *        Inline method: {@link CodePointAtRawNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#doUTF32BrokenReturnNegative}
             *   Parameter: {@link CodePointAtRawNode} codePointAtRawNode
             *   Inline method: {@link CodePointAtRawNodeGen#inline}</pre>
             */
            private final CodePointAtRawNode uTF32BrokenReturnNegative_codePointAtRawNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ByteLengthOfCodePointNode.class);
                this.state_0_ = target.getState(0, 27);
                this.uTF32BrokenReturnNegative_codePointAtRawNode_ = CodePointAtRawNodeGen.inline(InlineTarget.create(CodePointAtRawNode.class, state_0_.subUpdater(9, 18)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111111111) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value)) && (TStringGuards.isBestEffort(arg6Value))) {
                            return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUpToValidFixedWidth(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                            return doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isAscii(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                            return doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode)] */) {
                        if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                            return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value)) && (TStringGuards.isBestEffort(arg6Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doFixedValidReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doASCIIBrokenReturnNegative(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, CodePointAtRawNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends ByteLengthOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                if ((TStringGuards.isFixedWidth(arg3Value)) && (TStringGuards.isBestEffort(arg6Value))) {
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUpToValidFixedWidth(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    return doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    return doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF32(arg4Value)) && (TStringGuards.isBroken(arg3Value)) && (TStringGuards.isReturnNegative(arg6Value))) {
                    return ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CodePointAtRawNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RawIndexToCodePointIndexNode#doFixed}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf8Valid}
     *     Activation probability: 0.23095
     *     With/without class size: 7/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf8Broken}
     *     Activation probability: 0.18810
     *     With/without class size: 7/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf16Valid}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf16Broken}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#unsupported}
     *     Activation probability: 0.05952
     *     With/without class size: 5/1 bytes
     * </pre>
     */
    @GeneratedBy(RawIndexToCodePointIndexNode.class)
    @SuppressWarnings("javadoc")
    static final class RawIndexToCodePointIndexNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static RawIndexToCodePointIndexNode getUncached() {
            return RawIndexToCodePointIndexNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static RawIndexToCodePointIndexNode inline(@RequiredField(bits = 10, value = StateField.class) InlineTarget target) {
            return new RawIndexToCodePointIndexNodeGen.Inlined(target);
        }

        @GeneratedBy(RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Inlined extends RawIndexToCodePointIndexNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RawIndexToCodePointIndexNode#doFixed}
             *   1: SpecializationActive {@link RawIndexToCodePointIndexNode#utf8Valid}
             *   2: SpecializationActive {@link RawIndexToCodePointIndexNode#utf8Broken}
             *   3: SpecializationActive {@link RawIndexToCodePointIndexNode#utf16Valid}
             *   4: SpecializationActive {@link RawIndexToCodePointIndexNode#utf16Broken}
             *   5: SpecializationActive {@link RawIndexToCodePointIndexNode#unsupported}
             *   6-7: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#utf8Valid}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#unsupported}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#utf8Valid}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile broken;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#unsupported}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile unsupported_validProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(RawIndexToCodePointIndexNode.class);
                this.state_0_ = target.getState(0, 10);
                this.broken = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.unsupported_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_validProfile_, this.broken);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_validProfile_, this.broken);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Uncached extends RawIndexToCodePointIndexNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    return RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointIndexToRawNode#doFixed}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf8Valid}
     *     Activation probability: 0.23095
     *     With/without class size: 6/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf8Broken}
     *     Activation probability: 0.18810
     *     With/without class size: 6/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf16Valid}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf16Broken}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#unsupported}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(CodePointIndexToRawNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointIndexToRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointIndexToRawNode getUncached() {
            return CodePointIndexToRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CodePointIndexToRawNode inline(@RequiredField(bits = 6, value = StateField.class) InlineTarget target) {
            return new CodePointIndexToRawNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointIndexToRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointIndexToRawNode#doFixed}
             *   1: SpecializationActive {@link CodePointIndexToRawNode#utf8Valid}
             *   2: SpecializationActive {@link CodePointIndexToRawNode#utf8Broken}
             *   3: SpecializationActive {@link CodePointIndexToRawNode#utf16Valid}
             *   4: SpecializationActive {@link CodePointIndexToRawNode#utf16Broken}
             *   5: SpecializationActive {@link CodePointIndexToRawNode#unsupported}
             * </pre>
             */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointIndexToRawNode.class);
                this.state_0_ = target.getState(0, 6);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                            return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                            return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                            return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Valid(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16Broken(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointIndexToRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isValid(arg3Value))) {
                    return utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (TStringGuards.isBroken(arg3Value))) {
                    return utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadByteNode#doUTF16}
     *     Activation probability: 0.48333
     *     With/without class size: 11/0 bytes
     *   Specialization {@link ReadByteNode#doUTF32}
     *     Activation probability: 0.33333
     *     With/without class size: 10/1 bytes
     *   Specialization {@link ReadByteNode#doRest}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre>
     */
    @GeneratedBy(ReadByteNode.class)
    @SuppressWarnings("javadoc")
    static final class ReadByteNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ReadByteNode getUncached() {
            return ReadByteNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static ReadByteNode inline(@RequiredField(bits = 7, value = StateField.class) InlineTarget target) {
            return new ReadByteNodeGen.Inlined(target);
        }

        @GeneratedBy(ReadByteNode.class)
        @DenyReplace
        private static final class Inlined extends ReadByteNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReadByteNode#doUTF16}
             *   1: SpecializationActive {@link ReadByteNode#doUTF32}
             *   2: SpecializationActive {@link ReadByteNode#doRest}
             *   3-4: InlinedCache
             *        Specialization: {@link ReadByteNode#doUTF16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link ReadByteNode#doUTF32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadByteNode#doUTF16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile stride0;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadByteNode#doUTF32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile uTF32_stride1Profile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ReadByteNode.class);
                this.state_0_ = target.getState(0, 7);
                this.stride0 = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(3, 2)));
                this.uTF32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(5, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, Object, int, Encoding)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg4Value))) {
                            return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0, this.uTF32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, Object, int, Encoding)] */) {
                        if ((!(TStringGuards.isUTF16Or32(arg4Value)))) {
                            return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0);
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, Object, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0, this.uTF32_stride1Profile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, Object, int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ReadByteNode.class)
        @DenyReplace
        private static final class Uncached extends ReadByteNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value) {
                if ((TStringGuards.isUTF16(arg4Value))) {
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value)))) {
                    return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointAtNode#utf16}
     *     Activation probability: 0.27381
     *     With/without class size: 9/1 bytes
     *   Specialization {@link CodePointAtNode#utf32}
     *     Activation probability: 0.23095
     *     With/without class size: 8/1 bytes
     *   Specialization {@link CodePointAtNode#utf8}
     *     Activation probability: 0.18810
     *     With/without class size: 7/1 bytes
     *   Specialization {@link CodePointAtNode#doFixed}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointAtNode#doAsciiBroken}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointAtNode#unsupported}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(CodePointAtNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointAtNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointAtNode getUncached() {
            return CodePointAtNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CodePointAtNode inline(@RequiredField(bits = 16, value = StateField.class) InlineTarget target) {
            return new CodePointAtNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointAtNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointAtNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointAtNode#utf16}
             *   1: SpecializationActive {@link CodePointAtNode#utf32}
             *   2: SpecializationActive {@link CodePointAtNode#utf8}
             *   3: SpecializationActive {@link CodePointAtNode#doFixed}
             *   4: SpecializationActive {@link CodePointAtNode#doAsciiBroken}
             *   5: SpecializationActive {@link CodePointAtNode#unsupported}
             *   6-7: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile stride0;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile valid;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32_stride1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8_fixedWidthProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointAtNode.class);
                this.state_0_ = target.getState(0, 16);
                this.stride0 = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.valid = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.stride0, this.valid);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.valid);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                            return CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                            return CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                            return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.stride0, this.valid);
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.valid);
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CodePointAtNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                if ((TStringGuards.isUTF16(arg4Value))) {
                    return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    return CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    return CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    return unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointAtRawNode#utf16}
     *     Activation probability: 0.27381
     *     With/without class size: 9/1 bytes
     *   Specialization {@link CodePointAtRawNode#utf32}
     *     Activation probability: 0.23095
     *     With/without class size: 8/1 bytes
     *   Specialization {@link CodePointAtRawNode#utf8}
     *     Activation probability: 0.18810
     *     With/without class size: 7/1 bytes
     *   Specialization {@link CodePointAtRawNode#doFixed}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointAtRawNode#doAsciiBroken}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CodePointAtRawNode#unsupported}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(CodePointAtRawNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointAtRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointAtRawNode getUncached() {
            return CodePointAtRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CodePointAtRawNode inline(@RequiredField(bits = 18, value = StateField.class) InlineTarget target) {
            return new CodePointAtRawNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointAtRawNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointAtRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointAtRawNode#utf16}
             *   1: SpecializationActive {@link CodePointAtRawNode#utf32}
             *   2: SpecializationActive {@link CodePointAtRawNode#utf8}
             *   3: SpecializationActive {@link CodePointAtRawNode#doFixed}
             *   4: SpecializationActive {@link CodePointAtRawNode#doAsciiBroken}
             *   5: SpecializationActive {@link CodePointAtRawNode#unsupported}
             *   6-7: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile stride0;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf32_stride1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf8_validProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointAtRawNode.class);
                this.state_0_ = target.getState(0, 18);
                this.stride0 = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.stride0);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                            return CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                            return CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                            return CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.stride0);
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, Object, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doFixed(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unsupported(AbstractTruffleString, Object, int, Encoding, int, ErrorHandling)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CodePointAtRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, ErrorHandling arg6Value) {
                if ((TStringGuards.isUTF16(arg4Value))) {
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg4Value))) && (!(TStringGuards.isUTF8(arg4Value))) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    return CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isAscii(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    return CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.is7Or8Bit(arg3Value)))) {
                    return CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointNode#doFixedWidth}
     *     Activation probability: 0.65000
     *     With/without class size: 17/2 bytes
     *   Specialization {@link IndexOfCodePointNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 11/3 bytes
     * </pre>
     */
    @GeneratedBy(IndexOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static IndexOfCodePointNode getUncached() {
            return IndexOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static IndexOfCodePointNode inline(@RequiredField(bits = 14, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new IndexOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfCodePointNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfCodePointNode#doFixedWidth}
             *   1: SpecializationActive {@link IndexOfCodePointNode#decode}
             *   2-13: InlinedCache
             *        Specialization: {@link IndexOfCodePointNode#doFixedWidth}
             *        Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *        Inline method: {@link RawIndexOfCodePointNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link IndexOfCodePointNode#decode}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointNode#doFixedWidth}
             *   Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *   Inline method: {@link RawIndexOfCodePointNodeGen#inline}</pre>
             */
            private final RawIndexOfCodePointNode fixedWidth_indexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointNode#decode}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfCodePointNode.class);
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 21);
                this.fixedWidth_indexOfNode_ = RawIndexOfCodePointNodeGen.inline(InlineTarget.create(RawIndexOfCodePointNode.class, state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_indexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_);
                            return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_indexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_);
                    return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointRawNode#utf8Fixed}
     *     Activation probability: 0.38500
     *     With/without class size: 11/2 bytes
     *   Specialization {@link IndexOfCodePointRawNode#utf8Variable}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link IndexOfCodePointRawNode#utf16Variable}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link IndexOfCodePointRawNode#unsupported}
     *     Activation probability: 0.11500
     *     With/without class size: 6/3 bytes
     * </pre>
     */
    @GeneratedBy(IndexOfCodePointRawNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static IndexOfCodePointRawNode getUncached() {
            return IndexOfCodePointRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static IndexOfCodePointRawNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new IndexOfCodePointRawNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfCodePointRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfCodePointRawNode#utf8Fixed}
             *   1: SpecializationActive {@link IndexOfCodePointRawNode#utf8Variable}
             *   2: SpecializationActive {@link IndexOfCodePointRawNode#utf16Variable}
             *   3: SpecializationActive {@link IndexOfCodePointRawNode#unsupported}
             *   4-15: InlinedCache
             *        Specialization: {@link IndexOfCodePointRawNode#utf8Fixed}
             *        Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *        Inline method: {@link RawIndexOfCodePointNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link IndexOfCodePointRawNode#unsupported}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointRawNode#utf8Fixed}
             *   Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *   Inline method: {@link RawIndexOfCodePointNodeGen#inline}</pre>
             */
            private final RawIndexOfCodePointNode utf8Fixed_indexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointRawNode#unsupported}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode unsupported_nextNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfCodePointRawNode.class);
                this.state_0_ = target.getState(0, 16);
                this.state_1_ = target.getState(1, 21);
                this.utf8Fixed_indexOfNode_ = RawIndexOfCodePointNodeGen.inline(InlineTarget.create(RawIndexOfCodePointNode.class, state_0_.subUpdater(4, 12)));
                this.unsupported_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8Fixed_indexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            return utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            return utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_);
                            return IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_nextNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8Fixed_indexOfNode_);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(AbstractTruffleString, Object, int, Encoding, int, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_);
                    return IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfCodePointNode#doFixedWidth}
     *     Activation probability: 0.65000
     *     With/without class size: 17/2 bytes
     *   Specialization {@link LastIndexOfCodePointNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 11/3 bytes
     * </pre>
     */
    @GeneratedBy(LastIndexOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfCodePointNode getUncached() {
            return LastIndexOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static LastIndexOfCodePointNode inline(@RequiredField(bits = 14, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new LastIndexOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfCodePointNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfCodePointNode#doFixedWidth}
             *   1: SpecializationActive {@link LastIndexOfCodePointNode#decode}
             *   2-13: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointNode#doFixedWidth}
             *        Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *        Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointNode#decode}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointNode#doFixedWidth}
             *   Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *   Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}</pre>
             */
            private final RawLastIndexOfCodePointNode fixedWidth_lastIndexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointNode#decode}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfCodePointNode.class);
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 21);
                this.fixedWidth_lastIndexOfNode_ = RawLastIndexOfCodePointNodeGen.inline(InlineTarget.create(RawLastIndexOfCodePointNode.class, state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_lastIndexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_);
                            return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_lastIndexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_);
                    return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfCodePointRawNode#utf8Fixed}
     *     Activation probability: 0.38500
     *     With/without class size: 10/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#utf8Variable}
     *     Activation probability: 0.29500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#utf16Variable}
     *     Activation probability: 0.20500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#unsupported}
     *     Activation probability: 0.11500
     *     With/without class size: 6/3 bytes
     * </pre>
     */
    @GeneratedBy(LastIndexOfCodePointRawNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfCodePointRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfCodePointRawNode getUncached() {
            return LastIndexOfCodePointRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static LastIndexOfCodePointRawNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new LastIndexOfCodePointRawNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfCodePointRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *   1: SpecializationActive {@link LastIndexOfCodePointRawNode#utf8Variable}
             *   2: SpecializationActive {@link LastIndexOfCodePointRawNode#utf16Variable}
             *   3: SpecializationActive {@link LastIndexOfCodePointRawNode#unsupported}
             *   4-15: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *        Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *        Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointRawNode#unsupported}
             *        Parameter: {@link InternalPreviousNode} prevNode
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *   Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *   Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}</pre>
             */
            private final RawLastIndexOfCodePointNode lastIndexOfNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointRawNode#unsupported}
             *   Parameter: {@link InternalPreviousNode} prevNode
             *   Inline method: {@link InternalPreviousNodeGen#inline}</pre>
             */
            private final InternalPreviousNode unsupported_prevNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfCodePointRawNode.class);
                this.state_0_ = target.getState(0, 16);
                this.state_1_ = target.getState(1, 21);
                this.lastIndexOfNode = RawLastIndexOfCodePointNodeGen.inline(InlineTarget.create(RawLastIndexOfCodePointNode.class, state_0_.subUpdater(4, 12)));
                this.unsupported_prevNode_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalPreviousNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value))) {
                            return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalPreviousNode)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_);
                            return LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_prevNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(Node, AbstractTruffleString, Object, int, Encoding, int, int, int, InternalPreviousNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_);
                    return LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_prevNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isFixedWidth(arg3Value))) {
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg4Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InternalPreviousNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointSetNode#stride0}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link IndexOfCodePointSetNode#dynamicStride}
     *     Activation probability: 0.35000
     *     With/without class size: 11/4 bytes
     * </pre>
     */
    @GeneratedBy(IndexOfCodePointSetNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointSetNodeGen extends IndexOfCodePointSetNode {

        static final ReferenceField<DynamicStrideData> DYNAMIC_STRIDE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "dynamicStride_cache", DynamicStrideData.class);

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link IndexOfCodePointSetNode#stride0}
         *   1: SpecializationActive {@link IndexOfCodePointSetNode#dynamicStride}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @CompilationFinal private DynamicStrideData dynamicStride_cache;

        private IndexOfCodePointSetNodeGen(IndexOfNode[] indexOfNodes, Encoding encoding) {
            super(indexOfNodes, encoding);
        }

        @ExplodeLoop
        @Override
        int execute(Object arg0Value, int arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(Object, int, int, int, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(Object, int, int, int, int, int, int, int)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(Object, int, int, int, int, int, int)] */) {
                    assert DSLSupport.assertIdempotence((!(isUTF16Or32)));
                    return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(Object, int, int, int, int, int, int, int)] */) {
                    assert DSLSupport.assertIdempotence((isUTF16Or32));
                    DynamicStrideData s1_ = this.dynamicStride_cache;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStride_)) {
                            return dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if ((!(isUTF16Or32))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(Object, int, int, int, int, int, int)] */;
                this.state_0_ = state_0;
                return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((isUTF16Or32)) {
                while (true) {
                    int count1_ = 0;
                    DynamicStrideData s1_ = DYNAMIC_STRIDE_CACHE_UPDATER.getVolatile(this);
                    DynamicStrideData s1_original = s1_;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStride_)) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        // assert (arg3Value == s1_.cachedStride_);
                        if (count1_ < (IndexOfCodePointSetNode.POSSIBLE_STRIDE_VALUES)) {
                            s1_ = new DynamicStrideData(s1_original);
                            s1_.cachedStride_ = (arg3Value);
                            if (!DYNAMIC_STRIDE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(Object, int, int, int, int, int, int, int)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s1_ != null) {
                        return dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                    }
                    break;
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                    DynamicStrideData s1_ = this.dynamicStride_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static IndexOfCodePointSetNode create(IndexOfNode[] indexOfNodes, Encoding encoding) {
            return new IndexOfCodePointSetNodeGen(indexOfNodes, encoding);
        }

        @GeneratedBy(IndexOfCodePointSetNode.class)
        @DenyReplace
        private static final class DynamicStrideData {

            @CompilationFinal final DynamicStrideData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointSetNode#dynamicStride}
             *   Parameter: int cachedStride</pre>
             */
            @CompilationFinal int cachedStride_;

            DynamicStrideData(DynamicStrideData next_) {
                this.next_ = next_;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link SubstringNode#lengthZero}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link SubstringNode#sameStr}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link SubstringNode#materializeSubstring}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link SubstringNode#createLazySubstring}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre>
     */
    @GeneratedBy(SubstringNode.class)
    @SuppressWarnings("javadoc")
    static final class SubstringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static SubstringNode getUncached() {
            return SubstringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static SubstringNode inline(@RequiredField(bits = 28, value = StateField.class) InlineTarget target) {
            return new SubstringNodeGen.Inlined(target);
        }

        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Inlined extends SubstringNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubstringNode#lengthZero}
             *   1: SpecializationActive {@link SubstringNode#sameStr}
             *   2: SpecializationActive {@link SubstringNode#materializeSubstring}
             *   3: SpecializationActive {@link SubstringNode#createLazySubstring}
             *   4-19: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link CalcStringAttributesNode} calcAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             *   20-21: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   24-25: InlinedCache
             *        Specialization: {@link SubstringNode#createLazySubstring}
             *        Parameter: {@link InlinedConditionProfile} stride1MustMaterializeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link SubstringNode#createLazySubstring}
             *        Parameter: {@link InlinedConditionProfile} stride2MustMaterializeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link CalcStringAttributesNode} calcAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
             */
            private final CalcStringAttributesNode attributes;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile materializeSubstring_utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile materializeSubstring_utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#createLazySubstring}
             *   Parameter: {@link InlinedConditionProfile} stride1MustMaterializeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile createLazySubstring_stride1MustMaterializeProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#createLazySubstring}
             *   Parameter: {@link InlinedConditionProfile} stride2MustMaterializeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile createLazySubstring_stride2MustMaterializeProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(SubstringNode.class);
                this.state_0_ = target.getState(0, 28);
                this.attributes = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(4, 16)));
                this.materializeSubstring_utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(20, 2)));
                this.materializeSubstring_utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(22, 2)));
                this.createLazySubstring_stride1MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(24, 2)));
                this.createLazySubstring_stride2MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(26, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, Object, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */) {
                        if ((arg6Value == 0)) {
                            return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, Object, int, Encoding, int, int, boolean)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((arg5Value == 0) && (arg6Value == TStringGuards.length(arg1Value_))) {
                            return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg7Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value_)) && (arg7Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((arg6Value == 0)) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, Object, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg5Value == 0) && (arg6Value == TStringGuards.length(arg1Value_))) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, Object, int, Encoding, int, int, boolean)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg7Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value_)) && (arg7Value)) {
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, Object, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */;
                        this.state_0_.set(arg0Value, state_0);
                        assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                        return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                if ((arg6Value == 0)) {
                    return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg5Value == 0) && (arg6Value == TStringGuards.length(arg1Value_))) {
                        return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg7Value))) {
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (CalcStringAttributesNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg6Value > 0) && (arg6Value != TStringGuards.length(arg1Value_)) && (arg7Value)) {
                        return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (CalcStringAttributesNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConcatEagerNode#concat}
     *     Activation probability: 1.00000
     *     With/without class size: 32/11 bytes
     * </pre>
     */
    @GeneratedBy(ConcatEagerNode.class)
    @SuppressWarnings("javadoc")
    static final class ConcatEagerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ConcatEagerNode getUncached() {
            return ConcatEagerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#state_2_}
         * </ul>
         */
        @NeverDefault
        public static ConcatEagerNode inline(@RequiredField(bits = 32, value = StateField.class)@RequiredField(bits = 27, value = StateField.class)@RequiredField(bits = 25, value = StateField.class) InlineTarget target) {
            return new ConcatEagerNodeGen.Inlined(target);
        }

        @GeneratedBy(ConcatEagerNode.class)
        @DenyReplace
        private static final class Inlined extends ConcatEagerNode {

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link ToIndexableNode} toIndexableNodeA
             *        Inline method: {@link ToIndexableNodeGen#inline}
             *   7-13: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link ToIndexableNode} toIndexableNodeB
             *        Inline method: {@link ToIndexableNodeGen#inline}
             *   14-29: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link CalcStringAttributesNode} calculateAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             *   30-31: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link ConcatMaterializeBytesNode} materializeBytesNode
             *        Inline method: {@link ConcatMaterializeBytesNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-24: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthANode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             *   25-26: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * State Info: <pre>
             *   0-24: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthBNode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             * </pre>
             */
            private final StateField state_2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link ToIndexableNode} toIndexableNodeA
             *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
             */
            private final ToIndexableNode toIndexableNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link ToIndexableNode} toIndexableNodeB
             *   Inline method: {@link ToIndexableNodeGen#inline}</pre>
             */
            private final ToIndexableNode toIndexableNodeB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthANode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre>
             */
            private final GetCodePointLengthNode getCodePointLengthANode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthBNode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre>
             */
            private final GetCodePointLengthNode getCodePointLengthBNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link ConcatMaterializeBytesNode} materializeBytesNode
             *   Inline method: {@link ConcatMaterializeBytesNodeGen#inline}</pre>
             */
            private final ConcatMaterializeBytesNode materializeBytesNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link CalcStringAttributesNode} calculateAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre>
             */
            private final CalcStringAttributesNode calculateAttributesNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile brokenProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ConcatEagerNode.class);
                this.state_0_ = target.getState(0, 32);
                this.state_1_ = target.getState(1, 27);
                this.state_2_ = target.getState(2, 25);
                this.toIndexableNodeA_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, state_0_.subUpdater(0, 7)));
                this.toIndexableNodeB_ = ToIndexableNodeGen.inline(InlineTarget.create(ToIndexableNode.class, state_0_.subUpdater(7, 7)));
                this.getCodePointLengthANode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_1_.subUpdater(0, 25)));
                this.getCodePointLengthBNode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_2_.subUpdater(0, 25)));
                this.materializeBytesNode_ = ConcatMaterializeBytesNodeGen.inline(InlineTarget.create(ConcatMaterializeBytesNode.class, state_0_.subUpdater(30, 2)));
                this.calculateAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(14, 16)));
                this.brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(25, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_1_, this.state_2_, this.state_0_, this.state_0_, this.state_1_);
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.toIndexableNodeA_, this.toIndexableNodeB_, this.getCodePointLengthANode_, this.getCodePointLengthBNode_, this.materializeBytesNode_, this.calculateAttributesNode_, this.brokenProfile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ConcatEagerNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatEagerNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (ToIndexableNodeGen.getUncached()), (ToIndexableNodeGen.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (ConcatMaterializeBytesNodeGen.getUncached()), (CalcStringAttributesNodeGen.getUncached()), (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConcatMaterializeBytesNode#doWithCompression}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link ConcatMaterializeBytesNode#doNoCompression}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(ConcatMaterializeBytesNode.class)
    @SuppressWarnings("javadoc")
    static final class ConcatMaterializeBytesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ConcatMaterializeBytesNode getUncached() {
            return ConcatMaterializeBytesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static ConcatMaterializeBytesNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new ConcatMaterializeBytesNodeGen.Inlined(target);
        }

        @GeneratedBy(ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Inlined extends ConcatMaterializeBytesNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConcatMaterializeBytesNode#doWithCompression}
             *   1: SpecializationActive {@link ConcatMaterializeBytesNode#doNoCompression}
             * </pre>
             */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ConcatMaterializeBytesNode.class);
                this.state_0_ = target.getState(0, 2);
            }

            @Override
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value))) {
                            return doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] */) {
                        if ((!(TStringGuards.isUTF16(arg5Value))) && (!(TStringGuards.isUTF32(arg5Value)))) {
                            return doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private byte[] executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((!(TStringGuards.isUTF16(arg5Value))) && (!(TStringGuards.isUTF32(arg5Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(AbstractTruffleString, Object, AbstractTruffleString, Object, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatMaterializeBytesNode {

            @TruffleBoundary
            @Override
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value))) {
                    return doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((!(TStringGuards.isUTF16(arg5Value))) && (!(TStringGuards.isUTF32(arg5Value)))) {
                    return doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RegionEqualsNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link RegionEqualsNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 12/6 bytes
     * </pre>
     */
    @GeneratedBy(RegionEqualsNode.class)
    @SuppressWarnings("javadoc")
    static final class RegionEqualsNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static RegionEqualsNode getUncached() {
            return RegionEqualsNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static RegionEqualsNode inline(@RequiredField(bits = 23, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new RegionEqualsNodeGen.Inlined(target);
        }

        @GeneratedBy(RegionEqualsNode.class)
        @DenyReplace
        private static final class Inlined extends RegionEqualsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RegionEqualsNode#direct}
             *   1: SpecializationActive {@link RegionEqualsNode#decode}
             *   2-22: InlinedCache
             *        Specialization: {@link RegionEqualsNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link RegionEqualsNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RegionEqualsNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RegionEqualsNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNodeB_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(RegionEqualsNode.class);
                this.state_0_ = target.getState(0, 23);
                this.state_1_ = target.getState(1, 21);
                this.decode_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(2, 21)));
                this.decode_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding)] || SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value, arg7Value))) {
                            return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg3Value, arg7Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                            return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private boolean executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value, arg7Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg7Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, Object, int, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                    return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(RegionEqualsNode.class)
        @DenyReplace
        private static final class Uncached extends RegionEqualsNode {

            @TruffleBoundary
            @Override
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, Encoding arg10Value) {
                if ((TStringGuards.isFixedWidth(arg3Value, arg7Value))) {
                    return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg7Value)))) {
                    return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, (InternalNextNodeGen.getUncached()), (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link InternalIndexOfStringNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link InternalIndexOfStringNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 12/6 bytes
     * </pre>
     */
    @GeneratedBy(InternalIndexOfStringNode.class)
    @SuppressWarnings("javadoc")
    static final class InternalIndexOfStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static InternalIndexOfStringNode getUncached() {
            return InternalIndexOfStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#direct_indexOfStringNode__field1_}
         * </ul>
         */
        @NeverDefault
        public static InternalIndexOfStringNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new InternalIndexOfStringNodeGen.Inlined(target);
        }

        @GeneratedBy(InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined extends InternalIndexOfStringNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InternalIndexOfStringNode#direct}
             *   1: SpecializationActive {@link InternalIndexOfStringNode#decode}
             *   2: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#direct}
             *        Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawIndexOfStringNodeGen#inline}
             *   3-23: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            private final ReferenceField<Node> direct_indexOfStringNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#direct}
             *   Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawIndexOfStringNodeGen#inline}</pre>
             */
            private final RawIndexOfStringNode direct_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNodeB_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(InternalIndexOfStringNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.direct_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.direct_indexOfStringNode_ = RawIndexOfStringNodeGen.inline(InlineTarget.create(RawIndexOfStringNode.class, state_0_.subUpdater(2, 1), direct_indexOfStringNode__field1_));
                this.decode_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 21)));
                this.decode_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                            return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                            return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                    return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                    return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends InternalIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                    return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                    return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (InternalNextNodeGen.getUncached()), (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfStringRawNode#supported}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link IndexOfStringRawNode#unsupported}
     *     Activation probability: 0.35000
     *     With/without class size: 12/6 bytes
     * </pre>
     */
    @GeneratedBy(IndexOfStringRawNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfStringRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static IndexOfStringRawNode getUncached() {
            return IndexOfStringRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#supported_indexOfStringNode__field1_}
         * </ul>
         */
        @NeverDefault
        public static IndexOfStringRawNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new IndexOfStringRawNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfStringRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfStringRawNode#supported}
             *   1: SpecializationActive {@link IndexOfStringRawNode#unsupported}
             *   2: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#supported}
             *        Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawIndexOfStringNodeGen#inline}
             *   3-23: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unsupported}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unsupported}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            private final ReferenceField<Node> supported_indexOfStringNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#supported}
             *   Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawIndexOfStringNodeGen#inline}</pre>
             */
            private final RawIndexOfStringNode supported_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unsupported}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode unsupported_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unsupported}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode unsupported_nextNodeB_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfStringRawNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.supported_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.supported_indexOfStringNode_ = RawIndexOfStringNodeGen.inline(InlineTarget.create(RawIndexOfStringNode.class, state_0_.subUpdater(2, 1), supported_indexOfStringNode__field1_));
                this.unsupported_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 21)));
                this.unsupported_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_);
                            return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.supported_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                            return IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_);
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.supported_indexOfStringNode_);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                    return IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfStringRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, (InternalNextNodeGen.getUncached()), (InternalNextNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfStringNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link LastIndexOfStringNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 12/8 bytes
     * </pre>
     */
    @GeneratedBy(LastIndexOfStringNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfStringNode getUncached() {
            return LastIndexOfStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#state_2_}
         * <li>{@link Inlined#direct_indexOfStringNode__field1_}
         * </ul>
         */
        @NeverDefault
        public static LastIndexOfStringNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new LastIndexOfStringNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfStringNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfStringNode#direct}
             *   1: SpecializationActive {@link LastIndexOfStringNode#decode}
             *   2: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#direct}
             *        Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawLastIndexOfStringNodeGen#inline}
             *   3-23: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalPreviousNode} prevNodeA
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalPreviousNode} prevNodeB
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre>
             */
            private final StateField state_2_;
            private final ReferenceField<Node> direct_indexOfStringNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#direct}
             *   Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawLastIndexOfStringNodeGen#inline}</pre>
             */
            private final RawLastIndexOfStringNode direct_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode decode_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalPreviousNode} prevNodeA
             *   Inline method: {@link InternalPreviousNodeGen#inline}</pre>
             */
            private final InternalPreviousNode decode_prevNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalPreviousNode} prevNodeB
             *   Inline method: {@link InternalPreviousNodeGen#inline}</pre>
             */
            private final InternalPreviousNode decode_prevNodeB_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfStringNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.state_2_ = target.getState(2, 21);
                this.direct_indexOfStringNode__field1_ = target.getReference(3, Node.class);
                this.direct_indexOfStringNode_ = RawLastIndexOfStringNodeGen.inline(InlineTarget.create(RawLastIndexOfStringNode.class, state_0_.subUpdater(2, 1), direct_indexOfStringNode__field1_));
                this.decode_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 21)));
                this.decode_prevNodeA_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, state_1_.subUpdater(0, 21)));
                this.decode_prevNodeB_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, state_2_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                            return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_);
                            return LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_prevNodeA_, this.decode_prevNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, RawLastIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_);
                    return LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_prevNodeA_, this.decode_prevNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Encoding arg9Value) {
                if ((TStringGuards.isFixedWidth(arg3Value, arg6Value))) {
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg3Value, arg6Value)))) {
                    return LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (InternalNextNodeGen.getUncached()), (InternalPreviousNodeGen.getUncached()), (InternalPreviousNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfStringRawNode#lios8SameEncoding}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link LastIndexOfStringRawNode#unsupported}
     *     Activation probability: 0.35000
     *     With/without class size: 12/8 bytes
     * </pre>
     */
    @GeneratedBy(LastIndexOfStringRawNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfStringRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfStringRawNode getUncached() {
            return LastIndexOfStringRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#state_2_}
         * <li>{@link Inlined#lios8SameEncoding_indexOfStringNode__field1_}
         * </ul>
         */
        @NeverDefault
        public static LastIndexOfStringRawNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new LastIndexOfStringRawNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfStringRawNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfStringRawNode#lios8SameEncoding}
             *   1: SpecializationActive {@link LastIndexOfStringRawNode#unsupported}
             *   2: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#lios8SameEncoding}
             *        Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawLastIndexOfStringNodeGen#inline}
             *   3-23: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *        Parameter: {@link InternalPreviousNode} prevNodeA
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *        Parameter: {@link InternalPreviousNode} prevNodeB
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre>
             */
            private final StateField state_2_;
            private final ReferenceField<Node> lios8SameEncoding_indexOfStringNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#lios8SameEncoding}
             *   Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawLastIndexOfStringNodeGen#inline}</pre>
             */
            private final RawLastIndexOfStringNode lios8SameEncoding_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode unsupported_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *   Parameter: {@link InternalPreviousNode} prevNodeA
             *   Inline method: {@link InternalPreviousNodeGen#inline}</pre>
             */
            private final InternalPreviousNode unsupported_prevNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unsupported}
             *   Parameter: {@link InternalPreviousNode} prevNodeB
             *   Inline method: {@link InternalPreviousNodeGen#inline}</pre>
             */
            private final InternalPreviousNode unsupported_prevNodeB_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfStringRawNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.state_2_ = target.getState(2, 21);
                this.lios8SameEncoding_indexOfStringNode__field1_ = target.getReference(3, Node.class);
                this.lios8SameEncoding_indexOfStringNode_ = RawLastIndexOfStringNodeGen.inline(InlineTarget.create(RawLastIndexOfStringNode.class, state_0_.subUpdater(2, 1), lios8SameEncoding_indexOfStringNode__field1_));
                this.unsupported_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 21)));
                this.unsupported_prevNodeA_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, state_1_.subUpdater(0, 21)));
                this.unsupported_prevNodeB_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, state_2_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.lios8SameEncoding_indexOfStringNode__field1_);
                            return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.lios8SameEncoding_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_);
                            return LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_prevNodeA_, this.unsupported_prevNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.lios8SameEncoding_indexOfStringNode__field1_);
                    return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.lios8SameEncoding_indexOfStringNode_);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unsupported(Node, AbstractTruffleString, Object, int, AbstractTruffleString, Object, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_);
                    return LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_prevNodeA_, this.unsupported_prevNodeB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringRawNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, Encoding arg10Value) {
                if ((TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                    return LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg10Value)) && (!(TStringGuards.isFixedWidth(arg3Value)))) {
                    return LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, (InternalNextNodeGen.getUncached()), (InternalPreviousNodeGen.getUncached()), (InternalPreviousNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link StrideFromCodeRangeNode#doUTF16}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link StrideFromCodeRangeNode#doUTF32}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link StrideFromCodeRangeNode#doOther}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre>
     */
    @GeneratedBy(StrideFromCodeRangeNode.class)
    @SuppressWarnings("javadoc")
    static final class StrideFromCodeRangeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static StrideFromCodeRangeNode getUncached() {
            return StrideFromCodeRangeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static StrideFromCodeRangeNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
            return new StrideFromCodeRangeNodeGen.Inlined(target);
        }

        @GeneratedBy(StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined extends StrideFromCodeRangeNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrideFromCodeRangeNode#doUTF16}
             *   1: SpecializationActive {@link StrideFromCodeRangeNode#doUTF32}
             *   2: SpecializationActive {@link StrideFromCodeRangeNode#doOther}
             * </pre>
             */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(StrideFromCodeRangeNode.class);
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            int execute(Node arg0Value, int arg1Value, Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] || SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] || SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] */) {
                        if ((TStringGuards.isUTF16(arg2Value))) {
                            return doUTF16(arg1Value, arg2Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] */) {
                        if ((TStringGuards.isUTF32(arg2Value))) {
                            return doUTF32(arg1Value, arg2Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */) {
                        if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                            return doOther(arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int executeAndSpecialize(Node arg0Value, int arg1Value, Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg2Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF16(arg1Value, arg2Value);
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF32(arg1Value, arg2Value);
                }
                if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doOther(arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends StrideFromCodeRangeNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, int arg1Value, Encoding arg2Value) {
                if ((TStringGuards.isUTF16(arg2Value))) {
                    return doUTF16(arg1Value, arg2Value);
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    return doUTF32(arg1Value, arg2Value);
                }
                if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                    return doOther(arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CalcStringAttributesNode#empty}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link CalcStringAttributesNode#ascii}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link CalcStringAttributesNode#notAscii}
     *     Activation probability: 0.18333
     *     With/without class size: 7/2 bytes
     * </pre>
     */
    @GeneratedBy(CalcStringAttributesNode.class)
    @SuppressWarnings("javadoc")
    static final class CalcStringAttributesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CalcStringAttributesNode getUncached() {
            return CalcStringAttributesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CalcStringAttributesNode inline(@RequiredField(bits = 16, value = StateField.class) InlineTarget target) {
            return new CalcStringAttributesNodeGen.Inlined(target);
        }

        @GeneratedBy(CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Inlined extends CalcStringAttributesNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CalcStringAttributesNode#empty}
             *   1: SpecializationActive {@link CalcStringAttributesNode#ascii}
             *   2: SpecializationActive {@link CalcStringAttributesNode#notAscii}
             *   3-15: InlinedCache
             *        Specialization: {@link CalcStringAttributesNode#notAscii}
             *        Parameter: {@link CalcStringAttributesInnerNode} calcNode
             *        Inline method: {@link CalcStringAttributesInnerNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesNode#notAscii}
             *   Parameter: {@link CalcStringAttributesInnerNode} calcNode
             *   Inline method: {@link CalcStringAttributesInnerNodeGen#inline}</pre>
             */
            private final CalcStringAttributesInnerNode notAscii_calcNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CalcStringAttributesNode.class);
                this.state_0_ = target.getState(0, 16);
                this.notAscii_calcNode_ = CalcStringAttributesInnerNodeGen.inline(InlineTarget.create(CalcStringAttributesInnerNode.class, state_0_.subUpdater(3, 13)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.empty(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.ascii(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.notAscii(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, CalcStringAttributesInnerNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.empty(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((arg4Value == 0)) {
                            return empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.ascii(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((TStringGuards.is7Bit(arg8Value)) && (arg4Value > 0)) {
                            return ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.notAscii(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, CalcStringAttributesInnerNode)] */) {
                        if ((!(TStringGuards.is7Bit(arg8Value))) && (arg4Value > 0)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.notAscii_calcNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((arg4Value == 0)) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.empty(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.is7Bit(arg8Value)) && (arg4Value > 0)) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.ascii(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((!(TStringGuards.is7Bit(arg8Value))) && (arg4Value > 0)) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesNode.notAscii(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, CalcStringAttributesInnerNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.notAscii_calcNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                if ((arg4Value == 0)) {
                    return empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.is7Bit(arg8Value)) && (arg4Value > 0)) {
                    return ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((!(TStringGuards.is7Bit(arg8Value))) && (arg4Value > 0)) {
                    return CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (CalcStringAttributesInnerNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CalcStringAttributesInnerNode#doLatin1}
     *     Activation probability: 0.23929
     *     With/without class size: 6/0 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doBMP}
     *     Activation probability: 0.20714
     *     With/without class size: 6/0 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doUTF8}
     *     Activation probability: 0.17500
     *     With/without class size: 7/1 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doUTF16Valid}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doUTF16Unknown}
     *     Activation probability: 0.11071
     *     With/without class size: 5/0 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doUTF32}
     *     Activation probability: 0.07857
     *     With/without class size: 4/0 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#doGeneric}
     *     Activation probability: 0.04643
     *     With/without class size: 4/1 bytes
     * </pre>
     */
    @GeneratedBy(CalcStringAttributesInnerNode.class)
    @SuppressWarnings("javadoc")
    static final class CalcStringAttributesInnerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CalcStringAttributesInnerNode getUncached() {
            return CalcStringAttributesInnerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CalcStringAttributesInnerNode inline(@RequiredField(bits = 13, value = StateField.class) InlineTarget target) {
            return new CalcStringAttributesInnerNodeGen.Inlined(target);
        }

        @GeneratedBy(CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Inlined extends CalcStringAttributesInnerNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CalcStringAttributesInnerNode#doLatin1}
             *   1: SpecializationActive {@link CalcStringAttributesInnerNode#doBMP}
             *   2: SpecializationActive {@link CalcStringAttributesInnerNode#doUTF8}
             *   3: SpecializationActive {@link CalcStringAttributesInnerNode#doUTF16Valid}
             *   4: SpecializationActive {@link CalcStringAttributesInnerNode#doUTF16Unknown}
             *   5: SpecializationActive {@link CalcStringAttributesInnerNode#doUTF32}
             *   6: SpecializationActive {@link CalcStringAttributesInnerNode#doGeneric}
             *   7-8: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#doUTF8}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#doGeneric}
             *        Parameter: {@link InlinedConditionProfile} validCharacterProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   11-12: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#doGeneric}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#doUTF8}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile uTF8_brokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#doGeneric}
             *   Parameter: {@link InlinedConditionProfile} validCharacterProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile generic_validCharacterProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#doGeneric}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile generic_fixedWidthProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CalcStringAttributesInnerNode.class);
                this.state_0_ = target.getState(0, 13);
                this.uTF8_brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(7, 2)));
                this.generic_validCharacterProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(9, 2)));
                this.generic_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(11, 2)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && (arg5Value == 0)) {
                            return doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isUpTo16Bit(arg8Value)) && (arg5Value == 1)) {
                            return doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg6Value)) && (!(TStringGuards.isFixedWidth(arg8Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.uTF8_brokenProfile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isValid(arg8Value))) {
                            return doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isBroken(arg8Value))) {
                            return doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */) {
                        if ((arg5Value == 2)) {
                            return doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && (arg5Value == 0)) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doLatin1(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUpTo16Bit(arg8Value)) && (arg5Value == 1)) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doBMP(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF8(arg6Value)) && (!(TStringGuards.isFixedWidth(arg8Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.uTF8_brokenProfile_);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isValid(arg8Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Valid(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isBroken(arg8Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF16Unknown(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((arg5Value == 2)) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doUTF32(AbstractTruffleString, Object, int, int, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg6Value))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(Node, AbstractTruffleString, Object, int, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesInnerNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && (arg5Value == 0)) {
                    return doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUpTo16Bit(arg8Value)) && (arg5Value == 1)) {
                    return doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF8(arg6Value)) && (!(TStringGuards.isFixedWidth(arg8Value)))) {
                    return CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isValid(arg8Value))) {
                    return doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isBroken(arg8Value))) {
                    return doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((arg5Value == 2)) {
                    return doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg6Value))) {
                    return CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.38500
     *     With/without class size: 13/5 bytes
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.29500
     *     With/without class size: 11/5 bytes
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.20500
     *     With/without class size: 8/5 bytes
     *   Specialization {@link ParseIntNode#doGeneric}
     *     Activation probability: 0.11500
     *     With/without class size: 6/3 bytes
     * </pre>
     */
    @GeneratedBy(ParseIntNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseIntNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ParseIntNode getUncached() {
            return ParseIntNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static ParseIntNode inline(@RequiredField(bits = 17, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new ParseIntNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class Inlined extends ParseIntNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseIntNode#do7Bit}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   4: SpecializationActive {@link ParseIntNode#do7Bit}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   8: SpecializationActive {@link ParseIntNode#do7Bit}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   12: SpecializationActive {@link ParseIntNode#doGeneric}
             *   13: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   14: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   15: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   16: InlinedCache
             *        Specialization: {@link ParseIntNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link ParseIntNode#doGeneric}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit2_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#doGeneric}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode generic_nextNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile generic_errorProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseIntNode.class);
                this.state_0_ = target.getState(0, 17);
                this.state_1_ = target.getState(1, 21);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(15, 1)));
                this.generic_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
                this.generic_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(16, 1)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1000100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                        if ((!(TStringGuards.is7Bit(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_, this.state_0_);
                            return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.generic_nextNode_, this.generic_errorProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit0_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit0_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit0_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit0_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit1_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit1_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit1_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit1_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit2_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit2_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit2_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit2_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                        }
                        break;
                    }
                }
                if ((!(TStringGuards.is7Bit(arg3Value)))) {
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_, this.state_0_);
                    return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.generic_nextNode_, this.generic_errorProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class Uncached extends ParseIntNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((!(TStringGuards.is7Bit(arg3Value)))) {
                    return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InternalNextNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.38500
     *     With/without class size: 13/5 bytes
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.29500
     *     With/without class size: 11/5 bytes
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.20500
     *     With/without class size: 8/5 bytes
     *   Specialization {@link ParseLongNode#parseLong}
     *     Activation probability: 0.11500
     *     With/without class size: 6/3 bytes
     * </pre>
     */
    @GeneratedBy(ParseLongNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseLongNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ParseLongNode getUncached() {
            return ParseLongNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static ParseLongNode inline(@RequiredField(bits = 17, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new ParseLongNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class Inlined extends ParseLongNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseLongNode#do7Bit}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   4: SpecializationActive {@link ParseLongNode#do7Bit}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   8: SpecializationActive {@link ParseLongNode#do7Bit}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   12: SpecializationActive {@link ParseLongNode#parseLong}
             *   13: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   14: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   15: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   16: InlinedCache
             *        Specialization: {@link ParseLongNode#parseLong}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link ParseLongNode#parseLong}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile do7Bit2_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#parseLong}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode parseLong_nextNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#parseLong}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile parseLong_errorProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseLongNode.class);
                this.state_0_ = target.getState(0, 17);
                this.state_1_ = target.getState(1, 21);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(15, 1)));
                this.parseLong_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 21)));
                this.parseLong_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(16, 1)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1000100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                        if ((!(TStringGuards.is7Bit(arg3Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_, this.state_0_);
                            return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit0_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit0_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit0_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit0_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit1_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit1_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit1_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit1_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg3Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit2_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit2_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg3Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, Object, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit2_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit2_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                        }
                        break;
                    }
                }
                if ((!(TStringGuards.is7Bit(arg3Value)))) {
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, Object, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_, this.state_0_);
                    return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class Uncached extends ParseLongNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, Encoding arg4Value, int arg5Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg3Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((!(TStringGuards.is7Bit(arg3Value)))) {
                    return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InternalNextNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.48333
     *     With/without class size: 15/5 bytes
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.33333
     *     With/without class size: 12/5 bytes
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.18333
     *     With/without class size: 8/5 bytes
     * </pre>
     */
    @GeneratedBy(ParseDoubleNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseDoubleNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ParseDoubleNode getUncached() {
            return ParseDoubleNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static ParseDoubleNode inline(@RequiredField(bits = 15, value = StateField.class) InlineTarget target) {
            return new ParseDoubleNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseDoubleNode.class)
        @DenyReplace
        private static final class Inlined extends ParseDoubleNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseDoubleNode#doParse}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)]
             *   4: SpecializationActive {@link ParseDoubleNode#doParse}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)]
             *   8: SpecializationActive {@link ParseDoubleNode#doParse}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)]
             *   12: InlinedCache
             *        Specialization: {@link ParseDoubleNode#doParse}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   13: InlinedCache
             *        Specialization: {@link ParseDoubleNode#doParse}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   14: InlinedCache
             *        Specialization: {@link ParseDoubleNode#doParse}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseDoubleNode#doParse}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile parse0_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseDoubleNode#doParse}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile parse1_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseDoubleNode#doParse}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile parse2_errorProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseDoubleNode.class);
                this.state_0_ = target.getState(0, 15);
                this.parse0_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(12, 1)));
                this.parse1_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(13, 1)));
                this.parse2_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(14, 1)));
            }

            @Override
            double execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse0_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse1_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse2_errorProfile_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Parse0_duplicateFound_ = true;
                            }
                        }
                        if (!Parse0_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                            if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse0_duplicateFound_ = true;
                            }
                        }
                        if (Parse0_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse0_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Parse1_duplicateFound_ = true;
                            }
                        }
                        if (!Parse1_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse1_duplicateFound_ = true;
                            }
                        }
                        if (Parse1_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse1_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Parse2_duplicateFound_ = true;
                            }
                        }
                        if (!Parse2_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */);
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, Object, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse2_duplicateFound_ = true;
                            }
                        }
                        if (Parse2_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.parse2_errorProfile_);
                        }
                        break;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(ParseDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends ParseDoubleNode {

            @TruffleBoundary
            @Override
            double execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws NumberFormatException {
                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromJavaStringUTF16Node#doNonEmpty}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre>
     */
    @GeneratedBy(FromJavaStringUTF16Node.class)
    @SuppressWarnings("javadoc")
    static final class FromJavaStringUTF16NodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromJavaStringUTF16Node getUncached() {
            return FromJavaStringUTF16NodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static FromJavaStringUTF16Node inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new FromJavaStringUTF16NodeGen.Inlined(target);
        }

        @GeneratedBy(FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Inlined extends FromJavaStringUTF16Node {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromJavaStringUTF16Node#doNonEmpty}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromJavaStringUTF16Node#doNonEmpty}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile utf16CompactProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromJavaStringUTF16Node.class);
                this.state_0_ = target.getState(0, 2);
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf16CompactProfile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends FromJavaStringUTF16Node {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                return FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CreateJavaStringNode#createJavaString}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre>
     */
    @GeneratedBy(CreateJavaStringNode.class)
    @SuppressWarnings("javadoc")
    static final class CreateJavaStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CreateJavaStringNode getUncached() {
            return CreateJavaStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static CreateJavaStringNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new CreateJavaStringNodeGen.Inlined(target);
        }

        @GeneratedBy(CreateJavaStringNode.class)
        @DenyReplace
        private static final class Inlined extends CreateJavaStringNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link CreateJavaStringNode#createJavaString}
             *        Parameter: {@link InlinedConditionProfile} reuseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CreateJavaStringNode#createJavaString}
             *   Parameter: {@link InlinedConditionProfile} reuseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile reuseProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CreateJavaStringNode.class);
                this.state_0_ = target.getState(0, 2);
                this.reuseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            String execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, this.reuseProfile_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(CreateJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends CreateJavaStringNode {

            @TruffleBoundary
            @Override
            String execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                return CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link TransCodeNode#transcode}
     *     Activation probability: 1.00000
     *     With/without class size: 28/8 bytes
     * </pre>
     */
    @GeneratedBy(TransCodeNode.class)
    @SuppressWarnings("javadoc")
    static final class TransCodeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static TransCodeNode getUncached() {
            return TransCodeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static TransCodeNode inline(@RequiredField(bits = 27, value = StateField.class)@RequiredField(bits = 32, value = StateField.class) InlineTarget target) {
            return new TransCodeNodeGen.Inlined(target);
        }

        @GeneratedBy(TransCodeNode.class)
        @DenyReplace
        private static final class Inlined extends TransCodeNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link InlinedConditionProfile} asciiBytesInvalidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-26: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-31: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeNode#transcode}
             *   Parameter: {@link InlinedConditionProfile} asciiBytesInvalidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile asciiBytesInvalidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeNode#transcode}
             *   Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *   Inline method: {@link TransCodeIntlNodeGen#inline}</pre>
             */
            private final TransCodeIntlNode transCodeIntlNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(TransCodeNode.class);
                this.state_0_ = target.getState(0, 27);
                this.state_1_ = target.getState(1, 32);
                this.asciiBytesInvalidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.transCodeIntlNode_ = TransCodeIntlNodeGen.inline(InlineTarget.create(TransCodeIntlNode.class, state_1_.subUpdater(0, 32), state_0_.subUpdater(2, 25)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_0_);
                return TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.asciiBytesInvalidProfile_, this.transCodeIntlNode_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(TransCodeNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
                return TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (TransCodeIntlNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link TransCodeIntlNode#targetAscii}
     *     Activation probability: 0.15909
     *     With/without class size: 6/0 bytes
     *   Specialization {@link TransCodeIntlNode#latin1Transcode}
     *     Activation probability: 0.14545
     *     With/without class size: 6/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf8TranscodeRegular}
     *     Activation probability: 0.13182
     *     With/without class size: 6/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf8TranscodeLarge}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16Fixed32Bit}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16TranscodeRegular}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16TranscodeLarge}
     *     Activation probability: 0.07727
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeRegular}
     *     Activation probability: 0.06364
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeLarge}
     *     Activation probability: 0.05000
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeUTF16}
     *     Activation probability: 0.03636
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#unsupported}
     *     Activation probability: 0.02273
     *     With/without class size: 4/3 bytes
     * </pre>
     */
    @GeneratedBy(TransCodeIntlNode.class)
    @SuppressWarnings("javadoc")
    static final class TransCodeIntlNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static TransCodeIntlNode getUncached() {
            return TransCodeIntlNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul>
         */
        @NeverDefault
        public static TransCodeIntlNode inline(@RequiredField(bits = 32, value = StateField.class)@RequiredField(bits = 25, value = StateField.class) InlineTarget target) {
            return new TransCodeIntlNodeGen.Inlined(target);
        }

        @GeneratedBy(TransCodeIntlNode.class)
        @DenyReplace
        private static final class Inlined extends TransCodeIntlNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TransCodeIntlNode#targetAscii}
             *   1: SpecializationActive {@link TransCodeIntlNode#latin1Transcode}
             *   2: SpecializationActive {@link TransCodeIntlNode#utf8TranscodeRegular}
             *   3: SpecializationActive {@link TransCodeIntlNode#utf8TranscodeLarge}
             *   4: SpecializationActive {@link TransCodeIntlNode#utf16Fixed32Bit}
             *   5: SpecializationActive {@link TransCodeIntlNode#utf16TranscodeRegular}
             *   6: SpecializationActive {@link TransCodeIntlNode#utf16TranscodeLarge}
             *   7: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeRegular}
             *   8: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeLarge}
             *   9: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeUTF16}
             *   10: SpecializationActive {@link TransCodeIntlNode#unsupported}
             *   11-31: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#targetAscii}
             *        Parameter: {@link InternalNextNode} iteratorNextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre>
             */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#utf8TranscodeRegular}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#utf8TranscodeRegular}
             *        Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   3-4: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#unsupported}
             *        Parameter: {@link InlinedConditionProfile} nativeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-24: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#unsupported}
             *        Parameter: {@link FromBufferWithStringCompactionNode} fromBufferWithStringCompactionNode
             *        Inline method: {@link FromBufferWithStringCompactionNodeGen#inline}
             * </pre>
             */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#targetAscii}
             *   Parameter: {@link InternalNextNode} iteratorNextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre>
             */
            private final InternalNextNode iteratorNextNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#utf8TranscodeRegular}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile brokenProfile;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#utf8TranscodeRegular}
             *   Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private final InlinedBranchProfile outOfMemoryProfile;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#unsupported}
             *   Parameter: {@link InlinedConditionProfile} nativeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private final InlinedConditionProfile unsupported_nativeProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#unsupported}
             *   Parameter: {@link FromBufferWithStringCompactionNode} fromBufferWithStringCompactionNode
             *   Inline method: {@link FromBufferWithStringCompactionNodeGen#inline}</pre>
             */
            private final FromBufferWithStringCompactionNode unsupported_fromBufferWithStringCompactionNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(TransCodeIntlNode.class);
                this.state_0_ = target.getState(0, 32);
                this.state_1_ = target.getState(1, 25);
                this.iteratorNextNode = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(11, 21)));
                this.brokenProfile = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(0, 2)));
                this.outOfMemoryProfile = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_1_.subUpdater(2, 1)));
                this.unsupported_nativeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(3, 2)));
                this.unsupported_fromBufferWithStringCompactionNode_ = FromBufferWithStringCompactionNodeGen.inline(InlineTarget.create(FromBufferWithStringCompactionNode.class, state_1_.subUpdater(5, 20)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, Encoding arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11111111111) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InlinedBranchProfile, InlinedConditionProfile, FromBufferWithStringCompactionNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                            return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isLatin1(arg6Value))) {
                            return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF8(arg6Value))) {
                            return TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF8(arg6Value))) {
                            return TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding)] */) {
                        if ((TStringGuards.isUTF32(arg5Value)) && (TStringGuards.isUTF16(arg6Value))) {
                            return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF16(arg6Value))) {
                            return TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.outOfMemoryProfile);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF16(arg6Value))) {
                            return TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.outOfMemoryProfile);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */) {
                        if ((!(TStringGuards.isUTF16(arg5Value))) && (TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                            return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF32(arg6Value))) {
                            return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */) {
                        if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                            return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InlinedBranchProfile, InlinedConditionProfile, FromBufferWithStringCompactionNode)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_, this.state_1_);
                            return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.outOfMemoryProfile, this.unsupported_nativeProfile_, this.unsupported_fromBufferWithStringCompactionNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, Encoding arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isLatin1(arg6Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF8(arg6Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF8(arg6Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isUTF32(arg5Value)) && (TStringGuards.isUTF16(arg6Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, Object, int, int, Encoding, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF16(arg6Value))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF16(arg6Value))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if ((!(TStringGuards.isUTF16(arg5Value))) && (TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF32(arg6Value))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, Object, int, int, Encoding, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value))) {
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, Object, int, int, Encoding, Encoding, InlinedBranchProfile, InlinedConditionProfile, FromBufferWithStringCompactionNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_, this.state_1_);
                    return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.outOfMemoryProfile, this.unsupported_nativeProfile_, this.unsupported_fromBufferWithStringCompactionNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
        @GeneratedBy(TransCodeIntlNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeIntlNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value, Encoding arg6Value) {
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                    return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TStringGuards.isLatin1(arg6Value))) {
                    return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF8(arg6Value))) {
                    return TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF8(arg6Value))) {
                    return TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg5Value)) && (TStringGuards.isUTF16(arg6Value))) {
                    return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF16(arg6Value))) {
                    return TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF16(arg6Value))) {
                    return TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16(arg5Value))) && (TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                    return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (TransCodeIntlNode.isLarge(arg3Value)) && (TStringGuards.isUTF32(arg6Value))) {
                    return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value))) && (!(TransCodeIntlNode.isLarge(arg3Value))) && (TStringGuards.isUTF32(arg6Value))) {
                    return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNodeGen.getUncached()));
                }
                if ((TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value))) {
                    return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedBranchProfile.getUncached()), (InlinedConditionProfile.getUncached()), (FromBufferWithStringCompactionNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
