/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.nativeapi;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.CHeader;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CConst;
import org.graalvm.nativeimage.c.type.CTypedef;
import org.graalvm.polyglot.nativeapi.PolyglotIsolateHeader;
import org.graalvm.polyglot.nativeapi.PolyglotNativeAPICContext;
import org.graalvm.polyglot.nativeapi.types.PolyglotNativeAPITypes;

@CHeader(value=PolyglotIsolateHeader.class)
public final class PolyglotNativeAPIEntryPoints {
    private static final String UNINTERRUPTIBLE_REASON = "Unsafe state in case of failure";

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_set_isolate_params", documentation={"Initializes passed poly_isolate_params with the provided arguments.", "Later, when the isolate is created, these arguments will be passed to the isolate creation process.", "Note the first passed argument is reserved and must be a null pointer.", "", " @param params pointer to the poly_isolate_params struct to initialize.", " @param argc number of arguments within argv.", " @param argv a char** containing the arguments. Note the first argument is reserved", " and must be a null pointer.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "@since 22.3"})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polySetIsolateParams(PolyglotNativeAPITypes.PolyglotIsolateParameters params, int argc, CCharPointerPointer argv) {
        if (params.isNull()) {
            return Poly.generic_failure();
        }
        if (argc > 0) {
            if (argv.isNull()) {
                return Poly.generic_failure();
            }
            CCharPointer arg = argv.read(0);
            if (arg.isNonNull()) {
                return Poly.generic_failure();
            }
        }
        params.setVersion(4);
        params.setArgc(argc);
        params.setArgv(argv);
        params.setIgnoreUnrecognizedArguments(false);
        params.setExitWhenArgumentParsingFails(false);
        return Poly.ok();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_create_isolate", documentation={"Create a new isolate, considering the passed parameters (which may be NULL).", "Returns poly_ok on success, or a poly_generic_failure value on failure.", "On success, the current thread is attached to the created isolate, and the", "address of the isolate structure is written to the passed pointer.", "Every thread starts with a default handle scope. This scope is released when", "the thread is detached."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polyCreateIsolate( @CConst PolyglotNativeAPITypes.PolyglotIsolateParameters params, PolyglotNativeAPITypes.PolyglotIsolatePointer isolate, PolyglotNativeAPITypes.PolyglotIsolateThreadPointer thread) {
        return PolyglotNativeAPIEntryPoints.createIsolate(params, isolate, thread) == 0 ? Poly.ok() : Poly.generic_failure();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_attach_thread", documentation={"Attaches the current thread to the passed isolate.", "On failure, returns poly_generic_failure. On success, writes the address of the", "created isolate thread structure to the passed pointer and returns poly_ok.", "If the thread has already been attached, the call succeeds and also provides", "the thread's isolate thread structure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polyAttachThread(PolyglotNativeAPITypes.PolyglotIsolate isolate, PolyglotNativeAPITypes.PolyglotIsolateThreadPointer thread) {
        return PolyglotNativeAPIEntryPoints.attachThread(isolate, thread) == 0 ? Poly.ok() : Poly.generic_failure();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_get_current_thread", documentation={"Given an isolate to which the current thread is attached, returns the address of", "the thread's associated isolate thread structure.  If the current thread is not", "attached to the passed isolate or if another error occurs, returns NULL."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static PolyglotNativeAPITypes.PolyglotIsolateThread polyGetCurrentThread(PolyglotNativeAPITypes.PolyglotIsolate isolate) {
        return (PolyglotNativeAPITypes.PolyglotIsolateThread)PolyglotNativeAPIEntryPoints.getCurrentThread(isolate);
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_get_isolate", documentation={"Given an isolate thread structure, determines to which isolate it belongs and", "returns the address of its isolate structure.  If an error occurs, returns NULL", "instead."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static PolyglotNativeAPITypes.PolyglotIsolate polyGetIsolate(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        return (PolyglotNativeAPITypes.PolyglotIsolate)PolyglotNativeAPIEntryPoints.getIsolate(thread);
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_detach_thread", documentation={"Detaches the passed isolate thread from its isolate and discards any state or", "context that is associated with it. At the time of the call, no code may still", "be executing in the isolate thread's context.", "Returns poly_ok on success, or poly_generic_failure on failure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polyDetachThread(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        return PolyglotNativeAPIEntryPoints.detachThread(thread) == 0 ? Poly.ok() : Poly.generic_failure();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_detach_all_threads_and_tear_down_isolate", documentation={"In the isolate of the passed isolate thread, detach all those threads that were", "externally started (not within Java, which includes the \"main thread\") and were", "attached to the isolate afterwards. Afterwards, all threads that were started", "within Java undergo a regular shutdown process, followed by the tear-down of the", "entire isolate, which detaches the current thread and discards the objects,", "threads, and any other state or context associated with the isolate.", "None of the manually attached threads targeted by this function may be executing", "Java code at the time when this function is called or at any point in the future", "or this will cause entirely undefined (and likely fatal) behavior.", "Returns poly_ok on success, or poly_generic_failure on failure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polyDetachAllThreadsAndTearDownIsolate(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        return PolyglotNativeAPIEntryPoints.detachAllThreadsAndTearDownIsolate(thread) == 0 ? Poly.ok() : Poly.generic_failure();
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="poly_tear_down_isolate", documentation={"Tears down the passed isolate, waiting for any attached threads to detach from", "it, then discards the isolate's objects, threads, and any other state or context", "that is associated with it.", "Returns poly_ok on success, or poly_generic_failure on failure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=CEntryPointOptions.UnchangedNameTransformation.class)
    public static @CTypedef(name="poly_status") int polyTearDownIsolate(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        return PolyglotNativeAPIEntryPoints.tearDownIsolate(thread) == 0 ? Poly.ok() : Poly.generic_failure();
    }

    @CFunction(value="graal_create_isolate", transition=CFunction.Transition.NO_TRANSITION)
    private static native int createIsolate(CEntryPointCreateIsolateParameters var0, CEntryPointNativeFunctions.IsolatePointer var1, CEntryPointNativeFunctions.IsolateThreadPointer var2);

    @CFunction(value="graal_attach_thread", transition=CFunction.Transition.NO_TRANSITION)
    private static native int attachThread(Isolate var0, CEntryPointNativeFunctions.IsolateThreadPointer var1);

    @CFunction(value="graal_get_current_thread", transition=CFunction.Transition.NO_TRANSITION)
    private static native IsolateThread getCurrentThread(Isolate var0);

    @CFunction(value="graal_get_isolate", transition=CFunction.Transition.NO_TRANSITION)
    private static native Isolate getIsolate(IsolateThread var0);

    @CFunction(value="graal_detach_thread", transition=CFunction.Transition.NO_TRANSITION)
    private static native int detachThread(IsolateThread var0);

    @CFunction(value="graal_detach_all_threads_and_tear_down_isolate", transition=CFunction.Transition.NO_TRANSITION)
    private static native int detachAllThreadsAndTearDownIsolate(IsolateThread var0);

    @CFunction(value="graal_tear_down_isolate", transition=CFunction.Transition.NO_TRANSITION)
    private static native int tearDownIsolate(IsolateThread var0);

    @CContext(value=PolyglotNativeAPICContext.class)
    private static class Poly {
        private Poly() {
        }

        @CConstant(value="poly_ok")
        static native int ok();

        @CConstant(value="poly_generic_failure")
        static native int generic_failure();
    }
}

