/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class SourceResponse
extends Response {
    SourceResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public SourceResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceResponse other = (SourceResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.getBody());
        hash = 43 * hash + Objects.hashCode(this.getType());
        hash = 43 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 43 * hash + Boolean.hashCode(this.isSuccess());
        hash = 43 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 43 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 43 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static SourceResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new SourceResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getContent() {
            return this.jsonData.getString("content");
        }

        public ResponseBody setContent(String content) {
            this.jsonData.put("content", content);
            return this;
        }

        public String getMimeType() {
            return this.jsonData.optString("mimeType", null);
        }

        public ResponseBody setMimeType(String mimeType) {
            this.jsonData.putOpt("mimeType", mimeType);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getContent(), other.getContent())) {
                return false;
            }
            return Objects.equals(this.getMimeType(), other.getMimeType());
        }

        public int hashCode() {
            int hash = 5;
            hash = 11 * hash + Objects.hashCode(this.getContent());
            if (this.getMimeType() != null) {
                hash = 11 * hash + Objects.hashCode(this.getMimeType());
            }
            return hash;
        }

        public static ResponseBody create(String content) {
            JSONObject json = new JSONObject();
            json.put("content", content);
            return new ResponseBody(json);
        }
    }
}

