/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Module
extends JSONBase {
    Module(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getId() {
        return this.jsonData.get("id");
    }

    public Module setId(Object id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public Module setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public String getPath() {
        return this.jsonData.optString("path", null);
    }

    public Module setPath(String path) {
        this.jsonData.putOpt("path", path);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getIsOptimized() {
        return this.jsonData.has("isOptimized") ? Boolean.valueOf(this.jsonData.getBoolean("isOptimized")) : null;
    }

    public Module setIsOptimized(Boolean isOptimized) {
        this.jsonData.putOpt("isOptimized", isOptimized);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getIsUserCode() {
        return this.jsonData.has("isUserCode") ? Boolean.valueOf(this.jsonData.getBoolean("isUserCode")) : null;
    }

    public Module setIsUserCode(Boolean isUserCode) {
        this.jsonData.putOpt("isUserCode", isUserCode);
        return this;
    }

    public String getVersion() {
        return this.jsonData.optString("version", null);
    }

    public Module setVersion(String version) {
        this.jsonData.putOpt("version", version);
        return this;
    }

    public String getSymbolStatus() {
        return this.jsonData.optString("symbolStatus", null);
    }

    public Module setSymbolStatus(String symbolStatus) {
        this.jsonData.putOpt("symbolStatus", symbolStatus);
        return this;
    }

    public String getSymbolFilePath() {
        return this.jsonData.optString("symbolFilePath", null);
    }

    public Module setSymbolFilePath(String symbolFilePath) {
        this.jsonData.putOpt("symbolFilePath", symbolFilePath);
        return this;
    }

    public String getDateTimeStamp() {
        return this.jsonData.optString("dateTimeStamp", null);
    }

    public Module setDateTimeStamp(String dateTimeStamp) {
        this.jsonData.putOpt("dateTimeStamp", dateTimeStamp);
        return this;
    }

    public String getAddressRange() {
        return this.jsonData.optString("addressRange", null);
    }

    public Module setAddressRange(String addressRange) {
        this.jsonData.putOpt("addressRange", addressRange);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        if (!Objects.equals(this.getIsOptimized(), other.getIsOptimized())) {
            return false;
        }
        if (!Objects.equals(this.getIsUserCode(), other.getIsUserCode())) {
            return false;
        }
        if (!Objects.equals(this.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(this.getSymbolStatus(), other.getSymbolStatus())) {
            return false;
        }
        if (!Objects.equals(this.getSymbolFilePath(), other.getSymbolFilePath())) {
            return false;
        }
        if (!Objects.equals(this.getDateTimeStamp(), other.getDateTimeStamp())) {
            return false;
        }
        return Objects.equals(this.getAddressRange(), other.getAddressRange());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.getId());
        hash = 29 * hash + Objects.hashCode(this.getName());
        if (this.getPath() != null) {
            hash = 29 * hash + Objects.hashCode(this.getPath());
        }
        if (this.getIsOptimized() != null) {
            hash = 29 * hash + Boolean.hashCode(this.getIsOptimized());
        }
        if (this.getIsUserCode() != null) {
            hash = 29 * hash + Boolean.hashCode(this.getIsUserCode());
        }
        if (this.getVersion() != null) {
            hash = 29 * hash + Objects.hashCode(this.getVersion());
        }
        if (this.getSymbolStatus() != null) {
            hash = 29 * hash + Objects.hashCode(this.getSymbolStatus());
        }
        if (this.getSymbolFilePath() != null) {
            hash = 29 * hash + Objects.hashCode(this.getSymbolFilePath());
        }
        if (this.getDateTimeStamp() != null) {
            hash = 29 * hash + Objects.hashCode(this.getDateTimeStamp());
        }
        if (this.getAddressRange() != null) {
            hash = 29 * hash + Objects.hashCode(this.getAddressRange());
        }
        return hash;
    }

    public static Module create(Object id, String name) {
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("name", name);
        return new Module(json);
    }
}

